package bipartite_graph;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
/*
 * List2Graph.java
 *
 * Created on October 9, 2007, 5:50 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

/**
 *
 * @author Georgios
 */
public class List2Graph {
    
    public static Hashtable<String, Integer> GiveNodeName_GetIndex = new Hashtable();
    public static Hashtable<Integer, String> GiveIndex_GetNodeName = new Hashtable();
    public static ArrayList <String> labels = new ArrayList();
    public static float A[][];
    public static double B[][];
    

       
    
    
    public List2Graph(String filename) {
   System.out.println("Reading labels");   
   read_labels(filename);
   System.out.println("Reading values");   
   read_values_f(filename);
  // print_labels();
   print_number_of_elements();
  // System.out.println("Saving to file matrix.txt");   
  // save_matrix_to_file_f("matrix.txt"); 
   System.out.println("File loaded");
    }
    
    public List2Graph(ArrayList<String> list) {
     System.out.println("Reading labels");  
     read_labels(list);
     System.out.println("~~~~~~~~~~~~~~~"+this.labels.size());
     System.out.println("Reading values");   
     read_values_f(list);
     print_number_of_elements();
     System.out.println("File loaded");
    }

    
    public double[][] return_double_matrix()
    {
        B= new double[A.length][A.length];
        for (int i = 0; i < A.length; i++) {
            for (int j = 0; j < A.length; j++) {
                B[i][j]=(double)A[i][j];
            }
        }
        return B;
    }
    
    public double[][] return_double_matrix_square()
    {
        B= new double[A.length][A.length];
        for (int i = 0; i < A.length; i++) {
            for (int j = 0; j < A.length; j++) {
                B[i][j] = 0.00000;
            }
        }
        for (int i = 0; i < A.length; i++) { // aRow
            if(i%500==0)
            System.out.println("calculation of indirect connections progress:"+i+"/"+A.length);
            for (int j = 1; j < A.length; j++) { // bColumn
                for (int k = 0; k < A.length; k++) { // aColumn
                    B[i][j] += A[i][k] * A[k][j];
                }
            }
        }
        return B;
    }
    
      public ArrayList<String> return_indirect_connections()
    {
        double C[][];
        ArrayList indirect_connections= new ArrayList();
        C=return_double_matrix_square();
        for (int i = 0; i < C.length; i++) {
            
            for (int j = i+1; j < C.length; j++) {
                if(C[i][j]==1){
                    
                    String ss= labels.get(i)+"\t"+labels.get(j);
                    indirect_connections.add(ss);
                            }
            }
        }
        return indirect_connections;
    }
      
      public void print_indirect_connections() {
         ArrayList indirect_connections=return_indirect_connections();
          for (int i = 0; i < indirect_connections.size(); i++) {
              System.out.println(indirect_connections.get(i));
          }
      }
    
     public void print_matrix_f() {
        for (int i = 0; i < A.length; i++) {
            for (int j = 0; j < A.length; j++) {
                System.out.print(A[i][j] + "  ");
            }
            System.out.println("");
        }
    }
     

     
     
        public void save_matrix_to_file_f(String filename) { 
            try {
                BufferedWriter outp = new BufferedWriter(new FileWriter(filename));
                for(int i=0;i<A.length;i++){
                    for(int j=0;j<A.length;j++)
                    outp.write(A[i][j]+"\t");
                    outp.write("\n");
                }
                outp.close();
            } catch (IOException e) {}
   } 

        
        
       public void read_values_f(String filename)
    {
         String thisLine=null;
         A=new float[labels.size()][labels.size()];
         for (int i = 0; i < A.length; i++) {
             for (int j = 0; j < A.length; j++) {
                 A[i][j]=0;
             }
         }
         try{     
          FileInputStream fin =  new FileInputStream(filename); 
          BufferedReader myInput = new BufferedReader (new InputStreamReader(fin));
          while ((thisLine = myInput.readLine()) != null) { 
              String str[] = thisLine.split("\t");
              float value=Float.parseFloat(str[2]);
              A[GiveNodeName_GetIndex.get(str[0])][GiveNodeName_GetIndex.get(str[1])]=value;
              A[GiveNodeName_GetIndex.get(str[1])][GiveNodeName_GetIndex.get(str[0])]=value;

          }
          }//try
         catch (Exception e) {
         e.printStackTrace();}
    }
       
       public void read_values_f(ArrayList<String> list)
    {
         String thisLine=null;
         A=new float[labels.size()][labels.size()];
         for (int i = 0; i < A.length; i++) {
             for (int j = 0; j < A.length; j++) {
                 A[i][j]=0;
             }
         }
         try{     
             for (int i = 0; i < list.size(); i++) {
              String str[] = list.get(i).split("\t");
              float value=1;
              A[GiveNodeName_GetIndex.get(str[0])][GiveNodeName_GetIndex.get(str[1])]=value;
              A[GiveNodeName_GetIndex.get(str[1])][GiveNodeName_GetIndex.get(str[0])]=value;
          }
          }//try
         catch (Exception e) {
         e.printStackTrace();}
    }
            

     
     public void print_number_of_elements()
     {
         System.out.println(labels.size());
     }
     
     
     public void print_labels()
     {
         for (int i = 0; i < labels.size(); i++) {
             System.out.println(labels.get(i));
         }
     }
    
    

    
       public static void removeDuplicateWithOrder(ArrayList arlList)
       {
       Set set = new HashSet();
       List newList = new ArrayList();
       for (Iterator iter = arlList.iterator();    iter.hasNext(); ) {
       Object element = iter.next();
         if (set.add(element))
            newList.add(element);
          }
          arlList.clear();
          arlList.addAll(newList);
      }
       
    public void read_labels(String filename)
    { String thisLine=null;
      int count_labels=0;
         try{     
          FileInputStream fin =  new FileInputStream(filename); 
          BufferedReader myInput = new BufferedReader (new InputStreamReader(fin));
          while ((thisLine = myInput.readLine()) != null) { 
              String str[] = thisLine.split("\t");
              labels.add(str[0]);
              labels.add(str[1]);
          }
          removeDuplicateWithOrder(labels);
              
          for (int i = 0; i < labels.size(); i++) {
               GiveNodeName_GetIndex.put(labels.get(i),i);
               GiveIndex_GetNodeName.put(i,labels.get(i));
              
          }
  
          
          }//try
         catch (Exception e) {
         e.printStackTrace();}
    }
    
    
     public void read_labels(ArrayList<String> list)
    { String thisLine=null;
      int count_labels=0;
      labels.clear();
         try{     
             for (int i = 0; i < list.size(); i++) {
              String str[] = list.get(i).split("\t");
              labels.add(str[0]);
              labels.add(str[1]);
          }
          removeDuplicateWithOrder(labels);
              
          for (int i = 0; i < labels.size(); i++) {
               GiveNodeName_GetIndex.put(labels.get(i),i);
               GiveIndex_GetNodeName.put(i,labels.get(i));
              
          }
  
          
          }//try
         catch (Exception e) {
         e.printStackTrace();}
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
      List2Graph m = new List2Graph("C:\\Documents and Settings\\Georgios\\Desktop\\Mitocheck Analysis\\mitocheck_draft_peptide_all_vs_all_distance_matrix.txt");
    }
    
}
