package bipartite_graph;

import static bipartite_graph.Bipartite.Apply_Bipartite_Coordinates;
import java.util.ArrayList;
import processing.core.PApplet;
import static processing.core.PConstants.P2D;
import processing.core.PFont;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/**
 *
 * @author Georgios
 */
public class Graph extends PApplet {

    static int mousex, mousey;
    int selection_rectangle_color = color(0, 255, 255, 100);
    int selection_x_initial = 0;
    int selection_y_initial = 0;
    int selection_offsetx = 0;
    int selection_offsety = 0;
    boolean mouse_pressed_canvas = false;
    boolean create_graph_once = false;
    PFont font;

    @Override
    public void setup() {
        smooth();
        size(Variables.canvas_width, Variables.canvas_height, P2D);
        background(Variables.backcground_color);
   }

    public void draw() {
        smooth();
        background(Variables.backcground_color);
        mousex = mouseX;
        mousey = mouseY;


        if (Variables.file_loaded == true) {
            

            rectMode(CORNER);

            if (create_graph_once == false) {
             
                for (int i = 0; i < Variables.left.size(); i++) {
                    Draggable d = new Draggable(10, 25 * (i + 1), 10, 10, Variables.left.get(i));
                    d.fill_color = color(255, 0, 0);
                    Variables.give_label_get_Node.put(Variables.left.get(i), d);
                    Variables.nodes.add(d);
                }
                for (int i = 0; i < Variables.right.size(); i++) {
                    Draggable d = new Draggable(300, 25 * (i + 1), 10, 10, Variables.right.get(i));
                    d.fill_color = color(0, 0, 255);
                    Variables.give_label_get_Node.put(Variables.right.get(i), d);
                    Variables.nodes.add(d);
                }
                
                
                System.out.println("Calculating Indirect Connections");
                for (int i = 0; i < Variables.direct_connections.size(); i++) {
                    String[] str = Variables.direct_connections.get(i).split("\t");
                    Draggable d1 = Variables.give_label_get_Node.get(str[0]);
                    Draggable d2 = Variables.give_label_get_Node.get(str[1]); 
                    if(!d1.neighbors.contains(str[1]))d1.neighbors.add(str[1]);
                    if(!d2.neighbors.contains(str[0]))d2.neighbors.add(str[0]);
                }
                for (int i = 0; i < Variables.unique.size(); i++) {
                    if(i%100==0)
                    System.out.println("calculation of indirect connections progress:"+i*100/Variables.unique.size()+"/"+100);
                    Draggable source = Variables.give_label_get_Node.get(Variables.unique.get(i));
                    for (int j = 0; j < source.neighbors.size(); j++) {
                        Draggable neighbor = Variables.give_label_get_Node.get(source.neighbors.get(j));
                        for (int k = 0; k < neighbor.neighbors.size(); k++) {
                            Draggable indirect_neighbor = Variables.give_label_get_Node.get(neighbor.neighbors.get(k));
                            if(source.label.compareTo(indirect_neighbor.label)!=0){
                            String connection1 = source.label+"\t"+indirect_neighbor.label;
                            String connection2 = indirect_neighbor.label+"\t"+source.label;
                            if(!Variables.indirect_connections.contains(connection1) && !Variables.indirect_connections.contains(connection2) )
                                Variables.indirect_connections.add(connection1);
                        }
                        }
                    }
                    
                }
                System.out.println("indirect Connections:"+Variables.indirect_connections.size());
  
                Apply_Bipartite_Coordinates() ;
                Bipartite.jMenuItem_Open.setEnabled(false);
                create_graph_once = true;
            }

            
            
            
            
             if(Variables.show_direct_connections)
         {
                stroke(0,0,0,100);
                 for (int i = 0; i < Variables.direct_connections.size(); i++) {
                 String connections = Variables.direct_connections.get(i);
                 String[] str = connections.split("\t");
                 Draggable d1 = Variables.give_label_get_Node.get(str[0]);
                 Draggable d2 = Variables.give_label_get_Node.get(str[1]);
                 line(d1.x + d1.w / 2, d1.y + d1.h / 2, d2.x + d2.w / 2, d2.y + d2.h / 2);
             }
         }
         
          if(Variables.show_indirect_connections)
         {
                stroke(255,0,0,100);
                 for (int i = 0; i < Variables.indirect_connections.size(); i++) {
                 String connections = Variables.indirect_connections.get(i);
                 String[] str = connections.split("\t");
                 Draggable d1 = Variables.give_label_get_Node.get(str[0]);
                 Draggable d2 = Variables.give_label_get_Node.get(str[1]);
                 patternLine(d1.x + d1.w / 2, d1.y + d1.h / 2, d2.x + d2.w / 2, d2.y + d2.h / 2, 0x0F0F , 1);
             }
         }
            
            
            
            
            
            for (int i = 0; i < Variables.nodes.size(); i++) {
                Draggable d = Variables.nodes.get(i);
                d.rollover(mousex, mousey);
                d.drag(mousex, mousey);
                d.display();
            }
            
        


        }

    }

    @Override
    public void mousePressed() {
        mouse_pressed_canvas = true;
        selection_x_initial = mousex;
        selection_y_initial = mousey;

        for (int i = 0; i < Variables.nodes.size(); i++) {
            Draggable d = Variables.nodes.get(i);
            d.clicked(mousex, mousey);
        }

    }

    @Override
    public void mouseReleased() {
        selection_x_initial = 0;
        selection_y_initial = 0;
        mouse_pressed_canvas = false;
        for (int i = 0; i < Variables.nodes.size(); i++) {
            Draggable d = Variables.nodes.get(i);
            d.stopDragging();
        }
    }

    
    
    
// linePattern = 0x5555 will be a dotted line, alternating one drawn and one skipped pixel.
// linePattern = 0x0F0F will be medium sized dashes.
// linePattern = 0xFF00 will be large dashes.
//
//      The lineScale argument controls the size of the pattern.  
//        If you create a dotted line with linePattern = 0x5555 and a lineScale of 1, 
//        you will get a dotted line.  If you use a lineScale of 2, you will get a dashed line 
//        with two pixels on, two off (the same as linePattern = 0x3333, lineScale = 1).  
//        lineScale is primarily there to allow much larger dashes and patterns that 
//       can't be defined with the 16 bits in linePattern.  
//        A lineScale of 0 is the same as 1.
    
    
void patternLine(float xStart, float yStart, float xEnd, float yEnd, int linePattern, int lineScale) {
  float temp, yStep, x, y;
  int pattern = linePattern;
  float carry;
  float count = lineScale;
  
  boolean steep = (abs(yEnd - yStart) > abs(xEnd - xStart));
  if (steep == true) {
    temp = xStart;
    xStart = yStart;
    yStart = temp;
    temp = xEnd;
    xEnd = yEnd;
    yEnd = temp;
  }    
  if (xStart > xEnd) {
    temp = xStart;
    xStart = xEnd;
    xEnd = temp;
    temp = yStart;
    yStart = yEnd;
    yEnd = temp;
  }
  float deltaX = xEnd - xStart;
  float deltaY = abs(yEnd - yStart);
  float error = - (deltaX + 1) / 2;
  
  y = yStart;
  if (yStart < yEnd) {
    yStep = 1;
  } else {
    yStep = -1;
  }
  for (x = xStart; x <= xEnd; x++) {
    if ((pattern & 1) == 1) {
	if (steep == true) {
	  point(y, x);
	} else {
	  point(x, y);
	}
	carry = 0x8000;
    } else {
	carry = 0;
    }  
    count--;
    if (count <= 0) {
	pattern = (pattern >> 1) + (int)carry;
	count = lineScale;
    }
	  
    error += deltaY;
    if (error >= 0) {
	y += yStep;
	error -= deltaX;
    }
  }
}
 

    
    
    
    
    
    //-----------------------------------------------------------------------------   
    class Draggable {

        boolean dragging = false; // Is the object being dragged?
        boolean rollover = false; // Is the mouse over the ellipse?
        public float x, y, w, h;  // Location and size
        float offsetX, offsetY; // Mouseclick offset
        int stroke_color = color(255, 0, 0);
        int fill_color = color(175, 175, 175);
        String label = "";
        ArrayList<String> neighbors = new ArrayList();

        public Draggable(float tempX, float tempY, float tempW, float tempH, String lab) {
            x = tempX;
            y = tempY;
            w = tempW;
            h = tempH;
            offsetX = 0;
            offsetY = 0;
            label = lab;
        }

        // Method to display
        public void display() {
            stroke(0);
            if (dragging) {
                stroke(stroke_color);
            } else if (rollover) {
                stroke(stroke_color);
            } else {
                fill(fill_color);
            }
            rect(x, y, w, h);

            if (Variables.show_labels == true) {
                fill(50);
                textSize( 12);
                text(label, x + 11, y+11);
            }


        }
        // Is a point inside the rectangle (for click)?

        void clicked(int mx, int my) {
            if (mx > this.x && mx < this.x + this.w && my > this.y && my < this.y + this.h) {
                dragging = true;
                // If so, keep track of relative location of click to corner of rectangle
                offsetX = this.x - mx;
                offsetY = this.y - my;
                 Bipartite.jLabel.setText("label: "+this.label);
            }
        }

        // Is a point inside the rectangle (for rollover)
        void rollover(int mx, int my) {
            if (mx > this.x && mx < this.x + this.w && my > this.y && my < this.y + this.h) {
                rollover = true;
                Bipartite.jLabel.setText("label: "+this.label);
            } else {
                rollover = false;
            }
        }

        // Stop dragging
        void stopDragging() {
            dragging = false;
        }

        // Drag the rectangle
        void drag(int mx, int my) {
            if (dragging) {
                x = Math.min(Variables.canvas_width - this.w - 1, mx + offsetX);
                if (x <= 0) {
                    x = 1;
                }

                y = Math.min(Variables.canvas_height - this.h - 1, my + offsetY);
                if (y <= 0) {
                    y = 1;
                }
            }
        }
    }
//--------------------------------------------------- 
}
