/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package bipartite_graph;

import bipartite_graph.Graph.Draggable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.vecmath.Point3d;
import uchicago.src.sim.network.DefaultDrawableNode;
import uchicago.src.sim.network.EdgeFactory;

/**
 *
 * @author Georgios
 */
public class Bipartite extends javax.swing.JFrame {

    static Bipartite frame;
    public static Fruchterman graphLayout;

    /**
     * Creates new form GlowPrism
     */
    public static void create_graph() {

        try {
            // String test = "C:\\Users\\Georgios\\Desktop\\data1.txt";
            // FileInputStream fstream = new FileInputStream(test);


            FileInputStream fstream = new FileInputStream(Variables.input_file);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine;
            while ((strLine = br.readLine()) != null) {
                Variables.direct_connections.add(strLine);
                String[] str = strLine.split("\t");
                if (!Variables.unique.contains(str[0])) {
                    Variables.unique.add(str[0]);
                }
                if (!Variables.left.contains(str[0])) {
                    Variables.left.add(str[0]);
                }
                if (!Variables.unique.contains(str[1])) {
                    Variables.unique.add(str[1]);
                }
                if (!Variables.right.contains(str[1])) {
                    Variables.right.add(str[1]);
                }
            }
            in.close();
            
//            System.out.println("Calculating Indirect Connections");
//            Variables.gg = new List2Graph(Variables.direct_connections);
//            //Variables.indirect_connections = Variables.gg.return_indirect_connections(); slowwwww zzzzzz
            

            Variables.file_loaded = true;


        } catch (Exception e) {//Catch exception if any
            e.printStackTrace();
        }


    }

    public Bipartite() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        jMenu2 = new javax.swing.JMenu();
        jMenuBar2 = new javax.swing.JMenuBar();
        jMenu3 = new javax.swing.JMenu();
        jMenu4 = new javax.swing.JMenu();
        jMenuBar3 = new javax.swing.JMenuBar();
        jMenu5 = new javax.swing.JMenu();
        jMenu6 = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuBar4 = new javax.swing.JMenuBar();
        jMenu7 = new javax.swing.JMenu();
        jMenu8 = new javax.swing.JMenu();
        jMenuBar5 = new javax.swing.JMenuBar();
        jMenu9 = new javax.swing.JMenu();
        jMenu10 = new javax.swing.JMenu();
        canvas = new javax.swing.JPanel();
        jLabel = new javax.swing.JLabel();
        jMenuMain = new javax.swing.JMenuBar();
        jMenu_File = new javax.swing.JMenu();
        jMenuItem_Open = new javax.swing.JMenuItem();
        jMenuItem_Export = new javax.swing.JMenuItem();
        jMenuItem_Export_Indirect_Connections_Left = new javax.swing.JMenuItem();
        jMenuItem_Export_Indirect_Connections_Right = new javax.swing.JMenuItem();
        jMenu_Graph = new javax.swing.JMenu();
        jMenuItem_Show_Labels = new javax.swing.JMenuItem();
        jMenuItem_Hide_Labels = new javax.swing.JMenuItem();
        jMenuItem_Direct_Connections = new javax.swing.JMenuItem();
        jMenuItem_Indirect_Connections = new javax.swing.JMenuItem();
        jMenuItem_Direct_Indirect_Connections = new javax.swing.JMenuItem();
        jMenuItem4 = new javax.swing.JMenuItem();
        jMenu_Layout = new javax.swing.JMenu();
        jMenuItem_fruchterman_direct = new javax.swing.JMenuItem();
        jMenuItem_fruchterman_indirect = new javax.swing.JMenuItem();
        jMenuItem_fruchterman_direct_indirect = new javax.swing.JMenuItem();
        jMenuItem_Circular = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();
        jMenuItem3 = new javax.swing.JMenuItem();
        jMenu_About = new javax.swing.JMenu();

        jMenu1.setText("File");
        jMenuBar1.add(jMenu1);

        jMenu2.setText("Edit");
        jMenuBar1.add(jMenu2);

        jMenu3.setText("File");
        jMenuBar2.add(jMenu3);

        jMenu4.setText("Edit");
        jMenuBar2.add(jMenu4);

        jMenu5.setText("File");
        jMenuBar3.add(jMenu5);

        jMenu6.setText("Edit");
        jMenuBar3.add(jMenu6);

        jMenuItem1.setText("jMenuItem1");

        jMenu7.setText("File");
        jMenuBar4.add(jMenu7);

        jMenu8.setText("Edit");
        jMenuBar4.add(jMenu8);

        jMenu9.setText("File");
        jMenuBar5.add(jMenu9);

        jMenu10.setText("Edit");
        jMenuBar5.add(jMenu10);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("GlowPrism");
        setName("frame"); // NOI18N
        setPreferredSize(new java.awt.Dimension(820, 901));
        setResizable(false);

        canvas.setBackground(new java.awt.Color(255, 255, 255));
        canvas.setPreferredSize(new java.awt.Dimension(801, 801));

        javax.swing.GroupLayout canvasLayout = new javax.swing.GroupLayout(canvas);
        canvas.setLayout(canvasLayout);
        canvasLayout.setHorizontalGroup(
            canvasLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 801, Short.MAX_VALUE)
        );
        canvasLayout.setVerticalGroup(
            canvasLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 801, Short.MAX_VALUE)
        );

        jMenu_File.setText("File");

        jMenuItem_Open.setText("Open");
        jMenuItem_Open.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_OpenActionPerformed(evt);
            }
        });
        jMenu_File.add(jMenuItem_Open);

        jMenuItem_Export.setText("Export Indirect Connections");
        jMenuItem_Export.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_ExportActionPerformed(evt);
            }
        });
        jMenu_File.add(jMenuItem_Export);

        jMenuItem_Export_Indirect_Connections_Left.setText("Export Indirect Connections Left Bipartite");
        jMenuItem_Export_Indirect_Connections_Left.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_Export_Indirect_Connections_LeftActionPerformed(evt);
            }
        });
        jMenu_File.add(jMenuItem_Export_Indirect_Connections_Left);

        jMenuItem_Export_Indirect_Connections_Right.setText("Export Indirect Connections Right Bipartite");
        jMenuItem_Export_Indirect_Connections_Right.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_Export_Indirect_Connections_RightActionPerformed(evt);
            }
        });
        jMenu_File.add(jMenuItem_Export_Indirect_Connections_Right);

        jMenuMain.add(jMenu_File);

        jMenu_Graph.setText("Graph");
        jMenu_Graph.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jMenu_GraphMouseClicked(evt);
            }
        });
        jMenu_Graph.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenu_GraphActionPerformed(evt);
            }
        });

        jMenuItem_Show_Labels.setText("Show Labels");
        jMenuItem_Show_Labels.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_Show_LabelsActionPerformed(evt);
            }
        });
        jMenu_Graph.add(jMenuItem_Show_Labels);

        jMenuItem_Hide_Labels.setText("Hide Labels");
        jMenuItem_Hide_Labels.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_Hide_LabelsActionPerformed(evt);
            }
        });
        jMenu_Graph.add(jMenuItem_Hide_Labels);

        jMenuItem_Direct_Connections.setText("Show Only Direct Connections");
        jMenuItem_Direct_Connections.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_Direct_ConnectionsActionPerformed(evt);
            }
        });
        jMenu_Graph.add(jMenuItem_Direct_Connections);

        jMenuItem_Indirect_Connections.setText("Show Only Indirect Connections");
        jMenuItem_Indirect_Connections.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_Indirect_ConnectionsActionPerformed(evt);
            }
        });
        jMenu_Graph.add(jMenuItem_Indirect_Connections);

        jMenuItem_Direct_Indirect_Connections.setText("Show Both Direct/Indirect Connections");
        jMenuItem_Direct_Indirect_Connections.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_Direct_Indirect_ConnectionsActionPerformed(evt);
            }
        });
        jMenu_Graph.add(jMenuItem_Direct_Indirect_Connections);

        jMenuItem4.setText("Do NOT show connections");
        jMenuItem4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem4ActionPerformed(evt);
            }
        });
        jMenu_Graph.add(jMenuItem4);

        jMenuMain.add(jMenu_Graph);

        jMenu_Layout.setText("Layout");
        jMenu_Layout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenu_LayoutActionPerformed(evt);
            }
        });

        jMenuItem_fruchterman_direct.setText("Fruchterman Direct Connections");
        jMenuItem_fruchterman_direct.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_fruchterman_directActionPerformed(evt);
            }
        });
        jMenu_Layout.add(jMenuItem_fruchterman_direct);

        jMenuItem_fruchterman_indirect.setText("Fruchterman Indirect Connections");
        jMenuItem_fruchterman_indirect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_fruchterman_indirectActionPerformed(evt);
            }
        });
        jMenu_Layout.add(jMenuItem_fruchterman_indirect);

        jMenuItem_fruchterman_direct_indirect.setText("Fruchterman Direct/Indirecet Connections");
        jMenuItem_fruchterman_direct_indirect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_fruchterman_direct_indirectActionPerformed(evt);
            }
        });
        jMenu_Layout.add(jMenuItem_fruchterman_direct_indirect);

        jMenuItem_Circular.setText("Circular");
        jMenuItem_Circular.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_CircularActionPerformed(evt);
            }
        });
        jMenu_Layout.add(jMenuItem_Circular);

        jMenuItem2.setText("Bipartite grid");
        jMenuItem2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem2ActionPerformed(evt);
            }
        });
        jMenu_Layout.add(jMenuItem2);

        jMenuItem3.setText("Random");
        jMenuItem3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem3ActionPerformed(evt);
            }
        });
        jMenu_Layout.add(jMenuItem3);

        jMenuMain.add(jMenu_Layout);

        jMenu_About.setText("About");
        jMenu_About.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jMenu_AboutMouseClicked(evt);
            }
        });
        jMenuMain.add(jMenu_About);

        setJMenuBar(jMenuMain);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(canvas, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 10, Short.MAX_VALUE))
            .addComponent(jLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(canvas, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 34, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jMenuItem_OpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_OpenActionPerformed
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("TXT", "txt");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            System.out.println("You chose to open this file: " + chooser.getSelectedFile().getAbsolutePath());
            Variables.input_file = chooser.getSelectedFile().getAbsolutePath();
            Variables.codebase = chooser.getSelectedFile().getParent() + "\\";

            create_graph();


            System.out.println("Iput file:" + Variables.input_file);
            System.out.println("Codebase:" + Variables.codebase);

        }
    }//GEN-LAST:event_jMenuItem_OpenActionPerformed

    private void jMenu_AboutMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jMenu_AboutMouseClicked
        JOptionPane.showMessageDialog(this, "Implementation: g.pavlopoulos@med.uoc.gr");
    }//GEN-LAST:event_jMenu_AboutMouseClicked

    private void jMenu_GraphMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jMenu_GraphMouseClicked
        // TODO add your handling code here:
    }//GEN-LAST:event_jMenu_GraphMouseClicked

    private void jMenu_GraphActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenu_GraphActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jMenu_GraphActionPerformed

    private void jMenuItem_Show_LabelsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_Show_LabelsActionPerformed
        Variables.show_labels = true;
    }//GEN-LAST:event_jMenuItem_Show_LabelsActionPerformed

    private void jMenuItem_Hide_LabelsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_Hide_LabelsActionPerformed
        Variables.show_labels = false;
    }//GEN-LAST:event_jMenuItem_Hide_LabelsActionPerformed

    private void jMenuItem_Direct_ConnectionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_Direct_ConnectionsActionPerformed
        Variables.show_direct_connections = true;
        Variables.show_indirect_connections = false;
    }//GEN-LAST:event_jMenuItem_Direct_ConnectionsActionPerformed

    private void jMenuItem_Indirect_ConnectionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_Indirect_ConnectionsActionPerformed
        Variables.show_direct_connections = false;
        Variables.show_indirect_connections = true;
    }//GEN-LAST:event_jMenuItem_Indirect_ConnectionsActionPerformed

    private void jMenuItem_Direct_Indirect_ConnectionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_Direct_Indirect_ConnectionsActionPerformed
        Variables.show_direct_connections = true;
        Variables.show_indirect_connections = true;
    }//GEN-LAST:event_jMenuItem_Direct_Indirect_ConnectionsActionPerformed

    private void jMenuItem_ExportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_ExportActionPerformed
        if (Variables.file_loaded == true) {
            //Variables.indirect_connections = Variables.gg.return_indirect_connections();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < Variables.indirect_connections.size(); i++) {
                buf.append(Variables.indirect_connections.get(i) + "\n");
            }
            String output = Variables.input_file.replace(".txt", "_indirect_connections.txt");
            Save_To_File(output, buf);
        }

    }//GEN-LAST:event_jMenuItem_ExportActionPerformed

    private void jMenuItem_Export_Indirect_Connections_LeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_Export_Indirect_Connections_LeftActionPerformed
        if (Variables.file_loaded == true) {
            //Variables.indirect_connections = Variables.gg.return_indirect_connections();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < Variables.indirect_connections.size(); i++) {
                String[] str = Variables.indirect_connections.get(i).split("\t");
                if (Variables.left.contains(str[0]) && Variables.left.contains(str[1])) {
                    buf.append(Variables.indirect_connections.get(i) + "\n");
                }
            }
            String output = Variables.input_file.replace(".txt", "_indirect_left_connections.txt");
            Save_To_File(output, buf);
        }
    }//GEN-LAST:event_jMenuItem_Export_Indirect_Connections_LeftActionPerformed

    private void jMenuItem_Export_Indirect_Connections_RightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_Export_Indirect_Connections_RightActionPerformed
        if (Variables.file_loaded == true) {
            //Variables.indirect_connections = Variables.gg.return_indirect_connections();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < Variables.indirect_connections.size(); i++) {
                String[] str = Variables.indirect_connections.get(i).split("\t");
                if (Variables.right.contains(str[0]) && Variables.right.contains(str[1])) {
                    buf.append(Variables.indirect_connections.get(i) + "\n");
                }
            }
            String output = Variables.input_file.replace(".txt", "_indirect_right_connections.txt");
            Save_To_File(output, buf);
        }
    }//GEN-LAST:event_jMenuItem_Export_Indirect_Connections_RightActionPerformed

    private void jMenuItem_fruchterman_directActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_fruchterman_directActionPerformed
        if (Variables.file_loaded == true) {
            try {
                calculate_fruhterman_direct();
                Variables.show_direct_connections = true;
                Variables.show_indirect_connections = false;
            } catch (Exception e) {
            }

        }
    }//GEN-LAST:event_jMenuItem_fruchterman_directActionPerformed

    private void jMenuItem_fruchterman_indirectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_fruchterman_indirectActionPerformed
        if (Variables.file_loaded == true) {
            try {
                calculate_fruhterman_indirect();
                Variables.show_direct_connections = false;
                Variables.show_indirect_connections = true;
            } catch (Exception e) {
            }

        }
    }//GEN-LAST:event_jMenuItem_fruchterman_indirectActionPerformed

    private void jMenuItem_fruchterman_direct_indirectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_fruchterman_direct_indirectActionPerformed
        if (Variables.file_loaded == true) {
            try {
                calculate_fruhterman_direct_indirect();
                Variables.show_direct_connections = true;
                Variables.show_indirect_connections = true;
            } catch (Exception e) {
            }

        }
    }//GEN-LAST:event_jMenuItem_fruchterman_direct_indirectActionPerformed

    private void jMenu_LayoutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenu_LayoutActionPerformed
    }//GEN-LAST:event_jMenu_LayoutActionPerformed

    private void jMenuItem_CircularActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_CircularActionPerformed
        if (Variables.file_loaded == true) {
            try {
                Apply_Circular_Coordinates();
            } catch (Exception e) {
            }

        }
    }//GEN-LAST:event_jMenuItem_CircularActionPerformed

    private void jMenuItem2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem2ActionPerformed
        if (Variables.file_loaded == true) {
            try {
                Apply_Bipartite_Coordinates();
            } catch (Exception e) {
            }

        }
    }//GEN-LAST:event_jMenuItem2ActionPerformed

    private void jMenuItem3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem3ActionPerformed
        if (Variables.file_loaded == true) {
            try {
                Apply_Random_Coordinates();
            } catch (Exception e) {
            }

        }
    }//GEN-LAST:event_jMenuItem3ActionPerformed

    private void jMenuItem4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem4ActionPerformed
        Variables.show_direct_connections = false;
        Variables.show_indirect_connections = false;
    }//GEN-LAST:event_jMenuItem4ActionPerformed
    //----------------------------------------------------------------------------------------------------------------------------

    public static void Apply_Random_Coordinates() {


        for (int i = 0; i < Variables.left.size(); i++) {
            Draggable d = Variables.give_label_get_Node.get(Variables.left.get(i));
            d.x = (float) randInt(2, Variables.canvas_width / 2);
            d.y = (float) randInt(2, Variables.canvas_height - 10);

        }


        for (int i = 0; i < Variables.right.size(); i++) {
            Draggable d = Variables.give_label_get_Node.get(Variables.right.get(i));
            d.x = (float) randInt(Variables.canvas_width / 2, Variables.canvas_width);
            d.y = (float) randInt(2, Variables.canvas_height - 10);
        }


    }

    public static int randInt(int min, int max) {
        Random rand = new Random();
        int randomNum = rand.nextInt((max - min) + 1) + min;
        return randomNum;
    }
    //----------------------------------------------------------------------------------------------------------------------------

    public static void Apply_Bipartite_Coordinates() {


        Point3d p;
        int nodes_per_column = 52;
        int cnt_x = 0;
        int cnt_y = 0;
        int pos_x = 0;
        int last_pos_x = 0;

        cnt_x = 0;
        cnt_y = 0;
        for (int i = 0; i < Variables.left.size(); i++) {
            Draggable d = Variables.give_label_get_Node.get(Variables.left.get(i));
            d.x = cnt_x;
            d.y = 15 * cnt_y;
            cnt_y++;
            if (i % 50 == 0 && i > 0) {
                cnt_x += 30;
                cnt_y = 1;
            }
            pos_x = (int) d.x + 10;
        }
        pos_x += 30;
        last_pos_x=pos_x;

        cnt_x = 0;
        cnt_y = 0;
        for (int i = 0; i < Variables.right.size(); i++) {
            Draggable d = Variables.give_label_get_Node.get(Variables.right.get(i));
            d.x = (int) pos_x + cnt_x;
            d.y = 15 * cnt_y;
            cnt_y++;
            if (i % 50 == 0 && i > 0) {
                cnt_x += 30;
                cnt_y = 1;
                if(d.x>=Variables.canvas_width-10)
                    cnt_x=last_pos_x;
            }
            
              
            
        }


    }

    //----------------------------------------------------------------------------------------------------------------------------
    public static void Apply_Circular_Coordinates() {

        double CurX, CurY, prosX, prosY;
        ArrayList<Point3d> point_set = new ArrayList();
        Point3d p;
        if (Variables.unique.size() >= 2) {
            double R = (Variables.canvas_width - 100) / 2;
            double Xc = Variables.canvas_width / 2, Yc = Variables.canvas_height / 2;
            double x = 0, y = R;
            double Du = 0, angle_step;
            double[][] ctrlpoints = new double[Variables.unique.size()][2];

            angle_step = 360f / (Variables.unique.size() + 1);
            /**
             * ***********************************
             */
            for (int i = 0; i < Variables.unique.size(); i++) {
                x = Xc + R * (float) Math.cos(Math.toRadians(Du));
                y = Yc + R * (float) Math.sin(Math.toRadians(Du));
                ctrlpoints[i][0] = x;
                ctrlpoints[i][1] = y;
                Du = Du + angle_step;
                CurX = ctrlpoints[i][0];
                CurY = ctrlpoints[i][1];
                p = new Point3d(CurX, CurY, 0);
                point_set.add(p);
            }
            int counter = 0;
            for (int i = 0; i < Variables.left.size(); i++) {
                Draggable d = Variables.give_label_get_Node.get(Variables.left.get(i));
                d.x = (float) point_set.get(counter).x;
                d.y = (float) point_set.get(counter).y;
                counter++;
            }
            for (int i = 0; i < Variables.right.size(); i++) {
                Draggable d = Variables.give_label_get_Node.get(Variables.right.get(i));
                d.x = (float) point_set.get(counter).x;
                d.y = (float) point_set.get(counter).y;
                counter++;
            }
        }
    }

    public void calculate_fruhterman_direct() {
        ArrayList<DefaultDrawableNode> agentList = new ArrayList();
        DefaultDrawableNode node;
        graphLayout = new Fruchterman(Variables.canvas_width - 50, Variables.canvas_height - 50);

        for (int i = 0; i < Variables.unique.size(); i++) {
            node = new DefaultDrawableNode();
            node.setNodeLabel(Variables.unique.get(i));
            node.setX(Math.random());
            node.setY(Math.random());
            agentList.add(node);
        }
        for (int i = 0; i < Variables.direct_connections.size(); i++) {
            String[] str = Variables.direct_connections.get(i).split("\t");
            EdgeFactory.createEdge(agentList.get(Variables.unique.indexOf(str[0])), agentList.get(Variables.unique.indexOf(str[1])), "edge", (float) 1);
        }

//        for (int i = 0; i < agentList.size(); i++) {
//            System.out.println("*" + agentList.get(i).getNodeLabel() + "\t" + agentList.get(i).getX() + " " + agentList.get(i).getY());
//        }

        graphLayout.setList(agentList);


        graphLayout.updateLayout();


        for (int i = 0; i < agentList.size(); i++) {
            Draggable d = Variables.give_label_get_Node.get(agentList.get(i).getNodeLabel());
            d.x = (float) agentList.get(i).getX();
            d.y = (float) agentList.get(i).getY();
        }

    }

    public void calculate_fruhterman_direct_indirect() {
        ArrayList<DefaultDrawableNode> agentList = new ArrayList();
        DefaultDrawableNode node;
        graphLayout = new Fruchterman(Variables.canvas_width - 50, Variables.canvas_height - 50);

        for (int i = 0; i < Variables.unique.size(); i++) {
            node = new DefaultDrawableNode();
            node.setNodeLabel(Variables.unique.get(i));
            node.setX(Math.random());
            node.setY(Math.random());
            agentList.add(node);
        }
        for (int i = 0; i < Variables.direct_connections.size(); i++) {
            String[] str = Variables.direct_connections.get(i).split("\t");
            EdgeFactory.createEdge(agentList.get(Variables.unique.indexOf(str[0])), agentList.get(Variables.unique.indexOf(str[1])), "edge", (float) 1);
        }
        for (int i = 0; i < Variables.indirect_connections.size(); i++) {
            String[] str = Variables.indirect_connections.get(i).split("\t");
            EdgeFactory.createEdge(agentList.get(Variables.unique.indexOf(str[0])), agentList.get(Variables.unique.indexOf(str[1])), "edge", (float) 1);
        }

//        for (int i = 0; i < agentList.size(); i++) {
//            System.out.println("*" + agentList.get(i).getNodeLabel() + "\t" + agentList.get(i).getX() + " " + agentList.get(i).getY());
//        }

        graphLayout.setList(agentList);


        graphLayout.updateLayout();


        for (int i = 0; i < agentList.size(); i++) {
            Draggable d = Variables.give_label_get_Node.get(agentList.get(i).getNodeLabel());
            d.x = (float) agentList.get(i).getX();
            d.y = (float) agentList.get(i).getY();
        }

    }

    public void calculate_fruhterman_indirect() {
        ArrayList<DefaultDrawableNode> agentList = new ArrayList();
        DefaultDrawableNode node;
        graphLayout = new Fruchterman(Variables.canvas_width - 50, Variables.canvas_height - 50);

        for (int i = 0; i < Variables.unique.size(); i++) {
            node = new DefaultDrawableNode();
            node.setNodeLabel(Variables.unique.get(i));
            node.setX(Math.random());
            node.setY(Math.random());
            agentList.add(node);
        }

        for (int i = 0; i < Variables.indirect_connections.size(); i++) {
            String[] str = Variables.indirect_connections.get(i).split("\t");
            EdgeFactory.createEdge(agentList.get(Variables.unique.indexOf(str[0])), agentList.get(Variables.unique.indexOf(str[1])), "edge", (float) 1);
        }

//        for (int i = 0; i < agentList.size(); i++) {
//            System.out.println("*" + agentList.get(i).getNodeLabel() + "\t" + agentList.get(i).getX() + " " + agentList.get(i).getY());
//        }

        graphLayout.setList(agentList);

        graphLayout.updateLayout();


        for (int i = 0; i < agentList.size(); i++) {
            Draggable d = Variables.give_label_get_Node.get(agentList.get(i).getNodeLabel());
            d.x = (float) agentList.get(i).getX();
            d.y = (float) agentList.get(i).getY();
        }

    }

    public static void Save_To_File(String filename, StringBuffer message) {
        try {
            BufferedWriter outp = new BufferedWriter(new FileWriter(filename));
            outp.append(message.toString());
            outp.close();
            System.out.println("Indirect connections format was saved to " + filename + " file.");
        } catch (IOException e) {
        }

    }
    /*
     * @param args the command line arguments
     */

    public static void main(String args[]) {

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                frame = new Bipartite();
                final Graph draw = new Graph();
                draw.init();
                Bipartite.canvas.add(draw);
                jMenu_File.getPopupMenu().setLightWeightPopupEnabled(false);
                jMenu_About.getPopupMenu().setLightWeightPopupEnabled(false);
                frame.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public static javax.swing.JPanel canvas;
    public static javax.swing.JLabel jLabel;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu10;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JMenu jMenu4;
    private javax.swing.JMenu jMenu5;
    private javax.swing.JMenu jMenu6;
    private javax.swing.JMenu jMenu7;
    private javax.swing.JMenu jMenu8;
    private javax.swing.JMenu jMenu9;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuBar jMenuBar2;
    private javax.swing.JMenuBar jMenuBar3;
    private javax.swing.JMenuBar jMenuBar4;
    private javax.swing.JMenuBar jMenuBar5;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem3;
    private javax.swing.JMenuItem jMenuItem4;
    private javax.swing.JMenuItem jMenuItem_Circular;
    private javax.swing.JMenuItem jMenuItem_Direct_Connections;
    private javax.swing.JMenuItem jMenuItem_Direct_Indirect_Connections;
    private javax.swing.JMenuItem jMenuItem_Export;
    private javax.swing.JMenuItem jMenuItem_Export_Indirect_Connections_Left;
    private javax.swing.JMenuItem jMenuItem_Export_Indirect_Connections_Right;
    private javax.swing.JMenuItem jMenuItem_Hide_Labels;
    private javax.swing.JMenuItem jMenuItem_Indirect_Connections;
    public static javax.swing.JMenuItem jMenuItem_Open;
    private javax.swing.JMenuItem jMenuItem_Show_Labels;
    private javax.swing.JMenuItem jMenuItem_fruchterman_direct;
    private javax.swing.JMenuItem jMenuItem_fruchterman_direct_indirect;
    private javax.swing.JMenuItem jMenuItem_fruchterman_indirect;
    public static javax.swing.JMenuBar jMenuMain;
    public static javax.swing.JMenu jMenu_About;
    public static javax.swing.JMenu jMenu_File;
    public static javax.swing.JMenu jMenu_Graph;
    public static javax.swing.JMenu jMenu_Layout;
    // End of variables declaration//GEN-END:variables
}
