/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import com.sun.media.jai.util.PropertyGeneratorImpl;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;

class TranslatePropertyGenerator
extends PropertyGeneratorImpl {
    public TranslatePropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    public Object getProperty(String string, Object object) {
        this.validate(string, object);
        if (object instanceof RenderedOp && string.equalsIgnoreCase("roi")) {
            RenderedOp renderedOp = (RenderedOp)object;
            ParameterBlock parameterBlock = renderedOp.getParameterBlock();
            RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
            Object object2 = renderedImage.getProperty("ROI");
            if (object2 == null || object2.equals(Image.UndefinedProperty) || !(object2 instanceof ROI)) {
                return Image.UndefinedProperty;
            }
            ROI rOI = (ROI)object2;
            Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(2);
            Rectangle rectangle = null;
            PlanarImage planarImage = renderedOp.getRendering();
            rectangle = planarImage instanceof GeometricOpImage && ((GeometricOpImage)planarImage).getBorderExtender() == null ? new Rectangle(renderedImage.getMinX() + interpolation.getLeftPadding(), renderedImage.getMinY() + interpolation.getTopPadding(), renderedImage.getWidth() - interpolation.getWidth() + 1, renderedImage.getHeight() - interpolation.getHeight() + 1) : new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            if (!rectangle.contains(rOI.getBounds())) {
                rOI = rOI.intersect(new ROIShape(rectangle));
            }
            float f = parameterBlock.getFloatParameter(0);
            float f2 = parameterBlock.getFloatParameter(1);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
            ROI rOI2 = rOI.transform(affineTransform);
            Rectangle rectangle2 = renderedOp.getBounds();
            if (!rectangle2.contains(rOI2.getBounds())) {
                rOI2 = rOI2.intersect(new ROIShape(rectangle2));
            }
            return rOI2;
        }
        return Image.UndefinedProperty;
    }
}

