/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.media.jai.util.PropertyUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageJAI;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.SnapshotImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileFactory;
import javax.media.jai.TileRequest;
import javax.media.jai.WritablePropertySourceImpl;
import javax.media.jai.WritableRenderedImageAdapter;

public abstract class PlanarImage
implements ImageJAI,
RenderedImage {
    private Object UID;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    private Rectangle bounds = null;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected int tileWidth;
    protected int tileHeight;
    protected SampleModel sampleModel = null;
    protected ColorModel colorModel = null;
    protected TileFactory tileFactory = null;
    private Vector sources = null;
    private Vector sinks = null;
    protected PropertyChangeSupportJAI eventManager = null;
    protected WritablePropertySourceImpl properties = null;
    private SnapshotImage snapshot = null;
    private WeakReference weakThis = new WeakReference<PlanarImage>(this);
    private Set tileListeners = null;
    private boolean disposed = false;
    private static final int MIN_ARRAYCOPY_SIZE = 64;

    public PlanarImage() {
        this.eventManager = new PropertyChangeSupportJAI(this);
        this.properties = new WritablePropertySourceImpl(null, null, this.eventManager);
        this.UID = ImageUtil.generateID(this);
    }

    public PlanarImage(ImageLayout imageLayout, Vector vector, Map map) {
        this();
        if (imageLayout != null) {
            this.setImageLayout(imageLayout);
        }
        if (vector != null) {
            this.setSources(vector);
        }
        if (map != null) {
            Object v;
            this.properties.addProperties(map);
            if (map.containsKey(JAI.KEY_TILE_FACTORY) && (v = map.get(JAI.KEY_TILE_FACTORY)) instanceof TileFactory) {
                this.tileFactory = (TileFactory)v;
            }
        }
    }

    protected void setImageLayout(ImageLayout imageLayout) {
        if (imageLayout == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (imageLayout.isValid(1)) {
            this.minX = imageLayout.getMinX(null);
        }
        if (imageLayout.isValid(2)) {
            this.minY = imageLayout.getMinY(null);
        }
        if (imageLayout.isValid(4)) {
            this.width = imageLayout.getWidth(null);
        }
        if (imageLayout.isValid(8)) {
            this.height = imageLayout.getHeight(null);
        }
        if (imageLayout.isValid(16)) {
            this.tileGridXOffset = imageLayout.getTileGridXOffset(null);
        }
        if (imageLayout.isValid(32)) {
            this.tileGridYOffset = imageLayout.getTileGridYOffset(null);
        }
        this.tileWidth = imageLayout.isValid(64) ? imageLayout.getTileWidth(null) : this.width;
        this.tileHeight = imageLayout.isValid(128) ? imageLayout.getTileHeight(null) : this.height;
        if (imageLayout.isValid(256)) {
            this.sampleModel = imageLayout.getSampleModel(null);
        }
        if (this.sampleModel != null && this.tileWidth > 0 && this.tileHeight > 0 && (this.sampleModel.getWidth() != this.tileWidth || this.sampleModel.getHeight() != this.tileHeight)) {
            this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        }
        if (imageLayout.isValid(512)) {
            this.colorModel = imageLayout.getColorModel(null);
        }
        if (this.colorModel != null && this.sampleModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage5"));
        }
    }

    public static PlanarImage wrapRenderedImage(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (renderedImage instanceof PlanarImage) {
            return (PlanarImage)renderedImage;
        }
        if (renderedImage instanceof WritableRenderedImage) {
            return new WritableRenderedImageAdapter((WritableRenderedImage)renderedImage);
        }
        return new RenderedImageAdapter(renderedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanarImage createSnapshot() {
        if (this instanceof WritableRenderedImage) {
            if (this.snapshot == null) {
                PlanarImage planarImage = this;
                synchronized (planarImage) {
                    this.snapshot = new SnapshotImage(this);
                }
            }
            return this.snapshot.createSnapshot();
        }
        return this;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.getMinX() + this.getWidth();
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.getMinY() + this.getHeight();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumBands() {
        return this.getSampleModel().getNumBands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        if (this.bounds == null) {
            PlanarImage planarImage = this;
            synchronized (planarImage) {
                this.bounds = new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
            }
        }
        Rectangle rectangle = this.bounds;
        synchronized (rectangle) {
            this.bounds.setBounds(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
        }
        return this.bounds;
    }

    public int getTileGridXOffset() {
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        return this.tileGridYOffset;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getMinTileX() {
        return PlanarImage.XToTileX(this.getMinX(), this.getTileGridXOffset(), this.getTileWidth());
    }

    public int getMaxTileX() {
        return PlanarImage.XToTileX(this.getMinX() + this.getWidth() - 1, this.getTileGridXOffset(), this.getTileWidth());
    }

    public int getNumXTiles() {
        int n = this.getMinX();
        int n2 = this.getTileGridXOffset();
        int n3 = this.getTileWidth();
        return PlanarImage.XToTileX(n + this.getWidth() - 1, n2, n3) - PlanarImage.XToTileX(n, n2, n3) + 1;
    }

    public int getMinTileY() {
        return PlanarImage.YToTileY(this.getMinY(), this.getTileGridYOffset(), this.getTileHeight());
    }

    public int getMaxTileY() {
        return PlanarImage.YToTileY(this.getMinY() + this.getHeight() - 1, this.getTileGridYOffset(), this.getTileHeight());
    }

    public int getNumYTiles() {
        int n = this.getMinY();
        int n2 = this.getTileGridYOffset();
        int n3 = this.getTileHeight();
        return PlanarImage.YToTileY(n + this.getHeight() - 1, n2, n3) - PlanarImage.YToTileY(n, n2, n3) + 1;
    }

    public static int XToTileX(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    public static int YToTileY(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    public int XToTileX(int n) {
        return PlanarImage.XToTileX(n, this.getTileGridXOffset(), this.getTileWidth());
    }

    public int YToTileY(int n) {
        return PlanarImage.YToTileY(n, this.getTileGridYOffset(), this.getTileHeight());
    }

    public static int tileXToX(int n, int n2, int n3) {
        return n * n3 + n2;
    }

    public static int tileYToY(int n, int n2, int n3) {
        return n * n3 + n2;
    }

    public int tileXToX(int n) {
        return PlanarImage.tileXToX(n, this.getTileGridXOffset(), this.getTileWidth());
    }

    public int tileYToY(int n) {
        return PlanarImage.tileYToY(n, this.getTileGridYOffset(), this.getTileHeight());
    }

    public Rectangle getTileRect(int n, int n2) {
        return this.getBounds().intersection(new Rectangle(this.tileXToX(n), this.tileYToY(n2), this.getTileWidth(), this.getTileHeight()));
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public static ColorModel getDefaultColorModel(int n, int n2) {
        if (n < 0 || n == 2 || n > 5 || n2 < 1 || n2 > 4) {
            return null;
        }
        ColorSpace colorSpace = n2 <= 2 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
        boolean bl = n2 == 2 || n2 == 4;
        int n3 = bl ? 3 : 1;
        return RasterFactory.createComponentColorModel(n, colorSpace, bl, false, n3);
    }

    public static ColorModel createColorModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = sampleModel.getNumBands();
        if (n < 1 || n > 4) {
            return null;
        }
        if (sampleModel instanceof ComponentSampleModel) {
            return PlanarImage.getDefaultColorModel(sampleModel.getDataType(), n);
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int[] nArray = singlePixelPackedSampleModel.getBitMasks();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = nArray.length;
            if (n6 <= 2) {
                n3 = n4 = nArray[0];
                n2 = n4;
                if (n6 == 2) {
                    n5 = nArray[1];
                }
            } else {
                n2 = nArray[0];
                n3 = nArray[1];
                n4 = nArray[2];
                if (n6 == 4) {
                    n5 = nArray[3];
                }
            }
            int[] nArray2 = singlePixelPackedSampleModel.getSampleSize();
            int n7 = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                n7 += nArray2[i];
            }
            return new DirectColorModel(n7, n2, n3, n4, n5);
        }
        if (ImageUtil.isBinary(sampleModel)) {
            byte[] byArray = new byte[]{0, -1};
            return new IndexColorModel(1, 2, byArray, byArray, byArray);
        }
        return null;
    }

    public TileFactory getTileFactory() {
        return this.tileFactory;
    }

    public int getNumSources() {
        return this.sources == null ? 0 : this.sources.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSources() {
        if (this.getNumSources() == 0) {
            return null;
        }
        Vector vector = this.sources;
        synchronized (vector) {
            return (Vector)this.sources.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanarImage getSource(int n) {
        if (this.sources == null) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage0"));
        }
        Vector vector = this.sources;
        synchronized (vector) {
            return (PlanarImage)this.sources.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSources(List list) {
        Object e;
        if (list == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = list.size();
        Object object = this;
        synchronized (object) {
            if (this.sources != null) {
                Iterator iterator = this.sources.iterator();
                while (iterator.hasNext()) {
                    e = iterator.next();
                    if (!(e instanceof PlanarImage)) continue;
                    ((PlanarImage)e).removeSink(this);
                }
            }
            this.sources = new Vector(n);
        }
        object = this.sources;
        synchronized (object) {
            for (int i = 0; i < n; ++i) {
                e = list.get(i);
                if (e == null) {
                    throw new IllegalArgumentException(JaiI18N.getString("PlanarImage7"));
                }
                this.sources.add(e instanceof RenderedImage ? PlanarImage.wrapRenderedImage((RenderedImage)e) : e);
                if (!(e instanceof PlanarImage)) continue;
                ((PlanarImage)e).addSink(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSources() {
        if (this.sources != null) {
            PlanarImage planarImage = this;
            synchronized (planarImage) {
                if (this.sources != null) {
                    Iterator iterator = this.sources.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof PlanarImage)) continue;
                        ((PlanarImage)e).removeSink(this);
                    }
                }
                this.sources = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanarImage getSourceImage(int n) {
        if (this.sources == null) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage0"));
        }
        Vector vector = this.sources;
        synchronized (vector) {
            return (PlanarImage)this.sources.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSourceObject(int n) {
        if (this.sources == null) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage0"));
        }
        Vector vector = this.sources;
        synchronized (vector) {
            return this.sources.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSource(Object object) {
        Object object2;
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sources == null) {
            object2 = this;
            synchronized (object2) {
                this.sources = new Vector();
            }
        }
        object2 = this.sources;
        synchronized (object2) {
            this.sources.add(object instanceof RenderedImage ? PlanarImage.wrapRenderedImage((RenderedImage)object) : object);
        }
        if (object instanceof PlanarImage) {
            ((PlanarImage)object).addSink(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSource(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sources == null) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage0"));
        }
        Vector vector = this.sources;
        synchronized (vector) {
            if (n < this.sources.size() && this.sources.get(n) instanceof PlanarImage) {
                this.getSourceImage(n).removeSink(this);
            }
            this.sources.set(n, object instanceof RenderedImage ? PlanarImage.wrapRenderedImage((RenderedImage)object) : object);
        }
        if (object instanceof PlanarImage) {
            ((PlanarImage)object).addSink(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSource(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sources == null) {
            return false;
        }
        Vector vector = this.sources;
        synchronized (vector) {
            if (object instanceof PlanarImage) {
                ((PlanarImage)object).removeSink(this);
            }
            return this.sources.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSinks() {
        Vector vector = null;
        if (this.sinks != null) {
            Vector vector2 = this.sinks;
            synchronized (vector2) {
                int n = this.sinks.size();
                vector = new Vector(n);
                for (int i = 0; i < n; ++i) {
                    Object t = ((WeakReference)this.sinks.get(i)).get();
                    if (t == null) continue;
                    vector.add(t);
                }
            }
            if (vector.size() == 0) {
                vector = null;
            }
        }
        return vector;
    }

    public synchronized boolean addSink(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            this.sinks = new Vector();
        }
        boolean bl = false;
        bl = object instanceof PlanarImage ? this.sinks.add(((PlanarImage)object).weakThis) : this.sinks.add(new WeakReference<Object>(object));
        return bl;
    }

    public synchronized boolean removeSink(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            return false;
        }
        boolean bl = false;
        if (object instanceof PlanarImage) {
            bl = this.sinks.remove(((PlanarImage)object).weakThis);
        } else {
            Iterator iterator = this.sinks.iterator();
            while (iterator.hasNext()) {
                Object t = ((WeakReference)iterator.next()).get();
                if (t == object) {
                    iterator.remove();
                    bl = true;
                    continue;
                }
                if (t != null) continue;
                iterator.remove();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSink(PlanarImage planarImage) {
        Object object;
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            object = this;
            synchronized (object) {
                this.sinks = new Vector();
            }
        }
        object = this.sinks;
        synchronized (object) {
            this.sinks.add(planarImage.weakThis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSink(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            return false;
        }
        Vector vector = this.sinks;
        synchronized (vector) {
            return this.sinks.remove(planarImage.weakThis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSinks() {
        if (this.sinks != null) {
            PlanarImage planarImage = this;
            synchronized (planarImage) {
                this.sinks = null;
            }
        }
    }

    protected Hashtable getProperties() {
        return (Hashtable)this.properties.getProperties();
    }

    protected void setProperties(Hashtable hashtable) {
        this.properties.addProperties(hashtable);
    }

    public Object getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public Class getPropertyClass(String string) {
        return this.properties.getPropertyClass(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.setProperty(string, object);
    }

    public void removeProperty(String string) {
        this.properties.removeProperty(string);
    }

    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String[] getPropertyNames(String string) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(string.toLowerCase(), propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(string.toLowerCase(), propertyChangeListener);
    }

    private synchronized Set getTileComputationListeners(boolean bl) {
        if (bl && this.tileListeners == null) {
            this.tileListeners = Collections.synchronizedSet(new HashSet());
        }
        return this.tileListeners;
    }

    public synchronized void addTileComputationListener(TileComputationListener tileComputationListener) {
        if (tileComputationListener == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Set set = this.getTileComputationListeners(true);
        set.add(tileComputationListener);
    }

    public synchronized void removeTileComputationListener(TileComputationListener tileComputationListener) {
        if (tileComputationListener == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Set set = this.getTileComputationListeners(false);
        if (set != null) {
            set.remove(tileComputationListener);
        }
    }

    public TileComputationListener[] getTileComputationListeners() {
        Set set = this.getTileComputationListeners(false);
        if (set == null) {
            return null;
        }
        return set.toArray(new TileComputationListener[set.size()]);
    }

    public void getSplits(IntegerSequence integerSequence, IntegerSequence integerSequence2, Rectangle rectangle) {
        int n;
        if (integerSequence == null || integerSequence2 == null || rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.tileXToX(n2);
        for (n = n2; n <= n3; ++n) {
            integerSequence.insert(n4);
            n4 += this.tileWidth;
        }
        n = this.YToTileY(rectangle.y);
        int n5 = this.YToTileY(rectangle.y + rectangle.height - 1);
        int n6 = this.tileYToY(n);
        for (int i = n; i <= n5; ++i) {
            integerSequence2.insert(n6);
            n6 += this.tileHeight;
        }
    }

    public Point[] getTileIndices(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = (Rectangle)this.getBounds().clone();
        } else {
            if (!rectangle.intersects(this.getBounds())) {
                return null;
            }
            if ((rectangle = rectangle.intersection(this.getBounds())).isEmpty()) {
                return null;
            }
        }
        if (rectangle == null) {
            rectangle = this.getBounds();
        } else {
            Rectangle rectangle2 = new Rectangle(this.getMinX(), this.getMinY(), this.getWidth() + 1, this.getHeight() + 1);
            if (!rectangle.intersects(rectangle2)) {
                return null;
            }
            rectangle = rectangle.intersection(rectangle2);
        }
        int n = this.XToTileX(rectangle.x);
        int n2 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n3 = this.YToTileY(rectangle.y);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        Point[] pointArray = new Point[(n4 - n3 + 1) * (n2 - n + 1)];
        int n5 = 0;
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                pointArray[n5++] = new Point(j, i);
            }
        }
        return pointArray;
    }

    public boolean overlapsMultipleTiles(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException("rect == null!");
        }
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        return !rectangle2.isEmpty() && (this.XToTileX(rectangle2.x) != this.XToTileX(rectangle2.x + rectangle2.width - 1) || this.YToTileY(rectangle2.y) != this.YToTileY(rectangle2.y + rectangle2.height - 1));
    }

    protected final WritableRaster createWritableRaster(SampleModel sampleModel, Point point) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        return this.tileFactory != null ? this.tileFactory.createTile(sampleModel, point) : RasterFactory.createWritableRaster(sampleModel, point);
    }

    public Raster getData() {
        return this.getData(null);
    }

    public Raster getData(Rectangle rectangle) {
        WritableRaster writableRaster;
        int n;
        int n2;
        Rectangle rectangle2 = this.getBounds();
        if (rectangle == null) {
            rectangle = rectangle2;
        } else if (!rectangle.intersects(rectangle2)) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage4"));
        }
        Rectangle rectangle3 = rectangle == rectangle2 ? rectangle : rectangle.intersection(rectangle2);
        int n3 = this.XToTileX(rectangle3.x);
        int n4 = this.YToTileY(rectangle3.y);
        int n5 = this.XToTileX(rectangle3.x + rectangle3.width - 1);
        int n6 = this.YToTileY(rectangle3.y + rectangle3.height - 1);
        if (n3 == n5 && n4 == n6 && this.getTileRect(n3, n4).contains(rectangle)) {
            Raster raster = this.getTile(n3, n4);
            if (this instanceof WritableRenderedImage) {
                SampleModel sampleModel = raster.getSampleModel();
                if (sampleModel.getWidth() != rectangle.width || sampleModel.getHeight() != rectangle.height) {
                    sampleModel = sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
                }
                WritableRaster writableRaster2 = this.createWritableRaster(sampleModel, rectangle.getLocation());
                Raster raster2 = raster.getBounds().equals(rectangle) ? raster : raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
                JDKWorkarounds.setRect(writableRaster2, raster2);
                return writableRaster2;
            }
            return raster.getBounds().equals(rectangle) ? raster : raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        }
        SampleModel sampleModel = this.getSampleModel();
        int n7 = sampleModel.getDataType();
        int n8 = sampleModel.getNumBands();
        boolean bl = false;
        ComponentSampleModel componentSampleModel = null;
        int[] nArray = null;
        boolean bl2 = false;
        if (sampleModel instanceof ComponentSampleModel) {
            componentSampleModel = (ComponentSampleModel)sampleModel;
            int n9 = componentSampleModel.getPixelStride();
            n2 = n9 == 1 && n8 > 1 ? 1 : 0;
            boolean bl3 = bl = n9 > 1 && n8 != n9;
            if (!bl && n2 == 0) {
                nArray = componentSampleModel.getBandOffsets();
                for (n = 0; n < n8 && nArray[n] < n8; ++n) {
                }
                if (n == n8) {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            try {
                SampleModel sampleModel2 = RasterFactory.createPixelInterleavedSampleModel(n7, rectangle.width, rectangle.height, n8, rectangle.width * n8, nArray);
                writableRaster = this.createWritableRaster(sampleModel2, rectangle.getLocation());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(JaiI18N.getString("PlanarImage2"));
            }
            switch (n7) {
                case 0: {
                    this.cobbleByte(rectangle, writableRaster);
                    break;
                }
                case 2: {
                    this.cobbleShort(rectangle, writableRaster);
                    break;
                }
                case 1: {
                    this.cobbleUShort(rectangle, writableRaster);
                    break;
                }
                case 3: {
                    this.cobbleInt(rectangle, writableRaster);
                    break;
                }
                case 4: {
                    this.cobbleFloat(rectangle, writableRaster);
                    break;
                }
                case 5: {
                    this.cobbleDouble(rectangle, writableRaster);
                    break;
                }
            }
        } else {
            SampleModel sampleModel3 = this.sampleModel;
            if (sampleModel3.getWidth() != rectangle.width || sampleModel3.getHeight() != rectangle.height) {
                sampleModel3 = sampleModel3.createCompatibleSampleModel(rectangle.width, rectangle.height);
            }
            try {
                writableRaster = this.createWritableRaster(sampleModel3, rectangle.getLocation());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(JaiI18N.getString("PlanarImage2"));
            }
            for (n2 = n4; n2 <= n6; ++n2) {
                for (n = n3; n <= n5; ++n) {
                    Raster raster = this.getTile(n, n2);
                    Rectangle rectangle4 = rectangle.intersection(raster.getBounds());
                    Raster raster3 = raster.createChild(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, rectangle4.x, rectangle4.y, null);
                    if (sampleModel3 instanceof ComponentSampleModel && bl) {
                        switch (sampleModel3.getDataType()) {
                            case 4: {
                                writableRaster.setPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, raster3.getPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, new float[n8 * rectangle4.width * rectangle4.height]));
                                break;
                            }
                            case 5: {
                                writableRaster.setPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, raster3.getPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, new double[n8 * rectangle4.width * rectangle4.height]));
                                break;
                            }
                            default: {
                                writableRaster.setPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, raster3.getPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, new int[n8 * rectangle4.width * rectangle4.height]));
                                break;
                            }
                        }
                        continue;
                    }
                    JDKWorkarounds.setRect(writableRaster, raster3);
                }
            }
        }
        return writableRaster;
    }

    public WritableRaster copyData() {
        return this.copyData(null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        Rectangle rectangle;
        if (writableRaster == null) {
            rectangle = this.getBounds();
            SampleModel sampleModel = this.getSampleModel();
            if (sampleModel.getWidth() != rectangle.width || sampleModel.getHeight() != rectangle.height) {
                sampleModel = sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
            }
            writableRaster = this.createWritableRaster(sampleModel, rectangle.getLocation());
        } else {
            rectangle = writableRaster.getBounds().intersection(this.getBounds());
            if (rectangle.isEmpty()) {
                return writableRaster;
            }
        }
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        SampleModel[] sampleModelArray = new SampleModel[]{this.getSampleModel()};
        int n5 = RasterAccessor.findCompatibleTag(sampleModelArray, writableRaster.getSampleModel());
        RasterFormatTag rasterFormatTag = new RasterFormatTag(this.getSampleModel(), n5);
        RasterFormatTag rasterFormatTag2 = new RasterFormatTag(writableRaster.getSampleModel(), n5);
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                Raster raster = this.getTile(j, i);
                Rectangle rectangle2 = rectangle.intersection(raster.getBounds());
                RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTag, this.getColorModel());
                RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle2, rasterFormatTag2, null);
                ImageUtil.copyRaster(rasterAccessor, rasterAccessor2);
            }
        }
        return writableRaster;
    }

    public void copyExtendedData(WritableRaster writableRaster, BorderExtender borderExtender) {
        if (writableRaster == null || borderExtender == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Rectangle rectangle = writableRaster.getBounds();
        Rectangle rectangle2 = this.getBounds();
        if (rectangle2.contains(rectangle)) {
            this.copyData(writableRaster);
            return;
        }
        Rectangle rectangle3 = rectangle2.intersection(rectangle);
        if (!rectangle3.isEmpty()) {
            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
            this.copyData(writableRaster2);
        }
        borderExtender.extend(writableRaster, this);
    }

    public Raster getExtendedData(Rectangle rectangle, BorderExtender borderExtender) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.getBounds().contains(rectangle)) {
            return this.getData(rectangle);
        }
        if (borderExtender == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        SampleModel sampleModel = this.getSampleModel();
        if (sampleModel.getWidth() != rectangle.width || sampleModel.getHeight() != rectangle.height) {
            sampleModel = sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        }
        WritableRaster writableRaster = this.createWritableRaster(sampleModel, rectangle.getLocation());
        this.copyExtendedData(writableRaster, borderExtender);
        return writableRaster;
    }

    public BufferedImage getAsBufferedImage(Rectangle rectangle, ColorModel colorModel) {
        if (colorModel == null && (colorModel = this.getColorModel()) == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage6"));
        }
        if (!JDKWorkarounds.areCompatibleDataModels(this.sampleModel, colorModel)) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage3"));
        }
        rectangle = rectangle == null ? this.getBounds() : this.getBounds().intersection(rectangle);
        SampleModel sampleModel = this.sampleModel.getWidth() != rectangle.width || this.sampleModel.getHeight() != rectangle.height ? this.sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height) : this.sampleModel;
        WritableRaster writableRaster = this.createWritableRaster(sampleModel, rectangle.getLocation());
        this.copyData(writableRaster);
        if (rectangle.x != 0 || rectangle.y != 0) {
            writableRaster = RasterFactory.createWritableChild(writableRaster, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, null);
        }
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage getAsBufferedImage() {
        return this.getAsBufferedImage(null, null);
    }

    public Graphics getGraphics() {
        throw new IllegalAccessError(JaiI18N.getString("PlanarImage1"));
    }

    public abstract Raster getTile(int var1, int var2);

    public Raster[] getTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = pointArray.length;
        Raster[] rasterArray = new Raster[n];
        for (int i = 0; i < pointArray.length; ++i) {
            Point point = pointArray[i];
            rasterArray[i] = this.getTile(point.x, point.y);
        }
        return rasterArray;
    }

    public Raster[] getTiles() {
        return this.getTiles(this.getTileIndices(this.getBounds()));
    }

    public TileRequest queueTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        TileComputationListener[] tileComputationListenerArray = this.getTileComputationListeners();
        return JAI.getDefaultInstance().getTileScheduler().scheduleTiles(this, pointArray, tileComputationListenerArray);
    }

    public void cancelTiles(TileRequest tileRequest, Point[] pointArray) {
        if (tileRequest == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic4"));
        }
        JAI.getDefaultInstance().getTileScheduler().cancelTiles(tileRequest, pointArray);
    }

    public void prefetchTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        JAI.getDefaultInstance().getTileScheduler().prefetchTiles(this, pointArray);
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        Vector vector = this.getSources();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Object e = vector.get(i);
                if (!(e instanceof PlanarImage)) continue;
                ((PlanarImage)e).removeSink(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    private void printBounds() {
        System.out.println("Bounds: [x=" + this.getMinX() + ", y=" + this.getMinY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "]");
    }

    private void printTile(int n, int n2) {
        int n3 = n * this.getTileWidth() + this.getTileGridXOffset();
        int n4 = n2 * this.getTileHeight() + this.getTileGridYOffset();
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle(n3, n4, this.getTileWidth(), this.getTileHeight());
        rectangle2 = rectangle2.intersection(rectangle);
        Raster raster = this.getTile(n, n2);
        Rectangle rectangle3 = new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
        System.out.println("Tile bounds (actual)   = " + rectangle3);
        System.out.println("Tile bounds (computed) = " + rectangle2);
        n3 = rectangle2.x;
        n4 = rectangle2.y;
        int n5 = rectangle2.x + rectangle2.width - 1;
        int n6 = rectangle2.y + rectangle2.height - 1;
        int n7 = this.getSampleModel().getNumBands();
        int[] nArray = new int[n7];
        for (int i = n4; i <= n6; ++i) {
            for (int j = n3; j <= n5; ++j) {
                raster.getPixel(j, i, nArray);
                if (n7 == 1) {
                    System.out.print("(" + nArray[0] + ") ");
                    continue;
                }
                if (n7 != 3) continue;
                System.out.print("(" + nArray[0] + "," + nArray[1] + "," + nArray[2] + ") ");
            }
            System.out.println();
        }
    }

    public String toString() {
        return "PlanarImage[minX=" + this.minX + " minY=" + this.minY + " width=" + this.width + " height=" + this.height + " tileGridXOffset=" + this.tileGridXOffset + " tileGridYOffset=" + this.tileGridYOffset + " tileWidth=" + this.tileWidth + " tileHeight=" + this.tileHeight + " sampleModel=" + this.sampleModel + " colorModel=" + this.colorModel + "]";
    }

    private void cobbleByte(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        for (int i = n2; i <= n6; ++i) {
            for (int j = n; j <= n5; ++j) {
                int n11;
                int n12;
                int n13;
                Raster raster2 = this.getTile(j, i);
                if (raster2 == null) continue;
                if (!bl) {
                    componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                    n9 = componentSampleModel2.getPixelStride();
                    n10 = componentSampleModel2.getScanlineStride();
                    bl = true;
                }
                int n14 = n13 = i * this.tileHeight + this.tileGridYOffset;
                int n15 = n14 + this.tileHeight - 1;
                if (rectangle.y > n14) {
                    n14 = rectangle.y;
                }
                if (n4 < n15) {
                    n15 = n4;
                }
                int n16 = n15 - n14 + 1;
                int n17 = n12 = j * this.tileWidth + this.tileGridXOffset;
                int n18 = n17 + this.tileWidth - 1;
                if (rectangle.x > n17) {
                    n17 = rectangle.x;
                }
                if (n3 < n18) {
                    n18 = n3;
                }
                int n19 = n18 - n17 + 1;
                int n20 = n17 - rectangle.x;
                int n21 = n14 - rectangle.y;
                DataBufferByte dataBufferByte2 = (DataBufferByte)raster2.getDataBuffer();
                byte[] byArray2 = dataBufferByte2.getData();
                int n22 = n19 * n9;
                boolean bl2 = n22 >= 64;
                int n23 = (n14 - n13) * n10 + (n17 - n12) * n9;
                int n24 = n21 * n8 + n20 * n7;
                if (bl2) {
                    for (n11 = 0; n11 < n16; ++n11) {
                        System.arraycopy(byArray2, n23, byArray, n24, n22);
                        n23 += n10;
                        n24 += n8;
                    }
                    continue;
                }
                for (n11 = 0; n11 < n16; ++n11) {
                    int n25 = n23;
                    int n26 = n24;
                    int n27 = n26 + n22;
                    while (n26 < n27) {
                        byArray[n26++] = byArray2[n25++];
                    }
                    n23 += n10;
                    n24 += n8;
                }
            }
        }
    }

    private void cobbleShort(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
        short[] sArray = dataBufferShort.getData();
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        for (int i = n2; i <= n6; ++i) {
            for (int j = n; j <= n5; ++j) {
                int n11;
                int n12;
                int n13;
                Raster raster2 = this.getTile(j, i);
                if (raster2 == null) continue;
                if (!bl) {
                    componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                    n9 = componentSampleModel2.getPixelStride();
                    n10 = componentSampleModel2.getScanlineStride();
                    bl = true;
                }
                int n14 = n13 = i * this.tileHeight + this.tileGridYOffset;
                int n15 = n14 + this.tileHeight - 1;
                if (rectangle.y > n14) {
                    n14 = rectangle.y;
                }
                if (n4 < n15) {
                    n15 = n4;
                }
                int n16 = n15 - n14 + 1;
                int n17 = n12 = j * this.tileWidth + this.tileGridXOffset;
                int n18 = n17 + this.tileWidth - 1;
                if (rectangle.x > n17) {
                    n17 = rectangle.x;
                }
                if (n3 < n18) {
                    n18 = n3;
                }
                int n19 = n18 - n17 + 1;
                int n20 = n17 - rectangle.x;
                int n21 = n14 - rectangle.y;
                DataBufferShort dataBufferShort2 = (DataBufferShort)raster2.getDataBuffer();
                short[] sArray2 = dataBufferShort2.getData();
                int n22 = n19 * n9;
                boolean bl2 = n22 >= 64;
                int n23 = (n14 - n13) * n10 + (n17 - n12) * n9;
                int n24 = n21 * n8 + n20 * n7;
                if (bl2) {
                    for (n11 = 0; n11 < n16; ++n11) {
                        System.arraycopy(sArray2, n23, sArray, n24, n22);
                        n23 += n10;
                        n24 += n8;
                    }
                    continue;
                }
                for (n11 = 0; n11 < n16; ++n11) {
                    int n25 = n23;
                    int n26 = n24;
                    int n27 = n26 + n22;
                    while (n26 < n27) {
                        sArray[n26++] = sArray2[n25++];
                    }
                    n23 += n10;
                    n24 += n8;
                }
            }
        }
    }

    private void cobbleUShort(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        for (int i = n2; i <= n6; ++i) {
            for (int j = n; j <= n5; ++j) {
                int n11;
                int n12;
                int n13;
                Raster raster2 = this.getTile(j, i);
                if (raster2 == null) continue;
                if (!bl) {
                    componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                    n9 = componentSampleModel2.getPixelStride();
                    n10 = componentSampleModel2.getScanlineStride();
                    bl = true;
                }
                int n14 = n13 = i * this.tileHeight + this.tileGridYOffset;
                int n15 = n14 + this.tileHeight - 1;
                if (rectangle.y > n14) {
                    n14 = rectangle.y;
                }
                if (n4 < n15) {
                    n15 = n4;
                }
                int n16 = n15 - n14 + 1;
                int n17 = n12 = j * this.tileWidth + this.tileGridXOffset;
                int n18 = n17 + this.tileWidth - 1;
                if (rectangle.x > n17) {
                    n17 = rectangle.x;
                }
                if (n3 < n18) {
                    n18 = n3;
                }
                int n19 = n18 - n17 + 1;
                int n20 = n17 - rectangle.x;
                int n21 = n14 - rectangle.y;
                DataBufferUShort dataBufferUShort2 = (DataBufferUShort)raster2.getDataBuffer();
                short[] sArray2 = dataBufferUShort2.getData();
                int n22 = n19 * n9;
                boolean bl2 = n22 >= 64;
                int n23 = (n14 - n13) * n10 + (n17 - n12) * n9;
                int n24 = n21 * n8 + n20 * n7;
                if (bl2) {
                    for (n11 = 0; n11 < n16; ++n11) {
                        System.arraycopy(sArray2, n23, sArray, n24, n22);
                        n23 += n10;
                        n24 += n8;
                    }
                    continue;
                }
                for (n11 = 0; n11 < n16; ++n11) {
                    int n25 = n23;
                    int n26 = n24;
                    int n27 = n26 + n22;
                    while (n26 < n27) {
                        sArray[n26++] = sArray2[n25++];
                    }
                    n23 += n10;
                    n24 += n8;
                }
            }
        }
    }

    private void cobbleInt(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        for (int i = n2; i <= n6; ++i) {
            for (int j = n; j <= n5; ++j) {
                int n11;
                int n12;
                int n13;
                Raster raster2 = this.getTile(j, i);
                if (raster2 == null) continue;
                if (!bl) {
                    componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                    n9 = componentSampleModel2.getPixelStride();
                    n10 = componentSampleModel2.getScanlineStride();
                    bl = true;
                }
                int n14 = n13 = i * this.tileHeight + this.tileGridYOffset;
                int n15 = n14 + this.tileHeight - 1;
                if (rectangle.y > n14) {
                    n14 = rectangle.y;
                }
                if (n4 < n15) {
                    n15 = n4;
                }
                int n16 = n15 - n14 + 1;
                int n17 = n12 = j * this.tileWidth + this.tileGridXOffset;
                int n18 = n17 + this.tileWidth - 1;
                if (rectangle.x > n17) {
                    n17 = rectangle.x;
                }
                if (n3 < n18) {
                    n18 = n3;
                }
                int n19 = n18 - n17 + 1;
                int n20 = n17 - rectangle.x;
                int n21 = n14 - rectangle.y;
                DataBufferInt dataBufferInt2 = (DataBufferInt)raster2.getDataBuffer();
                int[] nArray2 = dataBufferInt2.getData();
                int n22 = n19 * n9;
                boolean bl2 = n22 >= 64;
                int n23 = (n14 - n13) * n10 + (n17 - n12) * n9;
                int n24 = n21 * n8 + n20 * n7;
                if (bl2) {
                    for (n11 = 0; n11 < n16; ++n11) {
                        System.arraycopy(nArray2, n23, nArray, n24, n22);
                        n23 += n10;
                        n24 += n8;
                    }
                    continue;
                }
                for (n11 = 0; n11 < n16; ++n11) {
                    int n25 = n23;
                    int n26 = n24;
                    int n27 = n26 + n22;
                    while (n26 < n27) {
                        nArray[n26++] = nArray2[n25++];
                    }
                    n23 += n10;
                    n24 += n8;
                }
            }
        }
    }

    private void cobbleFloat(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBuffer dataBuffer = raster.getDataBuffer();
        float[] fArray = DataBufferUtils.getDataFloat(dataBuffer);
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        for (int i = n2; i <= n6; ++i) {
            for (int j = n; j <= n5; ++j) {
                int n11;
                int n12;
                int n13;
                Raster raster2 = this.getTile(j, i);
                if (raster2 == null) continue;
                if (!bl) {
                    componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                    n9 = componentSampleModel2.getPixelStride();
                    n10 = componentSampleModel2.getScanlineStride();
                    bl = true;
                }
                int n14 = n13 = i * this.tileHeight + this.tileGridYOffset;
                int n15 = n14 + this.tileHeight - 1;
                if (rectangle.y > n14) {
                    n14 = rectangle.y;
                }
                if (n4 < n15) {
                    n15 = n4;
                }
                int n16 = n15 - n14 + 1;
                int n17 = n12 = j * this.tileWidth + this.tileGridXOffset;
                int n18 = n17 + this.tileWidth - 1;
                if (rectangle.x > n17) {
                    n17 = rectangle.x;
                }
                if (n3 < n18) {
                    n18 = n3;
                }
                int n19 = n18 - n17 + 1;
                int n20 = n17 - rectangle.x;
                int n21 = n14 - rectangle.y;
                DataBuffer dataBuffer2 = raster2.getDataBuffer();
                float[] fArray2 = DataBufferUtils.getDataFloat(dataBuffer2);
                int n22 = n19 * n9;
                boolean bl2 = n22 >= 64;
                int n23 = (n14 - n13) * n10 + (n17 - n12) * n9;
                int n24 = n21 * n8 + n20 * n7;
                if (bl2) {
                    for (n11 = 0; n11 < n16; ++n11) {
                        System.arraycopy(fArray2, n23, fArray, n24, n22);
                        n23 += n10;
                        n24 += n8;
                    }
                    continue;
                }
                for (n11 = 0; n11 < n16; ++n11) {
                    int n25 = n23;
                    int n26 = n24;
                    int n27 = n26 + n22;
                    while (n26 < n27) {
                        fArray[n26++] = fArray2[n25++];
                    }
                    n23 += n10;
                    n24 += n8;
                }
            }
        }
    }

    private void cobbleDouble(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBuffer dataBuffer = raster.getDataBuffer();
        double[] dArray = DataBufferUtils.getDataDouble(dataBuffer);
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        for (int i = n2; i <= n6; ++i) {
            for (int j = n; j <= n5; ++j) {
                int n11;
                int n12;
                int n13;
                Raster raster2 = this.getTile(j, i);
                if (raster2 == null) continue;
                if (!bl) {
                    componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                    n9 = componentSampleModel2.getPixelStride();
                    n10 = componentSampleModel2.getScanlineStride();
                    bl = true;
                }
                int n14 = n13 = i * this.tileHeight + this.tileGridYOffset;
                int n15 = n14 + this.tileHeight - 1;
                if (rectangle.y > n14) {
                    n14 = rectangle.y;
                }
                if (n4 < n15) {
                    n15 = n4;
                }
                int n16 = n15 - n14 + 1;
                int n17 = n12 = j * this.tileWidth + this.tileGridXOffset;
                int n18 = n17 + this.tileWidth - 1;
                if (rectangle.x > n17) {
                    n17 = rectangle.x;
                }
                if (n3 < n18) {
                    n18 = n3;
                }
                int n19 = n18 - n17 + 1;
                int n20 = n17 - rectangle.x;
                int n21 = n14 - rectangle.y;
                DataBuffer dataBuffer2 = raster2.getDataBuffer();
                double[] dArray2 = DataBufferUtils.getDataDouble(dataBuffer2);
                int n22 = n19 * n9;
                boolean bl2 = n22 >= 64;
                int n23 = (n14 - n13) * n10 + (n17 - n12) * n9;
                int n24 = n21 * n8 + n20 * n7;
                if (bl2) {
                    for (n11 = 0; n11 < n16; ++n11) {
                        System.arraycopy(dArray2, n23, dArray, n24, n22);
                        n23 += n10;
                        n24 += n8;
                    }
                    continue;
                }
                for (n11 = 0; n11 < n16; ++n11) {
                    int n25 = n23;
                    int n26 = n24;
                    int n27 = n26 + n22;
                    while (n26 < n27) {
                        dArray[n26++] = dArray2[n25++];
                    }
                    n23 += n10;
                    n24 += n8;
                }
            }
        }
    }

    public Object getImageID() {
        return this.UID;
    }
}

