/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineBicubic2OpImage;
import com.sun.media.jai.opimage.AffineBicubicOpImage;
import com.sun.media.jai.opimage.AffineBilinearOpImage;
import com.sun.media.jai.opimage.AffineGeneralOpImage;
import com.sun.media.jai.opimage.AffineNearestBinaryOpImage;
import com.sun.media.jai.opimage.AffineNearestOpImage;
import com.sun.media.jai.opimage.CopyOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import com.sun.media.jai.opimage.TransposeBinaryOpImage;
import com.sun.media.jai.opimage.TransposeOpImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;

public class RotateCRIF
extends CRIFImpl {
    public RotateCRIF() {
        super("rotate");
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f = parameterBlock.getFloatParameter(0);
        float f2 = parameterBlock.getFloatParameter(1);
        float f3 = parameterBlock.getFloatParameter(2);
        Object object = parameterBlock.getObjectParameter(3);
        Interpolation interpolation = (Interpolation)object;
        double[] dArray = (double[])parameterBlock.getObjectParameter(4);
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3);
        double d = 57.29577951308232 * (double)f3;
        double d2 = Math.round(d);
        if (Math.abs(d2 - d) < 1.0E-4) {
            int n = (int)d2 % 360;
            if (n < 0) {
                n += 360;
            }
            if (n == 0) {
                return new CopyOpImage(renderedImage, renderingHints, imageLayout);
            }
            int n2 = Math.round(f);
            int n3 = Math.round(f2);
            if (n % 90 == 0 && (double)Math.abs(f - (float)n2) < 1.0E-4 && (double)Math.abs(f2 - (float)n3) < 1.0E-4) {
                int n4 = -1;
                int n5 = 0;
                int n6 = 0;
                int n7 = renderedImage.getMinX();
                int n8 = renderedImage.getMinY();
                int n9 = n7 + renderedImage.getWidth();
                int n10 = n8 + renderedImage.getHeight();
                if (n == 90) {
                    n4 = 4;
                    n5 = n2 - (n10 - n3);
                    n6 = n3 - (n2 - n7);
                } else if (n == 180) {
                    n4 = 5;
                    n5 = 2 * n2 - n9;
                    n6 = 2 * n3 - n10;
                } else {
                    n4 = 6;
                    n5 = n2 - (n3 - n8);
                    n6 = n3 - (n9 - n2);
                }
                TransposeOpImage transposeOpImage = bl ? new TransposeBinaryOpImage(renderedImage, renderingHints, imageLayout, n4) : new TransposeOpImage(renderedImage, renderingHints, imageLayout, n4);
                int n11 = transposeOpImage.getMinX();
                int n12 = transposeOpImage.getMinY();
                if (imageLayout == null) {
                    return new TranslateIntOpImage(transposeOpImage, renderingHints, n5 - n11, n6 - n12);
                }
                ParameterBlock parameterBlock2 = new ParameterBlock();
                parameterBlock2.addSource(transposeOpImage);
                parameterBlock2.add(0.0f);
                parameterBlock2.add(0.0f);
                parameterBlock2.add(n5 - n11);
                parameterBlock2.add(n6 - n12);
                parameterBlock2.add(interpolation);
                return JAI.create("scale", parameterBlock2, renderingHints);
            }
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(f3, f, f2);
        if (interpolation instanceof InterpolationNearest) {
            if (bl) {
                return new AffineNearestBinaryOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
            }
            return new AffineNearestOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new AffineBilinearOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        if (interpolation instanceof InterpolationBicubic) {
            return new AffineBicubicOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        if (interpolation instanceof InterpolationBicubic2) {
            return new AffineBicubic2OpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        return new AffineGeneralOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
    }

    public RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        return parameterBlock.getRenderedSource(0);
    }

    public RenderContext mapRenderContext(int n, RenderContext renderContext, ParameterBlock parameterBlock, RenderableImage renderableImage) {
        float f = parameterBlock.getFloatParameter(0);
        float f2 = parameterBlock.getFloatParameter(1);
        float f3 = parameterBlock.getFloatParameter(2);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(f3, f, f2);
        RenderContext renderContext2 = (RenderContext)renderContext.clone();
        AffineTransform affineTransform2 = renderContext2.getTransform();
        affineTransform2.concatenate(affineTransform);
        renderContext2.setTransform(affineTransform2);
        return renderContext2;
    }

    public Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        float f;
        RenderableImage renderableImage = parameterBlock.getRenderableSource(0);
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        float f4 = parameterBlock.getFloatParameter(2);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(3);
        int n = 0;
        double d = (double)(180.0f * f4) / Math.PI;
        double d2 = Math.round(d);
        n = Math.abs(d2 - d) < 1.0E-4 ? (int)d2 : (int)d;
        if (n % 360 == 0) {
            return new Rectangle2D.Float(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
        }
        float f5 = renderableImage.getMinX();
        float f6 = renderableImage.getMinY();
        float f7 = renderableImage.getWidth();
        float f8 = renderableImage.getHeight();
        float f9 = f5 + f7 - 1.0f;
        float f10 = f6 + f8 - 1.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        if (n % 270 == 0) {
            if (n < 0) {
                f11 = f8 - f10 - 1.0f;
                f12 = f5;
                f13 = f8 - f6 - 1.0f;
                f14 = f9;
                return new Rectangle2D.Float(f11, f12, f13 - f11 + 1.0f, f14 - f12 + 1.0f);
            }
            f11 = f6;
            f12 = f7 - f9 - 1.0f;
            f13 = f10;
            f14 = f7 - f5 - 1.0f;
            return new Rectangle2D.Float(f11, f12, f13 - f11 + 1.0f, f14 - f12 + 1.0f);
        }
        if (n % 180 == 0) {
            f11 = f7 - f9 - 1.0f;
            f12 = f8 - f10 - 1.0f;
            f13 = f7 - f5 - 1.0f;
            f14 = f8 - f6 - 1.0f;
            return new Rectangle2D.Float(f11, f12, f13 - f11 + 1.0f, f14 - f12 + 1.0f);
        }
        if (n % 90 == 0) {
            if (n < 0) {
                f11 = f6;
                f12 = f7 - f9 - 1.0f;
                f13 = f10;
                f14 = f7 - f5 - 1.0f;
                return new Rectangle2D.Float(f11, f12, f13 - f11 + 1.0f, f14 - f12 + 1.0f);
            }
            f11 = f8 - f10 - 1.0f;
            f12 = f5;
            f13 = f8 - f6 - 1.0f;
            f14 = f9;
            return new Rectangle2D.Float(f11, f12, f13 - f11 + 1.0f, f14 - f12 + 1.0f);
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(f4, f2, f3);
        float f15 = renderableImage.getMinX();
        float f16 = renderableImage.getMinY();
        float f17 = renderableImage.getWidth();
        float f18 = renderableImage.getHeight();
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f15, f16), new Point2D.Float(f15 + f17, f16), new Point2D.Float(f15 + f17, f16 + f18), new Point2D.Float(f15, f16 + f18)};
        affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f19 = Float.MAX_VALUE;
        float f20 = Float.MAX_VALUE;
        float f21 = -3.4028235E38f;
        float f22 = -3.4028235E38f;
        for (int i = 0; i < 4; ++i) {
            f = (float)point2DArray[i].getX();
            float f23 = (float)point2DArray[i].getY();
            f19 = Math.min(f19, f);
            f20 = Math.min(f20, f23);
            f21 = Math.max(f21, f);
            f22 = Math.max(f22, f23);
        }
        float f24 = f21 - f19;
        f = f22 - f20;
        return new Rectangle2D.Float(f19, f20, f24, f);
    }
}

