/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.UntiledOpImage;

final class ErrorDiffusionOpImage
extends UntiledOpImage {
    private static final float FLOAT_EPSILON = 1.1920929E-7f;
    private static final int NBANDS = 3;
    private static final int NGRAYS = 256;
    private static final int OVERSHOOT = 256;
    private static final int UNDERSHOOT = 256;
    private static final int TOTALGRAYS = 768;
    private static final int ERR_SHIFT = 8;
    protected LookupTableJAI colorMap;
    protected KernelJAI errorKernel;
    private int numBandsSource;
    private boolean isOptimizedCase = false;
    private float minPixelValue;
    private float maxPixelValue;

    private static boolean isFloydSteinbergKernel(KernelJAI kernelJAI) {
        int n = kernelJAI.getYOrigin();
        return kernelJAI.getWidth() == 3 && kernelJAI.getXOrigin() == 1 && kernelJAI.getHeight() - n == 2 && Math.abs(kernelJAI.getElement(2, n) - 0.4375f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(0, n + 1) - 0.1875f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(1, n + 1) - 0.3125f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(2, n + 1) - 0.0625f) < 1.1920929E-7f;
    }

    private static int[] initFloydSteinberg24To8(ColorCube colorCube) {
        int n;
        int n2;
        int[] nArray = new int[2304];
        float[] fArray = new float[256];
        int[] nArray2 = colorCube.getMultipliers();
        int[] nArray3 = colorCube.getDimsLessOne();
        int n3 = colorCube.getAdjustedOffset();
        for (n2 = 0; n2 < 3; ++n2) {
            int n4;
            int n5;
            int n6;
            n = n2 * 768;
            float f = 255.0f / (float)nArray3[n2];
            for (n6 = 0; n6 < nArray3[n2]; ++n6) {
                fArray[n6] = ((float)n6 + 0.5f) * f;
            }
            fArray[nArray3[n2]] = 256.0f;
            n6 = 256;
            int n7 = -65536;
            for (n5 = -256; n5 < 0; ++n5) {
                nArray[n++] = n7;
                n7 += n6;
            }
            n5 = 0;
            float f2 = 0.0f;
            int n8 = 0;
            float f3 = fArray[0];
            int n9 = 0;
            while (n9 < 256) {
                int n10 = n5;
                n4 = (int)(f2 + 0.5f);
                while ((float)n9 < f3) {
                    nArray[n++] = (n9 - n4 << 8) + n10;
                    ++n9;
                }
                f3 = fArray[++n8];
                n5 += nArray2[n2];
                f2 += f;
            }
            n4 = 255;
            n7 = 256 - n4 << 8 | (n5 -= nArray2[n2]);
            for (n9 = 256; n9 < 512; ++n9) {
                nArray[n++] = n7;
                n7 += n6;
            }
        }
        n2 = 0;
        for (n = 768; n != 0; --n) {
            int n11 = n2++;
            nArray[n11] = nArray[n11] + n3;
        }
        return nArray;
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, LookupTableJAI lookupTableJAI) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        imageLayout2.setWidth(renderedImage.getWidth());
        imageLayout2.setHeight(renderedImage.getHeight());
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (lookupTableJAI.getNumBands() == 1 && lookupTableJAI.getNumEntries() == 2 && !ImageUtil.isBinary(imageLayout2.getSampleModel(renderedImage))) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
            colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        if ((imageLayout == null || !imageLayout2.isValid(512)) && renderedImage.getSampleModel().getDataType() == 0 && sampleModel.getDataType() == 0 && lookupTableJAI.getDataType() == 0 && lookupTableJAI.getNumBands() == 3 && ((colorModel = renderedImage.getColorModel()) == null || colorModel != null && colorModel.getColorSpace().isCS_sRGB())) {
            int n = lookupTableJAI.getNumEntries();
            byte[][] byArray = new byte[3][256];
            for (int i = 0; i < 3; ++i) {
                int n2;
                byte[] byArray2 = byArray[i];
                byte[] byArray3 = lookupTableJAI.getByteData(i);
                int n3 = lookupTableJAI.getOffset(i);
                int n4 = n3 + n;
                for (n2 = 0; n2 < n3; ++n2) {
                    byArray2[n2] = 0;
                }
                for (n2 = n3; n2 < n4; ++n2) {
                    byArray2[n2] = byArray3[n2 - n3];
                }
                for (n2 = n4; n2 < 256; ++n2) {
                    byArray2[n2] = -1;
                }
            }
            imageLayout2.setColorModel(new IndexColorModel(8, 256, byArray[0], byArray[1], byArray[2]));
        }
        return imageLayout2;
    }

    public ErrorDiffusionOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, LookupTableJAI lookupTableJAI, KernelJAI kernelJAI) {
        super(renderedImage, map, ErrorDiffusionOpImage.layoutHelper(imageLayout, renderedImage, lookupTableJAI));
        SampleModel sampleModel = renderedImage.getSampleModel();
        this.numBandsSource = sampleModel.getNumBands();
        this.colorMap = lookupTableJAI;
        this.errorKernel = kernelJAI;
        this.isOptimizedCase = this.sampleModel.getTransferType() == 0 && sampleModel.getTransferType() == 0 && this.numBandsSource == 3 && lookupTableJAI instanceof ColorCube && ErrorDiffusionOpImage.isFloydSteinbergKernel(kernelJAI);
        switch (lookupTableJAI.getDataType()) {
            case 0: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = 255.0f;
                break;
            }
            case 2: {
                this.minPixelValue = -32768.0f;
                this.maxPixelValue = 32767.0f;
                break;
            }
            case 1: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = 65535.0f;
                break;
            }
            case 3: {
                this.minPixelValue = -2.1474836E9f;
                this.maxPixelValue = 2.1474836E9f;
                break;
            }
            case 4: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = Float.MAX_VALUE;
                break;
            }
            case 5: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = Float.MAX_VALUE;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ErrorDiffusionOpImage0"));
            }
        }
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        if (this.isOptimizedCase) {
            this.computeImageOptimized(raster, writableRaster, rectangle);
        } else {
            this.computeImageDefault(raster, writableRaster, rectangle);
        }
    }

    protected void computeImageDefault(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2 = this.minX;
        int n3 = n2 + this.width - 1;
        int n4 = this.minY;
        int n5 = n4 + this.height - 1;
        int n6 = this.errorKernel.getHeight() - this.errorKernel.getYOrigin();
        float[][] fArray = new float[n6][this.width * this.numBandsSource];
        int[] nArray = new int[n6];
        for (n = 0; n < n6; ++n) {
            nArray[n] = n;
            raster.getPixels(n2, n4 + n, this.width, 1, fArray[n]);
        }
        n = n6 - 1;
        int n7 = this.errorKernel.getWidth();
        float[] fArray2 = this.errorKernel.getKernelData();
        int n8 = n7 - this.errorKernel.getXOrigin() - 1;
        int n9 = this.errorKernel.getHeight() - this.errorKernel.getYOrigin() - 1;
        int n10 = this.errorKernel.getYOrigin() * n7 + this.errorKernel.getXOrigin() + 1;
        int n11 = (this.errorKernel.getYOrigin() + 1) * n7;
        float[] fArray3 = new float[this.numBandsSource];
        int n12 = this.colorMap.getOffset();
        float[] fArray4 = new float[this.numBandsSource];
        int[] nArray2 = new int[this.width];
        for (int i = n4; i <= n5; ++i) {
            int n13;
            int n14 = nArray[0];
            float[] fArray5 = fArray[n14];
            int n15 = 0;
            int n16 = 0;
            for (n13 = n2; n13 <= n3; ++n13) {
                int n17;
                int n18;
                int n19;
                int n20;
                for (n20 = 0; n20 < this.numBandsSource; ++n20) {
                    fArray3[n20] = fArray5[n16++];
                    if (!(fArray3[n20] < this.minPixelValue) && !(fArray3[n20] > this.maxPixelValue)) continue;
                    fArray3[n20] = Math.max(fArray3[n20], this.minPixelValue);
                    fArray3[n20] = Math.min(fArray3[n20], this.maxPixelValue);
                }
                n20 = this.colorMap.findNearestEntry(fArray3);
                nArray2[n15++] = n20;
                boolean bl = false;
                for (n19 = 0; n19 < this.numBandsSource; ++n19) {
                    fArray4[n19] = fArray3[n19] - this.colorMap.lookupFloat(n19, n20);
                    if (fArray4[n19] == 0.0f) continue;
                    bl = true;
                }
                if (!bl) continue;
                n19 = Math.min(n8, n3 - n13);
                int n21 = n10;
                int n22 = n16;
                for (n18 = 1; n18 <= n19; ++n18) {
                    for (n17 = 0; n17 < this.numBandsSource; ++n17) {
                        int n23 = n22++;
                        fArray5[n23] = fArray5[n23] + fArray4[n17] * fArray2[n21];
                    }
                    ++n21;
                }
                n18 = Math.min(n13 - n2, n8);
                n17 = Math.min(n13 + n8, n3) - Math.max(n13 - n8, n2) + 1;
                for (int j = 1; j <= n9; ++j) {
                    float[] fArray6 = fArray[nArray[j]];
                    n21 = n11;
                    n22 = n16 - (n18 + 1) * this.numBandsSource;
                    for (int k = 1; k <= n17; ++k) {
                        for (int i2 = 0; i2 < this.numBandsSource; ++i2) {
                            int n24 = n22++;
                            fArray6[n24] = fArray6[n24] + fArray4[i2] * fArray2[n21];
                        }
                        ++n21;
                    }
                }
            }
            writableRaster.setSamples(n2, i, rectangle.width, 1, 0, nArray2);
            for (n13 = 0; n13 < n; ++n13) {
                nArray[n13] = nArray[n13 + 1];
            }
            nArray[n] = n14;
            if (i + n6 >= this.getMaxY()) continue;
            raster.getPixels(n2, i + n6, this.width, 1, fArray[nArray[n]]);
        }
    }

    protected void computeImageOptimized(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n = this.minX;
        int n2 = n + this.width - 1;
        int n3 = this.minY;
        int n4 = n3 + this.height - 1;
        int[] nArray = ErrorDiffusionOpImage.initFloydSteinberg24To8((ColorCube)this.colorMap);
        int n5 = raster.getWidth() + 2;
        int[] nArray2 = new int[n5 * 3];
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, new Rectangle(n, n3, raster.getWidth(), raster.getHeight()), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        byte[] byArray = rasterAccessor.getByteDataArray(0);
        byte[] byArray2 = rasterAccessor.getByteDataArray(1);
        byte[] byArray3 = rasterAccessor.getByteDataArray(2);
        byte[] byArray4 = rasterAccessor2.getByteDataArray(0);
        int n10 = rasterAccessor.getBandOffset(0);
        int n11 = rasterAccessor.getBandOffset(1);
        int n12 = rasterAccessor.getBandOffset(2);
        int n13 = rasterAccessor2.getBandOffset(0);
        for (int i = n3; i <= n4; ++i) {
            int n14;
            int n15 = n10;
            int n16 = n11;
            int n17 = n12;
            int n18 = n13;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = 0;
            int n23 = 0;
            int n24 = 0;
            int n25 = 0;
            int n26 = 0;
            int n27 = 0;
            int n28 = 0;
            boolean bl = false;
            for (n14 = n; n14 <= n2; ++n14) {
                int n29;
                int n30 = 256;
                int n31 = (n19 + nArray2[n28 + 3] + 8 >> 4) + (byArray[n15] & 0xFF);
                n15 += n6;
                int n32 = nArray[n30 + n31];
                int n33 = n29 = n32 >> 8;
                int n34 = n32 & 0xFF;
                int n35 = n29 + n29;
                nArray2[n28] = n20 + (n29 += n35);
                n20 = n21 + (n29 += n35);
                n21 = n33;
                n19 = n29 += n35;
                n31 = (n22 + nArray2[n28 + 4] + 8 >> 4) + (byArray2[n16] & 0xFF);
                n16 += n6;
                n32 = nArray[(n30 += 768) + n31];
                n33 = n29 = n32 >> 8;
                n34 += n32 & 0xFF;
                n35 = n29 + n29;
                nArray2[n28 + 1] = n23 + (n29 += n35);
                n23 = n24 + (n29 += n35);
                n24 = n33;
                n22 = n29 += n35;
                n31 = (n25 + nArray2[n28 + 5] + 8 >> 4) + (byArray3[n17] & 0xFF);
                n17 += n6;
                n32 = nArray[(n30 += 768) + n31];
                n33 = n29 = n32 >> 8;
                n34 += n32 & 0xFF;
                n35 = n29 + n29;
                nArray2[n28 + 2] = n26 + (n29 += n35);
                n26 = n27 + (n29 += n35);
                n27 = n33;
                n25 = n29 += n35;
                byArray4[n18] = (byte)(n34 & 0xFF);
                n18 += n8;
                n28 += 3;
            }
            n14 = 3 * (n5 - 2);
            nArray2[n14] = n20;
            nArray2[n14 + 1] = n23;
            nArray2[n14 + 2] = n26;
            n10 += n7;
            n11 += n7;
            n12 += n7;
            n13 += n9;
        }
        rasterAccessor2.copyDataToRaster();
    }
}

