/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;

public class Disassembler {
    public static final int CONSTANT_CLASS = 7;
    public static final int FIELD_REF = 9;
    public static final int METHOD_REF = 10;
    public static final int INT_METHOD_REF = 11;
    public static final int STRING = 8;
    public static final int INTEGER = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    public static final int NAME_AND_TYPE = 12;
    public static final int UTF8 = 1;
    private ClassDef def = new ClassDef();

    public Disassembler(File file) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        this.def.magic = dataInputStream.readInt();
        if (this.def.magic != -889275714) {
            dataInputStream.close();
            throw new IOException("Invalid class file");
        }
        this.def.minorVer = dataInputStream.readUnsignedShort();
        this.def.majorVer = dataInputStream.readUnsignedShort();
        this.def.poolCount = dataInputStream.readUnsignedShort();
        this.readPool(dataInputStream);
    }

    private void readPool(DataInputStream dataInputStream) throws IOException {
        block7: for (int i = 1; i < this.def.poolCount; ++i) {
            int n = dataInputStream.readUnsignedByte();
            switch (n) {
                case 7: {
                    ClassRef classRef = new ClassRef();
                    classRef.tag = 7;
                    classRef.nameIndex = dataInputStream.readUnsignedShort();
                    this.def.classRefs.put(new Integer(i), classRef);
                    continue block7;
                }
                case 1: {
                    Utf8 utf8 = new Utf8();
                    utf8.tag = 1;
                    utf8.string = dataInputStream.readUTF();
                    this.def.classRefs.put(new Integer(i), utf8);
                    continue block7;
                }
                case 8: {
                    dataInputStream.skipBytes(2);
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    dataInputStream.skipBytes(4);
                    continue block7;
                }
                case 5: 
                case 6: {
                    dataInputStream.skipBytes(8);
                    ++i;
                    continue block7;
                }
                default: {
                    dataInputStream.close();
                    throw new IOException("Invalid class file");
                }
            }
        }
        this.def.accessFlags = dataInputStream.readUnsignedShort();
        this.def.classIndex = dataInputStream.readUnsignedShort();
        dataInputStream.close();
    }

    public String getFQClassName() {
        ClassRef classRef = (ClassRef)this.def.classRefs.get(new Integer(this.def.classIndex));
        Utf8 utf8 = (Utf8)this.def.classRefs.get(new Integer(classRef.nameIndex));
        return utf8.string;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("/home/nick/classes2/uchicago/src/sim/heatBugs/HeatBugsModel.class");
            Disassembler disassembler = new Disassembler(file);
            System.out.println("d.getClassName() = " + disassembler.getFQClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    class Utf8 {
        int tag;
        String string;

        Utf8() {
        }
    }

    class ClassRef {
        int tag;
        int nameIndex;

        ClassRef() {
        }
    }

    class ClassDef {
        int magic;
        int minorVer;
        int majorVer;
        int poolCount;
        int accessFlags;
        int classIndex;
        HashMap classRefs = new HashMap();

        ClassDef() {
        }
    }
}

