/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space2;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.collection.NewMatrix;
import uchicago.src.sim.topology.Context;
import uchicago.src.sim.topology.ModifyableTopology;
import uchicago.src.sim.topology.RelationTopology;
import uchicago.src.sim.topology.space2.AbstractDiscrete2DTopology;
import uchicago.src.sim.topology.space2.Discrete2DSpace;
import uchicago.src.sim.topology.space2.Location;
import uchicago.src.sim.topology.space2.MooreTopology;
import uchicago.src.sim.topology.space2.OccupationTopology;
import uchicago.src.sim.topology.space2.VonNeumannTopology;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.SimUtilities;

public class Object2DGrid
implements Context,
Discrete2DSpace {
    HashMap locationMap;
    public static final int PGM_ASCII = 0;
    public static final int RASTER_ASCII = 1;
    protected NewMatrix matrix;
    protected int xSize;
    protected int ySize;
    protected AbstractDiscrete2DTopology VNneigh;
    protected AbstractDiscrete2DTopology Mneigh;
    protected ModifyableTopology occupy;
    protected HashMap relations;

    public List getRelated(Object object, String string, double d) {
        return null;
    }

    public void addRelation(Object object, Object object2, String string, double d) {
    }

    public boolean areRelated(Object object, Object object2, double d, String string) {
        return false;
    }

    public double distance(Object object, Object object2, String string) {
        return 0.0;
    }

    public RelationTopology getRelationTopology(String string) {
        return null;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean contains(Object object) {
        return false;
    }

    public Object[] toArray() {
        return new Object[0];
    }

    public Object[] toArray(Object[] objectArray) {
        return new Object[0];
    }

    public boolean add(Object object) {
        return false;
    }

    public boolean remove(Object object) {
        return false;
    }

    public boolean containsAll(Collection collection) {
        return false;
    }

    public boolean addAll(Collection collection) {
        return false;
    }

    public boolean retainAll(Collection collection) {
        return false;
    }

    public boolean removeAll(Collection collection) {
        return false;
    }

    public void clear() {
    }

    public Object2DGrid(int n, int n2) {
        this.xSize = n;
        this.ySize = n2;
        if (Random.uniform == null) {
            Random.createUniform();
        }
        this.matrix = new NewMatrix(n, n2);
        this.VNneigh = new VonNeumannTopology(this);
        this.Mneigh = new MooreTopology(this);
        this.occupy = new OccupationTopology(this);
        this.relations = new LinkedHashMap();
        this.relations.put(this.VNneigh.getRelationType(), this.VNneigh);
        this.relations.put(this.Mneigh.getRelationType(), this.Mneigh);
        this.relations.put(this.occupy.getRelationType(), this.occupy);
        this.locationMap = new HashMap();
        Location.createLocation(this);
    }

    public Object2DGrid(InputStream inputStream, int n) {
        if (n != 0) {
            throw new IllegalArgumentException("File type not supported.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.init(bufferedReader);
    }

    public Object2DGrid(String string, int n) {
        if (n != 0) {
            throw new IllegalArgumentException("File type not supported.");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.init(bufferedReader);
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error Reading image file", iOException);
            iOException.printStackTrace();
            System.exit(0);
        }
    }

    private void init(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            if (!string.equals("P2")) {
                throw new UnsupportedEncodingException("File is not in PGM ascii format");
            }
            string = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.xSize = Integer.valueOf(stringTokenizer.nextToken());
            this.ySize = Integer.valueOf(stringTokenizer.nextToken());
            stringTokenizer = null;
            bufferedReader.readLine();
            string = "";
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                string = string + string2 + " ";
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            stringTokenizer = new StringTokenizer(string);
            this.matrix = new NewMatrix(this.xSize, this.ySize);
            for (int i = 0; i < this.xSize; ++i) {
                for (int j = 0; j < this.ySize; ++j) {
                    this.matrix.put(i, j, Integer.valueOf(stringTokenizer.nextToken()));
                }
            }
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error Reading image file", iOException);
            iOException.printStackTrace();
            System.exit(0);
        }
        this.VNneigh = new VonNeumannTopology(this);
        this.Mneigh = new MooreTopology(this);
    }

    public Vector getVonNeumannNeighbors(int n, int n2, boolean bl) {
        return new Vector(this.VNneigh.getRelations(Location.getLocation(n, n2), 1.0));
    }

    public Vector getVonNeumannNeighbors(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[]{n3, n4};
        return new Vector(this.VNneigh.getRelations(n, n2, nArray, bl));
    }

    public Vector getMooreNeighbors(int n, int n2, boolean bl) {
        return new Vector(this.Mneigh.getRelations(Location.getLocation(n, n2), 1.0));
    }

    public Vector getMooreNeighbors(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[]{n3, n4};
        return new Vector(this.Mneigh.getRelations(n, n2, nArray, bl));
    }

    public void setComparator(Comparator comparator) {
        this.VNneigh.setComparator(comparator);
        this.Mneigh.setComparator(comparator);
    }

    public Vector findMaximum(int n, int n2, int n3, boolean bl, int n4) {
        Vector vector = new Vector();
        return vector;
    }

    public Vector findMinimum(int n, int n2, int n3, boolean bl, int n4) {
        Vector vector = new Vector();
        return vector;
    }

    protected void rangeCheck(int n, int n2) {
        if (n < 0 || n >= this.xSize || n2 < 0 || n2 >= this.ySize) {
            throw new IndexOutOfBoundsException("x or y coordinate is out of bounds");
        }
    }

    public int getSizeX() {
        return this.xSize;
    }

    public int getSizeY() {
        return this.ySize;
    }

    public Dimension getSize() {
        return new Dimension(this.xSize, this.ySize);
    }

    public Object getObjectAt(int n, int n2) {
        this.rangeCheck(n, n2);
        return this.matrix.get(n, n2);
    }

    public double getValueAt(int n, int n2) {
        this.rangeCheck(n, n2);
        Object object = this.matrix.get(n, n2);
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.doubleValue();
        }
        throw new IllegalArgumentException("Object cannot be converted to a long");
    }

    public void putObjectAt(int n, int n2, Object object) {
        this.rangeCheck(n, n2);
        this.matrix.put(n, n2, object);
        this.locationMap.put(object, Location.getLocation(n, n2));
    }

    public void putValueAt(int n, int n2, double d) {
        this.rangeCheck(n, n2);
        this.putObjectAt(n, n2, new Double(d));
    }

    public BaseMatrix getMatrix() {
        return this.matrix;
    }

    public Location getLocation(Object object) {
        Location location = (Location)this.locationMap.get(object);
        return location;
    }

    public Location getLocation(int n, int n2) {
        return Location.getLocation(n, n2);
    }

    public String[] getRelationTypes() {
        return this.relations.keySet().toArray(new String[this.relations.keySet().size()]);
    }

    public List getRelated(Object object, String string) {
        return ((RelationTopology)this.relations.get(string)).getRelations(object, 1.0);
    }

    public void addRelation(Object object, Object object2, String string) {
        if (!string.equalsIgnoreCase(OccupationTopology.type)) {
            throw new IllegalArgumentException("You cannot create relations of type " + string);
        }
        ModifyableTopology modifyableTopology = (ModifyableTopology)this.relations.get(string);
        modifyableTopology.addRelation(object, object2, 1.0);
    }

    public void removeRelation(Object object, Object object2, String string) {
        if (!string.equalsIgnoreCase(OccupationTopology.type)) {
            throw new IllegalArgumentException("You cannot create relations of type " + string);
        }
        ModifyableTopology modifyableTopology = (ModifyableTopology)this.relations.get(string);
        modifyableTopology.removeRelation(object, object2);
    }

    public boolean addElement(Object object) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        do {
            n = Random.uniform.nextIntFromTo(0, this.getSizeX() - 1);
            n2 = Random.uniform.nextIntFromTo(0, this.getSizeY() - 1);
            if (++n3 >= 30) continue;
            return false;
        } while (this.getObjectAt(n, n2) != null);
        this.putObjectAt(n, n2, object);
        return true;
    }

    public void removeElement(Object object) {
        Location location = this.getLocation(object);
        this.putObjectAt(location.getX(), location.getY(), null);
    }

    public int size() {
        return 0;
    }

    public Iterator iterator() {
        return this.locationMap.keySet().iterator();
    }

    public void update() {
    }

    public void addRelationType(RelationTopology relationTopology) {
    }

    public boolean areRelated(Object object, Object object2, String string) {
        RelationTopology relationTopology = (RelationTopology)this.relations.get(string);
        return relationTopology.getRelations(object, 1.0).contains(object2);
    }
}

