/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space.d3;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uchicago.src.sim.space.Torus;
import uchicago.src.sim.topology.space.AbstractNeighborhood;
import uchicago.src.sim.topology.space.Agent;
import uchicago.src.sim.topology.space.Location;
import uchicago.src.sim.topology.space.LocationIterator;
import uchicago.src.sim.topology.space.NeighborIterator;
import uchicago.src.sim.topology.space.Neighborhood;
import uchicago.src.sim.topology.space.Space;
import uchicago.src.sim.topology.space.d3.Object3DLocation;
import uchicago.src.sim.topology.space.d3.Object3DSpace;

public class Hex3DNeighborhood
extends AbstractNeighborhood
implements Neighborhood {
    protected Object3DSpace space;
    protected Log log = null;

    public Hex3DNeighborhood(Object3DSpace object3DSpace) {
        super("Hex Neighborhood");
        this.space = object3DSpace;
        this.log = LogFactory.getLog(this.getClass());
    }

    public Hex3DNeighborhood(String string, Object3DSpace object3DSpace) {
        super(string);
        this.space = object3DSpace;
        this.log = LogFactory.getLog(this.getClass());
    }

    protected Space getSpace() {
        return this.space;
    }

    public double distance(Object object, Object object2) {
        double d = Double.NaN;
        Object3DLocation object3DLocation = null;
        Object3DLocation object3DLocation2 = null;
        if (object instanceof Object3DLocation) {
            object3DLocation = (Object3DLocation)object;
        } else if (object instanceof Agent) {
            object3DLocation = (Object3DLocation)((Agent)object).getLocation();
        }
        if (object2 instanceof Object3DLocation) {
            object3DLocation2 = (Object3DLocation)object2;
        } else if (object2 instanceof Agent) {
            object3DLocation2 = (Object3DLocation)((Agent)object2).getLocation();
        }
        if (object3DLocation != null && object3DLocation2 != null) {
            d = object3DLocation.getY() % 2 == 0 ? (object3DLocation.getX() > object3DLocation2.getX() ? (double)Math.min(Math.abs(object3DLocation2.getX() - object3DLocation.getX()), Math.abs(object3DLocation2.getY() - object3DLocation.getY())) : (double)(Math.abs(object3DLocation2.getX() - object3DLocation.getX()) + Math.abs(object3DLocation2.getY() - object3DLocation.getY()))) : (object3DLocation.getX() > object3DLocation2.getX() ? (double)(Math.abs(object3DLocation2.getX() - object3DLocation.getX()) + Math.abs(object3DLocation2.getY() - object3DLocation.getY())) : (double)Math.min(Math.abs(object3DLocation2.getX() - object3DLocation.getX()), Math.abs(object3DLocation2.getY() - object3DLocation.getY())));
        }
        return d;
    }

    public int getNeighborhoodSize(Location location, int n, boolean bl) {
        return (int)(3.0 * Math.pow(n + 1, 2.0) - (double)(3 * (n + 1))) + (bl ? 1 : 0);
    }

    public boolean isFull(Location location, int n, boolean bl) {
        return false;
    }

    public int getAgentCount(Location location, int n, boolean bl) {
        return 0;
    }

    public NeighborIterator neighborIterator(Location location, int n, boolean bl) {
        return new NeighborIteratorImpl(location, n, bl);
    }

    public LocationIterator locationsIterator(Location location, int n, boolean bl) {
        return new HexLocationIteratorImpl(location, n, bl);
    }

    public LocationIterator emptyLocationsIterator(Location location, int n, boolean bl) {
        return new AvailableLocationIterator(location, n, bl);
    }

    public LocationIterator occupiedLocationsIterator(Location location, int n, boolean bl) {
        return new OccupiedIterator(location, n, bl);
    }

    private class NeighborIteratorImpl
    implements NeighborIterator {
        protected OccupiedIterator masterIter = null;
        protected Iterator currentIter = null;

        public NeighborIteratorImpl(Location location, int n, boolean bl) {
            this.masterIter = new OccupiedIterator(location, n, bl);
            if (this.masterIter.hasNext()) {
                this.currentIter = ((Object3DLocation)this.masterIter.next()).iterator();
            }
        }

        public boolean hasNext() {
            if (this.currentIter == null) {
                return false;
            }
            while (this.masterIter.hasNext() && !this.currentIter.hasNext()) {
                this.currentIter = ((Object3DLocation)this.masterIter.next()).iterator();
            }
            return this.masterIter.hasNext() && this.currentIter.hasNext();
        }

        public Object next() {
            if (this.hasNext()) {
                return this.currentIter.next();
            }
            return null;
        }

        public void remove() {
            if (this.currentIter != null) {
                this.currentIter.remove();
            }
        }

        public int currentDistance() {
            return this.masterIter.currentDistance();
        }

        public int currentDirection() {
            return this.masterIter.currentDirection();
        }
    }

    private class AvailableLocationIterator
    extends HexLocationIteratorImpl {
        public AvailableLocationIterator(Location location, int n, boolean bl) {
            super(location, n, bl);
        }

        protected boolean testNext(int n, int n2, int n3) {
            return Hex3DNeighborhood.this.space.getLocation(n, n2, n3).size() <= 0;
        }
    }

    private class OccupiedIterator
    extends HexLocationIteratorImpl {
        public OccupiedIterator(Location location, int n, boolean bl) {
            super(location, n, bl);
        }

        protected boolean testNext(int n, int n2, int n3) {
            return Hex3DNeighborhood.this.space.getLocation(n, n2, n3).size() != 0;
        }
    }

    private class HexLocationIteratorImpl
    implements LocationIterator {
        protected int currentDirection = 0;
        protected int currentDistance = 0;
        protected Object3DLocation current = null;
        protected Object3DLocation location = null;
        protected int ring = 0;
        protected int extent = 0;
        protected int cursorX = 0;
        protected int cursorY = 0;
        protected int cursorZ = 0;
        protected int sector = 0;
        protected int xMax = 0;
        protected int xMin = 0;
        protected int yMax = 0;
        protected int yMin = 0;
        protected boolean even;

        public HexLocationIteratorImpl(Location location, int n, boolean bl) {
            this.location = (Object3DLocation)location;
            this.even = this.location.getY() % 2 == 0;
            this.extent = n;
            if (bl) {
                this.ring = 0;
                this.sector = -1;
            } else {
                this.ring = 1;
                this.sector = 0;
            }
            this.xMax = this.location.getX() + this.ring;
            this.xMin = this.location.getX() - this.ring;
            this.yMax = this.location.getY() + this.ring;
            this.yMin = this.location.getY() - this.ring;
            if (this.even) {
                this.cursorX = this.xMin;
                this.cursorY = this.yMax;
            } else {
                this.cursorX = this.location.getX();
                this.cursorY = this.yMax;
            }
        }

        protected void logState() {
            Hex3DNeighborhood.this.log.debug((Object)" ");
            Hex3DNeighborhood.this.log.debug((Object)("ring=" + this.ring));
            Hex3DNeighborhood.this.log.debug((Object)("extent=" + this.extent));
            Hex3DNeighborhood.this.log.debug((Object)("cursorX=" + this.cursorX));
            Hex3DNeighborhood.this.log.debug((Object)("cursorY=" + this.cursorY));
            Hex3DNeighborhood.this.log.debug((Object)("sector=" + this.sector));
            Hex3DNeighborhood.this.log.debug((Object)" ");
        }

        protected boolean testNext(int n, int n2, int n3) {
            return true;
        }

        public boolean hasNext() {
            while (this.ring <= this.extent) {
                if (!(Hex3DNeighborhood.this.space instanceof Torus)) {
                    if (this.cursorX >= 0 && this.cursorX < Hex3DNeighborhood.this.space.getSizeX() && this.cursorY >= 0 && this.cursorY < Hex3DNeighborhood.this.space.getSizeY()) {
                        if (this.testNext(Hex3DNeighborhood.this.space.xnorm(this.cursorX), Hex3DNeighborhood.this.space.ynorm(this.cursorY), Hex3DNeighborhood.this.space.znorm(this.cursorZ))) break;
                        this.incrementCursor();
                        continue;
                    }
                    this.incrementCursor();
                    continue;
                }
                if (this.testNext(Hex3DNeighborhood.this.space.xnorm(this.cursorX), Hex3DNeighborhood.this.space.ynorm(this.cursorY), Hex3DNeighborhood.this.space.znorm(this.cursorZ))) break;
                this.incrementCursor();
            }
            return this.ring <= this.extent;
        }

        public void incrementCursor() {
            if (this.even) {
                this.incrementEvenCursor();
            } else {
                this.incrementOddCursor();
            }
        }

        public void incrementEvenCursor() {
            switch (this.sector) {
                case 0: {
                    ++this.cursorX;
                    if (this.cursorX != this.location.getX()) break;
                    this.sector = 1;
                    break;
                }
                case 1: {
                    ++this.cursorX;
                    --this.cursorY;
                    if (this.cursorX != this.xMax) break;
                    this.sector = 2;
                    break;
                }
                case 2: {
                    --this.cursorX;
                    --this.cursorY;
                    if (this.cursorX != this.location.getX()) break;
                    this.sector = 3;
                    break;
                }
                case 3: {
                    --this.cursorX;
                    if (this.cursorX != this.xMin) break;
                    this.sector = 4;
                    break;
                }
                case 4: {
                    ++this.cursorY;
                    if (this.cursorY != this.yMax) break;
                    ++this.ring;
                    this.sector = 0;
                    this.xMax = this.location.getX() + this.ring;
                    this.xMin = this.location.getX() - this.ring;
                    this.yMax = this.location.getY() + this.ring;
                    this.yMin = this.location.getY() - this.ring;
                    this.cursorX = this.xMin;
                    this.cursorY = this.yMax;
                    break;
                }
                default: {
                    ++this.ring;
                    this.sector = 0;
                    this.xMax = this.location.getX() + this.ring;
                    this.xMin = this.location.getX() - this.ring;
                    this.yMax = this.location.getY() + this.ring;
                    this.yMin = this.location.getY() - this.ring;
                    this.cursorX = this.xMin;
                    this.cursorY = this.yMax;
                }
            }
        }

        public void incrementOddCursor() {
            switch (this.sector) {
                case 0: {
                    ++this.cursorX;
                    if (this.cursorX != this.xMax) break;
                    this.sector = 1;
                    break;
                }
                case 1: {
                    --this.cursorY;
                    if (this.cursorY != this.yMin) break;
                    this.sector = 2;
                    break;
                }
                case 2: {
                    --this.cursorX;
                    if (this.cursorX != this.location.getX()) break;
                    this.sector = 3;
                    break;
                }
                case 3: {
                    --this.cursorX;
                    ++this.cursorY;
                    if (this.cursorX != this.xMin) break;
                    this.sector = 4;
                    break;
                }
                case 4: {
                    ++this.cursorX;
                    ++this.cursorY;
                    if (this.cursorY != this.yMax) break;
                    ++this.ring;
                    this.sector = 0;
                    this.xMax = this.location.getX() + this.ring;
                    this.xMin = this.location.getX() - this.ring;
                    this.yMax = this.location.getY() + this.ring;
                    this.yMin = this.location.getY() - this.ring;
                    this.cursorX = this.location.getX();
                    this.cursorY = this.yMax;
                    break;
                }
                default: {
                    ++this.ring;
                    this.sector = 0;
                    this.xMax = this.location.getX() + this.ring;
                    this.xMin = this.location.getX() - this.ring;
                    this.yMax = this.location.getY() + this.ring;
                    this.yMin = this.location.getY() - this.ring;
                    this.cursorX = this.location.getX();
                    this.cursorY = this.yMax;
                }
            }
        }

        public Object next() {
            return this.nextLocation();
        }

        public Location nextLocation() {
            try {
                if (this.ring <= this.extent) {
                    this.current = (Object3DLocation)Hex3DNeighborhood.this.space.getLocation(Hex3DNeighborhood.this.space.xnorm(this.cursorX), Hex3DNeighborhood.this.space.ynorm(this.cursorY), Hex3DNeighborhood.this.space.znorm(this.cursorZ));
                    this.currentDirection = this.sector;
                    this.currentDistance = this.ring;
                    this.logState();
                    this.incrementCursor();
                    return this.current;
                }
                return null;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            this.current.clear();
        }

        public int currentDistance() {
            return this.currentDistance;
        }

        public int currentDirection() {
            return this.currentDirection;
        }
    }
}

