/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space.d3;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import uchicago.src.sim.gui.Drawable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.space.Torus;
import uchicago.src.sim.topology.space.Agent;
import uchicago.src.sim.topology.space.Location;
import uchicago.src.sim.topology.space.Space;
import uchicago.src.sim.topology.space.d3.AbstractObject3DTopology;
import uchicago.src.sim.topology.space.d3.Object3DLocation;
import uchicago.src.sim.topology.space.d3.Object3DSpace;

public abstract class AbstractObject3DSpace
extends AbstractObject3DTopology
implements Object3DSpace {
    protected Object3DLocation[][][] matrix = null;

    public AbstractObject3DSpace(String string, int n, int n2, int n3) {
        super(string);
        this.matrix = new Object3DLocation[n][n2][n3];
    }

    public void removeLocation(Location location) {
        if (location instanceof Object3DLocation) {
            Object3DLocation object3DLocation = (Object3DLocation)location;
            this.removeLocation(object3DLocation.getX(), object3DLocation.getY(), object3DLocation.getZ());
        }
    }

    public void removeLocation(int n, int n2, int n3) {
        Object3DLocation object3DLocation = this.matrix[this.xnorm(n)][this.ynorm(n2)][this.znorm(n3)];
        this.matrix[this.xnorm((int)n)][this.ynorm((int)n2)][this.znorm((int)n3)] = null;
        if (object3DLocation != null) {
            object3DLocation.clear();
        }
    }

    public abstract Location getLocation(int var1, int var2, int var3);

    public Location getLocation(Object object) {
        return (Location)this.locations.get(object);
    }

    public double[] getSize() {
        return new double[]{this.getSizeX(), this.getSizeY(), this.getSizeZ()};
    }

    public int getSizeX() {
        return this.matrix.length;
    }

    public int getSizeY() {
        return this.matrix[0].length;
    }

    public int getSizeZ() {
        return this.matrix[0][0].length;
    }

    public void trim() {
        for (int i = 0; i < this.getSizeX(); ++i) {
            for (int j = 0; j < this.getSizeY(); ++j) {
                for (int k = 0; k < this.getSizeZ(); ++k) {
                    Object3DLocation object3DLocation = this.matrix[i][j][k];
                    if (object3DLocation == null || !object3DLocation.isEmpty()) continue;
                    this.matrix[i][j][k] = null;
                }
            }
        }
    }

    public int xnorm(int n) {
        if (n < 0 || n >= this.getSizeX()) {
            if (this instanceof Torus) {
                while (n < 0) {
                    n += this.getSizeX();
                }
                return n % this.getSizeX();
            }
            throw new IndexOutOfBoundsException("x coordinate is out of bounds");
        }
        return n;
    }

    public int ynorm(int n) {
        if (n < 0 || n >= this.getSizeY()) {
            if (this instanceof Torus) {
                while (n < 0) {
                    n += this.getSizeY();
                }
                return n % this.getSizeY();
            }
            throw new IndexOutOfBoundsException("y coordinate is out of bounds");
        }
        return n;
    }

    public int znorm(int n) {
        if (n < 0 || n >= this.getSizeZ()) {
            if (this instanceof Torus) {
                while (n < 0) {
                    n += this.getSizeZ();
                }
                return n % this.getSizeZ();
            }
            throw new IndexOutOfBoundsException("z coordinate is out of bounds");
        }
        return n;
    }

    public class Abstract3DLocation
    implements Object3DLocation,
    Drawable {
        protected Collection elements;
        protected int capacity = Integer.MAX_VALUE;
        protected int x;
        protected int y;
        protected int z;

        protected Abstract3DLocation(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Object3DLocation)) {
                return false;
            }
            Object3DLocation object3DLocation = (Object3DLocation)object;
            return this.x == object3DLocation.getX() && this.y == object3DLocation.getY() && ((Object)this.elements).equals(object);
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.x;
            n = 37 * n + this.y;
            n = 37 * n + this.z;
            n = 37 * n + ((Object)this.elements).hashCode();
            return n;
        }

        public String toString() {
            return "(x: " + this.x + " y: " + this.y + " z: " + this.z + ")";
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public void setCapacity(int n) {
            this.capacity = n;
        }

        public boolean isFull() {
            return this.size() >= this.capacity;
        }

        public Space getSpace() {
            return AbstractObject3DSpace.this;
        }

        public boolean addAll(Collection collection) {
            boolean bl = !collection.isEmpty();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl = !this.add(iterator.next()) ? false : bl;
            }
            return bl;
        }

        public boolean add(Object object) {
            boolean bl = false;
            if (!this.isFull()) {
                bl = this.elements.add(object);
            }
            if (bl) {
                if (!this.isEmpty()) {
                    AbstractObject3DSpace.this.matrix[this.x][this.y][this.z] = this;
                }
                if (object instanceof Agent) {
                    ((Agent)object).setLocation(this);
                }
            }
            return bl;
        }

        public boolean remove(Object object) {
            boolean bl = this.elements.remove(object);
            if (bl) {
                if (object instanceof Agent) {
                    ((Agent)object).setLocation(null);
                }
                if (this.isEmpty()) {
                    AbstractObject3DSpace.this.removeLocation(this.x, this.y, this.z);
                }
            }
            return bl;
        }

        public void clear() {
            if (!this.isEmpty()) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
            }
            this.elements.clear();
        }

        public boolean removeAll(Collection collection) {
            boolean bl = !collection.isEmpty();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!collection.contains(e)) continue;
                bl = true;
                iterator.remove();
            }
            return bl;
        }

        public boolean retainAll(Collection collection) {
            boolean bl = collection.isEmpty();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (collection.contains(e)) continue;
                bl = true;
                iterator.remove();
            }
            return bl;
        }

        public void draw(SimGraphics simGraphics) {
            simGraphics.drawHollowRect(Color.lightGray);
        }

        public boolean contains(Object object) {
            return this.elements.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.elements.containsAll(collection);
        }

        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        public Iterator iterator() {
            Iterator iterator = this.elements.iterator();
            return new Iterator(this, iterator){
                private Object o;
                private final /* synthetic */ Iterator val$iter;
                private final /* synthetic */ Abstract3DLocation this$1;
                {
                    this.this$1 = abstract3DLocation;
                    this.val$iter = iterator;
                    this.o = null;
                }

                public boolean hasNext() {
                    return this.val$iter.hasNext();
                }

                public Object next() {
                    this.o = this.val$iter.next();
                    return this.o;
                }

                public void remove() {
                    this.val$iter.remove();
                    if (this.o instanceof Agent) {
                        ((Agent)this.o).setLocation(null);
                    }
                    if (this.this$1.isEmpty()) {
                        Abstract3DLocation.access$000(this.this$1).removeLocation(this.this$1.x, this.this$1.y, this.this$1.z);
                    }
                }
            };
        }

        public int size() {
            return this.elements.size();
        }

        public Object[] toArray() {
            return this.elements.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.elements.toArray(objectArray);
        }

        static /* synthetic */ AbstractObject3DSpace access$000(Abstract3DLocation abstract3DLocation) {
            return abstract3DLocation.AbstractObject3DSpace.this;
        }
    }
}

