/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space.d2.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import uchicago.src.sim.topology.space.LocationIterator;
import uchicago.src.sim.topology.space.Neighborhood;
import uchicago.src.sim.topology.space.d2.MooreNeighborhood;
import uchicago.src.sim.topology.space.d2.Object2DLocation;
import uchicago.src.sim.topology.space.d2.Object2DSpace;
import uchicago.src.sim.topology.space.d2.Object2DTorus;

public class MooreNeighborhoodTest
extends TestCase {
    Object2DSpace space;
    Object2DLocation loc;
    Neighborhood hood;
    static /* synthetic */ Class class$uchicago$src$sim$topology$space$d2$test$MooreNeighborhoodTest;

    public static Test suite() {
        TestSuite testSuite = new TestSuite(class$uchicago$src$sim$topology$space$d2$test$MooreNeighborhoodTest == null ? (class$uchicago$src$sim$topology$space$d2$test$MooreNeighborhoodTest = MooreNeighborhoodTest.class$("uchicago.src.sim.topology.space.d2.test.MooreNeighborhoodTest")) : class$uchicago$src$sim$topology$space$d2$test$MooreNeighborhoodTest);
        testSuite.setName("Neighborhood Tests");
        return testSuite;
    }

    public MooreNeighborhoodTest(String string) {
        super(string);
    }

    public void testSize() {
        this.space = new Object2DTorus(100, 100);
        this.loc = (Object2DLocation)this.space.getLocation(50, 50);
        this.hood = new MooreNeighborhood(this.space);
        MooreNeighborhoodTest.assertEquals((String)"moore 1", (int)this.hood.getNeighborhoodSize(this.loc, 1, true), (int)9);
        MooreNeighborhoodTest.assertEquals((String)"moore 1", (int)this.hood.getNeighborhoodSize(this.loc, 1, false), (int)8);
        MooreNeighborhoodTest.assertEquals((String)"moore 2", (int)this.hood.getNeighborhoodSize(this.loc, 2, true), (int)25);
        MooreNeighborhoodTest.assertEquals((String)"moore 2", (int)this.hood.getNeighborhoodSize(this.loc, 2, false), (int)24);
        MooreNeighborhoodTest.assertEquals((String)"moore 3", (int)this.hood.getNeighborhoodSize(this.loc, 3, true), (int)49);
        MooreNeighborhoodTest.assertEquals((String)"moore 3", (int)this.hood.getNeighborhoodSize(this.loc, 3, false), (int)48);
    }

    public void testOriginIterators() {
        this.space = new Object2DTorus(100, 100);
        this.loc = (Object2DLocation)this.space.getLocation(50, 50);
        this.hood = new MooreNeighborhood(this.space);
        LocationIterator locationIterator = this.hood.locationsIterator(this.loc, 1, true);
        Object2DLocation object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x != 50", (int)50, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y != 50", (int)50, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = -1", (int)-1, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 0", (int)0, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x != 49", (int)49, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y != 51", (int)51, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 0", (int)0, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=50", (int)50, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=51", (int)51, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 0", (int)0, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=51", (int)51, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=51", (int)51, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 1", (int)1, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=51", (int)51, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=50", (int)50, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 1", (int)1, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=51", (int)51, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=49", (int)49, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 2", (int)2, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=50", (int)50, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=49", (int)49, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 2", (int)2, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=49", (int)49, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=49", (int)49, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 3", (int)3, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=49", (int)49, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=50", (int)50, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 3", (int)3, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        MooreNeighborhoodTest.assertTrue((String)"iter shouldn't have next", (!locationIterator.hasNext() ? 1 : 0) != 0);
    }

    public void testNoOriginIterators() {
        this.space = new Object2DTorus(100, 100);
        this.loc = (Object2DLocation)this.space.getLocation(50, 50);
        this.hood = new MooreNeighborhood(this.space);
        LocationIterator locationIterator = this.hood.locationsIterator(this.loc, 1, false);
        Object2DLocation object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x != 49", (int)49, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y != 51", (int)51, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 0", (int)0, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=50", (int)50, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=51", (int)51, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 0", (int)0, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=51", (int)51, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=51", (int)51, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 1", (int)1, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=51", (int)51, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=50", (int)50, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 1", (int)1, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=51", (int)51, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=49", (int)49, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 2", (int)2, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=50", (int)50, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=49", (int)49, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 2", (int)2, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=49", (int)49, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=49", (int)49, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 3", (int)3, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        object2DLocation = (Object2DLocation)locationIterator.next();
        MooreNeighborhoodTest.assertEquals((String)"x!=49", (int)49, (int)object2DLocation.getX());
        MooreNeighborhoodTest.assertEquals((String)"y!=50", (int)50, (int)object2DLocation.getY());
        MooreNeighborhoodTest.assertEquals((String)"dir = 3", (int)3, (int)locationIterator.currentDirection());
        MooreNeighborhoodTest.assertEquals((String)"dis = 1", (int)1, (int)locationIterator.currentDistance());
        MooreNeighborhoodTest.assertTrue((String)"iter shouldn't have next", (!locationIterator.hasNext() ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

