/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import uchicago.src.sim.topology.RelationTopology;
import uchicago.src.sim.topology.space.Agent;
import uchicago.src.sim.topology.space.Location;
import uchicago.src.sim.topology.space.LocationIterator;
import uchicago.src.sim.topology.space.NeighborIterator;
import uchicago.src.sim.topology.space.Neighborhood;
import uchicago.src.sim.topology.space.Space;

public abstract class AbstractNeighborhood
implements Neighborhood,
RelationTopology {
    protected int modCount;
    protected Comparator comparator;
    private String type;

    public AbstractNeighborhood(String string) {
        this.type = string;
        this.comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = object.hashCode();
                return n2 < (n = object2.hashCode()) ? -1 : (n2 > n ? 1 : 0);
            }
        };
    }

    public List neighbors(Location location, int n, boolean bl) {
        ArrayList arrayList = new ArrayList();
        NeighborIterator neighborIterator = this.neighborIterator(location, n, bl);
        while (neighborIterator.hasNext()) {
            arrayList.add(neighborIterator.next());
        }
        return arrayList;
    }

    public List locations(Location location, int n, boolean bl) {
        ArrayList arrayList = new ArrayList();
        LocationIterator locationIterator = this.locationsIterator(location, n, bl);
        while (locationIterator.hasNext()) {
            arrayList.add(locationIterator.next());
        }
        return arrayList;
    }

    public List emptyLocations(Location location, int n, boolean bl) {
        ArrayList arrayList = new ArrayList();
        LocationIterator locationIterator = this.emptyLocationsIterator(location, n, bl);
        while (locationIterator.hasNext()) {
            arrayList.add(locationIterator.next());
        }
        return arrayList;
    }

    public List occupiedLocations(Location location, int n, boolean bl) {
        ArrayList arrayList = new ArrayList();
        LocationIterator locationIterator = this.occupiedLocationsIterator(location, n, bl);
        while (locationIterator.hasNext()) {
            arrayList.add(locationIterator.next());
        }
        return arrayList;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public List findMaximum(Location location, int n, boolean bl) {
        List list = this.neighbors(location, n, bl);
        return this.compareMax(list);
    }

    public List findMinimum(Location location, int n, boolean bl) {
        List list = this.neighbors(location, n, bl);
        return this.compareMin(list);
    }

    protected List compareMax(List list) {
        ArrayList arrayList = new ArrayList(7);
        if (list.size() != 0) {
            Object e = list.get(0);
            int n = 0;
            for (int i = 1; i < list.size(); ++i) {
                Object e2 = list.get(i);
                n = this.comparator.compare(e, e2);
                if (n == 0) {
                    arrayList.add(e2);
                    continue;
                }
                if (n >= 0) continue;
                arrayList.clear();
                e = e2;
            }
            arrayList.add(e);
        }
        return arrayList;
    }

    protected List compareMin(List list) {
        ArrayList arrayList = new ArrayList(7);
        if (list.size() != 0) {
            Object e = list.get(0);
            int n = 0;
            for (int i = 1; i < list.size(); ++i) {
                Object e2 = list.get(i);
                n = this.comparator.compare(e, e2);
                if (n == 0) {
                    arrayList.add(e2);
                    continue;
                }
                if (n <= 0) continue;
                arrayList.clear();
                e = e2;
            }
            arrayList.add(e);
        }
        return arrayList;
    }

    protected abstract Space getSpace();

    public abstract boolean isFull(Location var1, int var2, boolean var3);

    public abstract int getAgentCount(Location var1, int var2, boolean var3);

    public abstract int getNeighborhoodSize(Location var1, int var2, boolean var3);

    public abstract NeighborIterator neighborIterator(Location var1, int var2, boolean var3);

    public abstract LocationIterator locationsIterator(Location var1, int var2, boolean var3);

    public abstract LocationIterator emptyLocationsIterator(Location var1, int var2, boolean var3);

    public abstract LocationIterator occupiedLocationsIterator(Location var1, int var2, boolean var3);

    public List getRelations(Object object, double d) {
        Location location = null;
        if (object instanceof Location) {
            location = (Location)object;
        } else if (object instanceof Agent) {
            location = ((Agent)object).getLocation();
        } else {
            this.getSpace().getLocation(object);
        }
        return this.neighbors(location, (int)d, false);
    }

    public String getRelationType() {
        return this.type;
    }

    public void setRelationType(String string) {
    }
}

