/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.graph.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uchicago.src.sim.topology.graph.Graph;
import uchicago.src.sim.topology.graph.renderer.NodeStyle;
import uchicago.src.sim.topology.graph.renderer.RenderableGraphLayout;

public class GraphRenderer {
    private NodeStyle nodeStyle;
    private Map edgeColors = new HashMap();
    private RenderableGraphLayout gl = null;
    private Graph g;
    private Set nodes;
    private Graphics2D graphics;

    public void addGraph(Graph graph) throws Exception {
        if (this.nodes != null && !((Object)graph.getNodes()).equals(this.nodes)) {
            throw new Exception("This graph doesn't containthe same node set");
        }
        this.edgeColors.put(graph.getRelationType(), Color.red);
        this.g = graph;
    }

    public void setEdgeColor(String string, Color color) {
        this.edgeColors.put(string, color);
    }

    public void render() {
        this.gl.update();
        Iterator iterator = this.g.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.nodeStyle.processObject(e);
            this.graphics.setColor(this.nodeStyle.getColor());
        }
    }

    public void setOutput(Graphics2D graphics2D) {
        this.graphics = graphics2D;
    }

    public void setLayout(RenderableGraphLayout renderableGraphLayout) {
        this.gl = renderableGraphLayout;
    }
}

