/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uchicago.src.sim.topology.graph.AbstractGraph;
import uchicago.src.sim.topology.graph.DirectedEdge;
import uchicago.src.sim.topology.graph.Edge;
import uchicago.src.sim.topology.graph.EdgeType;
import uchicago.src.sim.topology.graph.util.DepthFirstSearch;
import uchicago.src.sim.topology.graph.util.EdgeClassification;

public class DirectedGraph
extends AbstractGraph
implements Serializable {
    static final long serialVersionUID = -3047402482395522121L;
    private Map inEdgeMap;
    private Map outEdgeMap;
    private Set nodes;
    private String type;
    private final DirectedEdge query = new DirectedEdge();

    public DirectedGraph(Set set) {
        this(set, "DirectedGraph");
    }

    public DirectedGraph(Set set, String string) {
        this.type = string;
        this.nodes = set;
        this.inEdgeMap = new HashMap();
        this.outEdgeMap = new HashMap();
        this.nodes = set;
    }

    protected Set getEdgeSet(Object object, EdgeType edgeType) {
        Set set = null;
        if (edgeType.equals(EdgeType.IN)) {
            set = (LinkedHashSet)this.inEdgeMap.get(object);
            if (set == null) {
                set = new LinkedHashSet();
                this.inEdgeMap.put(object, set);
            }
        } else if (edgeType.equals(EdgeType.OUT)) {
            set = (Set)this.outEdgeMap.get(object);
            if (set == null) {
                set = new LinkedHashSet();
                this.outEdgeMap.put(object, set);
            }
        } else {
            set = (Set)this.inEdgeMap.get(object);
            Set set2 = (Set)this.outEdgeMap.get(object);
            if (set != null) {
                if (set2 != null) {
                    set.addAll(set2);
                } else {
                    this.outEdgeMap.put(object, new LinkedHashSet());
                }
            } else {
                this.inEdgeMap.put(object, new LinkedHashSet());
                if (set2 != null) {
                    set = set2;
                } else {
                    this.outEdgeMap.put(object, new LinkedHashSet());
                }
            }
        }
        return set;
    }

    public void insertEdge(Object object, Object object2, double d) {
        DirectedEdge directedEdge = new DirectedEdge(object, object2, d);
        Set set = this.getEdgeSet(object, EdgeType.OUT);
        set.add(directedEdge);
        set = this.getEdgeSet(object2, EdgeType.IN);
        set.add(directedEdge);
    }

    public void insertEdge(Edge edge) {
        DirectedEdge directedEdge = (DirectedEdge)edge;
        Set set = this.getEdgeSet(directedEdge.getFrom(), EdgeType.OUT);
        set.add(directedEdge);
        set = this.getEdgeSet(directedEdge.getTo(), EdgeType.IN);
        set.add(directedEdge);
    }

    public void removeEdge(Edge edge) {
        DirectedEdge directedEdge = (DirectedEdge)edge;
        Object object = directedEdge.getFrom();
        Object object2 = directedEdge.getTo();
        ((Set)this.outEdgeMap.get(object)).remove(edge);
        ((Set)this.inEdgeMap.get(object2)).remove(edge);
    }

    public void removeEdge(Object object, Object object2) {
        this.query.setFrom(object);
        this.query.setTo(object2);
        ((Set)this.outEdgeMap.get(object)).remove(this.query);
        ((Set)this.inEdgeMap.get(object2)).remove(this.query);
    }

    public boolean isUndirected(Edge edge) {
        Object object = edge.getElementOne();
        Object object2 = edge.getElementTwo();
        this.query.setFrom(object2);
        this.query.setTo(object);
        return ((Set)this.outEdgeMap.get(object2)).contains(this.query);
    }

    public boolean reverseDirection(Edge edge) {
        Object object = edge.getElementOne();
        Object object2 = edge.getElementTwo();
        edge.setElementTwo(object);
        edge.setElementOne(object2);
        return true;
    }

    public void setDirectionFrom(Edge edge, Object object) {
        if (!edge.getElementOne().equals(object)) {
            Object object2 = edge.getElementOne();
            edge.setElementOne(object);
            edge.setElementTwo(object2);
        }
    }

    public List getAdjacentNodes(Object object, EdgeType edgeType) {
        if (edgeType.equals(EdgeType.IN)) {
            return this.getInNodes(object);
        }
        if (edgeType.equals(EdgeType.OUT)) {
            return this.getOutNodes(object);
        }
        List list = this.getInNodes(object);
        list.addAll(this.getOutNodes(object));
        return list;
    }

    public List getInNodes(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Set set = this.getEdgeSet(object, EdgeType.IN);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            arrayList.add(edge.getOtherElement(object));
        }
        return arrayList;
    }

    public List getOutNodes(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Set set = this.getEdgeSet(object, EdgeType.OUT);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            arrayList.add(edge.getOtherElement(object));
        }
        return arrayList;
    }

    public List getAdjacentNodes(Object object, double d, EdgeType edgeType) {
        ArrayList arrayList = new ArrayList();
        if (EdgeType.OUT.equals(edgeType)) {
            arrayList.addAll((Set)this.outEdgeMap.get(object));
        }
        return arrayList;
    }

    public boolean areAdjacent(Object object, Object object2, EdgeType edgeType) {
        if (edgeType.equals(EdgeType.OUT)) {
            this.query.setFrom(object);
            this.query.setTo(object2);
            return ((Set)this.outEdgeMap.get(object)).contains(this.query);
        }
        return false;
    }

    public List getEdges(Object object, EdgeType edgeType) {
        ArrayList arrayList = new ArrayList();
        if (edgeType.equals(EdgeType.OUT) || edgeType.equals(EdgeType.ALL)) {
            arrayList.addAll((Set)this.outEdgeMap.get(object));
        }
        if (edgeType.equals(EdgeType.IN) || edgeType.equals(EdgeType.ALL)) {
            arrayList.addAll((Set)this.inEdgeMap.get(object));
        }
        return arrayList;
    }

    public int degree(Object object, EdgeType edgeType) {
        int n = 0;
        if (edgeType.equals(EdgeType.OUT) || edgeType.equals(EdgeType.ALL)) {
            n = ((Set)this.outEdgeMap.get(object)).size();
        }
        if (edgeType.equals(EdgeType.IN) || edgeType.equals(EdgeType.ALL)) {
            n = ((Set)this.inEdgeMap.get(object)).size();
        }
        return n;
    }

    public Iterator iterator() {
        return this.nodes.iterator();
    }

    public double distance(Object object, Object object2) {
        if (this.areAdjacent(object, object2, EdgeType.ALL)) {
            Edge edge = this.getEdge(object, object2);
            return edge.getStrength();
        }
        return Double.MAX_VALUE;
    }

    private Edge getEdge(Object object, Object object2) {
        List list = this.getEdges(object, EdgeType.ALL);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.getOtherElement(object).equals(object2)) continue;
            return edge;
        }
        return null;
    }

    public void makeUndirected(Edge edge) {
        DirectedEdge directedEdge = (DirectedEdge)edge.copy();
        Object object = directedEdge.getFrom();
        Object object2 = directedEdge.getTo();
        directedEdge.setFrom(object2);
        directedEdge.setTo(object);
        Set set = this.getEdgeSet(object2, EdgeType.OUT);
        set.add(directedEdge);
        Set set2 = this.getEdgeSet(object, EdgeType.IN);
        set2.add(directedEdge);
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isAcyclic() {
        DepthFirstSearch depthFirstSearch = new DepthFirstSearch(this);
        while (depthFirstSearch.hasNext()) {
            Object object = depthFirstSearch.next();
            if (!depthFirstSearch.getClassification(object).equals(EdgeClassification.BACK_EDGE)) continue;
            return false;
        }
        return true;
    }

    public boolean topologicalSort() {
        DepthFirstSearch depthFirstSearch = new DepthFirstSearch(this);
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        while (depthFirstSearch.hasNext()) {
            Object object = depthFirstSearch.next();
            if (depthFirstSearch.getClassification(object).equals(EdgeClassification.BACK_EDGE)) {
                return false;
            }
            linkedHashSet.add(object);
        }
        this.nodes = linkedHashSet;
        return true;
    }

    public Set getNodes() {
        return this.nodes;
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.inEdgeMap != null) {
            n = 1000003 * n + ((Object)this.inEdgeMap).hashCode();
        }
        if (this.outEdgeMap != null) {
            n = 1000003 * n + ((Object)this.outEdgeMap).hashCode();
        }
        if (this.nodes != null) {
            n = 1000003 * n + ((Object)this.nodes).hashCode();
        }
        if (this.type != null) {
            n = 1000003 * n + this.type.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DirectedGraph directedGraph = (DirectedGraph)object;
        if (this.inEdgeMap == null ? directedGraph.inEdgeMap != null : !((Object)this.inEdgeMap).equals(directedGraph.inEdgeMap)) {
            return false;
        }
        if (this.outEdgeMap == null ? directedGraph.outEdgeMap != null : !((Object)this.outEdgeMap).equals(directedGraph.outEdgeMap)) {
            return false;
        }
        if (this.nodes == null ? directedGraph.nodes != null : !((Object)this.nodes).equals(directedGraph.nodes)) {
            return false;
        }
        return !(this.type == null ? directedGraph.type != null : !this.type.equals(directedGraph.type));
    }

    public double clusterCoeffient() {
        double d = 0.0;
        HashSet hashSet = new HashSet();
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            hashSet.clear();
            int n = 0;
            Object e = iterator.next();
            List list = this.getAdjacentNodes(e, EdgeType.OUT);
            int n2 = list.size();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                hashSet.add(iterator2.next());
            }
            if (hashSet.contains(e)) {
                hashSet.remove(e);
            }
            iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                Iterator iterator3 = this.getAdjacentNodes(e2, EdgeType.OUT).iterator();
                while (iterator3.hasNext()) {
                    Object e3 = iterator3.next();
                    if (!hashSet.contains(e3) || e3.equals(e2)) continue;
                    ++n;
                }
            }
            if (n <= 0) continue;
            d = (double)n / (double)(n2 * (n2 - 1));
        }
        return d /= (double)this.getNodes().size();
    }
}

