/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.demo;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uchicago.src.sim.gui.DisplayConstants;
import uchicago.src.sim.gui.Drawable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.topology.Context;
import uchicago.src.sim.topology.demo.Model;
import uchicago.src.sim.topology.space2.GridAgent;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.SimUtilities;

public class Player
implements Drawable,
GridAgent {
    final int C = 1;
    final int D = 0;
    final String[] actionToString = new String[]{"D", "C"};
    public final int[] I_PARAMS = new int[]{1, 1, 0, 0};
    public final int[] P_PARAMS = new int[]{1, 1, 0, 0};
    public final int[] Q_PARAMS = new int[]{1, 0, 1, 0};
    private int x;
    private int y;
    private int playerID;
    private Player other;
    private int type;
    private int newType;
    private int[][] prefs = new int[][]{{1, 5}, {0, 3}};
    private int action;
    private int memory;
    private int cumulPayoff;
    private int numPlays;
    private double pAdapt;
    private int maxIter;
    private ArrayList otherList;
    private Context world;
    private String relationshipType;
    final Color[] COLOR = new Color[]{Color.red, Color.blue, Color.green, Color.white};

    public Player(int n, int n2, Model model) {
        this.playerID = n;
        this.type = n2;
        this.pAdapt = model.getPAdapt();
        this.maxIter = model.getMaxIter();
        this.otherList = new ArrayList();
    }

    public void reset() {
        this.numPlays = 0;
        this.cumulPayoff = 0;
        this.otherList.clear();
    }

    public void remember() {
        this.memory = this.other.action;
    }

    public void interact() {
        List list = this.world.getRelated(this, this.relationshipType, 1.0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Player player = (Player)iterator.next();
            this.game(player);
        }
    }

    public void game(Player player) {
        this.setOther(player);
        player.setOther(this);
        for (int i = 1; i <= this.maxIter; ++i) {
            this.play(i);
            player.play(i);
            this.remember();
            player.remember();
            this.addPayoff();
            player.addPayoff();
        }
    }

    public Context getWorld() {
        return this.world;
    }

    public void setWorld(Context context) {
        this.world = context;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String string) {
        this.relationshipType = string;
    }

    public void play(int n) {
        ++this.numPlays;
        this.action = n == 1 ? this.I_PARAMS[this.type] : (this.memory == 1 ? this.P_PARAMS[this.type] : this.Q_PARAMS[this.type]);
    }

    public void addPayoff() {
        this.cumulPayoff += this.prefs[this.action][this.other.action];
    }

    public void adapt() {
        this.newType = this.type;
        if (Random.uniform.nextDoubleFromTo(0.0, 1.0) < this.pAdapt) {
            SimUtilities.shuffle(this.otherList);
            double d = this.getAveragePayoff();
            Iterator iterator = this.otherList.iterator();
            while (iterator.hasNext()) {
                Player player = (Player)iterator.next();
                double d2 = player.getAveragePayoff();
                if (!(d2 > d)) continue;
                d = d2;
                this.newType = player.type;
            }
        }
    }

    public void updateType() {
        this.type = this.newType;
    }

    public double getAveragePayoff() {
        if (this.numPlays == 0) {
            return -1.0;
        }
        return (double)this.cumulPayoff / (double)this.numPlays;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Player getOther() {
        return this.other;
    }

    public void setOther(Player player) {
        this.other = player;
        this.otherList.add(player);
    }

    public int getPlayerID() {
        return this.playerID;
    }

    public void setPlayerID(int n) {
        this.playerID = n;
    }

    public String toString() {
        return Integer.toString(this.playerID);
    }

    public void draw(SimGraphics simGraphics) {
        simGraphics.setDrawingParameters(DisplayConstants.CELL_WIDTH * 2 / 3, DisplayConstants.CELL_HEIGHT * 2 / 3, DisplayConstants.CELL_DEPTH * 2 / 3);
        simGraphics.drawFastRoundRect(this.COLOR[this.type]);
    }
}

