/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.demo;

import java.util.Iterator;
import java.util.Vector;
import uchicago.src.reflector.ListPropertyDescriptor;
import uchicago.src.sim.engine.AbstractGUIController;
import uchicago.src.sim.engine.SimInit;
import uchicago.src.sim.engine.SimpleModel;
import uchicago.src.sim.gui.DisplaySurface;
import uchicago.src.sim.gui.Displayable;
import uchicago.src.sim.topology.Context;
import uchicago.src.sim.topology.ContextFactory;
import uchicago.src.sim.topology.DisplayableContext;
import uchicago.src.sim.topology.demo.Player;
import uchicago.src.sim.topology.space2.MooreTopology;
import uchicago.src.sim.topology.space2.Object2DGrid;
import uchicago.src.sim.topology.space2.VonNeumannTopology;

public class Model
extends SimpleModel {
    final int ALLC = 0;
    final int TFT = 1;
    final int ATFT = 2;
    final int ALLD = 3;
    final int NUMTYPES = 4;
    private Context world;
    private int worldSize;
    private int numPlayers;
    private double pALLC;
    private double pTFT;
    private double pATFT;
    private double pALLD;
    private int[] num;
    private int maxIter;
    private double pAdapt;
    private String topology;
    private DisplaySurface dsurf = null;

    public Model() {
        this.params = new String[]{"worldSize", "pALLC", "pTFT", "pATFT", "pALLD", "maxIter", "pAdapt", "Topology"};
        this.name = "GridIPD Model (Tutorial Step #4)";
        this.worldSize = 5;
        this.pALLC = 0.25;
        this.pTFT = 0.25;
        this.pATFT = 0.25;
        this.pALLD = 0.25;
        this.maxIter = 4;
        this.pAdapt = 0.2;
        this.topology = "";
        Vector<String> vector = new Vector<String>();
        vector.add("von neumann");
        vector.add("moore");
        vector.add("smallworld");
        ListPropertyDescriptor listPropertyDescriptor = new ListPropertyDescriptor("Topology", vector);
        this.descriptors.put("Topology", listPropertyDescriptor);
        this.topology = "von neumann";
    }

    public void setup() {
        super.setup();
        if (this.dsurf != null) {
            this.dsurf.dispose();
        }
        this.dsurf = null;
        ((AbstractGUIController)super.getController()).setConsoleErr(false);
        ((AbstractGUIController)super.getController()).setConsoleOut(false);
    }

    public void buildModel() {
        String string;
        Player player;
        this.numPlayers = this.worldSize * this.worldSize;
        this.num = new int[4];
        this.num[0] = (int)((double)this.numPlayers * this.pALLC);
        this.num[1] = (int)((double)this.numPlayers * this.pTFT);
        this.num[2] = (int)((double)this.numPlayers * this.pATFT);
        this.num[3] = (int)((double)this.numPlayers * this.pALLD);
        if (this.num[3] != this.numPlayers - this.num[0] - this.num[1] - this.num[2]) {
            this.num[3] = this.numPlayers - this.num[0] - this.num[1] - this.num[2];
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < this.num[i]; ++j) {
                player = new Player(++n, i, this);
                this.agentList.add(player);
            }
        }
        System.out.println("topology = " + this.topology);
        System.out.println("agentList.s = " + this.agentList.size());
        if (this.topology.equalsIgnoreCase("von neumann")) {
            this.world = ContextFactory.getGridFromList(this.worldSize, this.worldSize, this.agentList, true);
            string = VonNeumannTopology.type;
            this.dsurf = new DisplaySurface(this, "IPD");
            Displayable displayable = ((DisplayableContext)((Object)this.world)).getGui();
            this.dsurf.addDisplayableProbeable(displayable, "IPD ");
            this.registerDisplaySurface("IPD Display", this.dsurf);
            this.dsurf.display();
        } else if (this.topology.equalsIgnoreCase("moore")) {
            this.world = ContextFactory.getGridFromList(this.worldSize, this.worldSize, this.agentList, true);
            string = MooreTopology.type;
            this.dsurf = new DisplaySurface(this, "IPD");
            Displayable displayable = ((DisplayableContext)((Object)this.world)).getGui();
            this.dsurf.addDisplayableProbeable(displayable, "IPD ");
            this.registerDisplaySurface("IPD Display", this.dsurf);
            this.dsurf.display();
        } else {
            this.world = ContextFactory.getSmallWorldFromList(this.agentList, this.worldSize, this.worldSize, true, 1, 0.01);
            string = "SMALL_WORLD";
        }
        Iterator iterator = this.agentList.iterator();
        while (iterator.hasNext()) {
            player = (Player)iterator.next();
            player.setWorld(this.world);
            player.setRelationshipType(string);
        }
        this.reportResults();
    }

    public void resetPlayers() {
        Iterator iterator = this.agentList.iterator();
        while (iterator.hasNext()) {
            Player player = (Player)iterator.next();
            player.reset();
        }
    }

    public void play() {
        Iterator iterator = this.agentList.iterator();
        while (iterator.hasNext()) {
            Player player = (Player)iterator.next();
            player.interact();
        }
    }

    public void adaptation() {
        Player player;
        Iterator iterator = this.agentList.iterator();
        while (iterator.hasNext()) {
            player = (Player)iterator.next();
            player.adapt();
        }
        iterator = this.agentList.iterator();
        while (iterator.hasNext()) {
            player = (Player)iterator.next();
            player.updateType();
        }
    }

    public void reportResults() {
        int n;
        for (n = 0; n < 4; ++n) {
            this.num[n] = 0;
        }
        for (n = 0; n < this.numPlayers; ++n) {
            Player player = (Player)this.agentList.get(n);
            int n2 = player.getType();
            this.num[n2] = this.num[n2] + 1;
        }
        System.out.print(this.getTickCount() + ": ");
        for (n = 0; n < 4; ++n) {
            System.out.print(this.num[n] + " ");
        }
        System.out.println();
    }

    public void checkGrid() {
        Object2DGrid object2DGrid = (Object2DGrid)this.world;
        for (int i = 0; i < object2DGrid.getSizeX(); ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < object2DGrid.getSizeY(); ++j) {
                Object object = object2DGrid.getObjectAt(i, j);
                stringBuffer.append(object + " ");
            }
            System.out.println(stringBuffer);
        }
    }

    public void step() {
        this.checkGrid();
        this.resetPlayers();
        this.play();
        this.adaptation();
        this.reportResults();
        if (!this.topology.equalsIgnoreCase("smallworld")) {
            System.out.println("topology = " + this.topology);
            this.dsurf.updateDisplay();
        }
    }

    public int getWorldSize() {
        return this.worldSize;
    }

    public void setWorldSize(int n) {
        this.worldSize = n;
    }

    public double getpALLC() {
        return this.pALLC;
    }

    public void setpALLC(double d) {
        this.pALLC = d;
    }

    public double getpTFT() {
        return this.pTFT;
    }

    public void setpTFT(double d) {
        this.pTFT = d;
    }

    public double getpATFT() {
        return this.pATFT;
    }

    public void setpATFT(double d) {
        this.pATFT = d;
    }

    public double getpALLD() {
        return this.pALLD;
    }

    public void setpALLD(double d) {
        this.pALLD = d;
    }

    public int getMaxIter() {
        return this.maxIter;
    }

    public void setMaxIter(int n) {
        this.maxIter = n;
    }

    public double getPAdapt() {
        return this.pAdapt;
    }

    public void setPAdapt(double d) {
        this.pAdapt = d;
    }

    public Context getWorld() {
        return this.world;
    }

    public void setWorld(Context context) {
        this.world = context;
    }

    public String getTopology() {
        return this.topology;
    }

    public void setTopology(String string) {
        this.topology = string;
    }

    public static void main(String[] stringArray) {
        SimInit simInit = new SimInit();
        Model model = new Model();
        simInit.loadModel(model, null, false);
    }
}

