/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import uchicago.src.sim.topology.ModifyableTopology;

public class DefaultModifyableTopology
implements ModifyableTopology {
    private Map relationMap = new LinkedHashMap();
    public static String type = "DEFAULT_TOPOLOGY";
    private DijkstraSimple dijkstra = new DijkstraSimple();

    public void addRelation(Object object, Object object2, double d) {
        Set set = (Set)this.relationMap.get(object);
        Set set2 = (Set)this.relationMap.get(object2);
        set.add(object2);
        set2.add(object);
    }

    public void addRelation(Object object, Object object2) {
        this.addRelation(object, object, 1.0);
    }

    public void removeRelation(Object object, Object object2) {
        Set set = (Set)this.relationMap.get(object);
        Set set2 = (Set)this.relationMap.get(object2);
        set.remove(object2);
        set2.remove(object);
    }

    public boolean insertElement(Object object) {
        return this.relationMap.put(object, new LinkedHashSet()) != null;
    }

    public boolean removeElement(Object object) {
        Set set = (Set)this.relationMap.get(object);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Set set2 = (Set)this.relationMap.get(e);
            set2.remove(object);
        }
        return this.relationMap.remove(object) == null;
    }

    public List getRelations(Object object) {
        return new ArrayList((Set)this.relationMap.get(object));
    }

    public List getRelations(Object object, double d) {
        int n = (int)Math.floor(d);
        if (n == 1) {
            return this.getRelations(object);
        }
        ArrayList arrayList = new ArrayList();
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        linkedHashSet.add(object);
        for (int i = 0; i < n; ++i) {
            linkedHashSet2.clear();
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                arrayList.add(e);
                linkedHashSet2.addAll(this.getRelations(e));
            }
            linkedHashSet.clear();
            linkedHashSet.addAll(linkedHashSet2);
        }
        return arrayList;
    }

    public String getRelationType() {
        return type;
    }

    public double distance(Object object, Object object2) {
        if (this.areAdjacent(object, object2)) {
            return 1.0;
        }
        return this.dijkstra.dijkstra(object, object2);
    }

    public boolean areAdjacent(Object object, Object object2) {
        Set set = (Set)this.relationMap.get(object);
        return set.contains(object2);
    }

    public void setRelationType(String string) {
        type = string;
    }

    private class DijkstraSimple {
        private final Set settled = new HashSet();
        private final Map shortestDistances = new HashMap();
        private final Map predecessors = new HashMap();
        private final SortedSet unsettled = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                Integer n2 = (Integer)shortestDistances.get(object);
                int n3 = n2 == null ? Integer.MAX_VALUE : n2;
                if (n3 > (n = (n2 = (Integer)shortestDistances.get(object2)).intValue())) {
                    return 1;
                }
                if (n > n3) {
                    return -1;
                }
                return 0;
            }
        });

        private DijkstraSimple() {
        }

        public Object getPredecessor(Object object) {
            return this.predecessors.get(object);
        }

        public double dijkstra(Object object, Object object2) {
            Integer n;
            Object e;
            this.settled.clear();
            this.unsettled.clear();
            this.shortestDistances.clear();
            this.predecessors.clear();
            this.shortestDistances.put(object, new Integer(0));
            this.unsettled.add(object);
            Object e2 = this.unsettled.first();
            this.unsettled.remove(e2);
            while ((e = e2) != null) {
                if (this.settled.contains(e2)) continue;
                if (e == object2) break;
                this.settled.add(e);
                this.relaxNeighbors(e);
            }
            return (n = (Integer)this.shortestDistances.get(e2)) == null ? 2.147483647E9 : (double)n.intValue();
        }

        private void relaxNeighbors(Object object) {
            Iterator iterator = DefaultModifyableTopology.this.getRelations(object).iterator();
            while (iterator.hasNext()) {
                int n;
                Integer n2;
                int n3;
                Object e = iterator.next();
                if (this.settled.contains(e) || (n3 = (n2 = (Integer)this.shortestDistances.get(e)) == null ? Integer.MAX_VALUE : n2) <= (n = (n2 = (Integer)this.shortestDistances.get(object)) == null ? Integer.MAX_VALUE : n2) + 1) continue;
                n2 = (Integer)this.shortestDistances.get(object);
                int n4 = n2 == null ? Integer.MAX_VALUE : n2;
                this.shortestDistances.put(e, new Integer(n4 + 1));
                this.predecessors.put(e, object);
            }
        }
    }
}

