/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology;

import java.util.Iterator;
import java.util.List;
import uchicago.src.sim.topology.Context;
import uchicago.src.sim.topology.DefaultContext;
import uchicago.src.sim.topology.DefaultModifyableTopology;
import uchicago.src.sim.topology.ModifyableTopology;
import uchicago.src.sim.topology.RelationTopology;
import uchicago.src.sim.topology.space2.GridAgent;
import uchicago.src.sim.topology.space2.Location;
import uchicago.src.sim.topology.space2.Object2DGrid;
import uchicago.src.sim.topology.space2.OccupationTopology;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.SimUtilities;

public class ContextFactory {
    public static Context getFilledGrid(int n, int n2, Class clazz) {
        Object2DGrid object2DGrid = new Object2DGrid(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                try {
                    object2DGrid.addRelation(clazz.newInstance(), Location.getLocation(i, j), OccupationTopology.type, 1.0);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return object2DGrid;
    }

    public static Context getRandomGrid(int n, int n2, double d, Class clazz) {
        Object2DGrid object2DGrid = new Object2DGrid(n, n2);
        int n3 = (int)(d * (double)n * (double)n2);
        for (int i = 0; i < n3; ++i) {
            int n4 = Random.uniform.nextIntFromTo(0, n - 1);
            int n5 = Random.uniform.nextIntFromTo(0, n2 - 1);
            while (object2DGrid.getRelated(Location.getLocation(n4, n5), OccupationTopology.type, 1.0) != null) {
                n4 = Random.uniform.nextIntFromTo(0, n - 1);
                n5 = Random.uniform.nextIntFromTo(0, n2 - 1);
            }
            try {
                object2DGrid.addRelation(clazz.newInstance(), Location.getLocation(n4, n5), OccupationTopology.type, 1.0);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return object2DGrid;
    }

    public static Context getGridFromList(int n, int n2, List list, boolean bl) {
        if (list.size() > n * n2) {
            SimUtilities.showError("You have more Agents than spaces in grid", new IllegalArgumentException("size of list must not exceed size of grid"));
        }
        Object2DGrid object2DGrid = new Object2DGrid(n, n2);
        if (bl) {
            SimUtilities.shuffle(list);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                GridAgent gridAgent = (GridAgent)list.get(i * n + j);
                object2DGrid.addRelation(gridAgent, Location.getLocation(i, j), OccupationTopology.type);
                gridAgent.setX(i);
                gridAgent.setY(j);
            }
        }
        return object2DGrid;
    }

    public static Context getSmallWorldFromList(List list, int n, int n2, boolean bl, int n3, double d) {
        DefaultContext defaultContext = new DefaultContext();
        DefaultModifyableTopology defaultModifyableTopology = new DefaultModifyableTopology();
        defaultModifyableTopology.setRelationType("SMALL_WORLD");
        defaultContext.addRelationType(defaultModifyableTopology);
        ContextFactory.squareLattice(list, bl, n, n3, n2, defaultContext, defaultModifyableTopology);
        ContextFactory.randomRewire(list, defaultContext, d, defaultModifyableTopology);
        return defaultContext;
    }

    private static void randomRewire(List list, Context context, double d, RelationTopology relationTopology) {
        Iterator iterator = context.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            List list2 = context.getRelated(e, relationTopology.getRelationType(), 1.0);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                int n;
                Object e2;
                Object e3 = iterator2.next();
                if (!(Random.uniform.nextDoubleFromTo(0.0, 1.0) < d) || (e2 = list.get(n = Random.uniform.nextIntFromTo(0, list.size()))).equals(e) || context.areRelated(e, e2, 1.0, relationTopology.getRelationType())) continue;
                context.removeRelation(e, e3, relationTopology.getRelationType());
                context.addRelation(e, e2, relationTopology.getRelationType(), 1.0);
            }
        }
    }

    private static Context squareLattice(List list, boolean bl, int n, int n2, int n3, Context context, ModifyableTopology modifyableTopology) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            context.add(iterator.next());
        }
        int n4 = list.size();
        if (bl) {
            for (int i = 0; i < n4; ++i) {
                Object e = list.get(i);
                int n5 = i % n;
                int n6 = (int)Math.floor(i / n);
                for (int j = 1; j <= n2; ++j) {
                    Object e2;
                    int n7 = n6;
                    int n8 = (n5 + j) % n;
                    int n9 = n7 * n + n8;
                    if (i != n9) {
                        e2 = list.get(n9);
                        context.addRelation(e, e2, modifyableTopology.getRelationType(), 1.0);
                    }
                    if (i == (n9 = (n7 = (n6 + j) % n3) * n + (n8 = n5))) continue;
                    e2 = list.get(n9);
                    context.addRelation(e, e2, modifyableTopology.getRelationType(), 1.0);
                }
            }
        }
        return context;
    }
}

