/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import cern.colt.list.DoubleArrayList;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.test.Action;

public class ScheduleTest
extends TestCase {
    Schedule sch;
    Action action;
    static DoubleArrayList results;
    static ArrayList actionList;
    static /* synthetic */ Class class$uchicago$src$sim$test$ScheduleTest;

    public ScheduleTest(String string) {
        super(string);
    }

    public void setUp() {
        results = new DoubleArrayList();
        actionList = new ArrayList();
        this.sch = new Schedule();
        this.action = new Action(this.sch);
    }

    public void testAt() {
        this.sch.scheduleActionAt(3.45, this.action);
        this.sch.execute();
        ScheduleTest.assertEquals((double)3.45, (double)this.action.at, (double)0.0);
        ScheduleTest.assertEquals((double)3.45, (double)results.get(0), (double)0.0);
    }

    public void testBeginning() {
        int n;
        this.sch.scheduleActionBeginning(1.0, this.action);
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 10; ++n) {
            ScheduleTest.assertEquals((double)(n + 1), (double)results.get(n), (double)0.0);
        }
    }

    public void testDuration() {
        this.sch.scheduleActionBeginning(1.0, this.action);
        this.sch.scheduleActionAt(1.0, new BasicAction(){

            public void execute() {
                try {
                    int n = 0;
                    while ((long)n < 100000L && !Thread.currentThread().isInterrupted()) {
                        if (n % 100 == 0) {
                            // empty if block
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }, 4.0);
        for (int i = 0; i < 20; ++i) {
            this.sch.execute();
        }
    }

    public void testBeginningStepDouble() {
        int n;
        this.sch = new Schedule(0.4);
        this.action = new Action(this.sch);
        this.sch.scheduleActionBeginning(1.0, this.action);
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        ScheduleTest.assertEquals((double)1.0, (double)results.get(0), (double)0.0);
        for (n = 1; n < 10; ++n) {
            ScheduleTest.assertEquals((double)(1.0 + (double)n * 0.4), (double)results.get(n), (double)0.01);
        }
    }

    public void testBeginningStepInt() {
        int n;
        this.sch = new Schedule(2.0);
        this.action = new Action(this.sch);
        this.sch.scheduleActionBeginning(3.0, this.action);
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 10; ++n) {
            ScheduleTest.assertEquals((double)(3 + n * 2), (double)results.get(n), (double)0.0);
        }
    }

    public void testInterval() {
        int n;
        this.sch.execute();
        this.sch.scheduleActionAtInterval(0.4, this.action);
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 10; ++n) {
            ScheduleTest.assertEquals((double)(0.4 * (double)(n + 1)), (double)results.get(n), (double)0.01);
        }
    }

    public void testAtCon() {
        Action action = new Action(this.sch);
        action.tag = 999.0;
        action.setName("999");
        this.sch.scheduleActionBeginning(1.0, this.action);
        this.sch.scheduleActionAt(2.0, action);
        for (int i = 0; i < 25; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.sch.execute();
            }
            ScheduleTest.assertEquals((double)1.0, (double)results.get(0), (double)0.0);
            double d = results.get(1);
            ScheduleTest.assertTrue((d == 999.0 || d == 2.0 ? 1 : 0) != 0);
            d = results.get(2);
            ScheduleTest.assertTrue((d == 999.0 || d == 2.0 ? 1 : 0) != 0);
            for (int j = 3; j < 11; ++j) {
                ScheduleTest.assertEquals((double)j, (double)results.get(j), (double)0.0);
            }
            this.setUp();
            action = new Action(this.sch);
            action.tag = 999.0;
            action.setName("999");
            this.sch.scheduleActionBeginning(1.0, this.action);
            this.sch.scheduleActionAt(2.0, action);
        }
    }

    public void testBeginningD() {
        int n;
        this.sch.scheduleActionBeginning(0.3, this.action);
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 10; ++n) {
            ScheduleTest.assertEquals((double)(0.3 + (double)n), (double)results.get(n), (double)0.0);
        }
    }

    public void testBeginningAt() {
        int n;
        Action action = new Action(this.sch);
        this.sch.scheduleActionBeginning(1.0, this.action);
        this.sch.scheduleActionAt(5.43, action);
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 5; ++n) {
            ScheduleTest.assertEquals((double)(n + 1), (double)results.get(n), (double)0.0);
        }
        ScheduleTest.assertEquals((double)5.43, (double)results.get(5), (double)0.0);
        for (n = 6; n < results.size(); ++n) {
            ScheduleTest.assertEquals((double)n, (double)results.get(n), (double)0.0);
        }
    }

    public void testBegInterval() {
        this.action.setName("beg action");
        Action action = new Action(this.sch);
        action.setName("a - interval 2");
        Action action2 = new Action(this.sch);
        action2.setName("b - interval 4");
        this.sch.scheduleActionAtInterval(2.0, action);
        this.sch.scheduleActionAtInterval(4.0, action2);
        this.sch.scheduleActionBeginning(1.0, this.action);
        for (int i = 0; i < 12; ++i) {
            this.sch.execute();
        }
        ScheduleTest.assertEquals(actionList.get(0), (Object)this.action);
        Object e = actionList.get(1);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) ? 1 : 0) != 0);
        e = actionList.get(2);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) ? 1 : 0) != 0);
        e = actionList.get(3);
        ScheduleTest.assertTrue((boolean)e.equals(this.action));
        e = actionList.get(4);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) || e.equals(action2) ? 1 : 0) != 0);
        e = actionList.get(5);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) || e.equals(action2) ? 1 : 0) != 0);
        e = actionList.get(6);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) || e.equals(action2) ? 1 : 0) != 0);
        actionList.get(8);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) ? 1 : 0) != 0);
        e = actionList.get(9);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) ? 1 : 0) != 0);
        e = actionList.get(10);
        ScheduleTest.assertTrue((boolean)e.equals(this.action));
        e = actionList.get(11);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) || e.equals(action2) ? 1 : 0) != 0);
        e = actionList.get(12);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) || e.equals(action2) ? 1 : 0) != 0);
        e = actionList.get(13);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) || e.equals(action2) ? 1 : 0) != 0);
        e = actionList.get(14);
        ScheduleTest.assertTrue((boolean)e.equals(this.action));
        actionList.get(15);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) ? 1 : 0) != 0);
        e = actionList.get(16);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) ? 1 : 0) != 0);
        e = actionList.get(17);
        ScheduleTest.assertTrue((boolean)e.equals(this.action));
        e = actionList.get(18);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) || e.equals(action2) ? 1 : 0) != 0);
        e = actionList.get(19);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) || e.equals(action2) ? 1 : 0) != 0);
        e = actionList.get(20);
        ScheduleTest.assertTrue((e.equals(this.action) || e.equals(action) || e.equals(action2) ? 1 : 0) != 0);
    }

    public void testIntervalWithGenAction() {
        this.sch.scheduleActionAtInterval(3.2, (Object)this, "actionMethod");
        this.sch.execute();
        this.sch.execute();
        ScheduleTest.assertEquals((double)3.2, (double)results.get(0), (double)0.01);
        ScheduleTest.assertEquals((double)6.4, (double)results.get(1), (double)0.01);
    }

    public void testAtGen() {
        this.sch.scheduleActionAt(3.45, (Object)this, "actionMethod");
        this.sch.execute();
        ScheduleTest.assertEquals((double)3.45, (double)results.get(0), (double)0.0);
    }

    public void testBeginningGen() {
        int n;
        this.sch.scheduleActionBeginning(1.0, (Object)this, "actionMethod");
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 10; ++n) {
            ScheduleTest.assertEquals((double)(n + 1), (double)results.get(n), (double)0.0);
        }
    }

    public void testBeginningStepDoubleGen() {
        int n;
        this.sch = new Schedule(0.4);
        this.sch.scheduleActionBeginning(1.0, (Object)this, "actionMethod");
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        ScheduleTest.assertEquals((double)1.0, (double)results.get(0), (double)0.0);
        for (n = 1; n < 10; ++n) {
            ScheduleTest.assertEquals((double)(1.0 + (double)n * 0.4), (double)results.get(n), (double)0.01);
        }
    }

    public void testBeginningStepIntGen() {
        int n;
        this.sch = new Schedule(2.0);
        this.sch.scheduleActionBeginning(3.0, (Object)this, "actionMethod");
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 10; ++n) {
            ScheduleTest.assertEquals((double)(3 + n * 2), (double)results.get(n), (double)0.0);
        }
    }

    public void testIntervalGen() {
        int n;
        this.sch.execute();
        this.sch.scheduleActionAtInterval(0.4, (Object)this, "actionMethod");
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 10; ++n) {
            ScheduleTest.assertEquals((double)(0.4 * (double)(n + 1)), (double)results.get(n), (double)0.01);
        }
    }

    public void testAtLast() {
        int n;
        Action action = new Action(this.sch);
        action.tag = 999.0;
        Action action2 = new Action(this.sch);
        action2.tag = 222.0;
        Action action3 = new Action(this.sch);
        action3.tag = 444.0;
        this.sch.scheduleActionBeginning(1.0, this.action);
        this.sch.scheduleActionAt(2.0, (BasicAction)action, Schedule.LAST);
        this.sch.scheduleActionAt(2.0, (BasicAction)action2, Schedule.LAST);
        this.sch.scheduleActionAt(2.0, (BasicAction)action3, Schedule.LAST);
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 2; ++n) {
            ScheduleTest.assertEquals((double)(n + 1), (double)results.get(n), (double)0.0);
        }
        ScheduleTest.assertEquals((double)999.0, (double)results.get(2), (double)0.0);
        ScheduleTest.assertEquals((double)222.0, (double)results.get(3), (double)0.0);
        ScheduleTest.assertEquals((double)444.0, (double)results.get(4), (double)0.0);
        for (n = 5; n < 13; ++n) {
            ScheduleTest.assertEquals((double)(n - 2), (double)results.get(n), (double)0.0);
        }
    }

    public void testAtIntervalLast() {
        int n;
        Action action = new Action(this.sch);
        action.tag = 999.0;
        Action action2 = new Action(this.sch);
        action2.tag = 222.0;
        Action action3 = new Action(this.sch);
        action3.tag = 444.0;
        this.sch.scheduleActionBeginning(1.0, this.action);
        this.sch.scheduleActionAtInterval(4.0, (BasicAction)action, Schedule.LAST);
        this.sch.scheduleActionAtInterval(4.0, (BasicAction)action2, Schedule.LAST);
        this.sch.scheduleActionAtInterval(4.0, (BasicAction)action3, Schedule.LAST);
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 4; ++n) {
            ScheduleTest.assertEquals((double)(n + 1), (double)results.get(n), (double)0.0);
        }
        ScheduleTest.assertEquals((double)999.0, (double)results.get(4), (double)0.0);
        ScheduleTest.assertEquals((double)222.0, (double)results.get(5), (double)0.0);
        ScheduleTest.assertEquals((double)444.0, (double)results.get(6), (double)0.0);
        for (n = 7; n < 11; ++n) {
            ScheduleTest.assertEquals((double)(n - 2), (double)results.get(n), (double)0.0);
        }
        ScheduleTest.assertEquals((double)999.0, (double)results.get(11), (double)0.0);
        ScheduleTest.assertEquals((double)222.0, (double)results.get(12), (double)0.0);
        ScheduleTest.assertEquals((double)444.0, (double)results.get(13), (double)0.0);
        ScheduleTest.assertEquals((double)9.0, (double)results.get(14), (double)0.0);
        ScheduleTest.assertEquals((double)10.0, (double)results.get(15), (double)0.0);
    }

    public void testAtLastGen() {
        int n;
        this.sch.scheduleActionBeginning(1.0, (Object)this, "actionMethod");
        this.sch.scheduleActionAt(2.0, (Object)this, "actionMethodTag", Schedule.LAST);
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 2; ++n) {
            ScheduleTest.assertEquals((double)(n + 1), (double)results.get(n), (double)0.0);
        }
        ScheduleTest.assertEquals((double)999.0, (double)results.get(2), (double)0.0);
        for (n = 3; n < 11; ++n) {
            ScheduleTest.assertEquals((double)n, (double)results.get(n), (double)0.0);
        }
    }

    public void testAtConGen() {
        this.sch.scheduleActionBeginning(1.0, (Object)this, "actionMethod");
        this.sch.scheduleActionAt(2.0, (Object)this, "actionMethodTag");
        for (int i = 0; i < 25; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.sch.execute();
            }
            ScheduleTest.assertEquals((double)1.0, (double)results.get(0), (double)0.0);
            double d = results.get(1);
            ScheduleTest.assertTrue((d == 999.0 || d == 2.0 ? 1 : 0) != 0);
            d = results.get(2);
            ScheduleTest.assertTrue((d == 999.0 || d == 2.0 ? 1 : 0) != 0);
            for (int j = 3; j < 11; ++j) {
                ScheduleTest.assertEquals((double)j, (double)results.get(j), (double)0.0);
            }
            this.setUp();
            this.sch.scheduleActionBeginning(1.0, (Object)this, "actionMethod");
            this.sch.scheduleActionAt(2.0, (Object)this, "actionMethodTag");
        }
    }

    public void testBeginningDGen() {
        int n;
        this.sch.scheduleActionBeginning(0.3, (Object)this, "actionMethod");
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 10; ++n) {
            ScheduleTest.assertEquals((double)(0.3 + (double)n), (double)results.get(n), (double)0.0);
        }
    }

    public void testBeginningAtGen() {
        int n;
        this.sch.scheduleActionBeginning(1.0, (Object)this, "actionMethod");
        this.sch.scheduleActionAt(5.43, (Object)this, "actionMethod");
        for (n = 0; n < 10; ++n) {
            this.sch.execute();
        }
        for (n = 0; n < 5; ++n) {
            ScheduleTest.assertEquals((double)(n + 1), (double)results.get(n), (double)0.0);
        }
        ScheduleTest.assertEquals((double)5.43, (double)results.get(5), (double)0.0);
        for (n = 6; n < results.size(); ++n) {
            ScheduleTest.assertEquals((double)n, (double)results.get(n), (double)0.0);
        }
    }

    public void testRemoveAction() {
        int n;
        BasicAction basicAction = this.sch.scheduleActionBeginning(1.0, (Object)this, "actionMethod");
        this.sch.execute();
        ScheduleTest.assertEquals((int)1, (int)results.size());
        this.sch.removeAction(basicAction);
        this.sch.execute();
        ScheduleTest.assertEquals((int)1, (int)results.size());
        this.sch = new Schedule();
        basicAction = this.sch.scheduleActionBeginning(1.0, (Object)this, "actionMethod");
        results.clear();
        for (n = 0; n < 15; ++n) {
            this.sch.execute();
            if (n == 6) {
                this.sch.removeAction(basicAction);
            }
            if (n != 10) continue;
            this.sch.scheduleActionBeginning(this.sch.getCurrentTime() + 1.0, basicAction);
        }
        ScheduleTest.assertEquals((int)11, (int)results.size());
        for (n = 0; n < 11; ++n) {
            ScheduleTest.assertEquals((double)(n + 1), (double)results.get(n), (double)0.0);
        }
    }

    public void actionMethod() {
        results.add(this.sch.getCurrentTime());
    }

    public void actionMethodTag() {
        results.add(999.0);
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$ScheduleTest == null ? (class$uchicago$src$sim$test$ScheduleTest = ScheduleTest.class$("uchicago.src.sim.test.ScheduleTest")) : class$uchicago$src$sim$test$ScheduleTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

