/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import uchicago.src.sim.space.Object2DGrid;
import uchicago.src.sim.space.Object2DTorus;

public class RectTest
extends TestCase {
    private Object2DGrid grid = new Object2DGrid(10, 10);
    private Object2DTorus torus = new Object2DTorus(10, 10);
    static /* synthetic */ Class class$uchicago$src$sim$test$RectTest;

    public RectTest(String string) {
        super(string);
    }

    public void setUp() {
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.grid.putObjectAt(j, i, new Integer(n));
                this.torus.putObjectAt(j, i, new Integer(n));
                ++n;
            }
        }
    }

    public void testFindMooreMax() {
        Integer n = new Integer(66);
        Integer n2 = (Integer)this.grid.findMaximum(5, 5, 1, true, 1).get(0);
        RectTest.assertEquals((Object)n, (Object)n2);
    }

    public void testNormX() {
        Integer n = new Integer(51);
        Integer n2 = (Integer)this.torus.getObjectAt(11, 5);
        RectTest.assertEquals((Object)n, (Object)n2);
    }

    public void testFindVNMax() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(65));
        Vector vector2 = this.grid.findMaximum(5, 5, 1, true, 0);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testFindExtendedMooreMax() {
        Integer n = new Integer(77);
        Integer n2 = (Integer)this.grid.findMaximum(5, 5, 2, true, 1).get(0);
        RectTest.assertEquals((Object)n, (Object)n2);
    }

    public void testFindExtendedVNMax() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(75));
        Vector vector2 = this.grid.findMaximum(5, 5, 2, true, 0);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testFindExtendedVNTorusMin() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(9));
        Vector vector2 = this.torus.findMinimum(9, 9, 2, true, 0);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testTorusExtendedVN() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(57));
        vector.add(new Integer(58));
        vector.add(new Integer(51));
        vector.add(new Integer(50));
        vector.add(new Integer(39));
        vector.add(new Integer(49));
        vector.add(new Integer(79));
        vector.add(new Integer(69));
        Vector vector2 = this.torus.getVonNeumannNeighbors(9, 5, 2, 2, true);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testSEMooreEdge() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(88));
        vector.add(new Integer(89));
        vector.add(new Integer(80));
        vector.add(new Integer(98));
        vector.add(new Integer(90));
        vector.add(new Integer(8));
        vector.add(new Integer(9));
        vector.add(new Integer(0));
        Vector vector2 = this.torus.getMooreNeighbors(9, 9, false);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testSWMooreEdge() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(89));
        vector.add(new Integer(80));
        vector.add(new Integer(81));
        vector.add(new Integer(99));
        vector.add(new Integer(91));
        vector.add(new Integer(9));
        vector.add(new Integer(0));
        vector.add(new Integer(1));
        Vector vector2 = this.torus.getMooreNeighbors(0, 9, false);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testNWMooreEdge() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(99));
        vector.add(new Integer(90));
        vector.add(new Integer(91));
        vector.add(new Integer(9));
        vector.add(new Integer(1));
        vector.add(new Integer(19));
        vector.add(new Integer(10));
        vector.add(new Integer(11));
        Vector vector2 = this.torus.getMooreNeighbors(0, 0, false);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testNEMooreEdge() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(98));
        vector.add(new Integer(99));
        vector.add(new Integer(90));
        vector.add(new Integer(8));
        vector.add(new Integer(0));
        vector.add(new Integer(18));
        vector.add(new Integer(19));
        vector.add(new Integer(10));
        Vector vector2 = this.torus.getMooreNeighbors(9, 0, false);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testSEVNEdge() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(98));
        vector.add(new Integer(90));
        vector.add(new Integer(89));
        vector.add(new Integer(9));
        Vector vector2 = this.torus.getVonNeumannNeighbors(9, 9, false);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testSWVNEdge() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(99));
        vector.add(new Integer(91));
        vector.add(new Integer(80));
        vector.add(new Integer(0));
        Vector vector2 = this.torus.getVonNeumannNeighbors(0, 9, false);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testNWVNEdge() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(9));
        vector.add(new Integer(1));
        vector.add(new Integer(90));
        vector.add(new Integer(10));
        Vector vector2 = this.torus.getVonNeumannNeighbors(0, 0, false);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testNEVNEdge() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(8));
        vector.add(new Integer(0));
        vector.add(new Integer(99));
        vector.add(new Integer(19));
        Vector vector2 = this.torus.getVonNeumannNeighbors(9, 0, false);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testMooreMin() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(44));
        Vector vector2 = this.grid.findMinimum(5, 5, 1, true, 1);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testGridVNEdge() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(18));
        vector.add(new Integer(9));
        vector.add(new Integer(29));
        Vector vector2 = this.grid.getVonNeumannNeighbors(9, 1, 1, 1, true);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public void testGridMooreEdge() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(80));
        vector.add(new Integer(81));
        vector.add(new Integer(91));
        Vector vector2 = this.grid.getMooreNeighbors(0, 9, 1, 1, true);
        RectTest.assertEquals(vector, (Object)vector2);
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$RectTest == null ? (class$uchicago$src$sim$test$RectTest = RectTest.class$("uchicago.src.sim.test.RectTest")) : class$uchicago$src$sim$test$RectTest);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RectTest.suite());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

