/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import uchicago.src.sim.network.AdjacencyMatrix;
import uchicago.src.sim.network.AdjacencyMatrixFactory;
import uchicago.src.sim.network.NetUtilities;
import uchicago.src.sim.network.NetworkConvertor;
import uchicago.src.sim.network.NetworkFactory;
import uchicago.src.sim.network.NetworkRecorder;
import uchicago.src.sim.util.Random;

public class NetworkTest
extends TestCase {
    boolean windows = false;
    String outDir = "uchicago/src/sim/test/net_output";
    double[][] binMatrix = new double[][]{{0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0}};
    double[][] byteMatrix = new double[][]{{0.0, 0.0, 120.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0}, {0.0, -30.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 12.0, 0.0, 0.0}};
    double[][] doubleMatrix = new double[][]{{0.0, 0.0, 120000.23, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0}, {0.0, -3.1123123112E7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 32343.0, 0.0, 0.0}};
    static /* synthetic */ Class class$uchicago$src$sim$network$DefaultNode;
    static /* synthetic */ Class class$uchicago$src$sim$network$DefaultEdge;
    static /* synthetic */ Class class$uchicago$src$sim$test$NetworkTest;

    public NetworkTest(String string) {
        super(string);
    }

    public void setUp() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            this.windows = true;
        }
    }

    private boolean matrixComp(double[][] dArray, AdjacencyMatrix adjacencyMatrix) {
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < dArray2.length; ++j) {
                if (dArray2[j] == adjacencyMatrix.get(i, j)) continue;
                System.out.println("expected: " + dArray2[j] + ", got: " + adjacencyMatrix.get(i, j));
                return false;
            }
        }
        return true;
    }

    private String getFileAsString(String string) {
        String string2 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + string3 + "\n";
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        return string2.trim();
    }

    private String getComment(String string) {
        int n = string.indexOf("#");
        int n2 = string.indexOf("\n", n);
        return string.substring(n, n2);
    }

    private String getDLHeader(String string) {
        int n = string.indexOf("dl");
        int n2 = string.indexOf("data:", n);
        return string.substring(n, n2);
    }

    private AdjacencyMatrix getMatrixFromString(String string, int n) {
        int n2 = string.indexOf("data:");
        int n3 = string.indexOf("\n", n2);
        String string2 = string.substring(n3, string.length()).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        int n4 = stringTokenizer.countTokens();
        AdjacencyMatrix adjacencyMatrix = AdjacencyMatrixFactory.createAdjacencyMatrix(n4, n4, n);
        int n5 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), " ");
            int n6 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                adjacencyMatrix.set(n5, n6, Double.parseDouble(stringTokenizer2.nextToken()));
                ++n6;
            }
            ++n5;
        }
        return adjacencyMatrix;
    }

    public void testBinFactory() {
        List list = NetworkFactory.getNetwork("uchicago/src/sim/test/bin_matrix.dl", 0, class$uchicago$src$sim$network$DefaultNode == null ? (class$uchicago$src$sim$network$DefaultNode = NetworkTest.class$("uchicago.src.sim.network.DefaultNode")) : class$uchicago$src$sim$network$DefaultNode, class$uchicago$src$sim$network$DefaultEdge == null ? (class$uchicago$src$sim$network$DefaultEdge = NetworkTest.class$("uchicago.src.sim.network.DefaultEdge")) : class$uchicago$src$sim$network$DefaultEdge, 0);
        NetworkTest.assertEquals((int)9, (int)list.size());
        Vector vector = NetworkConvertor.nodesToMatrices(list, 0);
        AdjacencyMatrix adjacencyMatrix = (AdjacencyMatrix)vector.get(0);
        NetworkTest.assertTrue((boolean)this.matrixComp(this.binMatrix, adjacencyMatrix));
    }

    public void testByteFactory() {
        List list = NetworkFactory.getNetwork("uchicago/src/sim/test/byte_matrix.dl", 0, class$uchicago$src$sim$network$DefaultNode == null ? (class$uchicago$src$sim$network$DefaultNode = NetworkTest.class$("uchicago.src.sim.network.DefaultNode")) : class$uchicago$src$sim$network$DefaultNode, class$uchicago$src$sim$network$DefaultEdge == null ? (class$uchicago$src$sim$network$DefaultEdge = NetworkTest.class$("uchicago.src.sim.network.DefaultEdge")) : class$uchicago$src$sim$network$DefaultEdge, 1);
        NetworkTest.assertEquals((int)9, (int)list.size());
        Vector vector = NetworkConvertor.nodesToMatrices(list, 1);
        AdjacencyMatrix adjacencyMatrix = (AdjacencyMatrix)vector.get(0);
        NetworkTest.assertTrue((boolean)this.matrixComp(this.byteMatrix, adjacencyMatrix));
    }

    public void testDoubleFactory() {
        List list = NetworkFactory.getNetwork("uchicago/src/sim/test/double_matrix.dl", 0, class$uchicago$src$sim$network$DefaultNode == null ? (class$uchicago$src$sim$network$DefaultNode = NetworkTest.class$("uchicago.src.sim.network.DefaultNode")) : class$uchicago$src$sim$network$DefaultNode, class$uchicago$src$sim$network$DefaultEdge == null ? (class$uchicago$src$sim$network$DefaultEdge = NetworkTest.class$("uchicago.src.sim.network.DefaultEdge")) : class$uchicago$src$sim$network$DefaultEdge, 2);
        NetworkTest.assertEquals((int)9, (int)list.size());
        Vector vector = NetworkConvertor.nodesToMatrices(list, 2);
        AdjacencyMatrix adjacencyMatrix = (AdjacencyMatrix)vector.get(0);
        NetworkTest.assertTrue((boolean)this.matrixComp(this.doubleMatrix, adjacencyMatrix));
    }

    public void testRecorder() {
        List list = NetworkFactory.getNetwork("uchicago/src/sim/test/bin_matrix.dl", 0, class$uchicago$src$sim$network$DefaultNode == null ? (class$uchicago$src$sim$network$DefaultNode = NetworkTest.class$("uchicago.src.sim.network.DefaultNode")) : class$uchicago$src$sim$network$DefaultNode, class$uchicago$src$sim$network$DefaultEdge == null ? (class$uchicago$src$sim$network$DefaultEdge = NetworkTest.class$("uchicago.src.sim.network.DefaultEdge")) : class$uchicago$src$sim$network$DefaultEdge, 0);
        NetworkRecorder networkRecorder = new NetworkRecorder(0, this.outDir + "/recTestBin.dl", null);
        networkRecorder.record(list, "a comment", 0);
        networkRecorder.write();
        String string = this.getFileAsString(this.outDir + "/recTestBin.dl");
        String string2 = this.getComment(string);
        NetworkTest.assertTrue((String)"comments not equal", (boolean)string2.equals("# a comment"));
        NetworkTest.assertTrue((String)"dl header not equal", (boolean)this.getDLHeader(string).trim().equals("dl n=9"));
        AdjacencyMatrix adjacencyMatrix = this.getMatrixFromString(string, 0);
        NetworkTest.assertTrue((boolean)this.matrixComp(this.binMatrix, adjacencyMatrix));
    }

    public void testNetStats() {
        Random.createUniform();
        List list = NetworkFactory.getNetwork("uchicago/src/sim/test/stats_test_no_sym.dl", 0, class$uchicago$src$sim$network$DefaultNode == null ? (class$uchicago$src$sim$network$DefaultNode = NetworkTest.class$("uchicago.src.sim.network.DefaultNode")) : class$uchicago$src$sim$network$DefaultNode, class$uchicago$src$sim$network$DefaultEdge == null ? (class$uchicago$src$sim$network$DefaultEdge = NetworkTest.class$("uchicago.src.sim.network.DefaultEdge")) : class$uchicago$src$sim$network$DefaultEdge, 0);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        double d = NetUtilities.calcDensity(arrayList);
        NetworkTest.assertEquals((double)0.2993, (double)d, (double)0.0);
        double d2 = NetUtilities.calcClustCoef(arrayList);
        BigDecimal bigDecimal = new BigDecimal(d2);
        bigDecimal = bigDecimal.setScale(9, 1);
        NetworkTest.assertEquals((double)0.301275979, (double)bigDecimal.doubleValue(), (double)0.0);
        NetworkTest.assertEquals((int)1, (int)NetUtilities.getComponents(arrayList).size());
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$NetworkTest == null ? (class$uchicago$src$sim$test$NetworkTest = NetworkTest.class$("uchicago.src.sim.test.NetworkTest")) : class$uchicago$src$sim$test$NetworkTest);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)NetworkTest.suite());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

