/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import uchicago.src.sim.space.Cell;
import uchicago.src.sim.space.Multi2DGrid;
import uchicago.src.sim.space.Multi2DHexagonalGrid;
import uchicago.src.sim.space.Multi2DHexagonalTorus;
import uchicago.src.sim.space.Multi2DTorus;
import uchicago.src.sim.space.ObjectLocation;
import uchicago.src.sim.space.OrderedCell;
import uchicago.src.sim.space.OrderedMulti2DGrid;
import uchicago.src.sim.space.OrderedMulti2DHexagonalGrid;
import uchicago.src.sim.space.OrderedMulti2DHexagonalTorus;
import uchicago.src.sim.space.OrderedMulti2DTorus;

public class MultiGridTest
extends TestCase {
    Multi2DGrid grid;
    Multi2DTorus torus;
    OrderedMulti2DGrid ogrid;
    OrderedMulti2DTorus otorus;
    Multi2DHexagonalGrid hgrid;
    Multi2DHexagonalTorus htorus;
    OrderedMulti2DHexagonalGrid ohgrid;
    OrderedMulti2DHexagonalTorus ohtorus;
    static /* synthetic */ Class class$uchicago$src$sim$test$MultiGridTest;

    public MultiGridTest(String string) {
        super(string);
    }

    public void setUp() {
        this.grid = new Multi2DGrid(20, 30, true);
        this.grid.putObjectAt(10, 10, new Integer(3));
        this.grid.putObjectAt(10, 10, new Integer(4));
        this.grid.putObjectAt(17, 13, new Integer(12));
        this.grid.putObjectAt(13, 22, new Integer(-1));
        this.grid.putObjectAt(16, 1, new Integer(3));
        this.grid.putObjectAt(17, 0, new Integer(1));
        this.grid.putObjectAt(17, 2, new Integer(3));
        this.grid.putObjectAt(17, 2, new Integer(4));
        this.grid.putObjectAt(18, 0, new Integer(5));
        this.grid.putObjectAt(18, 0, new Integer(6));
        this.grid.putObjectAt(18, 2, new Integer(7));
        this.grid.putObjectAt(19, 0, new Integer(8));
        this.grid.putObjectAt(19, 1, new Integer(9));
        this.grid.putObjectAt(19, 2, new Integer(10));
        this.grid.putObjectAt(19, 2, new Integer(11));
        this.grid.putObjectAt(19, 2, new Integer(12));
        this.torus = new Multi2DTorus(20, 30, true);
        this.torus.putObjectAt(10, 10, new Integer(3));
        this.torus.putObjectAt(10, 40, new Integer(4));
        this.torus.putObjectAt(30, 10, new Integer(50));
        this.torus.putObjectAt(30, 40, new Integer(60));
        this.torus.putObjectAt(16, 1, new Integer(3));
        this.torus.putObjectAt(17, 0, new Integer(1));
        this.torus.putObjectAt(17, 2, new Integer(3));
        this.torus.putObjectAt(17, 2, new Integer(4));
        this.torus.putObjectAt(18, 30, new Integer(-1));
        this.torus.putObjectAt(18, 0, new Integer(5));
        this.torus.putObjectAt(18, 0, new Integer(6));
        this.torus.putObjectAt(18, 2, new Integer(7));
        this.torus.putObjectAt(19, 0, new Integer(8));
        this.torus.putObjectAt(19, 1, new Integer(9));
        this.torus.putObjectAt(19, 2, new Integer(10));
        this.torus.putObjectAt(19, 2, new Integer(11));
        this.torus.putObjectAt(19, 2, new Integer(12));
        this.torus.putObjectAt(20, 2, new Integer(13));
        this.torus.putObjectAt(20, 31, new Integer(14));
        this.torus.putObjectAt(1, 5, new Integer(12));
        this.torus.putObjectAt(13, 22, new Integer(-1));
        this.torus.putObjectAt(21, -55, new Integer(15));
        this.ogrid = new OrderedMulti2DGrid(20, 30, false);
        this.ogrid.putObjectAt(10, 10, new Integer(3));
        this.ogrid.putObjectAt(10, 10, new Integer(4));
        this.ogrid.putObjectAt(10, 10, new Integer(50));
        this.ogrid.putObjectAt(17, 13, new Integer(12));
        this.ogrid.putObjectAt(13, 22, new Integer(-1));
        this.otorus = new OrderedMulti2DTorus(20, 30, true);
        this.otorus.putObjectAt(1, 5, new Integer(3));
        this.otorus.putObjectAt(21, -55, new Integer(4));
        this.otorus.putObjectAt(-39, 35, new Integer(50));
        this.otorus.putObjectAt(17, 13, new Integer(12));
        this.otorus.putObjectAt(13, 22, new Integer(-1));
        this.hGridSetup();
    }

    private void hGridSetup() {
        this.hgrid = new Multi2DHexagonalGrid(7, 7, false);
        this.htorus = new Multi2DHexagonalTorus(7, 7, false);
        this.ohtorus = new OrderedMulti2DHexagonalTorus(7, 7, false);
        this.ohgrid = new OrderedMulti2DHexagonalGrid(7, 7, false);
        int n = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.hgrid.putObjectAt(j, i, new Integer(n));
                this.htorus.putObjectAt(j, i, new Integer(n));
                this.ohgrid.putObjectAt(j, i, new Integer(n));
                this.ohtorus.putObjectAt(j, i, new Integer(n));
                ++n;
            }
        }
        this.hgrid.clear(5, 4);
        this.htorus.clear(5, 4);
        this.ohtorus.clear(5, 4);
        this.ohgrid.clear(5, 4);
        this.hgrid.putObjectAt(4, 2, new Integer(50));
        this.hgrid.putObjectAt(4, 2, new Integer(51));
        this.hgrid.putObjectAt(4, 2, new Integer(52));
        this.htorus.putObjectAt(4, 2, new Integer(50));
        this.htorus.putObjectAt(4, 2, new Integer(51));
        this.htorus.putObjectAt(4, 2, new Integer(52));
        this.ohgrid.putObjectAt(4, 2, new Integer(50));
        this.ohgrid.putObjectAt(4, 2, new Integer(51));
        this.ohgrid.putObjectAt(4, 2, new Integer(52));
        this.ohtorus.putObjectAt(4, 2, new Integer(50));
        this.ohtorus.putObjectAt(4, 2, new Integer(51));
        this.ohtorus.putObjectAt(4, 2, new Integer(52));
    }

    public void testHMGGet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(50));
        hashSet.add(new Integer(51));
        hashSet.add(new Integer(52));
        hashSet.add(new Integer(18));
        List list = this.hgrid.getObjectsAt(4, 2);
        MultiGridTest.assertEquals((int)4, (int)list.size());
        Object e = list.get(0);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
        e = list.get(1);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
        e = list.get(2);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
        e = list.get(3);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
    }

    public void testHMOGGet() {
        List list = this.ohgrid.getObjectsAt(4, 2);
        MultiGridTest.assertEquals((int)4, (int)list.size());
        MultiGridTest.assertEquals((Object)new Integer(18), list.get(0));
        MultiGridTest.assertEquals((Object)new Integer(50), list.get(1));
        MultiGridTest.assertEquals((Object)new Integer(51), list.get(2));
        MultiGridTest.assertEquals((Object)new Integer(52), list.get(3));
    }

    public void testHMGOTGet() {
        List list = this.ohtorus.getObjectsAt(-3, 9);
        MultiGridTest.assertEquals((int)4, (int)list.size());
        MultiGridTest.assertEquals((Object)new Integer(18), list.get(0));
        MultiGridTest.assertEquals((Object)new Integer(50), list.get(1));
        MultiGridTest.assertEquals((Object)new Integer(51), list.get(2));
        MultiGridTest.assertEquals((Object)new Integer(52), list.get(3));
    }

    public void testHMTGet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(50));
        hashSet.add(new Integer(51));
        hashSet.add(new Integer(52));
        hashSet.add(new Integer(18));
        List list = this.htorus.getObjectsAt(4, 2);
        MultiGridTest.assertEquals((int)4, (int)list.size());
        Object e = list.get(0);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
        e = list.get(1);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
        e = list.get(2);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
        e = list.get(3);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
    }

    public void testHMTGetWrap() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(50));
        hashSet.add(new Integer(51));
        hashSet.add(new Integer(52));
        hashSet.add(new Integer(18));
        List list = this.htorus.getObjectsAt(-3, 9);
        MultiGridTest.assertEquals((int)4, (int)list.size());
        Object e = list.get(0);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
        e = list.get(1);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
        e = list.get(2);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
        e = list.get(3);
        MultiGridTest.assertTrue((boolean)hashSet.contains(e));
        hashSet.remove(e);
    }

    public void testHMGGetNeighbors() {
        ArrayList arrayList = this.hgrid.getNeighbors(3, 3, 2, true);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(18));
        hashSet.add(new Integer(50));
        hashSet.add(new Integer(51));
        hashSet.add(new Integer(52));
        MultiGridTest.assertEquals((int)21, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(10), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new Integer(11), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new Integer(19), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new Integer(26), arrayList.get(3));
        MultiGridTest.assertTrue((arrayList.get(4) == null ? 1 : 0) != 0);
        MultiGridTest.assertEquals((Object)new Integer(32), arrayList.get(5));
        MultiGridTest.assertEquals((Object)new Integer(38), arrayList.get(6));
        MultiGridTest.assertEquals((Object)new Integer(30), arrayList.get(7));
        MultiGridTest.assertEquals((Object)new Integer(29), arrayList.get(8));
        MultiGridTest.assertEquals((Object)new Integer(22), arrayList.get(9));
        MultiGridTest.assertEquals((Object)new Integer(15), arrayList.get(10));
        MultiGridTest.assertEquals((Object)new Integer(9), arrayList.get(11));
        MultiGridTest.assertEquals((Object)new Integer(17), arrayList.get(12));
        HashSet hashSet2 = new HashSet(arrayList.subList(13, 17));
        MultiGridTest.assertEquals(hashSet, hashSet2);
        MultiGridTest.assertEquals((Object)new Integer(25), arrayList.get(17));
        MultiGridTest.assertEquals((Object)new Integer(31), arrayList.get(18));
        MultiGridTest.assertEquals((Object)new Integer(23), arrayList.get(19));
        MultiGridTest.assertEquals((Object)new Integer(16), arrayList.get(20));
    }

    public void testHMTGetNeighbors() {
        ArrayList arrayList = this.htorus.getNeighbors(3, 3, 2, true);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(18));
        hashSet.add(new Integer(50));
        hashSet.add(new Integer(51));
        hashSet.add(new Integer(52));
        MultiGridTest.assertEquals((int)21, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(10), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new Integer(11), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new Integer(19), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new Integer(26), arrayList.get(3));
        MultiGridTest.assertTrue((arrayList.get(4) == null ? 1 : 0) != 0);
        MultiGridTest.assertEquals((Object)new Integer(32), arrayList.get(5));
        MultiGridTest.assertEquals((Object)new Integer(38), arrayList.get(6));
        MultiGridTest.assertEquals((Object)new Integer(30), arrayList.get(7));
        MultiGridTest.assertEquals((Object)new Integer(29), arrayList.get(8));
        MultiGridTest.assertEquals((Object)new Integer(22), arrayList.get(9));
        MultiGridTest.assertEquals((Object)new Integer(15), arrayList.get(10));
        MultiGridTest.assertEquals((Object)new Integer(9), arrayList.get(11));
        MultiGridTest.assertEquals((Object)new Integer(17), arrayList.get(12));
        HashSet hashSet2 = new HashSet(arrayList.subList(13, 17));
        MultiGridTest.assertEquals(hashSet, hashSet2);
        MultiGridTest.assertEquals((Object)new Integer(25), arrayList.get(17));
        MultiGridTest.assertEquals((Object)new Integer(31), arrayList.get(18));
        MultiGridTest.assertEquals((Object)new Integer(23), arrayList.get(19));
        MultiGridTest.assertEquals((Object)new Integer(16), arrayList.get(20));
    }

    public void testHMGGetNeighborsLoc() {
        ArrayList arrayList = this.hgrid.getNeighborsLoc(3, 3, 2, true);
        HashSet<ObjectLocation> hashSet = new HashSet<ObjectLocation>();
        hashSet.add(new ObjectLocation(new Integer(18), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(50), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(51), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(52), 4, 2));
        MultiGridTest.assertEquals((int)21, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(10), 3, 1), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(11), 4, 1), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(19), 5, 2), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(26), 5, 3), arrayList.get(3));
        MultiGridTest.assertEquals((Object)new ObjectLocation(null, 5, 4), arrayList.get(4));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(32), 4, 4), arrayList.get(5));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(38), 3, 5), arrayList.get(6));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(30), 2, 4), arrayList.get(7));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(29), 1, 4), arrayList.get(8));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(22), 1, 3), arrayList.get(9));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(15), 1, 2), arrayList.get(10));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(9), 2, 1), arrayList.get(11));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(17), 3, 2), arrayList.get(12));
        HashSet hashSet2 = new HashSet(arrayList.subList(13, 17));
        MultiGridTest.assertEquals(hashSet, hashSet2);
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(25), 4, 3), arrayList.get(17));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(31), 3, 4), arrayList.get(18));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(23), 2, 3), arrayList.get(19));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(16), 2, 2), arrayList.get(20));
    }

    public void testHMTGetNeighborsLoc() {
        ArrayList arrayList = this.htorus.getNeighborsLoc(3, 3, 2, true);
        HashSet<ObjectLocation> hashSet = new HashSet<ObjectLocation>();
        hashSet.add(new ObjectLocation(new Integer(18), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(50), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(51), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(52), 4, 2));
        MultiGridTest.assertEquals((int)21, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(10), 3, 1), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(11), 4, 1), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(19), 5, 2), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(26), 5, 3), arrayList.get(3));
        MultiGridTest.assertEquals((Object)new ObjectLocation(null, 5, 4), arrayList.get(4));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(32), 4, 4), arrayList.get(5));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(38), 3, 5), arrayList.get(6));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(30), 2, 4), arrayList.get(7));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(29), 1, 4), arrayList.get(8));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(22), 1, 3), arrayList.get(9));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(15), 1, 2), arrayList.get(10));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(9), 2, 1), arrayList.get(11));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(17), 3, 2), arrayList.get(12));
        HashSet hashSet2 = new HashSet(arrayList.subList(13, 17));
        MultiGridTest.assertEquals(hashSet, hashSet2);
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(25), 4, 3), arrayList.get(17));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(31), 3, 4), arrayList.get(18));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(23), 2, 3), arrayList.get(19));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(16), 2, 2), arrayList.get(20));
    }

    public void testHMGGetNeighborsLocNoNull() {
        ArrayList arrayList = this.hgrid.getNeighborsLoc(3, 3, 2, false);
        HashSet<ObjectLocation> hashSet = new HashSet<ObjectLocation>();
        hashSet.add(new ObjectLocation(new Integer(18), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(50), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(51), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(52), 4, 2));
        MultiGridTest.assertEquals((int)20, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(10), 3, 1), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(11), 4, 1), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(19), 5, 2), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(26), 5, 3), arrayList.get(3));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(32), 4, 4), arrayList.get(4));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(38), 3, 5), arrayList.get(5));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(30), 2, 4), arrayList.get(6));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(29), 1, 4), arrayList.get(7));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(22), 1, 3), arrayList.get(8));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(15), 1, 2), arrayList.get(9));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(9), 2, 1), arrayList.get(10));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(17), 3, 2), arrayList.get(11));
        HashSet hashSet2 = new HashSet(arrayList.subList(12, 16));
        MultiGridTest.assertEquals(hashSet, hashSet2);
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(25), 4, 3), arrayList.get(16));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(31), 3, 4), arrayList.get(17));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(23), 2, 3), arrayList.get(18));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(16), 2, 2), arrayList.get(19));
    }

    public void testHMTGetNeighborsLocNoNull() {
        ArrayList arrayList = this.htorus.getNeighborsLoc(3, 3, 2, false);
        HashSet<ObjectLocation> hashSet = new HashSet<ObjectLocation>();
        hashSet.add(new ObjectLocation(new Integer(18), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(50), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(51), 4, 2));
        hashSet.add(new ObjectLocation(new Integer(52), 4, 2));
        MultiGridTest.assertEquals((int)20, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(10), 3, 1), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(11), 4, 1), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(19), 5, 2), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(26), 5, 3), arrayList.get(3));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(32), 4, 4), arrayList.get(4));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(38), 3, 5), arrayList.get(5));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(30), 2, 4), arrayList.get(6));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(29), 1, 4), arrayList.get(7));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(22), 1, 3), arrayList.get(8));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(15), 1, 2), arrayList.get(9));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(9), 2, 1), arrayList.get(10));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(17), 3, 2), arrayList.get(11));
        HashSet hashSet2 = new HashSet(arrayList.subList(12, 16));
        MultiGridTest.assertEquals(hashSet, hashSet2);
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(25), 4, 3), arrayList.get(16));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(31), 3, 4), arrayList.get(17));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(23), 2, 3), arrayList.get(18));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(16), 2, 2), arrayList.get(19));
    }

    public void testHMGNeighSideEdgeLoc() {
        ArrayList arrayList = this.hgrid.getNeighborsLoc(6, 2, true);
        MultiGridTest.assertEquals((int)4, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(13), 6, 1), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(27), 6, 3), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(26), 5, 3), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(19), 5, 2), arrayList.get(3));
    }

    public void testHMTNeighSideEdgeLoc() {
        ArrayList arrayList = this.htorus.getNeighborsLoc(6, 2, true);
        MultiGridTest.assertEquals((int)6, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(13), 6, 1), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(14), 0, 2), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(21), 0, 3), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(27), 6, 3), arrayList.get(3));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(26), 5, 3), arrayList.get(4));
        MultiGridTest.assertEquals((Object)new ObjectLocation(new Integer(19), 5, 2), arrayList.get(5));
    }

    public void testHMGGetNeighborsNoNull() {
        ArrayList arrayList = this.hgrid.getNeighbors(3, 3, 2, false);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(18));
        hashSet.add(new Integer(50));
        hashSet.add(new Integer(51));
        hashSet.add(new Integer(52));
        MultiGridTest.assertEquals((int)20, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(10), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new Integer(11), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new Integer(19), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new Integer(26), arrayList.get(3));
        MultiGridTest.assertEquals((Object)new Integer(32), arrayList.get(4));
        MultiGridTest.assertEquals((Object)new Integer(38), arrayList.get(5));
        MultiGridTest.assertEquals((Object)new Integer(30), arrayList.get(6));
        MultiGridTest.assertEquals((Object)new Integer(29), arrayList.get(7));
        MultiGridTest.assertEquals((Object)new Integer(22), arrayList.get(8));
        MultiGridTest.assertEquals((Object)new Integer(15), arrayList.get(9));
        MultiGridTest.assertEquals((Object)new Integer(9), arrayList.get(10));
        MultiGridTest.assertEquals((Object)new Integer(17), arrayList.get(11));
        HashSet hashSet2 = new HashSet(arrayList.subList(12, 16));
        MultiGridTest.assertEquals(hashSet, hashSet2);
        MultiGridTest.assertEquals((Object)new Integer(25), arrayList.get(16));
        MultiGridTest.assertEquals((Object)new Integer(31), arrayList.get(17));
        MultiGridTest.assertEquals((Object)new Integer(23), arrayList.get(18));
        MultiGridTest.assertEquals((Object)new Integer(16), arrayList.get(19));
    }

    public void testHMTGetNeighborsNoNull() {
        ArrayList arrayList = this.htorus.getNeighbors(3, 3, 2, false);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(18));
        hashSet.add(new Integer(50));
        hashSet.add(new Integer(51));
        hashSet.add(new Integer(52));
        MultiGridTest.assertEquals((int)20, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(10), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new Integer(11), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new Integer(19), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new Integer(26), arrayList.get(3));
        MultiGridTest.assertEquals((Object)new Integer(32), arrayList.get(4));
        MultiGridTest.assertEquals((Object)new Integer(38), arrayList.get(5));
        MultiGridTest.assertEquals((Object)new Integer(30), arrayList.get(6));
        MultiGridTest.assertEquals((Object)new Integer(29), arrayList.get(7));
        MultiGridTest.assertEquals((Object)new Integer(22), arrayList.get(8));
        MultiGridTest.assertEquals((Object)new Integer(15), arrayList.get(9));
        MultiGridTest.assertEquals((Object)new Integer(9), arrayList.get(10));
        MultiGridTest.assertEquals((Object)new Integer(17), arrayList.get(11));
        HashSet hashSet2 = new HashSet(arrayList.subList(12, 16));
        MultiGridTest.assertEquals(hashSet, hashSet2);
        MultiGridTest.assertEquals((Object)new Integer(25), arrayList.get(16));
        MultiGridTest.assertEquals((Object)new Integer(31), arrayList.get(17));
        MultiGridTest.assertEquals((Object)new Integer(23), arrayList.get(18));
        MultiGridTest.assertEquals((Object)new Integer(16), arrayList.get(19));
    }

    public void testHMGNeighSideEdge() {
        ArrayList arrayList = this.hgrid.getNeighbors(6, 2, true);
        MultiGridTest.assertEquals((int)4, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(13), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new Integer(27), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new Integer(26), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new Integer(19), arrayList.get(3));
    }

    public void testHMTNeighSideEdge() {
        ArrayList arrayList = this.htorus.getNeighbors(6, 2, true);
        MultiGridTest.assertEquals((int)6, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(13), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new Integer(14), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new Integer(21), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new Integer(27), arrayList.get(3));
        MultiGridTest.assertEquals((Object)new Integer(26), arrayList.get(4));
        MultiGridTest.assertEquals((Object)new Integer(19), arrayList.get(5));
    }

    public void testHMGNeighTopEdge() {
        ArrayList arrayList = this.htorus.getNeighbors(5, 0, true);
        MultiGridTest.assertEquals((int)6, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(47), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new Integer(48), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new Integer(6), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new Integer(12), arrayList.get(3));
        MultiGridTest.assertEquals((Object)new Integer(4), arrayList.get(4));
        MultiGridTest.assertEquals((Object)new Integer(46), arrayList.get(5));
    }

    public void testHMTNeighTopEdge() {
        ArrayList arrayList = this.hgrid.getNeighbors(5, 0, true);
        MultiGridTest.assertEquals((int)3, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(6), arrayList.get(0));
        MultiGridTest.assertEquals((Object)new Integer(12), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new Integer(4), arrayList.get(2));
    }

    public void testOList() {
        List list = this.ogrid.getObjectsAt(10, 10);
        MultiGridTest.assertEquals((Object)new Integer(3), list.get(0));
        MultiGridTest.assertEquals((Object)new Integer(4), list.get(1));
        MultiGridTest.assertEquals((Object)new Integer(50), list.get(2));
    }

    public void testGetAtIndex() {
        MultiGridTest.assertEquals((Object)new Integer(4), (Object)this.ogrid.getObjectAt(10, 10, 1));
        MultiGridTest.assertEquals(null, (Object)this.ogrid.getObjectAt(10, 10, 5));
        MultiGridTest.assertEquals(null, (Object)this.ogrid.getObjectAt(11, 14));
    }

    public void testPutAtIndex() {
        this.ogrid.putObjectAt(10, 10, 1, new Integer(14));
        MultiGridTest.assertEquals((Object)new Integer(14), (Object)this.ogrid.getObjectAt(10, 10, 1));
        MultiGridTest.assertEquals((Object)new Integer(4), (Object)this.ogrid.getObjectAt(10, 10, 2));
    }

    public void testGetFirstLast() {
        OrderedCell orderedCell = (OrderedCell)this.ogrid.getObjectAt(17, 13);
        MultiGridTest.assertEquals((Object)new Integer(12), (Object)orderedCell.getFirst());
        MultiGridTest.assertEquals((Object)new Integer(12), (Object)orderedCell.getLast());
        orderedCell = (OrderedCell)this.ogrid.getObjectAt(10, 10);
        MultiGridTest.assertEquals((Object)new Integer(3), (Object)orderedCell.getFirst());
        MultiGridTest.assertEquals((Object)new Integer(50), (Object)orderedCell.getLast());
    }

    public void testGetIndexOf() {
        MultiGridTest.assertEquals((int)2, (int)this.ogrid.getIndexOf(10, 10, new Integer(50)));
        MultiGridTest.assertEquals((int)-1, (int)this.ogrid.getIndexOf(1, 3, new Integer(1)));
    }

    public void testRemoveAt() {
        Object object = this.ogrid.removeObjectAt(10, 10, 2);
        MultiGridTest.assertEquals((int)2, (int)this.ogrid.getCellSizeAt(10, 10));
        MultiGridTest.assertEquals((Object)new Integer(50), (Object)object);
    }

    public void testRemove() {
        this.grid.removeObjectAt(10, 10, new Integer(3));
        MultiGridTest.assertEquals((int)1, (int)this.grid.getCellSizeAt(10, 10));
    }

    public void testOListT() {
        List list = this.otorus.getObjectsAt(1, 5);
        MultiGridTest.assertEquals((Object)new Integer(3), list.get(0));
        MultiGridTest.assertEquals((Object)new Integer(4), list.get(1));
        MultiGridTest.assertEquals((Object)new Integer(50), list.get(2));
    }

    public void testGetAtIndexT() {
        MultiGridTest.assertEquals((Object)new Integer(4), (Object)this.otorus.getObjectAt(-39, 5, 1));
        MultiGridTest.assertEquals(null, (Object)this.otorus.getObjectAt(1, 5, 5));
        MultiGridTest.assertEquals(null, (Object)this.otorus.getObjectAt(11, 14));
    }

    public void testPutAtIndexT() {
        this.otorus.putObjectAt(21, 35, 1, new Integer(14));
        MultiGridTest.assertEquals((Object)new Integer(14), (Object)this.otorus.getObjectAt(1, 5, 1));
        MultiGridTest.assertEquals((Object)new Integer(4), (Object)this.otorus.getObjectAt(21, 35, 2));
    }

    public void testGetFirstLastT() {
        OrderedCell orderedCell = (OrderedCell)this.otorus.getObjectAt(1, 5);
        MultiGridTest.assertEquals((Object)new Integer(3), (Object)orderedCell.getFirst());
        MultiGridTest.assertEquals((Object)new Integer(50), (Object)orderedCell.getLast());
    }

    public void testGetIndexOfT() {
        MultiGridTest.assertEquals((int)2, (int)this.otorus.getIndexOf(41, -55, new Integer(50)));
        MultiGridTest.assertEquals((int)-1, (int)this.otorus.getIndexOf(1, 3, new Integer(1)));
    }

    public void testRemoveAtT() {
        Object object = this.otorus.removeObjectAt(1, 5, 2);
        MultiGridTest.assertEquals((int)2, (int)this.otorus.getCellSizeAt(21, 35));
        MultiGridTest.assertEquals((Object)new Integer(50), (Object)object);
    }

    public void testSize() {
        MultiGridTest.assertEquals((int)2, (int)this.grid.getCellSizeAt(10, 10));
        MultiGridTest.assertEquals((int)1, (int)this.grid.getCellSizeAt(17, 13));
        MultiGridTest.assertEquals((int)1, (int)this.grid.getCellSizeAt(13, 22));
    }

    public void testIterator() {
        Iterator iterator = this.grid.getIteratorAt(18, 0);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(5));
        hashSet.add(new Integer(6));
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            MultiGridTest.assertTrue((boolean)hashSet.contains(n));
            hashSet.remove(n);
        }
    }

    public void testGetObjAtT() {
        Cell cell = (Cell)this.torus.getObjectAt(10, 10);
        MultiGridTest.assertEquals((int)4, (int)cell.size());
        cell = (Cell)this.torus.getObjectAt(10, 40);
        MultiGridTest.assertEquals((int)4, (int)cell.size());
        cell = (Cell)this.torus.getObjectAt(30, 10);
        MultiGridTest.assertEquals((int)4, (int)cell.size());
        cell = (Cell)this.torus.getObjectAt(30, 40);
        MultiGridTest.assertEquals((int)4, (int)cell.size());
        MultiGridTest.assertEquals((int)4, (int)this.torus.getCellSizeAt(10, 40));
        cell = this.torus.getCellAt(30, 40);
        MultiGridTest.assertEquals((int)4, (int)cell.size());
        cell = (Cell)this.torus.getObjectAt(1, 5);
        MultiGridTest.assertEquals((int)2, (int)cell.size());
    }

    public void testGetListT() {
        List list = this.torus.getObjectsAt(21, 5);
        MultiGridTest.assertEquals((int)2, (int)list.size());
        list = this.torus.getObjectsAt(0, 0);
        MultiGridTest.assertEquals((int)0, (int)list.size());
    }

    public void testGetIterT() {
        Iterator iterator = this.torus.getIteratorAt(-39, -55);
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        MultiGridTest.assertEquals((int)2, (int)n);
        iterator = this.torus.getIteratorAt(0, 0);
        n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        MultiGridTest.assertEquals((int)0, (int)n);
    }

    public void testList() {
        List list = this.grid.getObjectsAt(10, 10);
        MultiGridTest.assertEquals((int)2, (int)list.size());
        list = this.grid.getObjectsAt(0, 0);
        MultiGridTest.assertEquals((int)0, (int)list.size());
    }

    public void testIter() {
        Iterator iterator = this.grid.getIteratorAt(10, 10);
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        MultiGridTest.assertEquals((int)2, (int)n);
        n = 0;
        iterator = this.grid.getIteratorAt(0, 0);
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        MultiGridTest.assertEquals((int)0, (int)n);
    }

    public void testGetVNLoc() {
        ArrayList arrayList = this.grid.getVNNeighborsLoc(18, 1, true);
        MultiGridTest.assertEquals((int)5, (int)arrayList.size());
        ObjectLocation objectLocation = (ObjectLocation)arrayList.get(0);
        MultiGridTest.assertEquals(null, (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)17, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)1, (int)objectLocation.y);
        objectLocation = (ObjectLocation)arrayList.get(1);
        MultiGridTest.assertEquals((Object)new Integer(9), (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)19, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)1, (int)objectLocation.y);
        objectLocation = (ObjectLocation)arrayList.get(2);
        MultiGridTest.assertEquals((Object)new Integer(6), (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)18, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)0, (int)objectLocation.y);
        objectLocation = (ObjectLocation)arrayList.get(3);
        MultiGridTest.assertEquals((Object)new Integer(5), (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)18, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)0, (int)objectLocation.y);
        objectLocation = (ObjectLocation)arrayList.get(4);
        MultiGridTest.assertEquals((Object)new Integer(7), (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)18, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)2, (int)objectLocation.y);
        arrayList = this.grid.getVNNeighborsLoc(18, 1, false);
        MultiGridTest.assertEquals((int)4, (int)arrayList.size());
        arrayList = this.grid.getVNNeighborsLoc(18, 1, 3, 2, false);
        MultiGridTest.assertEquals((int)5, (int)arrayList.size());
        arrayList = this.grid.getVNNeighborsLoc(18, 1, 3, 2, true);
        MultiGridTest.assertEquals((int)8, (int)arrayList.size());
        arrayList = this.grid.getVNNeighborsLoc(19, 1, true);
        MultiGridTest.assertEquals((int)5, (int)arrayList.size());
        arrayList = this.grid.getVNNeighborsLoc(17, 1, false);
        MultiGridTest.assertEquals((int)4, (int)arrayList.size());
    }

    public void testMooreLoc() {
        ArrayList arrayList = this.grid.getMooreNeighborsLoc(18, 1, true);
        MultiGridTest.assertEquals((int)12, (int)arrayList.size());
        ObjectLocation objectLocation = (ObjectLocation)arrayList.get(5);
        MultiGridTest.assertEquals((Object)new Integer(9), (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)19, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)1, (int)objectLocation.y);
        arrayList = this.grid.getMooreNeighborsLoc(18, 1, 3, 2, false);
        MultiGridTest.assertEquals((int)12, (int)arrayList.size());
        objectLocation = (ObjectLocation)arrayList.get(4);
        MultiGridTest.assertEquals((Object)new Integer(3), (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)16, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)1, (int)objectLocation.y);
        arrayList = this.grid.getMooreNeighborsLoc(18, 1, 3, 2, true);
        MultiGridTest.assertEquals((int)23, (int)arrayList.size());
        objectLocation = (ObjectLocation)arrayList.get(4);
        MultiGridTest.assertEquals((Object)new Integer(5), (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)18, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)0, (int)objectLocation.y);
    }

    public void testVNNeighbors() {
        ArrayList arrayList = this.grid.getVNNeighbors(18, 1, true);
        MultiGridTest.assertEquals((int)5, (int)arrayList.size());
        MultiGridTest.assertEquals(null, arrayList.get(0));
        MultiGridTest.assertEquals((Object)new Integer(9), arrayList.get(1));
        MultiGridTest.assertEquals((Object)new Integer(6), arrayList.get(2));
        MultiGridTest.assertEquals((Object)new Integer(5), arrayList.get(3));
        MultiGridTest.assertEquals((Object)new Integer(7), arrayList.get(4));
        arrayList = this.grid.getVNNeighbors(18, 1, false);
        MultiGridTest.assertEquals((int)4, (int)arrayList.size());
        arrayList = this.grid.getVNNeighbors(18, 1, 3, 2, false);
        MultiGridTest.assertEquals((int)5, (int)arrayList.size());
        arrayList = this.grid.getVNNeighbors(18, 1, 3, 2, true);
        MultiGridTest.assertEquals((int)8, (int)arrayList.size());
        arrayList = this.grid.getVNNeighbors(19, 1, true);
        MultiGridTest.assertEquals((int)5, (int)arrayList.size());
        arrayList = this.grid.getVNNeighbors(17, 1, false);
        MultiGridTest.assertEquals((int)4, (int)arrayList.size());
    }

    public void testMooreNeighbors() {
        ArrayList arrayList = this.grid.getMooreNeighbors(18, 1, true);
        MultiGridTest.assertEquals((int)12, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(9), arrayList.get(5));
        arrayList = this.grid.getMooreNeighbors(18, 1, 3, 2, false);
        MultiGridTest.assertEquals((int)12, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(3), arrayList.get(4));
        arrayList = this.grid.getMooreNeighbors(18, 1, 3, 2, true);
        MultiGridTest.assertEquals((int)23, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(5), arrayList.get(4));
    }

    public void testGetVNLocT() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(5));
        hashSet.add(new Integer(-1));
        hashSet.add(new Integer(6));
        ArrayList arrayList = this.torus.getVNNeighborsLoc(18, 1, true);
        MultiGridTest.assertEquals((int)6, (int)arrayList.size());
        ObjectLocation objectLocation = (ObjectLocation)arrayList.get(0);
        MultiGridTest.assertEquals(null, (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)17, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)1, (int)objectLocation.y);
        objectLocation = (ObjectLocation)arrayList.get(1);
        MultiGridTest.assertEquals((Object)new Integer(9), (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)19, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)1, (int)objectLocation.y);
        objectLocation = (ObjectLocation)arrayList.get(2);
        Integer n = (Integer)objectLocation.obj;
        MultiGridTest.assertTrue((boolean)hashSet.contains(n));
        hashSet.remove(n);
        MultiGridTest.assertEquals((int)18, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)0, (int)objectLocation.y);
        objectLocation = (ObjectLocation)arrayList.get(3);
        n = (Integer)objectLocation.obj;
        MultiGridTest.assertTrue((boolean)hashSet.contains(n));
        hashSet.remove(n);
        MultiGridTest.assertEquals((int)18, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)0, (int)objectLocation.y);
        objectLocation = (ObjectLocation)arrayList.get(4);
        n = (Integer)objectLocation.obj;
        MultiGridTest.assertTrue((boolean)hashSet.contains(n));
        hashSet.remove(n);
        MultiGridTest.assertEquals((int)18, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)0, (int)objectLocation.y);
        arrayList = this.torus.getVNNeighborsLoc(18, 1, false);
        MultiGridTest.assertEquals((int)5, (int)arrayList.size());
        arrayList = this.torus.getVNNeighborsLoc(18, 1, 3, 2, false);
        MultiGridTest.assertEquals((int)7, (int)arrayList.size());
        arrayList = this.torus.getVNNeighborsLoc(18, 1, 3, 2, true);
        MultiGridTest.assertEquals((int)12, (int)arrayList.size());
        arrayList = this.torus.getVNNeighborsLoc(19, 1, true);
        MultiGridTest.assertEquals((int)6, (int)arrayList.size());
        arrayList = this.torus.getVNNeighborsLoc(17, 1, false);
        MultiGridTest.assertEquals((int)4, (int)arrayList.size());
    }

    public void testMooreLocT() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(5));
        hashSet.add(new Integer(-1));
        hashSet.add(new Integer(6));
        ArrayList arrayList = this.torus.getMooreNeighborsLoc(18, 1, true);
        MultiGridTest.assertEquals((int)13, (int)arrayList.size());
        ObjectLocation objectLocation = (ObjectLocation)arrayList.get(3);
        Integer n = (Integer)objectLocation.obj;
        MultiGridTest.assertTrue((boolean)hashSet.contains(n));
        hashSet.remove(n);
        MultiGridTest.assertEquals((int)18, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)0, (int)objectLocation.y);
        arrayList = this.torus.getMooreNeighborsLoc(18, 1, 3, 2, false);
        MultiGridTest.assertEquals((int)15, (int)arrayList.size());
        objectLocation = (ObjectLocation)arrayList.get(7);
        MultiGridTest.assertEquals((Object)new Integer(14), (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)0, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)1, (int)objectLocation.y);
        arrayList = this.torus.getMooreNeighborsLoc(18, 1, 3, 2, true);
        MultiGridTest.assertEquals((int)39, (int)arrayList.size());
        objectLocation = (ObjectLocation)arrayList.get(7);
        MultiGridTest.assertEquals(null, (Object)objectLocation.obj);
        MultiGridTest.assertEquals((int)15, (int)objectLocation.x);
        MultiGridTest.assertEquals((int)0, (int)objectLocation.y);
    }

    public void testVNNeighborsT() {
        ArrayList arrayList = this.torus.getVNNeighbors(18, 1, true);
        MultiGridTest.assertEquals((int)6, (int)arrayList.size());
        MultiGridTest.assertEquals(null, arrayList.get(0));
        MultiGridTest.assertEquals((Object)new Integer(9), arrayList.get(1));
        MultiGridTest.assertTrue((boolean)arrayList.contains(new Integer(6)));
        MultiGridTest.assertTrue((boolean)arrayList.contains(new Integer(5)));
        MultiGridTest.assertTrue((boolean)arrayList.contains(new Integer(-1)));
        MultiGridTest.assertEquals((Object)new Integer(7), arrayList.get(5));
        arrayList = this.torus.getVNNeighbors(18, 1, false);
        MultiGridTest.assertEquals((int)5, (int)arrayList.size());
        arrayList = this.torus.getVNNeighbors(18, 1, 3, 2, false);
        MultiGridTest.assertEquals((int)7, (int)arrayList.size());
        arrayList = this.torus.getVNNeighbors(18, 1, 3, 2, true);
        MultiGridTest.assertEquals((int)12, (int)arrayList.size());
        arrayList = this.torus.getVNNeighbors(19, 1, true);
        MultiGridTest.assertEquals((int)6, (int)arrayList.size());
        arrayList = this.torus.getVNNeighbors(17, 1, false);
        MultiGridTest.assertEquals((int)4, (int)arrayList.size());
    }

    public void testMooreNeighborsT() {
        ArrayList arrayList = this.torus.getMooreNeighbors(18, 1, true);
        MultiGridTest.assertEquals((int)13, (int)arrayList.size());
        Object e = arrayList.get(3);
        MultiGridTest.assertTrue((e.equals(new Integer(5)) || e.equals(new Integer(-1)) || e.equals(new Integer(6)) ? 1 : 0) != 0);
        arrayList = this.torus.getMooreNeighbors(18, 1, 3, 2, false);
        MultiGridTest.assertEquals((int)15, (int)arrayList.size());
        MultiGridTest.assertEquals((Object)new Integer(14), arrayList.get(7));
        arrayList = this.torus.getMooreNeighbors(18, 1, 3, 2, true);
        MultiGridTest.assertEquals((int)39, (int)arrayList.size());
        MultiGridTest.assertEquals(null, arrayList.get(7));
    }

    public void testGetCellAtT() {
        Cell cell = this.torus.getCellAt(41, 5);
        MultiGridTest.assertEquals((int)2, (int)cell.size());
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$MultiGridTest == null ? (class$uchicago$src$sim$test$MultiGridTest = MultiGridTest.class$("uchicago.src.sim.test.MultiGridTest")) : class$uchicago$src$sim$test$MultiGridTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

