/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.engine.TickCounter;
import uchicago.src.sim.math.CEquation;
import uchicago.src.sim.math.CEquationFactory;
import uchicago.src.sim.test.EquationTarget;

public class CEquationTest
extends TestCase {
    private CEquation equation;
    private EquationTarget target;
    static /* synthetic */ Class class$uchicago$src$sim$test$CEquationTest;

    public CEquationTest(String string) {
        super(string);
    }

    public void setUp() {
        this.target = new EquationTarget();
    }

    public void testSin() {
        this.equation = new CEquation(this.target, new Counter(), "sin(x * 10)", "y");
        this.equation.evaluate();
        this.equation.assign();
        CEquationTest.assertEquals((double)Math.sin(30.0), (double)this.target.getY(), (double)0.0);
    }

    public void testEq() {
        this.equation = new CEquation(this.target, new Counter(), "x + z * 5", "y");
        this.equation.evaluate();
        this.equation.assign();
        CEquationTest.assertEquals((double)8.0, (double)this.target.getY(), (double)0.0);
    }

    public void testEqSwitch() {
        Counter counter = new Counter();
        this.equation = new CEquation(this.target, counter, "x + z * 5", "y");
        this.equation.evaluate();
        this.equation.assign();
        counter.increment();
        CEquationTest.assertEquals((double)8.0, (double)this.target.getY(), (double)0.0);
        this.equation.evaluate();
        this.equation.assign();
        counter.increment();
        counter.increment();
        this.equation.setEquation("x / 2 * z * dt");
        this.equation.evaluateAndAssign();
        CEquationTest.assertEquals((double)3.0, (double)this.target.getY(), (double)0.0);
    }

    public void testT() {
        this.equation = new CEquation(this.target, new Counter(), "t * x + z * 5", "y");
        this.equation.evaluate();
        this.equation.assign();
        CEquationTest.assertEquals((double)11.0, (double)this.target.getY(), (double)0.0);
    }

    public void testDTInitialValue() {
        Counter counter = new Counter();
        this.equation = new CEquation(this.target, counter, "dt * x + z * 5.1", "y", 3.0);
        this.equation.evaluate();
        this.equation.assign();
        CEquationTest.assertEquals((double)14.1, (double)this.target.getY(), (double)0.0);
        counter.increment();
        counter.increment();
        this.equation.evaluate();
        this.equation.assign();
        CEquationTest.assertEquals((double)11.1, (double)this.target.getY(), (double)0.0);
    }

    public void testDT() {
        Counter counter = new Counter();
        this.equation = new CEquation(this.target, counter, "dt * x + z * 5.1", "y");
        this.equation.evaluate();
        this.equation.assign();
        CEquationTest.assertEquals((double)5.1, (double)this.target.getY(), (double)0.0);
        counter.increment();
        counter.increment();
        this.equation.evaluate();
        this.equation.assign();
        CEquationTest.assertEquals((double)11.1, (double)this.target.getY(), (double)0.0);
    }

    public void testSimpleFactory() {
        EquationTarget equationTarget = new EquationTarget();
        Schedule schedule = new Schedule();
        CEquationFactory cEquationFactory = new CEquationFactory(schedule);
        cEquationFactory.createEquation(equationTarget, "t * x + z * 5", "y", 1.0);
        schedule.execute();
        CEquationTest.assertEquals((double)8.0, (double)equationTarget.getY(), (double)0.0);
        schedule.execute();
        CEquationTest.assertEquals((double)11.0, (double)equationTarget.getY(), (double)0.0);
    }

    public void testComplexFactory() {
        Schedule schedule = new Schedule();
        CEquationFactory cEquationFactory = new CEquationFactory(schedule);
        EquationTarget equationTarget = new EquationTarget();
        EquationTarget equationTarget2 = new EquationTarget();
        cEquationFactory.createEquation(equationTarget, "t * x + z * 5", "y", 1.0);
        cEquationFactory.createEquation(equationTarget2, "t * 5 + x", "y", 1.5);
        schedule.execute();
        CEquationTest.assertEquals((double)8.0, (double)equationTarget.getY(), (double)0.0);
        CEquationTest.assertEquals((double)4.0, (double)equationTarget2.getY(), (double)0.0);
        schedule.execute();
        CEquationTest.assertEquals((double)8.0, (double)equationTarget.getY(), (double)0.0);
        CEquationTest.assertEquals((double)10.5, (double)equationTarget2.getY(), (double)0.0);
        schedule.execute();
        CEquationTest.assertEquals((double)11.0, (double)equationTarget.getY(), (double)0.0);
        CEquationTest.assertEquals((double)10.5, (double)equationTarget2.getY(), (double)0.0);
        schedule.execute();
        CEquationTest.assertEquals((double)14.0, (double)equationTarget.getY(), (double)0.0);
        CEquationTest.assertEquals((double)18.0, (double)equationTarget2.getY(), (double)0.0);
    }

    public void testSameIntervalFactory() {
        Schedule schedule = new Schedule();
        CEquationFactory cEquationFactory = new CEquationFactory(schedule);
        EquationTarget equationTarget = new EquationTarget();
        EquationTarget equationTarget2 = new EquationTarget();
        EquationTarget equationTarget3 = new EquationTarget();
        EquationTarget equationTarget4 = new EquationTarget();
        cEquationFactory.createEquation(equationTarget, "t * x + z * 5", "y", 1.0);
        cEquationFactory.createEquation(equationTarget2, "t * 5 + x", "y", 1.5);
        cEquationFactory.createEquation(equationTarget3, "x * (z + t)", "y", 1.0);
        cEquationFactory.createEquation(equationTarget4, "x * (z + t)", "y", 1.0);
        schedule.execute();
        CEquationTest.assertEquals((double)8.0, (double)equationTarget.getY(), (double)0.0);
        CEquationTest.assertEquals((double)6.0, (double)equationTarget3.getY(), (double)0.0);
        CEquationTest.assertEquals((double)6.0, (double)equationTarget4.getY(), (double)0.0);
        CEquationTest.assertEquals((double)4.0, (double)equationTarget2.getY(), (double)0.0);
        schedule.execute();
        CEquationTest.assertEquals((double)8.0, (double)equationTarget.getY(), (double)0.0);
        CEquationTest.assertEquals((double)6.0, (double)equationTarget3.getY(), (double)0.0);
        CEquationTest.assertEquals((double)6.0, (double)equationTarget4.getY(), (double)0.0);
        CEquationTest.assertEquals((double)10.5, (double)equationTarget2.getY(), (double)0.0);
        schedule.execute();
        CEquationTest.assertEquals((double)11.0, (double)equationTarget.getY(), (double)0.0);
        CEquationTest.assertEquals((double)9.0, (double)equationTarget3.getY(), (double)0.0);
        CEquationTest.assertEquals((double)9.0, (double)equationTarget4.getY(), (double)0.0);
        CEquationTest.assertEquals((double)10.5, (double)equationTarget2.getY(), (double)0.0);
        schedule.execute();
        CEquationTest.assertEquals((double)14.0, (double)equationTarget.getY(), (double)0.0);
        CEquationTest.assertEquals((double)12.0, (double)equationTarget3.getY(), (double)0.0);
        CEquationTest.assertEquals((double)12.0, (double)equationTarget4.getY(), (double)0.0);
        CEquationTest.assertEquals((double)18.0, (double)equationTarget2.getY(), (double)0.0);
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$CEquationTest == null ? (class$uchicago$src$sim$test$CEquationTest = CEquationTest.class$("uchicago.src.sim.test.CEquationTest")) : class$uchicago$src$sim$test$CEquationTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Counter
    implements TickCounter {
        double curTime = 2.0;

        Counter() {
        }

        public double getCurrentTime() {
            return this.curTime;
        }

        public void increment() {
            this.curTime += 1.0;
        }
    }
}

