/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.collection.DoubleMatrix;
import uchicago.src.sim.space.Discrete2DSpace;

public class RasterSpace
implements Serializable,
Discrete2DSpace {
    double sparseness;
    double originx;
    double originy;
    double termx;
    double termy;
    double cellSize;
    double nodata;
    double min = Double.NEGATIVE_INFINITY;
    double max = Double.POSITIVE_INFINITY;
    double missing = Double.NaN;
    int height;
    int width;
    DoubleMatrix matrix;

    public RasterSpace(double d, double d2, double d3, int n, int n2) {
        this.cellSize = d3;
        this.originx = Math.floor(d2) * d3;
        this.originy = d - (double)n;
        this.originy = Math.floor(this.originy / d3) * d3;
        this.termy = d;
        this.height = n;
        this.width = n2;
        this.matrix = new DoubleMatrix(n, n2);
    }

    public RasterSpace(double d, double d2, double d3, double d4, double d5, int n, int n2) {
        this.cellSize = d5;
        this.originx = d;
        this.originy = d2;
        this.termx = d3;
        this.termy = d4;
        this.height = n2;
        this.width = n;
        this.matrix = new DoubleMatrix(n2, n);
    }

    public RasterSpace(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.init(fileInputStream);
    }

    public RasterSpace(InputStream inputStream) throws IOException {
        this.init(inputStream);
    }

    private void init(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.parseNumbers();
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.lowerCaseMode(true);
        int n = streamTokenizer.nextToken();
        n = streamTokenizer.nextToken();
        this.width = (int)streamTokenizer.nval;
        n = streamTokenizer.nextToken();
        n = streamTokenizer.nextToken();
        this.height = (int)streamTokenizer.nval;
        n = streamTokenizer.nextToken();
        n = streamTokenizer.nextToken();
        this.originx = streamTokenizer.nval;
        n = streamTokenizer.nextToken();
        n = streamTokenizer.nextToken();
        this.originy = streamTokenizer.nval;
        n = streamTokenizer.nextToken();
        n = streamTokenizer.nextToken();
        this.cellSize = streamTokenizer.nval;
        this.termx = Math.floor(this.originx) + this.cellSize * (double)this.width;
        this.termy = Math.floor(this.originy) + this.cellSize * (double)this.height;
        n = streamTokenizer.nextToken();
        if (n == -2) {
            streamTokenizer.pushBack();
            this.nodata = this.missing;
        } else {
            n = streamTokenizer.nextToken();
            this.nodata = streamTokenizer.nval;
        }
        streamTokenizer.ordinaryChars(69, 69);
        this.matrix = new DoubleMatrix(this.width, this.height);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                streamTokenizer.nextToken();
                double d = streamTokenizer.nval;
                n = streamTokenizer.nextToken();
                if (n != -2 && n != -1) {
                    streamTokenizer.nextToken();
                    d *= Math.pow(10.0, streamTokenizer.nval);
                } else {
                    streamTokenizer.pushBack();
                }
                this.min = Math.min(this.min, d);
                this.max = Math.max(this.max, d);
                this.matrix.putDoubleAt(j, i, d);
            }
        }
    }

    public final boolean onSurface(double d, double d2) {
        return d >= this.originx && d < this.originx + (double)this.width * this.cellSize && d2 >= this.originy && d2 < this.originy + (double)this.height * this.cellSize;
    }

    public final int getCellRow(double d) {
        int n = (int)Math.floor(((double)this.height * this.cellSize - d + this.originy) / this.cellSize);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public final int getCellCol(double d) {
        int n = (int)Math.floor((d - this.originx) / this.cellSize);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public BaseMatrix getMatrix() {
        return this.matrix;
    }

    public double getOriginX() {
        return this.originx;
    }

    public double getOriginY() {
        return this.originy;
    }

    public double getTermX() {
        return this.termx;
    }

    public double getTermY() {
        return this.termy;
    }

    public Object getObjectAt(int n, int n2) {
        return this.matrix.get(n, n2);
    }

    public Object getObjectAt(double d, double d2) {
        return this.matrix.get(this.getCellCol(d), this.getCellRow(d2));
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public int getSizeX() {
        return this.width;
    }

    public int getSizeY() {
        return this.height;
    }

    public double getValueAt(int n, int n2) {
        Object object = this.matrix.get(n, n2);
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.doubleValue();
        }
        throw new IllegalArgumentException("Object cannot be converted to a long");
    }

    public double getValueAt(double d, double d2) {
        Object object = this.matrix.get(this.getCellCol(d), this.getCellRow(d2));
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.doubleValue();
        }
        throw new IllegalArgumentException("Object cannot be converted to a long");
    }

    public void putObjectAt(int n, int n2, Object object) {
        this.matrix.put(n, n2, object);
    }

    public void putObjectAt(double d, double d2, Object object) {
        this.matrix.put(this.getCellCol(d), this.getCellCol(d2), object);
    }

    public void putValueAt(int n, int n2, double d) {
        this.matrix.putDoubleAt(n, n2, d);
    }

    public void putValueAt(double d, double d2, double d3) {
        this.matrix.putDoubleAt(this.getCellCol(d), this.getCellRow(d2), d3);
    }

    public double getCellSize() {
        return this.cellSize;
    }
}

