/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter.rpl;

import java.lang.reflect.InvocationTargetException;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.rpl.AbstractDynamicParameter;
import uchicago.src.sim.parameter.rpl.RPLList;
import uchicago.src.sim.util.RepastException;

public class ListRPLParameter
extends AbstractDynamicParameter {
    private RPLList list;
    private int index = 0;

    public ListRPLParameter(String string, RPLList rPLList) {
        super(string);
        this.list = rPLList;
        this.name = string;
        this.type = rPLList.getType();
    }

    protected void invokeSet(SimModel simModel) throws RepastException {
        Object object = this.list.get(this.index);
        if (this.convertor != null) {
            object = this.convertor.convert((Double)object);
        }
        try {
            this.setMethod.invoke((Object)simModel, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RepastException(illegalAccessException, "Unable to set model parameter '" + this.name + "'.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RepastException(illegalArgumentException, "Unable to set model parameter '" + this.name + "'.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RepastException(invocationTargetException, "Unable to set model parameter '" + this.name + "'.");
        }
    }

    protected boolean incrementSelf() {
        ++this.index;
        return this.index < this.list.size();
    }

    public void reset() {
        super.reset();
        this.index = 0;
    }

    protected Object getValue() {
        if (this.convertor != null) {
            return this.convertor.convert((Double)this.list.get(this.index));
        }
        return this.list.get(this.index);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        stringBuffer.append("(");
        stringBuffer.append(this.list.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

