/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import uchicago.src.sim.engine.gui.model.ConstantParameter;
import uchicago.src.sim.engine.gui.model.DataParameter;
import uchicago.src.sim.engine.gui.model.IncrementParameter;
import uchicago.src.sim.engine.gui.model.ListParameter;

public class XMLParameterFileWriter {
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private PrintStream out;

    public void write(String string, DefaultMutableTreeNode defaultMutableTreeNode, ArrayList arrayList) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            this.out = new PrintStream((OutputStream)fileOutputStream, false, DEFAULT_CHARACTER_ENCODING);
            this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.out.println("<Repast:Params xmlns:Repast=\"http://www.src.uchicago.edu\" name=\"myparams\">");
            this.writeParameterBlock(defaultMutableTreeNode, this.out, 4);
            this.writeOutputParameters(arrayList, this.out);
            this.out.println("</Repast:Params>");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeOutputParameters(ArrayList arrayList, PrintStream printStream) {
        DataParameter dataParameter = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            dataParameter = (DataParameter)arrayList.get(i);
            this.out.println(dataParameter.toXMLString());
        }
    }

    private void writeParameterBlock(DefaultMutableTreeNode defaultMutableTreeNode, PrintStream printStream, int n) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        IncrementParameter incrementParameter = null;
        ListParameter listParameter = null;
        ConstantParameter constantParameter = null;
        Object object = null;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        boolean bl2 = false;
        String string = this.createIndentString(n);
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            object = defaultMutableTreeNode2.getUserObject();
            if (object == null || !(object instanceof IncrementParameter) && !(object instanceof ListParameter) && !(object instanceof ConstantParameter)) continue;
            if (object instanceof IncrementParameter) {
                incrementParameter = (IncrementParameter)object;
                listParameter = null;
                constantParameter = null;
                n3 = incrementParameter.getRuns();
            }
            if (object instanceof ListParameter) {
                incrementParameter = null;
                listParameter = (ListParameter)object;
                constantParameter = null;
                n3 = listParameter.getRuns();
            }
            if (object instanceof ConstantParameter) {
                incrementParameter = null;
                listParameter = null;
                constantParameter = (ConstantParameter)object;
                n3 = constantParameter.getRuns();
            }
            if (n3 != n2) {
                if (bl) {
                    bl = false;
                } else {
                    this.out.print(string);
                    this.out.println("</Repast:ParamBlock>");
                }
                this.out.print(string);
                this.out.println("<Repast:ParamBlock runs=\"" + Integer.toString(n3) + "\">");
                if (!bl2) {
                    bl2 = true;
                }
                n2 = n3;
            }
            if (incrementParameter != null) {
                this.out.print(string);
                this.out.println(incrementParameter.toXMLString());
            } else if (listParameter != null) {
                this.out.print(string);
                this.out.println(listParameter.toXMLString());
            } else if (constantParameter != null) {
                this.out.print(string);
                this.out.println(constantParameter.toXMLString());
            }
            this.writeParameterBlock(defaultMutableTreeNode2, this.out, n + 4);
            this.out.print(string);
        }
        if (bl2) {
            this.out.print(string);
            this.out.println("</Repast:ParamBlock>");
        }
    }

    private String createIndentString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }
}

