/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;
import uchicago.src.sim.parameter.NumericParameter;
import uchicago.src.sim.parameter.Parameter;
import uchicago.src.sim.parameter.ParameterLexer;
import uchicago.src.sim.parameter.XMLParameterReader;

public class ParameterReader {
    private Vector params = new Vector();
    private boolean start = true;
    private long numRuns = -1L;
    private Hashtable errorMsgs = new Hashtable(8);
    private XMLParameterReader xmlReader;

    public ParameterReader() {
        this.fillErrorHash();
    }

    public ParameterReader(String string) throws IOException {
        this();
        if (this.isXMLFormat(string)) {
            this.xmlReader = new XMLParameterReader(string);
            this.xmlReader.parse();
        } else {
            this.read(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isXMLFormat(String string) throws IOException {
        BufferedReader bufferedReader = null;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null && (string2 = string2.trim()).length() == 0) {
            }
            if (string2 == null) {
                throw new IOException("File is empty");
            }
            if (string2.indexOf("<?xml") != -1 || string2.indexOf("<?XML") != -1) {
                bl = true;
            }
            Object var6_6 = null;
            if (bufferedReader == null) return bl;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        bufferedReader.close();
        return bl;
    }

    public Vector read(String string) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = "";
            bufferedReader.mark(1000);
            while ((string2 = bufferedReader.readLine()) != null && ((string2 = string2.trim()).length() == 0 || string2.startsWith("#"))) {
                if (string2.startsWith("#")) {
                    bufferedReader.mark(1000);
                }
                bufferedReader.mark(1000);
            }
            bufferedReader.reset();
            this.parse(bufferedReader);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
        return this.params;
    }

    private void parse(Reader reader) throws IOException {
        int n;
        ParameterLexer parameterLexer = new ParameterLexer(reader);
        NumericParameter numericParameter = new NumericParameter();
        Vector<Integer> vector = new Vector<Integer>(5);
        vector.add(new Integer(5));
        int n2 = 0;
        block17: while ((n = parameterLexer.nextToken()) != 15) {
            if (!vector.contains(new Integer(n))) {
                String string = "Illegally formatted parameter file at line: " + parameterLexer.getLineNum() + "\n";
                for (int i = 0; i < vector.size(); ++i) {
                    string = string + (String)this.errorMsgs.get(vector.elementAt(i)) + "\n";
                }
                throw new IOException(string);
            }
            switch (n) {
                case 7: {
                    if (n2 == 0) {
                        numericParameter = new NumericParameter();
                        numericParameter.setName(parameterLexer.getString());
                    } else if (n2 % 2 == 0) {
                        NumericParameter numericParameter2 = new NumericParameter();
                        numericParameter.addChild(numericParameter2);
                        numericParameter2.setParent(numericParameter);
                        long l = numericParameter.getSubRuns();
                        numericParameter = numericParameter2;
                        numericParameter.setName(parameterLexer.getString());
                        numericParameter.setNumRuns(l);
                    } else {
                        String string = "Illegally formatted parameter file at line: " + parameterLexer.getLineNum() + "\n";
                        string = string + "Missing '}'\n";
                        throw new IOException(string);
                    }
                    vector.clear();
                    vector.add(new Integer(0));
                    vector.add(new Integer(16));
                    continue block17;
                }
                case 0: {
                    ++n2;
                    vector.clear();
                    vector.add(new Integer(2));
                    vector.add(new Integer(5));
                    vector.add(new Integer(8));
                    vector.add(new Integer(9));
                    vector.add(new Integer(13));
                    vector.add(new Integer(11));
                    vector.add(new Integer(12));
                    vector.add(new Integer(10));
                    continue block17;
                }
                case 1: {
                    --n2;
                    if (!numericParameter.isComplete()) {
                        String string = "Illegally formatted parameter file at line: " + parameterLexer.getLineNum() + "\n";
                        string = string + "Parameter definition is incomplete";
                        throw new IOException(string);
                    }
                    if (numericParameter.getParent() != null) {
                        numericParameter = (NumericParameter)numericParameter.getParent();
                    } else if (!this.params.contains(numericParameter)) {
                        this.params.add(numericParameter);
                    }
                    vector.clear();
                    vector.add(new Integer(5));
                    vector.add(new Integer(7));
                    vector.add(new Integer(1));
                    continue block17;
                }
                case 2: {
                    numericParameter.setStart(this.getNumber(parameterLexer));
                    vector.clear();
                    vector.add(new Integer(4));
                    continue block17;
                }
                case 4: {
                    numericParameter.setEnd(this.getNumber(parameterLexer));
                    vector.clear();
                    vector.add(new Integer(3));
                    continue block17;
                }
                case 3: {
                    numericParameter.setIncr(this.getNumber(parameterLexer));
                    vector.clear();
                    vector.add(new Integer(0));
                    vector.add(new Integer(1));
                    continue block17;
                }
                case 8: {
                    double d = this.getNumber(parameterLexer);
                    numericParameter.setConstVal(new Double(d));
                    vector.clear();
                    vector.add(new Integer(1));
                    continue block17;
                }
                case 9: {
                    Vector<Double> vector2 = new Vector<Double>();
                    while (parameterLexer.nextToken() == 6) {
                        vector2.add(new Double(parameterLexer.getNumber()));
                    }
                    numericParameter.setList(vector2);
                    parameterLexer.pushBack();
                    vector.clear();
                    vector.add(new Integer(0));
                    vector.add(new Integer(1));
                    continue block17;
                }
                case 10: {
                    Object object;
                    int n3 = parameterLexer.nextToken();
                    if (n3 != 14) {
                        object = "Expected boolean value on line " + parameterLexer.getLineNum();
                        throw new IOException((String)object);
                    }
                    numericParameter.setConstVal(parameterLexer.getString());
                    vector.clear();
                    vector.add(new Integer(1));
                    continue block17;
                }
                case 11: {
                    Object object = new Vector<Boolean>();
                    while (parameterLexer.nextToken() == 14) {
                        ((Vector)object).add(new Boolean(parameterLexer.getString()));
                    }
                    numericParameter.setList((Vector)object);
                    parameterLexer.pushBack();
                    vector.clear();
                    vector.add(new Integer(0));
                    vector.add(new Integer(1));
                    continue block17;
                }
                case 12: {
                    String string = parameterLexer.nextToken() == 7 ? parameterLexer.getString() : String.valueOf(parameterLexer.getNumber());
                    numericParameter.setConstVal(string);
                    vector.clear();
                    vector.add(new Integer(1));
                    continue block17;
                }
                case 13: {
                    Vector<String> vector3 = new Vector<String>();
                    while (parameterLexer.nextToken() == 7) {
                        vector3.add(parameterLexer.getString());
                    }
                    numericParameter.setList(vector3);
                    parameterLexer.pushBack();
                    vector.clear();
                    vector.add(new Integer(0));
                    vector.add(new Integer(1));
                    continue block17;
                }
                case 5: {
                    long l = (long)this.getNumber(parameterLexer);
                    if (this.start) {
                        this.numRuns = l;
                        this.start = false;
                    } else {
                        numericParameter.setSubRuns(l);
                    }
                    vector.clear();
                    vector.add(new Integer(7));
                    continue block17;
                }
                case 16: {
                    if (parameterLexer.nextToken() == 18) {
                        numericParameter.setInput(true);
                    } else {
                        numericParameter.setInput(false);
                    }
                    vector.clear();
                    vector.add(new Integer(17));
                    continue block17;
                }
                case 17: {
                    vector.clear();
                    vector.add(new Integer(0));
                    vector.add(new Integer(7));
                    continue block17;
                }
            }
            System.out.println(parameterLexer.getString());
            System.out.println(parameterLexer.getNumber());
            throw new IOException("Invalid token: " + n);
        }
        for (int i = 0; i < this.params.size(); ++i) {
            Parameter parameter = (Parameter)this.params.elementAt(i);
            parameter.setNumRuns(this.numRuns);
        }
    }

    public Vector getParameters() {
        if (this.xmlReader == null) {
            return this.params;
        }
        return this.xmlReader.getParameters();
    }

    private double getNumber(ParameterLexer parameterLexer) throws IOException {
        int n = parameterLexer.nextToken();
        if (n != 6) {
            String string = "Illegally formatted parameter file at line: " + parameterLexer.getLineNum() + "\n";
            string = string + "Expected a number";
            throw new IOException(string);
        }
        return parameterLexer.getNumber();
    }

    private void fillErrorHash() {
        this.errorMsgs.put(new Integer(4), "Expected 'end:'");
        this.errorMsgs.put(new Integer(3), "Expected 'incr:'");
        this.errorMsgs.put(new Integer(0), "Expected '{'");
        this.errorMsgs.put(new Integer(6), "Expected number");
        this.errorMsgs.put(new Integer(1), "Expected '}'");
        this.errorMsgs.put(new Integer(5), "Expected 'runs:'");
        this.errorMsgs.put(new Integer(2), "Expected 'start:'");
        this.errorMsgs.put(new Integer(7), "Expected attribute");
    }
}

