/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import uchicago.src.reflector.Invoker;
import uchicago.src.reflector.InvokerException;
import uchicago.src.reflector.InvokerFactory;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.AbstractParameterSetter;
import uchicago.src.sim.parameter.NumericParameter;
import uchicago.src.sim.parameter.Parameter;
import uchicago.src.sim.parameter.ParameterReader;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.SimUtilities;

public class DefaultParameterSetter
extends AbstractParameterSetter {
    private boolean first = true;
    private String[] modelParamNames;
    private HashMap setMethodsTable = new HashMap();
    private HashMap getMethodsTable = new HashMap();
    private ArrayList dynamicParamNames = new ArrayList();
    private HashMap parameterMap = new HashMap();
    private boolean finished = false;
    private HashSet stringables = new HashSet();
    private boolean doSetup = true;
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;

    public DefaultParameterSetter() {
        this.stringables.add(class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultParameterSetter.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.stringables.add(Integer.TYPE);
        this.stringables.add(class$java$lang$Long == null ? (class$java$lang$Long = DefaultParameterSetter.class$("java.lang.Long")) : class$java$lang$Long);
        this.stringables.add(Long.TYPE);
        this.stringables.add(class$java$lang$String == null ? (class$java$lang$String = DefaultParameterSetter.class$("java.lang.String")) : class$java$lang$String);
        this.stringables.add(class$java$lang$Float == null ? (class$java$lang$Float = DefaultParameterSetter.class$("java.lang.Float")) : class$java$lang$Float);
        this.stringables.add(Float.TYPE);
        this.stringables.add(class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultParameterSetter.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.stringables.add(Byte.TYPE);
        this.stringables.add(class$java$lang$Double == null ? (class$java$lang$Double = DefaultParameterSetter.class$("java.lang.Double")) : class$java$lang$Double);
        this.stringables.add(Double.TYPE);
        this.stringables.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultParameterSetter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.stringables.add(Boolean.TYPE);
        this.stringables.add(class$java$lang$Character == null ? (class$java$lang$Character = DefaultParameterSetter.class$("java.lang.Character")) : class$java$lang$Character);
        this.stringables.add(Character.TYPE);
    }

    public DefaultParameterSetter(Object object, String[] stringArray) throws IllegalAccessException, InvocationTargetException {
        this();
        ArrayList<NumericParameter> arrayList = new ArrayList<NumericParameter>();
        this.modelParamNames = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.modelParamNames, 0, stringArray.length);
        this.fillMethodTable(object);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Method method = (Method)this.getMethodsTable.get(this.capitalize(string));
            if (method == null || !this.stringables.contains(method.getReturnType())) continue;
            NumericParameter numericParameter = new NumericParameter();
            numericParameter.setName(this.capitalize(string));
            numericParameter.setConstVal(method.invoke(object, EMPTY_OBJ_ARRAY));
            arrayList.add(numericParameter);
        }
        this.doSetup = false;
        this.fillListSet(arrayList);
    }

    public void init(String string) throws IOException {
        ParameterReader parameterReader = new ParameterReader(string);
        Vector vector = parameterReader.getParameters();
        this.fillListSet(vector);
    }

    private void setupParamArray(SimModel simModel) {
        String[] stringArray = simModel.getInitParam();
        this.modelParamNames = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, this.modelParamNames, 0, stringArray.length);
        this.modelParamNames[stringArray.length] = "rngSeed";
    }

    private void fillListSet(List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Parameter parameter = (Parameter)list.get(i);
            this.parameterMap.put(new AbstractParameterSetter.ParamName(parameter.getName()), parameter);
            if (!parameter.isConstant()) {
                this.dynamicParamNames.add(this.capitalize(parameter.getName()));
            }
            if (!parameter.hasChildren()) continue;
            this.fillListSet(parameter.getChildren());
        }
    }

    private void fillMethodTable(Object object) {
        this.getMethodsTable.clear();
        this.setMethodsTable.clear();
        Method[] methodArray = object.getClass().getMethods();
        int n = methodArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int n2;
            String string;
            Method method = methodArray[i];
            String string2 = method.getName();
            if (string2.startsWith("set") && method.getParameterTypes().length == 1) {
                string = string2.substring(3);
                for (n2 = 0; n2 < this.modelParamNames.length; ++n2) {
                    if (!string.equalsIgnoreCase(this.modelParamNames[n2])) continue;
                    this.setMethodsTable.put(string.toLowerCase(), method);
                    continue block0;
                }
                continue;
            }
            if (string2.startsWith("get") && method.getParameterTypes().length == 0) {
                string = string2.substring(3);
                for (n2 = 0; n2 < this.modelParamNames.length; ++n2) {
                    if (!string.equalsIgnoreCase(this.modelParamNames[n2])) continue;
                    string = this.capitalize(string);
                    this.getMethodsTable.put(string, method);
                    continue block0;
                }
                continue;
            }
            if (!string2.startsWith("is") || method.getParameterTypes().length != 0 || !method.getReturnType().equals(Boolean.TYPE)) continue;
            string = string2.substring(2);
            for (n2 = 0; n2 < this.modelParamNames.length; ++n2) {
                if (!string.equalsIgnoreCase(this.modelParamNames[n2])) continue;
                string = this.capitalize(string);
                this.getMethodsTable.put(string, method);
                continue block0;
            }
        }
    }

    private void setParameters(SimModel simModel) {
        Iterator iterator = this.parameterMap.values().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            Method method = (Method)this.setMethodsTable.get(parameter.getName().toLowerCase());
            Invoker invoker = InvokerFactory.createInvoker(method.getParameterTypes()[0], simModel, method, parameter.getStringValue());
            try {
                invoker.execute();
            }
            catch (InvokerException invokerException) {
                SimUtilities.showError("Unable to set model parameter " + parameter.getName(), invokerException);
                invokerException.printStackTrace();
                System.exit(0);
            }
            catch (InvocationTargetException invocationTargetException) {
                SimUtilities.showError("Unable to set model parameter " + parameter.getName(), invocationTargetException);
                invocationTargetException.printStackTrace();
                System.exit(0);
            }
            catch (IllegalAccessException illegalAccessException) {
                SimUtilities.showError("Unable to set model parameter " + parameter.getName(), illegalAccessException);
                illegalAccessException.printStackTrace();
                System.exit(0);
            }
            catch (NullPointerException nullPointerException) {
                SimUtilities.showError("Unable to set model parameter " + parameter.getName(), nullPointerException);
                nullPointerException.printStackTrace();
                System.exit(0);
            }
        }
    }

    private void incrementParameters() {
        Iterator iterator = this.parameterMap.values().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter.getParent() != null || parameter.increment()) continue;
            if (parameter.isConstant()) {
                if (this.dynamicParamNames.size() != 0) continue;
                this.finished = true;
                return;
            }
            this.finished = true;
            return;
        }
    }

    public boolean isParameter(String string) {
        if (string.equalsIgnoreCase("RngSeed")) {
            return true;
        }
        return this.parameterMap.containsKey(new AbstractParameterSetter.ParamName(string));
    }

    public boolean isConstant(String string) {
        Parameter parameter = (Parameter)this.parameterMap.get(new AbstractParameterSetter.ParamName(string));
        return parameter == null ? false : parameter.isConstant();
    }

    public ArrayList getDynamicParameterNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.dynamicParamNames);
        if (!this.parameterMap.containsKey(new AbstractParameterSetter.ParamName("RngSeed")) && !arrayList.contains("RngSeed")) {
            arrayList.add("RngSeed");
        }
        return arrayList;
    }

    public Hashtable getDefaultModelParameters(SimModel simModel) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(23);
        if (simModel != null) {
            if (this.first) {
                this.setup(simModel);
            }
            hashtable.put("RngSeed", new Long(Random.getSeed()));
            if (simModel != null) {
                Object object;
                Object object2;
                Object[] objectArray = new Object[]{};
                Iterator<Object> iterator = this.getMethodsTable.keySet().iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    object = (Method)this.getMethodsTable.get(object2);
                    Object object3 = null;
                    try {
                        object3 = ((Method)object).invoke((Object)simModel, objectArray);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        SimUtilities.showError("Error getting model parameter '" + (String)object2 + "'", illegalAccessException);
                        if (simModel.getController().getExitOnExit()) {
                            System.exit(0);
                        }
                        return null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        SimUtilities.showError("Error getting model parameter '" + (String)object2 + "'", illegalArgumentException);
                        if (simModel.getController().getExitOnExit()) {
                            System.exit(0);
                        }
                        return null;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        SimUtilities.showError("Error getting model parameter '" + (String)object2 + "'", invocationTargetException);
                        if (simModel.getController().getExitOnExit()) {
                            System.exit(0);
                        }
                        return null;
                    }
                    hashtable.put(object2, object3);
                }
                iterator = this.parameterMap.values().iterator();
                while (iterator.hasNext()) {
                    object2 = (Parameter)iterator.next();
                    object = new StringBuffer(((Parameter)object2).getName());
                    char c = Character.toUpperCase(((StringBuffer)object).charAt(0));
                    ((StringBuffer)object).setCharAt(0, c);
                    String string = ((StringBuffer)object).toString();
                    if (!hashtable.containsKey(string)) continue;
                    hashtable.put(string, ((Parameter)object2).getStringValue());
                }
            }
        }
        return hashtable;
    }

    public void setModelParameters(SimModel simModel) {
        simModel.generateNewSeed();
        Random.createUniform();
        if (this.first) {
            this.setup(simModel);
            this.first = false;
        }
        this.setParameters(simModel);
    }

    private void setup(SimModel simModel) {
        if (this.doSetup) {
            this.setupParamArray(simModel);
            this.fillMethodTable(simModel);
        }
    }

    public boolean hasNext() {
        return !this.finished;
    }

    public void setNextModelParameters(SimModel simModel) {
        if (this.first) {
            this.setup(simModel);
            this.setModelParameters(simModel);
            this.first = false;
            return;
        }
        this.incrementParameters();
        if (!this.finished) {
            this.setModelParameters(simModel);
        }
    }

    public Object getParameterValue(String string, SimModel simModel) {
        Parameter parameter = (Parameter)this.parameterMap.get(new AbstractParameterSetter.ParamName(string));
        if (parameter != null) {
            return parameter.getStringValue();
        }
        return null;
    }

    public Object getParameter(String string) {
        Parameter parameter = (Parameter)this.parameterMap.get(new AbstractParameterSetter.ParamName(string));
        return parameter;
    }

    public Iterator parameterNames() {
        return new AbstractParameterSetter.ParamNameIterator(this.parameterMap.keySet().iterator());
    }

    public Class getParameterType(String string) {
        Method method = (Method)this.getMethodsTable.get(this.capitalize(string));
        if (method == null) {
            return null;
        }
        return method.getReturnType();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

