/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.math;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nfunk.jep.JEP;
import org.nfunk.jep.SymbolTable;
import uchicago.src.sim.engine.TickCounter;
import uchicago.src.sim.util.RepastException;
import uchicago.src.sim.util.SimUtilities;

public class CEquation {
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private static Set validReturnTypes = new HashSet();
    private static Set validAssignArgTypes = new HashSet();
    private String equation = "";
    private Object target;
    private Double result = new Double(0.0);
    private ResultVariable resultVar;
    private TickCounter counter;
    private JEP eqParser = new JEP();
    private List vars = new ArrayList();
    private Double initialDTVal;
    private double lastTimeEvaluated = -1.0;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;

    public CEquation(Object object, TickCounter tickCounter, String string, String string2) {
        this(object, tickCounter, string, string2, 0.0);
    }

    public CEquation(Object object, TickCounter tickCounter, String string, String string2, double d) {
        this.equation = string;
        this.counter = tickCounter;
        this.target = object;
        this.resultVar = new ResultVariable(string2);
        this.initialDTVal = new Double(d);
        this.eqParser.addStandardConstants();
        this.eqParser.addStandardFunctions();
        this.eqParser.setAllowUndeclared(true);
        this.reset();
    }

    private void reset() {
        this.vars.clear();
        this.result = new Double(0.0);
        this.eqParser.parseExpression(this.equation);
        this.checkForErrors();
        try {
            this.initTarget();
            this.initResultVariable();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private void initResultVariable() throws IntrospectionException {
        Class<?> clazz = this.target.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            String string;
            Object object;
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (!propertyDescriptor.getName().equalsIgnoreCase(this.resultVar.var)) continue;
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                object = "Equation Error - target is missing set method for resultVar '" + this.resultVar.var + "'";
                SimUtilities.showError(object, new IllegalArgumentException((String)object));
                continue;
            }
            object = method.getParameterTypes();
            if (((Class<?>[])object).length > 1) {
                string = "Equation Error - target has invalid set method for resultVar '" + this.resultVar.var + "'";
                SimUtilities.showError(string, new IllegalArgumentException(string));
            }
            if (!validAssignArgTypes.contains(object[0])) {
                string = "Equation Error - target set method for resultVar '" + this.resultVar.var + "' must take a numeric parameter";
                SimUtilities.showError(string, new IllegalArgumentException(string));
            }
            this.resultVar.write = method;
            return;
        }
        String string = "Equation Error - unable to find set method for resultVar: '" + this.resultVar.var + "'";
        SimUtilities.showError(string, new IllegalArgumentException(string));
    }

    private void initTarget() throws IntrospectionException {
        SymbolTable symbolTable = this.eqParser.getSymbolTable();
        Class<?> clazz = this.target.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        Enumeration enumeration = symbolTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("e") || string.equals("pi")) continue;
            if (string.equals("t")) {
                this.vars.add(new TimeVariable(this.counter));
                continue;
            }
            if (string.equals("dt")) {
                DTVariable dTVariable = new DTVariable(this.counter, this.initialDTVal);
                if (this.lastTimeEvaluated != -1.0) {
                    dTVariable.lastTime = this.lastTimeEvaluated;
                }
                this.vars.add(dTVariable);
                continue;
            }
            boolean bl = false;
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Object object;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (!propertyDescriptor.getName().equalsIgnoreCase(string)) continue;
                Method method = propertyDescriptor.getReadMethod();
                if (!validReturnTypes.contains(method.getReturnType())) {
                    object = "Equation Error - target get method for variable '" + string + "' does not return a number";
                    SimUtilities.showError((String)object, new IllegalArgumentException((String)object));
                }
                object = new EqVariable(method, string);
                bl = true;
                this.vars.add(object);
                break;
            }
            if (bl) continue;
            String string2 = "Equation Error - target get method for variable '" + string + "' not found.";
            SimUtilities.showError(string2, new IllegalArgumentException(string2));
        }
    }

    private void checkForErrors() {
        if (this.eqParser.hasError()) {
            SimUtilities.showError("CEquation Error, error evaluating equation '" + this.equation + "'", new RepastException(this.eqParser.getErrorInfo()));
        }
    }

    public void evaluate() {
        Iterator iterator = this.vars.iterator();
        while (iterator.hasNext()) {
            String string;
            Variable variable = (Variable)iterator.next();
            try {
                variable.setEquationValue(this.eqParser, this.target);
            }
            catch (IllegalAccessException illegalAccessException) {
                string = "Equation Error - unable to evaluate equation";
                SimUtilities.showError(string, new IllegalArgumentException(string));
            }
            catch (InvocationTargetException invocationTargetException) {
                string = "Equation Error - unable to evaluate equation";
                SimUtilities.showError(string, new IllegalArgumentException(string));
            }
        }
        this.result = new Double(this.eqParser.getValue());
        this.checkForErrors();
        this.lastTimeEvaluated = this.counter.getCurrentTime();
    }

    public void assign() {
        try {
            this.resultVar.setValue(this.target, this.result);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Equation Error - unable to assign result to resultVar '" + this.resultVar.var + "'";
            SimUtilities.showError(string, new IllegalArgumentException(string));
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Equation Error - unable to assign result to resultVar '" + this.resultVar.var + "'";
            SimUtilities.showError(string, new IllegalArgumentException(string));
        }
    }

    public void evaluateAndAssign() {
        this.evaluate();
        this.assign();
    }

    public String getEquation() {
        return this.equation;
    }

    public void setEquation(String string) {
        this.equation = string;
        this.eqParser = new JEP();
        this.eqParser.addStandardConstants();
        this.eqParser.addStandardFunctions();
        this.eqParser.setAllowUndeclared(true);
        this.reset();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        validReturnTypes.add(Double.TYPE);
        validReturnTypes.add(Integer.TYPE);
        validReturnTypes.add(Float.TYPE);
        validReturnTypes.add(Long.TYPE);
        validReturnTypes.add(class$java$lang$Double == null ? (class$java$lang$Double = CEquation.class$("java.lang.Double")) : class$java$lang$Double);
        validReturnTypes.add(class$java$lang$Float == null ? (class$java$lang$Float = CEquation.class$("java.lang.Float")) : class$java$lang$Float);
        validReturnTypes.add(class$java$lang$Integer == null ? (class$java$lang$Integer = CEquation.class$("java.lang.Integer")) : class$java$lang$Integer);
        validReturnTypes.add(class$java$lang$Long == null ? (class$java$lang$Long = CEquation.class$("java.lang.Long")) : class$java$lang$Long);
        validAssignArgTypes.add(Double.TYPE);
        validAssignArgTypes.add(class$java$lang$Double == null ? (class$java$lang$Double = CEquation.class$("java.lang.Double")) : class$java$lang$Double);
    }

    static class EqVariable
    implements Variable {
        private String var;
        private Method read;

        public EqVariable(Method method, String string) {
            this.read = method;
            this.var = string;
        }

        public void setEquationValue(JEP jEP, Object object) throws IllegalAccessException, InvocationTargetException {
            Object object2 = this.read.invoke(object, EMPTY_OBJ_ARRAY);
            jEP.addVariableAsObject(this.var, object2);
        }
    }

    static class DTVariable
    extends TimeVariable {
        double lastTime = 0.0;
        Double initialVal;

        public DTVariable(TickCounter tickCounter, Double d) {
            super(tickCounter);
            this.initialVal = d;
        }

        public void setEquationValue(JEP jEP, Object object) throws IllegalAccessException, InvocationTargetException {
            double d = this.counter.getCurrentTime();
            if (this.lastTime == 0.0) {
                if (this.initialVal == null) {
                    jEP.addVariable("dt", 0.0);
                } else {
                    jEP.addVariable("dt", this.initialVal.doubleValue());
                }
            } else {
                jEP.addVariable("dt", d - this.lastTime);
            }
            this.lastTime = d;
        }
    }

    static class TimeVariable
    implements Variable {
        protected TickCounter counter;

        public TimeVariable(TickCounter tickCounter) {
            this.counter = tickCounter;
        }

        public void setEquationValue(JEP jEP, Object object) throws IllegalAccessException, InvocationTargetException {
            jEP.addVariable("t", this.counter.getCurrentTime());
        }
    }

    static class ResultVariable {
        private String var;
        private Method write;

        public ResultVariable(String string) {
            this.var = string;
        }

        public void setValue(Object object, Double d) throws IllegalAccessException, InvocationTargetException {
            this.write.invoke(object, d);
        }
    }

    static interface Variable {
        public void setEquationValue(JEP var1, Object var2) throws IllegalAccessException, InvocationTargetException;
    }
}

