/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.ArrayList;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.collection.DoubleMatrix;
import uchicago.src.sim.gui.ColorMap;
import uchicago.src.sim.gui.HexaDisplay2D;
import uchicago.src.sim.gui.ProbeableNumber;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.space.Discrete2DSpace;

public class Value2DHexaDisplay
extends HexaDisplay2D {
    private ColorMap colorMap;
    private int mapping = 1;
    private int mappingColor = 0;
    private boolean zeroTrans = false;

    public Value2DHexaDisplay(Discrete2DSpace discrete2DSpace, ColorMap colorMap) {
        super(discrete2DSpace);
        this.colorMap = colorMap;
    }

    public void setDisplayMapping(int n, int n2) {
        this.mapping = n;
        this.mappingColor = n2;
    }

    public void setZeroTransparent(boolean bl) {
        this.zeroTrans = bl;
    }

    public boolean isZeroTransparent() {
        return this.zeroTrans;
    }

    public void drawDisplay(SimGraphics simGraphics) {
        if (!this.view) {
            return;
        }
        BaseMatrix baseMatrix = this.grid.getMatrix();
        if (baseMatrix instanceof DoubleMatrix) {
            DoubleMatrix doubleMatrix = (DoubleMatrix)baseMatrix;
            for (int i = 0; i < this.grid.getSizeX(); ++i) {
                for (int j = 0; j < this.grid.getSizeY(); ++j) {
                    double d = doubleMatrix.getDoubleAt(i, j);
                    int n = (int)(d / (double)this.mapping + (double)this.mappingColor);
                    this.drawAt(simGraphics, i, j, n);
                }
            }
        } else {
            for (int i = 0; i < this.grid.getSizeX(); ++i) {
                for (int j = 0; j < this.grid.getSizeY(); ++j) {
                    Number number = (Number)baseMatrix.get(i, j);
                    int n = (int)(number.doubleValue() / (double)this.mapping + (double)this.mappingColor);
                    this.drawAt(simGraphics, i, j, n);
                }
            }
        }
    }

    private void drawAt(SimGraphics simGraphics, int n, int n2, int n3) {
        super.setHexagons();
        n2 = n % 2 != 0 ? n2 * yTrans : n2 * yTrans + yTransHalf;
        n = n * xTrans - n * xTrans1q;
        Polygon polygon = new Polygon(Value2DHexaDisplay.polyClip.xpoints, Value2DHexaDisplay.polyClip.ypoints, Value2DHexaDisplay.polyClip.npoints);
        polygon.translate(n, n2);
        Graphics2D graphics2D = simGraphics.getGraphics();
        if (!this.zeroTrans || n3 != 0) {
            graphics2D.setColor(this.colorMap.getColor(n3));
            graphics2D.fillPolygon(polygon);
        }
        if (this.isFramed) {
            graphics2D.setColor(this.frameColor);
            graphics2D.draw(polygon);
        }
    }

    public ArrayList getObjectsAt(int n, int n2) {
        Dimension dimension = this.getCoordinates(n, n2);
        ArrayList<ProbeableNumber> arrayList = new ArrayList<ProbeableNumber>();
        Object object = this.grid.getObjectAt(n, n2);
        if (object != null) {
            arrayList.add(new ProbeableNumber(dimension.width, dimension.height, this.grid, object));
        }
        return arrayList;
    }
}

