/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import uchicago.src.sim.gui.FrameFactory;
import uchicago.src.sim.util.SimUtilities;

public class RepastConsole
extends WindowAdapter
implements WindowListener,
Runnable {
    private JFrame frame;
    private JTextArea textArea;
    private Thread reader;
    private Thread reader2;
    private boolean quit;
    private boolean stdoutOn = true;
    private boolean stderrOn = true;
    private final PipedInputStream stdout = new PipedInputStream();
    private final PipedInputStream stderr = new PipedInputStream();
    protected static final PrintStream oldStdout = System.out;
    protected static final PrintStream oldStderr = System.err;
    protected static PrintStream newStdout;
    protected static PrintStream newStderr;

    public RepastConsole(boolean bl, boolean bl2) {
        this.frame = FrameFactory.createFrame("RePast Output");
        Rectangle rectangle = FrameFactory.getBounds("RePast Output");
        if (rectangle == null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = new Dimension(dimension.width - 40, 180);
            int n = 20;
            int n2 = dimension.height - 220;
            this.frame.setBounds(n, n2, dimension2.width, dimension2.height);
        }
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)new JScrollPane(this.textArea), "Center");
        this.frame.addWindowListener(this);
        try {
            newStdout = new PrintStream(new PipedOutputStream(this.stdout));
        }
        catch (IOException iOException) {
            SimUtilities.showError("Couldn't attach stdout to console", iOException);
        }
        catch (SecurityException securityException) {
            SimUtilities.showError("Couldn't attach stdout to console", securityException);
        }
        try {
            newStderr = new PrintStream(new PipedOutputStream(this.stderr));
        }
        catch (IOException iOException) {
            SimUtilities.showError("Couldn't attach stderr to console", iOException);
        }
        catch (SecurityException securityException) {
            SimUtilities.showError("Coudldn't attach stderr to console", securityException);
        }
        this.setStdoutOn(bl);
        this.setStderrOn(bl2);
        this.quit = false;
    }

    public void display() {
        this.frame.setVisible(true);
        if (this.stdoutOn) {
            this.reader = new Thread(this);
            this.reader.setDaemon(true);
            this.reader.start();
        }
        if (this.stderrOn) {
            this.reader2 = new Thread(this);
            this.reader2.setDaemon(true);
            this.reader2.start();
        }
    }

    public boolean isStdoutOn() {
        return this.stdoutOn;
    }

    public void setStdoutOn(boolean bl) {
        this.stdoutOn = bl;
        if (bl) {
            System.setOut(newStdout);
        } else {
            System.setOut(oldStdout);
        }
    }

    public boolean isStderrOn() {
        return this.stderrOn;
    }

    public void setStderrOn(boolean bl) {
        this.stderrOn = bl;
        if (bl) {
            System.setErr(newStderr);
        } else {
            System.setErr(oldStderr);
        }
    }

    public synchronized void dispose() {
        this.quit = true;
        this.frame.dispose();
    }

    public synchronized void windowClosed(WindowEvent windowEvent) {
        this.quit = true;
        this.notifyAll();
        if (this.stdoutOn) {
            try {
                this.reader.join(1000L);
                this.stdout.close();
            }
            catch (Exception exception) {
                SimUtilities.showError("Error closing console", exception);
            }
        }
        if (this.stderrOn) {
            try {
                this.reader2.join(1000L);
                this.stderr.close();
            }
            catch (Exception exception) {
                SimUtilities.showError("Error closing console", exception);
            }
        }
        System.setErr(oldStderr);
        System.setOut(oldStdout);
    }

    public synchronized void windowClosing(WindowEvent windowEvent) {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public synchronized void run() {
        block11: {
            try {
                String string;
                if (this.stdoutOn) {
                    while (Thread.currentThread() == this.reader) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.stdout.available() != 0) {
                            string = this.readLine(this.stdout);
                            this.textArea.append(string);
                        }
                        if (!this.quit) continue;
                        return;
                    }
                }
                if (!this.stderrOn) break block11;
                while (Thread.currentThread() == this.reader2) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.stderr.available() != 0) {
                        string = this.readLine(this.stderr);
                        this.textArea.append(string);
                    }
                    if (!this.quit) continue;
                    return;
                }
            }
            catch (Exception exception) {
                SimUtilities.showError("Error displaying message", exception);
            }
        }
    }

    public synchronized String readLine(PipedInputStream pipedInputStream) throws IOException {
        int n;
        String string = "";
        while ((n = pipedInputStream.available()) != 0) {
            byte[] byArray = new byte[n];
            pipedInputStream.read(byArray);
            if (!(string = string + new String(byArray, 0, byArray.length)).endsWith("\n") && !string.endsWith("\r\n") && !this.quit) continue;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        new RepastConsole(true, true);
        System.out.println("This is my message");
        throw new NullPointerException("This is a test of err");
    }
}

