/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import uchicago.src.sim.engine.CustomProbeable;
import uchicago.src.sim.space.Discrete2DSpace;
import uchicago.src.sim.util.ByteWrapper;
import uchicago.src.sim.util.DoubleWrapper;
import uchicago.src.sim.util.FloatWrapper;
import uchicago.src.sim.util.IntWrapper;
import uchicago.src.sim.util.LongWrapper;

public class ProbeableNumber
implements CustomProbeable {
    private int x;
    private int y;
    private Discrete2DSpace grid;
    private DoubleWrapper wrapper;

    public ProbeableNumber(int n, int n2, Discrete2DSpace discrete2DSpace, Object object) {
        this.x = n;
        this.y = n2;
        this.grid = discrete2DSpace;
        if (object instanceof Double) {
            this.wrapper = new DoubleWrapper((Double)object);
        } else if (object instanceof Integer) {
            this.wrapper = new IntWrapper((Integer)object);
        } else if (object instanceof Float) {
            this.wrapper = new FloatWrapper(((Float)object).floatValue());
        } else if (object instanceof Long) {
            this.wrapper = new LongWrapper((Long)object);
        } else if (object instanceof Byte) {
            this.wrapper = new ByteWrapper((Byte)object);
        } else {
            throw new IllegalArgumentException("Object must be a Number");
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double getVal() {
        return ((Number)this.grid.getObjectAt(this.x, this.y)).doubleValue();
    }

    public void setVal(double d) {
        this.wrapper.setVal(d);
        this.grid.putObjectAt(this.x, this.y, this.wrapper.getWrappedNumber());
    }

    public String[] getProbedProperties() {
        String[] stringArray = new String[]{"val", "x", "y"};
        return stringArray;
    }
}

