/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimEventListener;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.gui.DisplayInfo;
import uchicago.src.sim.gui.Displayable;
import uchicago.src.sim.gui.Drawable;
import uchicago.src.sim.gui.FrameFactory;
import uchicago.src.sim.gui.Legend;
import uchicago.src.sim.gui.LocalPainter;
import uchicago.src.sim.gui.MediaProducer;
import uchicago.src.sim.gui.Moveable;
import uchicago.src.sim.gui.MovieMaker;
import uchicago.src.sim.gui.NonGridDrawable;
import uchicago.src.sim.gui.Painter;
import uchicago.src.sim.gui.Probeable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.gui.ViewEvent;
import uchicago.src.sim.gui.Zoomable;
import uchicago.src.sim.util.ProbeUtilities;
import uchicago.src.sim.util.SimUtilities;

public class DisplaySurface
extends JComponent
implements SimEventListener,
MediaProducer,
ComponentListener {
    protected Painter painter;
    protected ArrayList probeables = new ArrayList();
    protected JFrame frame;
    protected boolean needsUpdate = true;
    protected String snapshotFile = null;
    protected SimModel model;
    protected Hashtable displays = new Hashtable();
    protected JMenu menu = new JMenu("Options");
    protected JMenuBar bar;
    protected String name = "";
    protected MovieMaker movieMaker;
    protected Legend legend;
    protected ArrayList keyListeners = new ArrayList();
    protected ArrayList zoomables = new ArrayList();
    protected Point location = null;
    protected Dimension size;
    protected Dimension defaultSize;
    protected boolean mousePressed = false;
    protected Rect zoomRect = new Rect();
    protected WindowAdapter dsWindowAdapter = new WindowAdapter(){

        public void windowIconified(WindowEvent windowEvent) {
            DisplaySurface.this.needsUpdate = false;
            ViewEvent viewEvent = new ViewEvent(this, 3, false);
            for (int i = 0; i < DisplaySurface.this.painter.displayables.size(); ++i) {
                Displayable displayable = (Displayable)DisplaySurface.this.painter.displayables.get(i);
                displayable.viewEventPerformed(viewEvent);
            }
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            DisplaySurface.this.needsUpdate = true;
            ViewEvent viewEvent = new ViewEvent(this, 3, true);
            for (int i = 0; i < DisplaySurface.this.painter.displayables.size(); ++i) {
                Displayable displayable = (Displayable)DisplaySurface.this.painter.displayables.get(i);
                displayable.viewEventPerformed(viewEvent);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            DisplaySurface.this.needsUpdate = false;
            DisplaySurface.this.frame.removeWindowListener(this);
            DisplaySurface.this.dispose();
            DisplaySurface.this.frame = null;
        }
    };
    protected MouseInputAdapter dsMouseAdapter = new MouseInputAdapter(){
        private boolean firstDrag = true;
        private Moveable moveable = null;
        private int origX;
        private int origY;
        private Probeable probeable = null;
        private int count = 0;
        private int origXOffset;
        private int origYOffset;

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (DisplaySurface.this.zoomRect.x != -1) {
                DisplaySurface.this.eraseRect();
            }
            DisplaySurface.this.zoomRect.x = -1;
            for (int i = 0; i < DisplaySurface.this.probeables.size(); ++i) {
                Probeable probeable = (Probeable)DisplaySurface.this.probeables.get(i);
                ArrayList arrayList = probeable.getObjectsAt(n, n2);
                for (int j = 0; j < arrayList.size(); ++j) {
                    Object e = arrayList.get(j);
                    if (e == null) continue;
                    ProbeUtilities.probe(e);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isControlDown()) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                DisplaySurface.this.zoomRect.x = this.origX > n ? n : this.origX;
                DisplaySurface.this.zoomRect.y = this.origY > n2 ? n2 : this.origY;
                DisplaySurface.this.zoomRect.width = this.origX > n ? this.origX - n : n - this.origX;
                DisplaySurface.this.zoomRect.height = this.origY > n2 ? this.origY - n2 : n2 - this.origY;
                DisplaySurface.this.drawRect(DisplaySurface.this.zoomRect.x, DisplaySurface.this.zoomRect.y, DisplaySurface.this.zoomRect.width, DisplaySurface.this.zoomRect.height);
            } else {
                int n = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                ++this.count;
                if (this.firstDrag) {
                    this.moveable = this.getMoveableAt(n, n3);
                    this.firstDrag = false;
                }
                if (this.moveable != null && this.count > 3) {
                    if (n >= DisplaySurface.this.getWidth()) {
                        n = DisplaySurface.this.getWidth() - 4;
                    }
                    if (n <= 0) {
                        n = 4;
                    }
                    if (n3 >= DisplaySurface.this.getHeight()) {
                        n3 = DisplaySurface.this.getHeight() - 4;
                    }
                    if (n3 <= 0) {
                        n3 = 4;
                    }
                    this.probeable.setMoveableXY(this.moveable, n + this.origXOffset, n3 + this.origYOffset);
                    this.count = 0;
                    DisplaySurface.this.updateDisplayDirect();
                }
            }
        }

        private Moveable getMoveableAt(int n, int n2) {
            Moveable moveable = null;
            for (int i = DisplaySurface.this.probeables.size() - 1; i >= 0; --i) {
                this.probeable = (Probeable)DisplaySurface.this.probeables.get(i);
                ArrayList arrayList = this.probeable.getObjectsAt(n, n2);
                for (int j = arrayList.size() - 1; j >= 0; --j) {
                    if (!(arrayList.get(j) instanceof Moveable)) continue;
                    moveable = (Moveable)arrayList.get(j);
                    break;
                }
                if (moveable != null) break;
            }
            return moveable;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.origX = mouseEvent.getX();
            this.origY = mouseEvent.getY();
            Moveable moveable = this.getMoveableAt(this.origX, this.origY);
            if (moveable instanceof NonGridDrawable) {
                this.origXOffset = (int)(((NonGridDrawable)((Object)moveable)).getX() * (double)SimGraphics.getInstance().getXScale() - (double)this.origX);
                this.origYOffset = (int)(((NonGridDrawable)((Object)moveable)).getY() * (double)SimGraphics.getInstance().getYScale() - (double)this.origY);
            } else if (moveable instanceof Drawable) {
                this.origXOffset = (int)((float)((Drawable)((Object)moveable)).getX() * SimGraphics.getInstance().getXScale()) - this.origX;
                this.origYOffset = (int)((float)((Drawable)((Object)moveable)).getY() * SimGraphics.getInstance().getYScale()) - this.origY;
            } else {
                this.origXOffset = 0;
                this.origYOffset = 0;
            }
            this.firstDrag = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.moveable != null) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                this.probeable.setMoveableXY(this.moveable, n + this.origXOffset, n2 + this.origYOffset);
                DisplaySurface.this.updateDisplayDirect();
                this.count = 0;
                this.moveable = null;
                this.probeable = null;
            }
        }
    };
    DUpdate du = new DUpdate();
    private Action viewAction = new AbstractAction(""){

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            DisplayInfo displayInfo = (DisplayInfo)DisplaySurface.this.displays.get(jCheckBoxMenuItem.getActionCommand());
            ViewEvent viewEvent = new ViewEvent(this, displayInfo.getId(), jCheckBoxMenuItem.isSelected());
            displayInfo.getDisplayable().viewEventPerformed(viewEvent);
            DisplaySurface.this.repaint();
        }
    };
    private Action defaultSizeAction = new AbstractAction("Resize to Default"){

        public void actionPerformed(ActionEvent actionEvent) {
            if (DisplaySurface.this.frame != null) {
                DisplaySurface.this.setSize(DisplaySurface.this.defaultSize);
                DisplaySurface.this.componentResized(null);
                DisplaySurface.this.frame.pack();
            }
        }
    };

    public DisplaySurface(Dimension dimension, SimModel simModel, String string) {
        this(simModel, string);
        super.setSize(dimension);
    }

    public DisplaySurface(SimModel simModel, String string, Painter painter) {
        this(simModel, string);
        this.painter = painter;
    }

    public DisplaySurface(SimModel simModel, String string) {
        this.model = simModel;
        this.name = string;
        this.addMouseListener(this.dsMouseAdapter);
        this.addMouseMotionListener(this.dsMouseAdapter);
        this.addKeyListener(new KeyAdapter(){
            boolean inZoom = false;

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 90) {
                    if (DisplaySurface.this.zoomRect.x != -1) {
                        for (int i = 0; i < DisplaySurface.this.zoomables.size(); ++i) {
                            Zoomable zoomable = (Zoomable)DisplaySurface.this.zoomables.get(i);
                            zoomable.startZoom(DisplaySurface.this.zoomRect.x, DisplaySurface.this.zoomRect.y, DisplaySurface.this.zoomRect.width, DisplaySurface.this.zoomRect.height);
                        }
                        this.inZoom = true;
                        DisplaySurface.this.zoomRect.x = -1;
                        DisplaySurface.this.updateDisplayDirect();
                    }
                } else if (keyEvent.getKeyCode() == 82 && this.inZoom) {
                    for (int i = 0; i < DisplaySurface.this.zoomables.size(); ++i) {
                        Zoomable zoomable = (Zoomable)DisplaySurface.this.zoomables.get(i);
                        zoomable.endZoom();
                    }
                    this.inZoom = false;
                    DisplaySurface.this.updateDisplayDirect();
                }
            }
        });
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.painter.setBackgroundColor(color);
    }

    public void addDisplayable(Displayable displayable, String string) {
        this.buildPainter(displayable);
        this.addDisplay(displayable, string);
        this.painter.addDisplayable(displayable);
    }

    public void addDisplayable(Displayable displayable, String string, int n) {
        if (this.painter == null) {
            Dimension dimension = displayable.getSize();
            super.setSize(dimension);
            this.painter = new LocalPainter(this, dimension.width, dimension.height);
        } else if (this.painter.surface == null) {
            Dimension dimension = displayable.getSize();
            super.setSize(dimension);
            this.painter.init(this, dimension.width, dimension.height);
        }
        this.addDisplay(displayable, string);
        this.painter.addDisplayable(new DisplayableOrder(displayable, n));
    }

    public void removeDisplayable(Displayable displayable) {
        this.painter.removeDisplayable(displayable);
        this.removeDisplay(displayable);
    }

    public void addProbeable(Probeable probeable) {
        this.probeables.add(probeable);
    }

    public void removeProbeable(Probeable probeable) {
        this.probeables.remove(probeable);
    }

    public void removeProbeableDisplayable(Displayable displayable) {
        this.removeDisplayable(displayable);
        if (displayable instanceof Probeable) {
            this.removeProbeable((Probeable)((Object)displayable));
        }
    }

    public void addZoomable(Zoomable zoomable) {
        this.zoomables.add(zoomable);
    }

    public Dimension getDefaultSize() {
        return new Dimension(this.defaultSize);
    }

    public void addDisplayableProbeable(Displayable displayable, String string) {
        this.buildPainter(displayable);
        if (!(displayable instanceof Probeable)) {
            throw new IllegalArgumentException("Object is not a Probleable and a Displayable");
        }
        this.probeables.add(displayable);
        this.painter.addDisplayable(displayable);
        this.addDisplay(displayable, string);
    }

    public void updateDisplay() {
        if (this.needsUpdate) {
            try {
                SwingUtilities.invokeAndWait(this.du);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
            }
        }
    }

    public void updateDisplayDirect() {
        this.painter.paint(this.getGraphics());
    }

    private void buildPainter(Displayable displayable) {
        Dimension dimension = displayable != null ? displayable.getSize() : new Dimension(200, 200);
        if (this.painter == null) {
            super.setSize(dimension);
            this.painter = new LocalPainter(this, dimension.width, dimension.height);
        } else if (this.painter.surface == null) {
            super.setSize(dimension);
            this.painter.init(this, dimension.width, dimension.height);
        }
    }

    private void drawRect(int n, int n2, int n3, int n4) {
        if (this.needsUpdate) {
            this.painter.drawRect(this.getGraphics(), n, n2, n3, n4);
        }
    }

    private void eraseRect() {
        if (this.needsUpdate) {
            this.painter.eraseRect(this.getGraphics());
        }
    }

    public void paint(Graphics graphics) {
        this.painter.paint(graphics);
    }

    public void paintComponents(Graphics graphics) {
        this.painter.paint(graphics);
    }

    public void paintAll(Graphics graphics) {
        this.painter.paint(graphics);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void removeDisplay(Displayable displayable) {
        Iterator iterator = this.displays.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DisplayInfo displayInfo = (DisplayInfo)entry.getValue();
            if (!displayInfo.getDisplayable().equals(displayable)) continue;
            String string = (String)entry.getKey();
            int n = this.menu.getItemCount();
            for (int i = 0; i < n; ++i) {
                JMenuItem jMenuItem = this.menu.getItem(i);
                if (!jMenuItem.getText().equals(string)) continue;
                this.menu.remove(i);
                continue block0;
            }
        }
    }

    private void addDisplay(Displayable displayable, String string) {
        this.buildPainter(displayable);
        ArrayList arrayList = displayable.getDisplayableInfo();
        for (int i = 0; i < arrayList.size(); ++i) {
            DisplayInfo displayInfo = (DisplayInfo)arrayList.get(i);
            String string2 = displayInfo.getMenuText();
            string2 = string2.length() == 0 ? string : "(" + string + ")" + " " + string2;
            if (this.displays.containsKey(string2)) {
                throw new IllegalArgumentException("Display Surface already contains a menu item with this menu text");
            }
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string2, true);
            jCheckBoxMenuItem.addActionListener(this.viewAction);
            jCheckBoxMenuItem.setActionCommand(string2);
            this.menu.setMnemonic('o');
            this.menu.add(jCheckBoxMenuItem);
            this.displays.put(string2, displayInfo);
        }
    }

    public boolean isFrameVisible() {
        if (this.frame == null) {
            return false;
        }
        return this.frame.isVisible();
    }

    public void setLocation(int n, int n2) {
        this.location = new Point(n, n2);
        if (this.frame != null) {
            this.frame.setLocation(this.location);
        }
    }

    public void display() {
        this.buildPainter(null);
        this.frame = FrameFactory.createFrame(this.name);
        this.frame.setDefaultCloseOperation(0);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this, "Center");
        this.frame.getRootPane().setDoubleBuffered(false);
        this.frame.addWindowListener(this.dsWindowAdapter);
        this.bar = new JMenuBar();
        this.menu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(this.defaultSizeAction);
        this.menu.add(jMenuItem);
        this.bar.add(this.menu);
        this.frame.addComponentListener(this);
        this.frame.addMouseMotionListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DisplaySurface.this.mousePressed = true;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DisplaySurface.this.mousePressed = false;
            }
        });
        this.frame.setJMenuBar(this.bar);
        this.frame.pack();
        this.defaultSize = new Dimension(this.getWidth(), this.getHeight());
        Rectangle rectangle = FrameFactory.getBounds(this.name);
        if (this.location != null) {
            this.frame.setLocation(this.location);
            if (rectangle != null) {
                this.frame.setSize(rectangle.getSize());
            }
        } else if (rectangle != null) {
            this.frame.setBounds(rectangle);
        }
        this.frame.setVisible(true);
        if (this.legend != null) {
            this.legend.display();
        }
        if (this.movieMaker != null) {
            this.addMovieFrame();
        }
        if (this.keyListeners.size() > 0) {
            for (int i = 0; i < this.keyListeners.size(); ++i) {
                this.frame.addKeyListener((KeyListener)this.keyListeners.get(i));
            }
            this.keyListeners.clear();
        }
    }

    public void dispose() {
        if (this.painter != null) {
            this.painter.dispose();
            this.painter = null;
        }
        if (this.frame != null) {
            this.frame.getContentPane().remove(this);
            this.frame.remove(this.menu);
            this.menu.removeAll();
            this.frame.dispose();
            this.frame = null;
        }
        if (this.legend != null) {
            this.legend.dispose();
        }
        if (this.probeables != null) {
            this.probeables.clear();
        }
        this.displays.clear();
        this.keyListeners.clear();
        this.zoomables.clear();
        this.removeAll();
        this.probeables = null;
        this.model = null;
        this.menu = null;
        System.gc();
    }

    public void createLegend(String string) {
        this.legend = new Legend(string);
    }

    public void addLegendLabel(String string, int n, Color color, boolean bl) {
        if (this.legend == null) {
            System.err.println("Must createLegend before adding labels to it");
            return;
        }
        this.legend.addLegend(string, n, color, bl);
    }

    public void addLegendLabel(String string, int n, Color color, boolean bl, int n2, int n3) {
        if (this.legend == null) {
            System.err.println("Must createLegend before adding labels to it");
            return;
        }
        this.legend.addLegend(string, n, color, bl, n2, n3);
    }

    public void setMovieName(String string, String string2) {
        Dimension dimension = this.getSize();
        if (string2.equals("video.quicktime")) {
            string = string + ".mov";
            this.movieMaker = new MovieMaker(dimension.width, dimension.height, 1, string, string2);
        } else {
            SimUtilities.showMessage("Movie type " + string2 + " is unsupported");
        }
    }

    public void addMovieFrame() {
        if (this.movieMaker == null) {
            System.err.println("Unable to create frame - use setMovieFileName first");
            return;
        }
        this.painter.paint(this.getGraphics());
        this.movieMaker.addImageAsFrame(this.painter.getCurrentImage());
    }

    public void closeMovie() {
        if (this.movieMaker != null) {
            this.movieMaker.cleanUp();
        }
    }

    public JMenu getOptionsMenu() {
        return this.menu;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setSnapshotFileName(String string) {
        this.snapshotFile = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void takeSnapshot() {
        block12: {
            if (this.snapshotFile == null) {
                System.err.println("file not defined - use setSnapshotFileName");
                return;
            }
            this.painter.paint(this.getGraphics());
            String string = this.snapshotFile + this.model.getTickCount() + ".png";
            DataOutputStream dataOutputStream = null;
            dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            this.painter.takeSnapshot(dataOutputStream);
            Object var5_3 = null;
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
                break block12;
            }
            catch (Exception exception) {
                SimUtilities.showError("Unable to close output stream for snapshot image", exception);
                exception.printStackTrace();
            }
            break block12;
            {
                catch (IOException iOException) {
                    SimUtilities.showError("Unable to create output stream for snapshot image", iOException);
                    iOException.printStackTrace();
                    Object var5_4 = null;
                    try {
                        if (dataOutputStream != null) {
                            dataOutputStream.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        SimUtilities.showError("Unable to close output stream for snapshot image", exception);
                        exception.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    SimUtilities.showError("Unable to close output stream for snapshot image", exception);
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.frame != null) {
            this.frame.addKeyListener(keyListener);
        } else {
            this.keyListeners.add(keyListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (this.frame != null) {
            this.frame.removeKeyListener(keyListener);
        } else {
            this.keyListeners.remove(keyListener);
        }
    }

    public void simEventPerformed(SimEvent simEvent) {
        int n = simEvent.getId();
        if (n == 1 || n == 0) {
            // empty if block
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (!this.mousePressed) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            this.painter.reSize(n, n2);
            this.updateDisplayDirect();
        }
    }

    public class DisplayableOrder
    implements Comparable {
        int order;
        Displayable displayble;

        public DisplayableOrder(Displayable displayable, int n) {
            this.displayble = displayable;
            this.order = n;
        }

        public int compareTo(Object object) {
            DisplayableOrder displayableOrder = (DisplayableOrder)object;
            return this.order - displayableOrder.order;
        }

        public Displayable getDisplayable() {
            return this.displayble;
        }
    }

    class DUpdate
    implements Runnable {
        DUpdate() {
        }

        public void run() {
            DisplaySurface.this.painter.paint(DisplaySurface.this.getGraphics());
        }
    }

    class Rect {
        int x;
        int y;
        int width;
        int height;

        Rect() {
        }

        public String toString() {
            return "x: " + this.x + ", y: " + this.y + ", width: " + this.width + ", height: " + this.height;
        }
    }
}

