/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine.gui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import uchicago.src.sim.engine.gui.ParameterWizard;
import uchicago.src.sim.engine.gui.components.ArrayListListModel;
import uchicago.src.sim.engine.gui.components.DataTypeMismatchException;
import uchicago.src.sim.engine.gui.components.EnhancedJTable;
import uchicago.src.sim.engine.gui.components.ParameterData;
import uchicago.src.sim.engine.gui.components.ParameterDataObjectTableModel;
import uchicago.src.sim.engine.gui.components.RadioBarPanel;
import uchicago.src.sim.engine.gui.model.ConstantParameter;
import uchicago.src.sim.engine.gui.model.DataParameter;
import uchicago.src.sim.engine.gui.model.IncrementParameter;
import uchicago.src.sim.engine.gui.model.ListParameter;

public class ParameterWizardPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String treeName = "Parameter Definitions:";
    private DefaultMutableTreeNode top = null;
    private ArrayListListModel inputParmListModel = null;
    private ButtonGroup buttonGroup1;
    private EnhancedJTable allParameterTable;
    private JButton addNestParmButton = new JButton();
    private JButton addParmButton = new JButton();
    private JButton okButton;
    private JButton cancelButton;
    private JButton selectButton;
    private JButton removeParmButton = new JButton();
    private JLabel endLabel = new JLabel();
    private JLabel incrLabel = new JLabel();
    private JLabel fileNameLabel;
    private JLabel outputLocationLabel;
    private JLabel commaLabel;
    private JLabel runsLabel = new JLabel();
    private JLabel startLabel = new JLabel();
    private JList inputParameterList = new JList();
    private JPanel allParametersPanel;
    private JPanel buttonPanel;
    private JPanel inputParametersPanel;
    private JPanel outputLocationPanel;
    private JRadioButton listOfValuesRadioButton = new JRadioButton();
    private JRadioButton incrValueRadioButton = new JRadioButton();
    private JRadioButton constValueRadioButton = new JRadioButton();
    private JTabbedPane tabPane;
    private JTextField endTextField = new JTextField();
    private JTextField incrTextField = new JTextField();
    private JTextField runsTextField = new JTextField("1");
    private JTextField startTextField = new JTextField();
    private JTree configuredParmTree = null;
    private ParameterData aParameterData;
    private ParameterDataObjectTableModel aParameterDataObjectTableModel;
    private ParameterWizard aParameterWizard;
    private TreePath curPath;
    static /* synthetic */ Class class$java$lang$Integer;

    public ParameterWizardPanel(ParameterWizard parameterWizard) {
        this.aParameterWizard = parameterWizard;
        this.initComponents();
    }

    public void setInputParameterList(JList jList) {
        this.inputParameterList = jList;
    }

    public JList getInputParameterList() {
        return this.inputParameterList;
    }

    public String getOutputLocation() {
        return this.outputLocationLabel.getText();
    }

    public void setOutputLocation(String string) {
        this.outputLocationLabel.setText(string);
    }

    public void setParameterData(ParameterData parameterData) {
        this.aParameterData = parameterData;
        this.aParameterDataObjectTableModel.setAParameterData(parameterData);
        this.inputParmListModel.setSomeList(parameterData.getInputParameterList());
        ArrayList arrayList = parameterData.getRootNodes();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.configuredParmTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(i);
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.top, this.top.getChildCount());
        }
        this.expandAll(this.configuredParmTree, true);
        this.setOutputLocation(parameterData.getOutputLocation());
    }

    public void expandAll(JTree jTree, boolean bl) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        this.expandAll(jTree, new TreePath(treeNode), bl);
    }

    private void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public void configureOutputScreen() {
        this.outputLocationPanel.setLayout(new GridBagLayout());
        this.fileNameLabel = new JLabel();
        this.outputLocationLabel = new JLabel();
        this.selectButton = new JButton();
        this.fileNameLabel.setFont(new Font("Microsoft Sans Serif", 1, 11));
        this.fileNameLabel.setText("File Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 23;
        this.outputLocationPanel.add((Component)this.fileNameLabel, gridBagConstraints);
        this.outputLocationLabel.setText("File Name Not Specified.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 23;
        this.outputLocationPanel.add((Component)this.outputLocationLabel, gridBagConstraints);
        this.selectButton.setText("Select");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 23;
        this.outputLocationPanel.add((Component)this.selectButton, gridBagConstraints);
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.selectButtonAction();
            }
        });
    }

    public void rePaintTree() {
        this.configuredParmTree.repaint();
        this.configuredParmTree.invalidate();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.configuredParmTree.getModel();
        defaultTreeModel.nodeChanged((TreeNode)this.curPath.getLastPathComponent());
    }

    public void refreshTree() {
        this.top = new DefaultMutableTreeNode(treeName);
        this.configuredParmTree = new JTree(this.top);
        this.configuredParmTree.getSelectionModel().setSelectionMode(1);
        this.configuredParmTree.setRootVisible(false);
        this.configuredParmTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ParameterWizardPanel.this.configuredParmTree.getLastSelectedPathComponent();
                if (ParameterWizardPanel.this.configuredParmTree.isSelectionEmpty()) {
                    ParameterWizardPanel.this.removeParmButton.setEnabled(false);
                } else {
                    ParameterWizardPanel.this.removeParmButton.setEnabled(true);
                }
                if (defaultMutableTreeNode == null) {
                    return;
                }
            }
        });
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.configuredParmTree.getModel();
        defaultTreeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
                try {
                    int n = treeModelEvent.getChildIndices()[0];
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
    }

    protected void CancelActionPerformed(ActionEvent actionEvent) {
        this.aParameterWizard.actionPerformed(new ActionEvent(this.outputLocationLabel, 1001, "EXIT"));
    }

    protected void OKActionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        if (this.outputLocationLabel.getText() == null || this.outputLocationLabel.getText().equals("")) {
            this.selectButtonAction();
            if (this.outputLocationLabel.getText() == null || this.outputLocationLabel.getText().equals("")) {
                JOptionPane.showMessageDialog(this.aParameterWizard.getDialog(), "You must select an output parameter file to run in Multi-Run mode.", "Alert", 0);
            }
            bl = this.outputLocationLabel.getText() != null && !this.outputLocationLabel.getText().equals("");
        } else {
            bl = true;
        }
        if (bl) {
            this.aParameterWizard.actionPerformed(new ActionEvent(this.outputLocationLabel, 1001, "RUN_SIMULATION"));
        }
    }

    protected void addNestActionPerformed(ActionEvent actionEvent) {
        DataParameter dataParameter = null;
        try {
            dataParameter = this.createParameterNode();
        }
        catch (DataTypeMismatchException dataTypeMismatchException) {
            JOptionPane.showMessageDialog(this.aParameterWizard.getDialog(), dataTypeMismatchException.getMessage(), "Alert", 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dataParameter);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.configuredParmTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode2 = this.configuredParmTree.getSelectionPath() != null ? (DefaultMutableTreeNode)this.configuredParmTree.getSelectionPath().getLastPathComponent() : this.top;
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.configuredParmTree.scrollPathToVisible(treePath);
        this.configuredParmTree.setSelectionPath(treePath);
    }

    protected void addParmActionPerformed(ActionEvent actionEvent) {
        DataParameter dataParameter = null;
        try {
            dataParameter = this.createParameterNode();
        }
        catch (DataTypeMismatchException dataTypeMismatchException) {
            JOptionPane.showMessageDialog(this.aParameterWizard.getDialog(), dataTypeMismatchException.getMessage(), "Alert", 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dataParameter);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.configuredParmTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode2 = this.top;
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.configuredParmTree.scrollPathToVisible(treePath);
        this.configuredParmTree.setSelectionPath(treePath);
    }

    protected void inputParameterListChanged(ListSelectionEvent listSelectionEvent) {
        if (this.inputParameterList.isSelectionEmpty()) {
            this.addNestParmButton.setEnabled(false);
            this.addParmButton.setEnabled(false);
        } else {
            this.addParmButton.setEnabled(true);
            if (this.configuredParmTree.getModel().getChildCount(this.top) > 0) {
                this.addNestParmButton.setEnabled(true);
            }
        }
    }

    protected void removeParmActionPerformed(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (this.configuredParmTree.getSelectionPath() != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.configuredParmTree.getSelectionPath().getLastPathComponent();
        }
        if (!defaultMutableTreeNode.getUserObject().equals(treeName)) {
            ((DefaultTreeModel)this.configuredParmTree.getModel()).removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    protected void valueTypeSpecificationPerformed(ActionEvent actionEvent) {
        if (this.listOfValuesRadioButton.isSelected()) {
            this.endTextField.setVisible(false);
            this.incrTextField.setVisible(false);
            this.endLabel.setVisible(false);
            this.incrLabel.setVisible(false);
            this.startLabel.setText("List of Values:");
            this.commaLabel.setText("(space separated)");
        } else if (this.constValueRadioButton.isSelected()) {
            this.endTextField.setVisible(false);
            this.incrTextField.setVisible(false);
            this.endLabel.setVisible(false);
            this.incrLabel.setVisible(false);
            this.startLabel.setText("Const Value:");
            this.commaLabel.setText("");
        } else {
            this.endTextField.setVisible(true);
            this.incrTextField.setVisible(true);
            this.endLabel.setVisible(true);
            this.incrLabel.setVisible(true);
            this.startLabel.setText("Start Value:");
            this.commaLabel.setText("");
        }
    }

    private void configureInputParametersPanel() {
        this.buttonGroup1 = new ButtonGroup();
        JPanel jPanel = new JPanel();
        this.incrValueRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.valueTypeSpecificationPerformed(actionEvent);
            }
        });
        this.listOfValuesRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.valueTypeSpecificationPerformed(actionEvent);
            }
        });
        this.constValueRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.valueTypeSpecificationPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.incrValueRadioButton);
        this.buttonGroup1.add(this.listOfValuesRadioButton);
        this.buttonGroup1.add(this.constValueRadioButton);
        this.addParmButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.addParmActionPerformed(actionEvent);
            }
        });
        this.addNestParmButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.addNestActionPerformed(actionEvent);
            }
        });
        this.removeParmButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.removeParmActionPerformed(actionEvent);
            }
        });
        this.refreshTree();
        this.inputParmListModel = new ArrayListListModel(new ArrayList());
        this.inputParameterList = new JList(this.inputParmListModel);
        this.inputParametersPanel.setLayout(new BorderLayout());
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(" Parameter Definition: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.incrValueRadioButton.setText("Increment");
        this.incrValueRadioButton.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.incrValueRadioButton, gridBagConstraints);
        this.listOfValuesRadioButton.setText("List");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.listOfValuesRadioButton, gridBagConstraints);
        this.constValueRadioButton.setText("Constant");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.constValueRadioButton, gridBagConstraints);
        this.runsLabel.setText("Runs:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.runsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.runsTextField, gridBagConstraints);
        this.startLabel.setText("Start Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.startLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.startTextField, gridBagConstraints);
        this.endLabel.setText("End Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.endLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.endTextField, gridBagConstraints);
        this.incrLabel.setText("Step:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.incrLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.incrTextField, gridBagConstraints);
        this.commaLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 22;
        jPanel.add((Component)this.commaLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        this.addParmButton.setText("Add");
        this.addParmButton.setEnabled(false);
        jPanel2.add(this.addParmButton);
        this.addNestParmButton.setText("Add/Nest");
        jPanel2.add(this.addNestParmButton);
        this.addNestParmButton.setEnabled(false);
        this.removeParmButton.setText("Remove");
        this.removeParmButton.setEnabled(false);
        jPanel2.add(this.removeParmButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("List of parameter definitions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this.configuredParmTree);
        jScrollPane.setPreferredSize(new Dimension(250, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.inputParametersPanel.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Available parameters:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 23;
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        this.inputParameterList.setSelectionMode(0);
        this.inputParameterList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ParameterWizardPanel.this.inputParameterListChanged(listSelectionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.inputParameterList);
        jPanel3.add((Component)jScrollPane, gridBagConstraints);
        this.inputParametersPanel.add((Component)jPanel3, "West");
        this.inputParametersPanel.setBorder(BorderFactory.createTitledBorder(" Specify Input Parameters Values "));
    }

    private Object parseValue(String string, String string2) throws DataTypeMismatchException {
        try {
            if (string2.equalsIgnoreCase("java.lang.Integer")) {
                Integer n = new Integer(string);
                return n;
            }
            if (string2.equalsIgnoreCase("java.lang.Long")) {
                Long l = new Long(string);
                return l;
            }
            if (string2.equalsIgnoreCase("java.lang.String")) {
                return string;
            }
            if (string2.equalsIgnoreCase("java.lang.Float")) {
                Float f = new Float(string);
                return f;
            }
            if (string2.equalsIgnoreCase("java.lang.Byte")) {
                Byte by = new Byte(string);
                return by;
            }
            if (string2.equalsIgnoreCase("java.lang.Double")) {
                Double d = new Double(string);
                return d;
            }
            if (string2.equalsIgnoreCase("java.lang.Boolean")) {
                Boolean bl = new Boolean(string);
                return bl;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataTypeMismatchException(string + " is not of type " + string2);
        }
        return null;
    }

    private DataParameter createParameterNode() throws DataTypeMismatchException {
        String string = null;
        String string2 = null;
        boolean bl = true;
        DataParameter dataParameter = (DataParameter)this.inputParameterList.getSelectedValue();
        String string3 = "";
        try {
            int n;
            if (dataParameter != null) {
                string = dataParameter.getName();
                string2 = dataParameter.getDataType();
            }
            try {
                n = Integer.parseInt(this.runsTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (this.incrValueRadioButton.isSelected()) {
                string3 = "Start";
                Object object = this.parseValue(this.startTextField.getText(), string2);
                string3 = "End";
                Object object2 = this.parseValue(this.endTextField.getText(), string2);
                string3 = "Step";
                Object object3 = this.parseValue(this.incrTextField.getText(), string2);
                IncrementParameter incrementParameter = null;
                incrementParameter = new IncrementParameter(n, string, string2, bl, object, object2, object3);
                return incrementParameter;
            }
            if (this.constValueRadioButton.isSelected()) {
                string3 = "Start";
                Object object = this.parseValue(this.startTextField.getText(), string2);
                ConstantParameter constantParameter = null;
                constantParameter = new ConstantParameter(n, string, string2, bl, object);
                return constantParameter;
            }
            if (this.listOfValuesRadioButton.isSelected()) {
                Object[] objectArray = null;
                string3 = "List value";
                StringTokenizer stringTokenizer = new StringTokenizer(this.startTextField.getText().trim());
                if (stringTokenizer.countTokens() > 0) {
                    objectArray = new Object[stringTokenizer.countTokens()];
                    int n2 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        objectArray[n2] = this.parseValue(stringTokenizer.nextToken(), string2);
                        ++n2;
                    }
                }
                ListParameter listParameter = null;
                listParameter = new ListParameter(n, string, string2, bl, objectArray);
                return listParameter;
            }
            return null;
        }
        catch (DataTypeMismatchException dataTypeMismatchException) {
            throw new DataTypeMismatchException(string3 + " " + dataTypeMismatchException.getMessage(), dataTypeMismatchException);
        }
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.tabPane = new JTabbedPane();
        this.inputParametersPanel = new JPanel();
        this.outputLocationPanel = new JPanel();
        this.okButton.setText("OK");
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.OKActionPerformed(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.CancelActionPerformed(actionEvent);
            }
        });
        this.allParametersPanel = new JPanel();
        this.allParametersPanel.setLayout(new GridLayout(1, 1));
        this.aParameterDataObjectTableModel = new ParameterDataObjectTableModel(this.aParameterWizard, this.aParameterData);
        this.allParameterTable = new EnhancedJTable(this.aParameterDataObjectTableModel, 90);
        String[] stringArray = new String[]{"Input", "Output"};
        int[] nArray = new int[]{0, 1};
        this.allParameterTable.setDefaultRenderer(class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterWizardPanel.class$("java.lang.Integer")) : class$java$lang$Integer, new RadioBarPanel(this.aParameterWizard, stringArray, nArray));
        this.allParameterTable.setDefaultEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterWizardPanel.class$("java.lang.Integer")) : class$java$lang$Integer, new RadioBarPanel(this.aParameterWizard, stringArray, nArray));
        this.allParametersPanel.add(new JScrollPane(this.allParameterTable, 20, 30));
        this.allParametersPanel.setBorder(BorderFactory.createTitledBorder(" Specify Parameters Function "));
        this.tabPane.addTab("All Parameters", this.allParametersPanel);
        this.configureInputParametersPanel();
        this.tabPane.addTab("Input Parameters", this.inputParametersPanel);
        this.configureOutputScreen();
        this.tabPane.addTab("Parameter File Location", this.outputLocationPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPane, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    private void selectButtonAction() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle("Choose file to store parameters");
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string = this.cleanupFileName(jFileChooser.getSelectedFile().getPath());
            this.outputLocationLabel.setText(string);
            this.aParameterWizard.actionPerformed(new ActionEvent(this.outputLocationLabel, 1001, "CHANGED_OUTPUT_LOCATION"));
        }
    }

    private String cleanupFileName(String string) {
        if (!string.endsWith(".xml")) {
            return string + ".xml";
        }
        return string;
    }

    public DefaultMutableTreeNode getTreeTop() {
        return this.top;
    }

    public static void main(String[] stringArray) {
        ParameterWizardPanel parameterWizardPanel = new ParameterWizardPanel(null);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(parameterWizardPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

