/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import uchicago.src.sim.engine.ActionQueue;
import uchicago.src.sim.engine.BasicAction;

public class ThreadedAction
extends BasicAction {
    private BasicAction action;
    private boolean done = false;
    private Thread runner;
    private double duration;

    public ThreadedAction(BasicAction basicAction, double d) {
        this.action = basicAction;
        this.duration = d;
    }

    public synchronized void done() {
        this.done = true;
        this.notifyAll();
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    void setUpdater(int n) {
        if (n == 1) {
            this.updater = new ThreadedIntervalUpdater();
        } else if (n == 2) {
            this.updater = new ThreadedAtUpdater();
        } else {
            throw new IllegalArgumentException("Illegal Updater type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.runner == null) {
            this.runner = new Thread(new ActionRunner(this.action, this));
            this.runner.setName("ThreadedAction Thread");
            this.runner.start();
        } else {
            try {
                ThreadedAction threadedAction = this;
                synchronized (threadedAction) {
                    while (!this.done) {
                        this.wait();
                    }
                }
                this.runner = null;
                this.done = false;
            }
            catch (InterruptedException interruptedException) {
                this.runner.interrupt();
            }
        }
    }

    static class ActionRunner
    implements Runnable {
        BasicAction baction;
        ThreadedAction owner;

        public ActionRunner(BasicAction basicAction, ThreadedAction threadedAction) {
            this.baction = basicAction;
            this.owner = threadedAction;
        }

        public void run() {
            this.baction.execute();
            this.owner.done();
        }
    }

    class ThreadedIntervalUpdater
    implements BasicAction.Updater {
        private boolean done = false;

        ThreadedIntervalUpdater() {
        }

        public void update(ActionQueue actionQueue) {
            if (!this.done) {
                ThreadedAction.this.nextTime += ThreadedAction.this.duration;
                System.out.println("duration.nextTime = " + ThreadedAction.this.nextTime);
                actionQueue.toss(ThreadedAction.this);
                this.done = true;
            } else {
                ThreadedAction.this.nextTime += ThreadedAction.this.intervalTime - ThreadedAction.this.duration;
                System.out.println("interval.nextTime = " + ThreadedAction.this.nextTime);
                actionQueue.toss(ThreadedAction.this);
                this.done = false;
            }
        }
    }

    class ThreadedAtUpdater
    implements BasicAction.Updater {
        private boolean done = false;

        ThreadedAtUpdater() {
        }

        public void update(ActionQueue actionQueue) {
            if (!this.done) {
                ThreadedAction.this.nextTime += ThreadedAction.this.duration;
                actionQueue.toss(ThreadedAction.this);
                this.done = true;
            }
        }
    }
}

