/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.util.ArrayList;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.engine.SimModelImpl;
import uchicago.src.sim.engine.Stepable;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.SimUtilities;

public class SimpleModel
extends SimModelImpl {
    protected Schedule schedule;
    protected ArrayList agentList = new ArrayList();
    protected String name = "A Repast Model";
    protected String[] params = new String[]{""};
    private double stoppingTime = Double.POSITIVE_INFINITY;
    private BasicAction stoppingAction;
    protected boolean autoStep = false;
    protected boolean shuffle = false;
    protected long seed = 1L;
    protected boolean isGui;
    protected long startAt = 1L;

    public void setStoppingTime(long l) {
        this.setStoppingTime((double)l);
    }

    public void setStoppingTime(double d) {
        this.stoppingTime = d;
        if (this.stoppingAction != null) {
            this.schedule.removeAction(this.stoppingAction);
        }
        if (this.schedule != null) {
            this.setStopAction();
        }
    }

    private void setStopAction() {
        this.stoppingAction = this.schedule.scheduleActionAt(this.stoppingTime, (Object)this, "stop", Schedule.LAST);
    }

    public void setup() {
        this.isGui = !this.getController().isBatch();
        this.stoppingTime = Double.POSITIVE_INFINITY;
        this.stoppingAction = null;
        this.schedule = new Schedule();
        this.agentList = new ArrayList();
        this.setRngSeed(this.seed);
        Random.createUniform();
    }

    public void setRngSeed(long l) {
        this.seed = l;
        super.setRngSeed(l);
        Random.createUniform();
    }

    public int getNextIntFromTo(int n, int n2) {
        return Random.uniform.nextIntFromTo(n, n2);
    }

    public double getNextDoubleFromTo(double d, double d2) {
        return Random.uniform.nextDoubleFromTo(d, d2);
    }

    public void begin() {
        this.buildModel();
        this.buildSchedule();
    }

    public String getName() {
        return this.name;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public String[] getInitParam() {
        return this.params;
    }

    public void buildModel() {
    }

    public void buildSchedule() {
        if (this.autoStep) {
            this.schedule.scheduleActionBeginning((double)this.startAt, this, "runAutoStep");
        } else {
            this.schedule.scheduleActionBeginning((double)this.startAt, this, "run");
        }
        this.schedule.scheduleActionAtEnd(this, "atEnd");
        this.schedule.scheduleActionAtPause(this, "atPause");
        this.setStopAction();
    }

    public void atPause() {
    }

    public void atEnd() {
    }

    public void runAutoStep() {
        this.preStep();
        this.autoStep();
        this.postStep();
    }

    public void run() {
        this.preStep();
        this.step();
        this.postStep();
    }

    private void autoStep() {
        if (this.shuffle) {
            SimUtilities.shuffle(this.agentList);
        }
        int n = this.agentList.size();
        for (int i = 0; i < n; ++i) {
            Stepable stepable = (Stepable)this.agentList.get(i);
            stepable.step();
        }
    }

    protected void preStep() {
    }

    protected void step() {
    }

    protected void postStep() {
    }
}

