/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import javax.swing.UIManager;
import uchicago.src.sim.engine.AbstractGUIController;
import uchicago.src.sim.engine.BaseController;
import uchicago.src.sim.engine.BatchController;
import uchicago.src.sim.engine.Controller;
import uchicago.src.sim.engine.IController;
import uchicago.src.sim.engine.SimEventListener;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.gui.FrameFactory;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.parameter.ParameterSetterFactory;
import uchicago.src.sim.util.SimUtilities;

public class SimInit {
    public static final String VERSION = "3.0";
    private static boolean noGui = false;
    private boolean exitOnExit = true;
    private static final String USAGE = "\nUsage:\t [-ng -b] [fully_qualified_name_of_model_class] [parameter file | run count]\ne.g java -cp .;sim.jar uchicago.src.sim.SimInit uchicago.src.sim.heatBugs.HeatBugModel\n";
    private int numRuns = 1;

    private void open() {
        Controller controller = new Controller();
        controller.setModel(null);
        controller.display();
    }

    private void open(String string) throws IllegalAccessException {
        this.open(string, false, "");
    }

    public void setNumRuns(int n) {
        this.numRuns = n;
    }

    private void open(String string, boolean bl, String string2) throws IllegalAccessException {
        SimModel simModel = null;
        try {
            Class<?> clazz = Class.forName(string);
            simModel = (SimModel)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Model does not implement the SimModel interface");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Can't find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Can't instantiate " + string);
        }
        this.load(simModel, bl, string2);
    }

    private void load(SimModel simModel, boolean bl, String string) {
        this.load(simModel, bl, string, true);
    }

    private void load(SimModel simModel, boolean bl, String string, boolean bl2) {
        Object object;
        try {
            object = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel((String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            FrameFactory.load(simModel.getClass().getName());
            object = null;
            if (string.length() == 0) {
                object = new Controller();
            } else {
                ParameterSetter parameterSetter = null;
                try {
                    parameterSetter = ParameterSetterFactory.createParameterSetter(string);
                }
                catch (Exception exception) {
                    SimUtilities.showError("Error reading parameter file", exception);
                    if (this.exitOnExit) {
                        System.exit(0);
                    }
                    throw new RuntimeException("Error reading parameter file");
                }
                object = new Controller(parameterSetter);
            }
            simModel.setController((IController)object);
            ((BaseController)object).setExitOnExit(this.exitOnExit);
            ((Controller)object).setModel(simModel);
            simModel.addSimEventListener((SimEventListener)object);
            if (noGui) {
                ((AbstractGUIController)object).loadAndStart();
            } else {
                ((Controller)object).display();
            }
        } else {
            object = null;
            if (string != null && string.trim().length() > 0) {
                try {
                    object = ParameterSetterFactory.createParameterSetter(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SimUtilities.showError("Initialization error", exception);
                    if (this.exitOnExit) {
                        System.exit(0);
                    }
                    throw new RuntimeException("Error reading parameter file");
                }
            } else {
                object = ParameterSetterFactory.createSingleSetParameterSetter(this.numRuns);
            }
            BatchController batchController = new BatchController((ParameterSetter)object);
            simModel.setController(batchController);
            batchController.setModel(simModel);
            batchController.begin();
        }
    }

    public void loadModel(SimModel simModel, String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        this.load(simModel, bl, string);
    }

    public void setExitOnExit(boolean bl) {
        this.exitOnExit = bl;
    }

    public static void main(String[] stringArray) {
        block23: {
            Object object;
            try {
                object = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = new SimInit();
            try {
                if (stringArray.length == 0) {
                    super.open();
                } else if (stringArray[0].startsWith("-")) {
                    if (stringArray[0].equals("-ng")) {
                        noGui = true;
                        super.open(stringArray[1]);
                    } else if (stringArray[0].equals("-v")) {
                        System.out.println("RePast Version: 3.0");
                        System.exit(0);
                    } else if (stringArray[0].equals("-b")) {
                        if (stringArray.length < 2) {
                            System.out.println("Model argument is missing.\nSpecify a model class name");
                            System.exit(0);
                        } else if (stringArray.length == 2) {
                            super.open(stringArray[1], true, "");
                        } else {
                            try {
                                ((SimInit)object).numRuns = Integer.parseInt(stringArray[2]);
                                super.open(stringArray[1], true, "");
                            }
                            catch (NumberFormatException numberFormatException) {
                                super.open(stringArray[1], true, stringArray[2]);
                            }
                        }
                    } else {
                        System.out.println("Invalid option");
                        System.out.println(USAGE);
                        if (((SimInit)object).exitOnExit) {
                            System.exit(0);
                        }
                    }
                } else if (stringArray.length > 1) {
                    super.open(stringArray[0], false, stringArray[1]);
                } else {
                    super.open(stringArray[0]);
                }
            }
            catch (Exception exception) {
                SimUtilities.showError("Initialization error", exception);
                exception.printStackTrace();
                if (!((SimInit)object).exitOnExit) break block23;
                System.exit(0);
            }
        }
    }
}

