/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class HelpPane
implements HyperlinkListener {
    private JEditorPane ep;
    private JFrame frame;
    private Vector urls = new Vector(3);
    private int urlPointer = 0;
    private URL currentURL = null;
    private JButton right = new JButton(new ImageIcon("d:/home/nick/src/uchicago/src/sim/images/Right.gif"));
    private JButton left = new JButton(new ImageIcon("d:/home/nick/src/uchicago/src/sim/images/Left.gif"));
    private JButton exit = new JButton(new ImageIcon("d:/home/nick/src/uchicago/src/sim/images/Delete.gif"));

    public HelpPane() {
        try {
            this.currentURL = new URL("file:///d:/home/nick/repast/docs/how_to/how_to.html");
            this.urls.add(this.currentURL);
            this.ep = new JEditorPane(this.currentURL);
            this.ep.setEditable(false);
            this.ep.addHyperlinkListener(this);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        JScrollPane jScrollPane = new JScrollPane(this.ep);
        this.frame = new JFrame("Repast Help");
        Container container = this.frame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jScrollPane, "Center");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HelpPane.this.exit();
            }
        });
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.left);
        jToolBar.add(this.right);
        jToolBar.add(this.exit);
        this.left.setEnabled(false);
        this.right.setEnabled(false);
        container.add((Component)jToolBar, "North");
        this.addListeners();
    }

    public void display() {
        if (!this.frame.isVisible()) {
            this.frame.setSize(500, 400);
            this.frame.setVisible(true);
        } else if (this.frame.getState() == 1) {
            this.frame.setState(0);
        } else {
            this.frame.requestFocus();
        }
    }

    private void addListeners() {
        this.left.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpPane.this.urlPointer--;
                HelpPane.this.gotoLink((URL)HelpPane.this.urls.get(HelpPane.this.urlPointer));
                if (HelpPane.this.urlPointer == 0) {
                    HelpPane.this.left.setEnabled(false);
                }
                HelpPane.this.right.setEnabled(true);
            }
        });
        this.right.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpPane.this.urlPointer++;
                HelpPane.this.gotoLink((URL)HelpPane.this.urls.get(HelpPane.this.urlPointer));
                if (HelpPane.this.urlPointer == HelpPane.this.urls.size() - 1) {
                    HelpPane.this.right.setEnabled(false);
                }
                HelpPane.this.left.setEnabled(true);
            }
        });
        this.exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpPane.this.exit();
            }
        });
    }

    private void exit() {
        this.frame.dispose();
        System.exit(0);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            Cursor cursor = Cursor.getPredefinedCursor(12);
            this.ep.setCursor(cursor);
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.ep.setCursor(Cursor.getPredefinedCursor(0));
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.ep.setCursor(Cursor.getPredefinedCursor(3));
            this.urls.add(hyperlinkEvent.getURL());
            this.gotoLink(hyperlinkEvent.getURL());
            this.ep.setCursor(Cursor.getPredefinedCursor(0));
            ++this.urlPointer;
            for (int i = this.urlPointer + 1; i < this.urls.size(); ++i) {
                this.urls.removeElementAt(i);
            }
            this.right.setEnabled(false);
        }
    }

    private void gotoLink(URL uRL) {
        if (uRL != null) {
            Document document = this.ep.getDocument();
            try {
                this.ep.setPage(uRL);
                this.currentURL = uRL;
                if (this.urls.size() > 1) {
                    this.left.setEnabled(true);
                }
            }
            catch (Exception exception) {
                this.ep.setDocument(document);
            }
        }
    }

    public static void main(String[] stringArray) {
        HelpPane helpPane = new HelpPane();
        helpPane.display();
    }
}

