/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import uchicago.src.reflector.IntrospectPanel;
import uchicago.src.sim.engine.AbstractGUIController;
import uchicago.src.sim.engine.BatchController;
import uchicago.src.sim.engine.BatchEvent;
import uchicago.src.sim.engine.BatchListener;
import uchicago.src.sim.engine.ModelManipulator;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.engine.gui.RepastActionPanel;
import uchicago.src.sim.engine.gui.RepastParamPanel;
import uchicago.src.sim.gui.RepastConsole;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.parameter.ParameterSetterFactory;
import uchicago.src.sim.util.ProbeUtilities;
import uchicago.src.sim.util.SimUtilities;

public class Controller
extends AbstractGUIController {
    protected JToolBar toolBar = new JToolBar();
    protected JFrame tbFrame;
    protected JButton btnSetup;
    protected JButton btnStart;
    protected JButton btnStep;
    protected JButton btnStop;
    protected JButton btnPause;
    protected JButton btnExit;
    protected JButton btnLoad;
    protected JButton btnSettings;
    protected JButton btnBegin;
    protected JButton btnMultRunsStart;
    protected RepastParamPanel parameterFilePanel;
    protected BatchController batchController;
    protected JLabel tickCount = new JLabel(" Tick Count: 0.0                ");
    protected JLabel runCountLabel = new JLabel(" Run: 1       ");
    protected JFrame settingsFrame = null;
    protected JTabbedPane tabPane = null;
    protected IntrospectPanel modelPanel = null;
    protected IntrospectPanel simPanel = null;
    protected RepastActionPanel repastPanel = new RepastActionPanel();
    protected ArrayList userButtons = new ArrayList();
    protected ArrayList listeners = new ArrayList();
    protected ArrayList keyListeners = new ArrayList();
    static /* synthetic */ Class class$uchicago$src$sim$engine$Controller;

    public Controller() {
    }

    public Controller(ParameterSetter parameterSetter) {
        super(parameterSetter);
    }

    private void setSettingsEnabled(boolean bl) {
        if (this.isGui) {
            if (this.modelPanel != null) {
                this.modelPanel.setEnabled(bl);
            }
            this.simPanel.setEnabled(bl);
        }
    }

    public void setModel(SimModel simModel) {
        String string = "Repast";
        super.setModel(simModel);
        this.tbFrame = new JFrame(string);
        this.tbFrame.setIconImage(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/RepastSmall.gif")).getImage());
        this.setupToolBar();
        this.setButtonsState(simModel == null);
        this.addListeners();
        this.tickCount.setForeground(Color.blue);
        this.runCountLabel.setForeground(Color.blue);
    }

    public JButton addButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        int n = jButton.getPreferredSize().width - 10;
        jButton.setMinimumSize(new Dimension(n, 31));
        jButton.setMaximumSize(jButton.getMinimumSize());
        jButton.setPreferredSize(jButton.getMinimumSize());
        jButton.addActionListener(actionListener);
        this.userButtons.add(jButton);
        return jButton;
    }

    public JButton addButton(JButton jButton) {
        this.userButtons.add(jButton);
        return jButton;
    }

    public JButton addIconButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(new ImageIcon(string));
        jButton.addActionListener(actionListener);
        this.userButtons.add(jButton);
        return jButton;
    }

    private void setupToolBar() {
        this.toolBar.setFloatable(false);
        this.btnLoad = new JButton(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/Open24.gif")));
        this.btnLoad.setActionCommand("load");
        this.btnBegin = new JButton(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/Redo24.gif")));
        this.btnBegin.setActionCommand("initialize");
        this.btnSetup = new JButton(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/Refresh24.gif")));
        this.btnSetup.setActionCommand("setup");
        this.btnStart = new JButton(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/Play24.gif")));
        this.btnStart.setActionCommand("start");
        this.btnStep = new JButton(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/StepForward24.gif")));
        this.btnStep.setActionCommand("step");
        this.btnStop = new JButton(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/StopSquare24.gif")));
        this.btnStop.setActionCommand("stop");
        this.btnPause = new JButton(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/Pause24.gif")));
        this.btnPause.setActionCommand("pause");
        this.btnExit = new JButton(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/Delete.gif")));
        this.btnExit.setActionCommand("exit");
        this.btnSettings = new JButton(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/TipOfTheDay24.gif")));
        this.btnSettings.setActionCommand("settings");
        this.btnMultRunsStart = new JButton(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/ParameterSweep.gif")));
        this.btnMultRunsStart.setActionCommand("MultRunsStart");
        this.toolBar.add(this.btnLoad);
        this.btnLoad.setToolTipText("Load Model");
        this.toolBar.addSeparator();
        this.toolBar.add(this.btnMultRunsStart);
        this.btnMultRunsStart.setToolTipText("Multiple Runs Start");
        this.toolBar.add(this.btnStart);
        this.btnStart.setToolTipText("Start");
        this.toolBar.add(this.btnStep);
        this.btnStep.setToolTipText("Step");
        this.toolBar.add(this.btnBegin);
        this.toolBar.add(this.btnStop);
        this.btnBegin.setToolTipText("Initialize");
        this.btnStop.setToolTipText("Stop");
        this.toolBar.add(this.btnPause);
        this.btnPause.setToolTipText("Pause");
        this.toolBar.addSeparator();
        this.toolBar.add(this.btnSetup);
        this.btnSetup.setToolTipText("Setup Model");
        this.toolBar.add(this.btnSettings);
        this.btnSettings.setToolTipText("View Parameters");
        this.toolBar.addSeparator();
        this.btnExit.setMinimumSize(this.btnPause.getPreferredSize());
        this.btnExit.setMaximumSize(this.btnExit.getMinimumSize());
        this.btnExit.setPreferredSize(this.btnExit.getMinimumSize());
        this.toolBar.add(this.btnExit);
        this.btnExit.setToolTipText("Exit");
        for (int i = 0; i < this.userButtons.size(); ++i) {
            if (i == 0) {
                this.toolBar.addSeparator();
            }
            this.toolBar.add((JButton)this.userButtons.get(i));
        }
        this.toolBar.addSeparator();
        this.toolBar.add(this.tickCount);
        this.toolBar.addSeparator();
        this.toolBar.add(this.runCountLabel);
        Dimension dimension = this.btnExit.getPreferredSize();
        Dimension dimension2 = this.tickCount.getPreferredSize();
        this.tickCount.setPreferredSize(new Dimension(dimension2.width + 4, dimension.height));
        this.tickCount.setMaximumSize(this.tickCount.getPreferredSize());
        this.tickCount.setMinimumSize(this.tickCount.getPreferredSize());
        Border border = BorderFactory.createBevelBorder(1);
        this.tickCount.setBorder(border);
        this.tickCount.setText(" Tick Count: 0.0                ");
        dimension2 = this.runCountLabel.getPreferredSize();
        this.runCountLabel.setPreferredSize(new Dimension(dimension2.width + 4, dimension.height));
        this.runCountLabel.setMaximumSize(this.tickCount.getPreferredSize());
        this.runCountLabel.setMinimumSize(this.tickCount.getPreferredSize());
        this.runCountLabel.setBorder(border);
        this.tbFrame.getContentPane().add(this.toolBar);
    }

    private void setButtonsState(boolean bl) {
        if (!bl) {
            this.btnMultRunsStart.setEnabled(true);
            this.btnStart.setEnabled(true);
            this.btnBegin.setEnabled(true);
            this.btnSetup.setEnabled(false);
            this.btnStep.setEnabled(true);
            this.btnPause.setEnabled(false);
            this.btnStop.setEnabled(false);
            this.btnSettings.setEnabled(true);
        } else {
            this.btnMultRunsStart.setEnabled(false);
            this.btnBegin.setEnabled(false);
            this.btnStart.setEnabled(false);
            this.btnSetup.setEnabled(false);
            this.btnStep.setEnabled(false);
            this.btnPause.setEnabled(false);
            this.btnStop.setEnabled(false);
            this.btnLoad.setEnabled(true);
            this.btnSettings.setEnabled(false);
        }
    }

    private void addListeners() {
        this.btnMultRunsStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Controller.this.parameterFilePanel == null) {
                    Controller.this.initParamFileOptions();
                }
                Controller.this.startMultRunsSim();
            }
        });
        this.btnStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.startSim();
            }
        });
        this.btnBegin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.beginModel();
            }
        });
        this.btnLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.loadModel();
            }
        });
        this.btnPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.pauseSim();
            }
        });
        this.btnSetup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.setup();
                Controller.this.setSettingsEnabled(true);
            }
        });
        this.btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.stopSim();
            }
        });
        this.btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.exitSim();
            }
        });
        this.btnStep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.stepSim();
            }
        });
        this.btnSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.showSettings();
            }
        });
        this.tbFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (Controller.this.exitOnExit) {
                    Controller.this.exitSim();
                } else {
                    Controller.this.shutdown();
                }
            }
        });
    }

    protected void initParamFileOptions() {
        if (this.parameterFilePanel == null) {
            this.parameterFilePanel = new RepastParamPanel(this.model);
            this.toolBar.add((Component)this.parameterFilePanel, 3);
            int n = this.tbFrame.getWidth();
            this.tbFrame.pack();
            this.tbFrame.setLocation(this.tbFrame.getX() - (this.tbFrame.getWidth() - n), this.tbFrame.getY());
        }
    }

    protected void startMultRunsSim() {
        this.btnBegin.setEnabled(false);
        this.btnStart.setEnabled(false);
        this.btnStep.setEnabled(false);
        this.btnSetup.setEnabled(false);
        this.btnPause.setEnabled(false);
        this.btnSettings.setEnabled(false);
        this.btnStop.setEnabled(true);
        this.btnLoad.setEnabled(false);
        this.setSettingsEnabled(false);
        String string = this.parameterFilePanel.getParameterFileName();
        if (string != null) {
            this.tickCount.setText(" Tick Count: 0");
            if (this.settingsFrame != null) {
                this.settingsFrame.dispose();
            }
            this.runCountLabel.setText(" Run: 1       ");
            this.runBatch(string);
        } else {
            this.stopSim();
            SimUtilities.showMessage("You must select a parameter file to perform a Multi-Run\nChoose a parameter file, or use the parameter wizard to build one, or press setup to reset.");
        }
    }

    private void runBatch(String string) {
        try {
            if (AbstractGUIController.CONSOLE_ERR | AbstractGUIController.CONSOLE_OUT) {
                try {
                    if (this.console != null) {
                        this.console.dispose();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.console = null;
                this.console = new RepastConsole(AbstractGUIController.CONSOLE_OUT, AbstractGUIController.CONSOLE_ERR);
                this.console.display();
            }
            ParameterSetter parameterSetter = ParameterSetterFactory.createParameterSetter(string);
            this.batchController = new BatchController(parameterSetter);
            this.batchController.setModel(this.getModel());
            this.model.setController(this.batchController);
            this.model.removeSimEventListener(this);
            BatchRunHandler batchRunHandler = new BatchRunHandler();
            this.batchController.setExitOnExit(false);
            this.batchController.addBatchListener(batchRunHandler);
            Thread thread = new Thread(){

                public void run() {
                    Controller.this.batchController.begin();
                }
            };
            thread.start();
            this.model.setup();
            this.btnStop.addActionListener(batchRunHandler);
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error loading parameter file", iOException);
        }
    }

    private void loadModel() {
        super.showLoadModelDialog(this.tbFrame);
        this.resetParamPanel();
    }

    public void startSim() {
        this.enableManipulation(true);
        this.btnMultRunsStart.setEnabled(false);
        this.btnBegin.setEnabled(false);
        this.btnStart.setEnabled(false);
        this.btnStep.setEnabled(false);
        this.btnSetup.setEnabled(false);
        this.btnPause.setEnabled(true);
        this.btnStop.setEnabled(true);
        this.btnLoad.setEnabled(false);
        this.setSettingsEnabled(false);
        super.startSim();
    }

    public void stopSim() {
        this.btnMultRunsStart.setEnabled(true);
        this.btnSetup.setEnabled(true);
        this.btnStep.setEnabled(false);
        this.btnStart.setEnabled(false);
        this.btnPause.setEnabled(false);
        this.btnStop.setEnabled(false);
        this.btnLoad.setEnabled(true);
        super.stopSim();
    }

    public void shutdown() {
        super.shutdown();
        this.settingsFrame.dispose();
        this.tbFrame.dispose();
    }

    public void showSettings() {
        if (this.settingsFrame == null) {
            this.setupParamFrame();
        } else if (!this.settingsFrame.isVisible()) {
            this.settingsFrame.setVisible(true);
        } else if (this.settingsFrame.getState() == 1) {
            this.settingsFrame.setState(0);
        } else {
            this.settingsFrame.requestFocus();
        }
    }

    public void stepSim() {
        super.stepSim();
        this.setSettingsEnabled(false);
        this.btnStop.setEnabled(true);
        this.btnSetup.setEnabled(false);
        this.btnLoad.setEnabled(false);
    }

    public void beginModel() {
        this.btnMultRunsStart.setEnabled(false);
        this.btnBegin.setEnabled(false);
        if (this.model != null) {
            super.beginModel();
            this.executeBegin = false;
        }
    }

    public void pauseSim() {
        super.pauseSim();
        this.btnStart.setEnabled(true);
        this.btnPause.setEnabled(false);
        this.btnStep.setEnabled(true);
    }

    private void removeCustomListeners() {
        int n;
        for (n = 0; n < this.listeners.size(); ++n) {
            this.btnStart.removeActionListener((ActionListener)this.listeners.get(n));
            this.btnStop.removeActionListener((ActionListener)this.listeners.get(n));
            this.btnStep.removeActionListener((ActionListener)this.listeners.get(n));
            this.btnPause.removeActionListener((ActionListener)this.listeners.get(n));
            this.btnExit.removeActionListener((ActionListener)this.listeners.get(n));
        }
        this.listeners.clear();
        for (n = 0; n < this.keyListeners.size(); ++n) {
            this.tbFrame.removeKeyListener((KeyListener)this.keyListeners.get(n));
        }
        this.keyListeners.clear();
    }

    public void setup() {
        this.removeCustomListeners();
        super.setup();
        this.btnMultRunsStart.setEnabled(false);
        this.btnStart.setEnabled(true);
        this.btnStep.setEnabled(true);
        this.tickCount.setText(" Tick Count: 0.0                ");
        this.runCountLabel.setText(" Run: 1       ");
        this.tickCount.setEnabled(true);
        this.btnBegin.setEnabled(true);
        this.setupParamFrame();
        this.tabPane.setSelectedIndex(0);
        ProbeUtilities.closeAllProbeWindows();
    }

    protected void onTickCountUpdate() {
        this.tickCount.setText(" Tick Count: " + String.valueOf(this.time));
        if (UPDATE_PROBES) {
            ProbeUtilities.updateProbePanels();
        }
    }

    public void display() {
        this.isGui = true;
        this.tbFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.tbFrame.getWidth();
        int n2 = dimension.width - n;
        this.tbFrame.setLocation(n2, 10);
        this.tbFrame.setVisible(true);
        if (this.model != null) {
            if (this.params != null) {
                this.setParameters();
            }
            this.setupParamFrame();
        }
    }

    private void setupParamFrame() {
        if (this.settingsFrame == null) {
            this.settingsFrame = new JFrame();
            this.settingsFrame.setIconImage(new ImageIcon((class$uchicago$src$sim$engine$Controller == null ? (class$uchicago$src$sim$engine$Controller = Controller.class$("uchicago.src.sim.engine.Controller")) : class$uchicago$src$sim$engine$Controller).getResource("/uchicago/src/sim/images/RepastSmall.gif")).getImage());
            this.tabPane = new JTabbedPane();
            Container container = this.settingsFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this.tabPane, "Center");
            this.settingsFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Controller.this.settingsFrame.dispose();
                }
            });
            this.addParamPanel();
            this.addActionPanel();
            this.addRepastPanel();
            this.settingsFrame.pack();
            Dimension dimension = this.settingsFrame.getSize();
            if (dimension.width < 240) {
                this.settingsFrame.setSize(240, dimension.height);
            }
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = this.settingsFrame.getWidth();
            int n2 = this.tbFrame.getHeight();
            int n3 = dimension2.width - n;
            int n4 = this.tbFrame.getLocation().y;
            int n5 = n4 + n2 + 10;
            if (dimension.height > dimension2.height - 150) {
                this.settingsFrame.setSize(this.settingsFrame.getSize().width, dimension2.height - 150);
            }
            this.settingsFrame.setLocation(n3, n5);
        } else {
            this.modelPanel.reset();
            this.simPanel.reset();
            this.addActionPanel();
        }
        this.settingsFrame.setVisible(true);
        this.settingsFrame.setTitle(this.model.getName() + " Settings");
    }

    private void addParamPanel() {
        try {
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            Border border = BorderFactory.createEtchedBorder();
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            ProbeUtilities.clearProbePanels();
            jPanel.add((Component)jScrollPane, "Center");
            if (this.model.getInitParam() != null) {
                this.modelPanel = super.getModelParameterPanel();
                this.modelPanel.setBorder(BorderFactory.createTitledBorder(border, "Model Parameters"));
                jPanel2.add((Component)this.modelPanel, "North");
            }
            this.modelPanel.getBeanBowlButton().setText("Inspect Model");
            this.simPanel = super.getRepastParameterPanel();
            this.simPanel.setBorder(BorderFactory.createTitledBorder(border, "RePast Parameters"));
            jPanel2.add((Component)this.simPanel, "South");
            this.tabPane.insertTab("Parameters", null, jPanel, null, 0);
        }
        catch (Exception exception) {
            SimUtilities.showError("Unable to display model parameters", exception);
            exception.printStackTrace();
            System.exit(0);
        }
    }

    private void resetParamPanel() {
        if (this.modelPanel != null) {
            this.tabPane.remove(0);
            this.addParamPanel();
            this.settingsFrame.pack();
        }
    }

    private void addRepastPanel() {
        this.repastPanel.clear();
        this.repastPanel.addButton("Make Movie", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.showMakeMovieDialog(Controller.this.tbFrame);
            }
        });
        this.repastPanel.addButton("Take Snapshot", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Action action = Controller.this.showSnapshotDialog(Controller.this.tbFrame);
                if (action != null) {
                    Controller.this.repastPanel.addButton(action);
                    Controller.this.repastPanel.revalidate();
                    Controller.this.settingsFrame.invalidate();
                    Controller.this.settingsFrame.pack();
                    Controller.this.settingsFrame.repaint();
                }
            }
        });
        this.repastPanel.addButton("Create / Edit Charts", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.showChartDialog(Controller.this.tbFrame);
            }
        });
        this.repastPanel.addCheckBox("In Alpha Order", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ALPHA_ORDER = jCheckBox.isSelected();
                Controller.this.modelPanel.setAlphaOrder(ALPHA_ORDER);
                try {
                    Controller.this.modelPanel.redraw();
                }
                catch (Exception exception) {
                    SimUtilities.showError("Error querying parameters", exception);
                    System.exit(0);
                }
            }
        }, ALPHA_ORDER);
        this.repastPanel.addCheckBox("Stdout to Console", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                AbstractGUIController.CONSOLE_OUT = jCheckBox.isSelected();
            }
        }, CONSOLE_OUT);
        this.repastPanel.addCheckBox("Stderr to Console", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                AbstractGUIController.CONSOLE_ERR = jCheckBox.isSelected();
            }
        }, CONSOLE_ERR);
        if (this.tabPane.getTabCount() == 2) {
            this.tabPane.addTab("Repast Actions", this.repastPanel);
        }
        this.repastPanel.addCheckBox("Rng Seed in Defaults", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                DEFAULTS_INCLUDE_RNGSEED = jCheckBox.isSelected();
            }
        }, DEFAULTS_INCLUDE_RNGSEED);
        this.repastPanel.addCheckBox("Update Probes", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                UPDATE_PROBES = jCheckBox.isSelected();
            }
        }, UPDATE_PROBES);
        this.repastPanel.addCheckBox("Show Custom Charts", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                SHOW_CHARTS = jCheckBox.isSelected();
            }
        }, SHOW_CHARTS);
        this.repastPanel.addButton("Set As Default", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.makeCurrentParamsDefault();
            }
        });
        this.repastPanel.addButton("Write Parameters", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.showWriteParamsDialog(Controller.this.tbFrame);
            }
        });
        this.repastPanel.addButton("About", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controller.this.showVersion();
            }
        });
    }

    public JFrame getFrame() {
        return this.tbFrame;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JTabbedPane getTabPane() {
        return this.tabPane;
    }

    private void addActionPanel() {
        if (this.tabPane.getTabCount() > 1) {
            this.tabPane.remove(this.tabPane.getComponentAt(1));
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabPane.insertTab("Custom Actions", null, jPanel, null, 1);
        ModelManipulator modelManipulator = this.model.getModelManipulator();
        modelManipulator.setEnabled(false);
        jPanel.add((Component)modelManipulator.getPanel(), "Center");
    }

    public void addStartListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
        this.btnStart.addActionListener(actionListener);
    }

    public void addStopListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
        this.btnStop.addActionListener(actionListener);
    }

    public void addPauseListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
        this.btnPause.addActionListener(actionListener);
    }

    public void addExitListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
        this.btnExit.addActionListener(actionListener);
    }

    public void addStepListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
        this.btnStep.addActionListener(actionListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListeners.add(keyListener);
        this.tbFrame.addKeyListener(keyListener);
    }

    public void simEventPerformed(SimEvent simEvent) {
        if (simEvent.getId() == 0) {
            this.stopSimulation();
            this.setSettingsEnabled(true);
        } else if (simEvent.getId() == 2) {
            this.exitSimulation();
        } else if (simEvent.getId() == 3) {
            if (this.simPanel != null) {
                this.simPanel.reset();
            }
        } else if (simEvent.getId() == 1) {
            this.pauseSimulation();
            this.setSettingsEnabled(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BatchRunHandler
    implements BatchListener,
    ActionListener {
        int runCount = 1;

        BatchRunHandler() {
        }

        public void batchEventPerformed(BatchEvent batchEvent) {
            if (batchEvent.getType() == BatchEvent.RUN_ENDED) {
                ++this.runCount;
                Controller.this.runCountLabel.setText(" Run: " + this.runCount);
            } else if (batchEvent.getType() == BatchEvent.BATCH_FINISHED) {
                Controller.this.model.addSimEventListener(Controller.this);
                Controller.this.batchController.removeBatchListener(this);
                Controller.this.model.setController(Controller.this);
                Controller.this.stopSim();
                Controller.this.btnStop.removeActionListener(this);
            } else if (batchEvent.getType() == BatchEvent.TICK_CHANGED) {
                Controller.this.tickCount.setText("Tick Count:" + batchEvent.getTick());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == Controller.this.btnStop) {
                Controller.this.batchController.endSim();
            }
        }
    }
}

