/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis.plot;

import cern.colt.map.OpenIntIntHashMap;
import cern.colt.map.OpenIntObjectHashMap;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import ptolemy.plot.EPSGraphics;
import ptolemy.plot.Message;
import uchicago.src.sim.analysis.plot.ZoomListener;

public class RepastPlotBox
extends JPanel {
    private ZoomListener zListener;
    private ArrayList _detailsStrings = new ArrayList();
    protected transient double _yMax = 0.0;
    protected transient double _yMin = 0.0;
    protected transient double _xMax = 0.0;
    protected transient double _xMin = 0.0;
    protected static final transient double _PADDING = 0.05;
    protected transient boolean _xRangeGiven = false;
    protected transient boolean _yRangeGiven = false;
    protected transient boolean _rangesGivenByZooming = false;
    protected double _xlowgiven;
    protected double _xhighgiven;
    protected double _ylowgiven;
    protected double _yhighgiven;
    protected double _xBottom = Double.MAX_VALUE;
    protected double _xTop = -1.7976931348623157E308;
    protected double _yBottom = Double.MAX_VALUE;
    protected double _yTop = -1.7976931348623157E308;
    protected boolean _xlog = false;
    protected boolean _ylog = false;
    protected static final double _LOG10SCALE = 1.0 / Math.log(10.0);
    protected boolean _grid = true;
    protected boolean _wrap = false;
    protected Color _background = Color.white;
    protected Color _foreground = Color.black;
    protected int _topPadding = 10;
    protected int _bottomPadding = 5;
    protected int _rightPadding = 10;
    protected int _leftPadding = 10;
    protected int _ulx = 1;
    protected int _uly = 1;
    protected int _lrx = 100;
    protected int _lry = 100;
    protected double _yscale = 1.0;
    protected double _xscale = 1.0;
    protected boolean _usecolor = true;
    protected static Color[] _colors = new Color[]{new Color(0xFF0000), new Color(255), new Color(43690), new Color(0), new Color(16753920), new Color(5473931), new Color(16744272), new Color(4565791), new Color(9454125), new Color(0xA0A0A0), new Color(0x14FF14)};
    protected OpenIntObjectHashMap dsColorMap = new OpenIntObjectHashMap();
    protected OpenIntIntHashMap dsMarkMap = new OpenIntIntHashMap();
    protected static final int _MAX_MARKS = 10;
    protected int _width = 400;
    protected int _height = 400;
    public URL _documentBase = null;
    private BufferedImage _buffer;
    private String _filespec = null;
    private static final Color _boxColor = Color.darkGray;
    private double _ytickMax = 0.0;
    private double _ytickMin = 0.0;
    private double _xtickMax = 0.0;
    private double _xtickMin = 0.0;
    private int _yExp = 0;
    private int _xExp = 0;
    private double _ytickscale = 0.0;
    private double _xtickscale = 0.0;
    private Font _labelFont = null;
    private Font _superscriptFont = null;
    private Font _titleFont = null;
    private FontMetrics _labelFontMetrics = null;
    private FontMetrics _superscriptFontMetrics = null;
    private FontMetrics _titleFontMetrics = null;
    private transient int _gridCurJuke = 0;
    private transient double _gridBase = 0.0;
    private transient String[] _errorMsg;
    private String _xlabel;
    private String _ylabel;
    private String _title;
    private Vector _legendStrings = new Vector();
    private Vector _legendDatasets = new Vector();
    private Vector _xticks = null;
    private Vector _xticklabels = null;
    private Vector _yticks = null;
    private Vector _yticklabels = null;
    private transient Button _fillButton = null;
    private transient int _zoomx = -1;
    private transient int _zoomy = -1;
    private transient int _zoomxn = -1;
    private transient int _zoomyn = -1;
    private transient boolean _zoomin = false;
    private transient boolean _zoomout = false;
    private transient boolean _drawn = false;
    private transient boolean _zooming = false;
    private static final String _DTD = "<!-- PlotML DTD, created by Edward A. Lee, eal@eecs.berkeley.edu. --><!ELEMENT plot (barGraph | bin | dataset | default | noColor | \n\tnoGrid | title | wrap | xLabel | xLog | xRange | xTicks | yLabel | \n yLog | yRange | yTicks)*>\n  <!ELEMENT barGraph EMPTY>\n    <!ATTLIST barGraph width CDATA #IMPLIED>\n    <!ATTLIST barGraph offset CDATA #IMPLIED>\n  <!ELEMENT bin EMPTY>\n    <!ATTLIST bin width CDATA #IMPLIED>\n    <!ATTLIST bin offset CDATA #IMPLIED>\n  <!ELEMENT dataset (m | move | p | point)*>\n    <!ATTLIST dataset connected (yes | no) #IMPLIED>\n    <!ATTLIST dataset marks (none | dots | points | various) #IMPLIED>\n    <!ATTLIST dataset name CDATA #IMPLIED>\n    <!ATTLIST dataset stems (yes | no) #IMPLIED>\n  <!ELEMENT default EMPTY>\n    <!ATTLIST default connected (yes | no) \"yes\">\n    <!ATTLIST default marks (none | dots | points | various) \"none\">\n    <!ATTLIST default stems (yes | no) \"no\">\n  <!ELEMENT noColor EMPTY>\n  <!ELEMENT noGrid EMPTY>\n  <!ELEMENT title (#PCDATA)>\n  <!ELEMENT wrap EMPTY>\n  <!ELEMENT xLabel (#PCDATA)>\n  <!ELEMENT xLog EMPTY>\n  <!ELEMENT xRange EMPTY>\n    <!ATTLIST xRange min CDATA #REQUIRED>\n    <!ATTLIST xRange max CDATA #REQUIRED>\n  <!ELEMENT xTicks (tick)+>\n  <!ELEMENT yLabel (#PCDATA)>\n  <!ELEMENT yLog EMPTY>\n  <!ELEMENT yRange EMPTY>\n    <!ATTLIST yRange min CDATA #REQUIRED>\n    <!ATTLIST yRange max CDATA #REQUIRED>\n  <!ELEMENT yTicks (tick)+>\n    <!ELEMENT tick EMPTY>\n      <!ATTLIST tick label CDATA #REQUIRED>\n      <!ATTLIST tick position CDATA #REQUIRED>\n    <!ELEMENT m EMPTY>\n      <!ATTLIST m x CDATA #IMPLIED>\n      <!ATTLIST m x CDATA #REQUIRED>\n      <!ATTLIST m lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST m highErrorBar CDATA #IMPLIED>\n    <!ELEMENT move EMPTY>\n      <!ATTLIST move x CDATA #IMPLIED>\n      <!ATTLIST move x CDATA #REQUIRED>\n      <!ATTLIST move lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST move highErrorBar CDATA #IMPLIED>\n    <!ELEMENT p EMPTY>\n      <!ATTLIST p x CDATA #IMPLIED>\n      <!ATTLIST p x CDATA #REQUIRED>\n      <!ATTLIST p lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST p highErrorBar CDATA #IMPLIED>\n    <!ELEMENT point EMPTY>\n      <!ATTLIST point x CDATA #IMPLIED>\n      <!ATTLIST point x CDATA #REQUIRED>\n      <!ATTLIST point lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST point highErrorBar CDATA #IMPLIED>";

    public RepastPlotBox(ZoomListener zoomListener) {
        super(false);
        this.setLayout(new FlowLayout(2));
        this.addMouseListener(new PtZoomListener());
        this.addKeyListener(new CommandListener());
        this.addMouseMotionListener(new DragListener());
        this._measureFonts();
        this.requestFocus();
        this.zListener = zoomListener;
    }

    public void addLegend(int n, String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this._legendStrings.addElement(string);
        this._legendDatasets.addElement(new Integer(n));
        int n2 = n % _colors.length;
        this.dsColorMap.put(n, (Object)_colors[n2]);
        this.dsMarkMap.put(n, n % 10);
    }

    public void addLegend(int n, String string, Color color) {
        this.addLegend(n, string);
        this.dsColorMap.put(n, (Object)color);
    }

    public void addLegend(int n, String string, int n2) {
        this.addLegend(n, string);
        this.dsMarkMap.put(n, n2);
    }

    public void addLegend(int n, String string, Color color, int n2) {
        this.addLegend(n, string);
        this.dsColorMap.put(n, (Object)color);
        this.dsMarkMap.put(n, n2);
    }

    public void addDetailString(String string) {
        this._detailsStrings.add(string);
    }

    public void clearDetailStrings() {
        this._detailsStrings.clear();
    }

    public void addXTick(String string, double d) {
        if (this._xticks == null) {
            this._xticks = new Vector();
            this._xticklabels = new Vector();
        }
        this._xticks.addElement(new Double(d));
        this._xticklabels.addElement(string);
    }

    public void updateXTick(String string, double d, int n) {
        if (this._xticks == null) {
            this._xticks = new Vector();
            this._xticklabels = new Vector();
        }
        if (this._xticks.size() > n) {
            this._xticks.removeElementAt(n);
            this._xticklabels.removeElementAt(n);
        }
        this._xticks.insertElementAt(new Double(d), n);
        this._xticklabels.insertElementAt(string, n);
    }

    public void addYTick(String string, double d) {
        if (this._yticks == null) {
            this._yticks = new Vector();
            this._yticklabels = new Vector();
        }
        this._yticks.addElement(new Double(d));
        this._yticklabels.addElement(string);
    }

    public synchronized void clear(boolean bl) {
        this._xBottom = Double.MAX_VALUE;
        this._xTop = -1.7976931348623157E308;
        this._yBottom = Double.MAX_VALUE;
        this._yTop = -1.7976931348623157E308;
        if (bl) {
            this._yMax = 0.0;
            this._yMin = 0.0;
            this._xMax = 0.0;
            this._xMin = 0.0;
            this._xRangeGiven = false;
            this._yRangeGiven = false;
            this._rangesGivenByZooming = false;
            this._xlog = false;
            this._ylog = false;
            this._grid = true;
            this._wrap = false;
            this._usecolor = true;
            this._filespec = null;
            this._xlabel = null;
            this._ylabel = null;
            this._title = null;
            this._legendStrings = new Vector();
            this._legendDatasets = new Vector();
            this._xticks = null;
            this._xticklabels = null;
            this._yticks = null;
            this._yticklabels = null;
        }
    }

    public void export(OutputStream outputStream) {
        EPSGraphics ePSGraphics = new EPSGraphics(outputStream, this._width, this._height);
        this._drawPlot((Graphics)ePSGraphics, false);
        ePSGraphics.showpage();
    }

    public synchronized void fillPlot() {
        this._setXRange(this._xBottom, this._xTop);
        this._setYRange(this._yBottom, this._yTop);
        this.repaint();
    }

    public boolean getColor() {
        return this._usecolor;
    }

    public static Color getColorByName(String string) {
        try {
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            Color color = new Color(Integer.parseInt(string, 16));
            return color;
        }
        catch (NumberFormatException numberFormatException) {
            String[][] stringArrayArray = new String[][]{{"black", "00000"}, {"white", "ffffff"}, {"red", "ff0000"}, {"green", "00ff00"}, {"blue", "0000ff"}};
            for (int i = 0; i < stringArrayArray.length; ++i) {
                if (!string.equals(stringArrayArray[i][0])) continue;
                try {
                    Color color = new Color(Integer.parseInt(stringArrayArray[i][1], 16));
                    return color;
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public String getDataurl() {
        return this._filespec;
    }

    public URL getDocumentBase() {
        return this._documentBase;
    }

    public boolean getGrid() {
        return this._grid;
    }

    public String getLegend(int n) {
        int n2 = this._legendDatasets.indexOf(new Integer(n), 0);
        if (n2 != -1) {
            return (String)this._legendStrings.elementAt(n2);
        }
        return null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this._width, this._height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this._width, this._height);
    }

    public String getTitle() {
        if (this._title == null) {
            return "";
        }
        return this._title;
    }

    public String getXLabel() {
        return this._xlabel;
    }

    public boolean getXLog() {
        return this._xlog;
    }

    public double[] getXRange() {
        double[] dArray = new double[2];
        if (this._xRangeGiven) {
            dArray[0] = this._xlowgiven;
            dArray[1] = this._xhighgiven;
        } else {
            dArray[0] = this._xMin + (this._xMax - this._xMin) * 0.05;
            dArray[1] = this._xMax - (this._xMax - this._xMin) * 0.05;
        }
        return dArray;
    }

    public Vector[] getXTicks() {
        if (this._xticks == null) {
            return null;
        }
        Vector[] vectorArray = new Vector[]{this._xticks, this._xticklabels};
        return vectorArray;
    }

    public String getYLabel() {
        return this._ylabel;
    }

    public boolean getYLog() {
        return this._ylog;
    }

    public double[] getYRange() {
        double[] dArray = new double[2];
        if (this._yRangeGiven) {
            dArray[0] = this._ylowgiven;
            dArray[1] = this._yhighgiven;
        } else {
            dArray[0] = this._yMin + (this._yMax - this._yMin) * 0.05;
            dArray[1] = this._yMax - (this._yMax - this._yMin) * 0.05;
        }
        return dArray;
    }

    public Vector[] getYTicks() {
        if (this._yticks == null) {
            return null;
        }
        Vector[] vectorArray = new Vector[]{this._yticks, this._yticklabels};
        return vectorArray;
    }

    public void init() {
        this.setButtons(true);
        if (this._filespec != null) {
            this.parseFile(this._filespec, this._documentBase);
        }
    }

    public void paint(Graphics graphics) {
        if (this._buffer == null) {
            this._buffer = this.getGraphicsConfiguration().createCompatibleImage(this._width, this._height);
        }
        Graphics2D graphics2D = this._buffer.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this._drawPlot(graphics2D, true);
        graphics.drawImage(this._buffer, 0, 0, null);
    }

    public void parseFile(String string) {
        this.parseFile(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile(String string, URL uRL) {
        Object object;
        DataInputStream dataInputStream = null;
        if (string == null || string.length() == 0) {
            dataInputStream = new DataInputStream(System.in);
        } else {
            try {
                object = null;
                if (uRL == null && this._documentBase != null) {
                    uRL = this._documentBase;
                }
                if (uRL == null) {
                    object = new URL(string);
                } else {
                    try {
                        object = new URL(uRL, string);
                    }
                    catch (NullPointerException nullPointerException) {
                        object = new URL(string);
                    }
                }
                dataInputStream = new DataInputStream(((URL)object).openStream());
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    dataInputStream = new DataInputStream(new FileInputStream(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this._errorMsg = new String[2];
                    this._errorMsg[0] = "File not found: " + string;
                    this._errorMsg[1] = fileNotFoundException.getMessage();
                    return;
                }
                catch (SecurityException securityException) {
                    this._errorMsg = new String[2];
                    this._errorMsg[0] = "Security Exception: " + string;
                    this._errorMsg[1] = securityException.getMessage();
                    return;
                }
            }
            catch (IOException iOException) {
                this._errorMsg = new String[3];
                this._errorMsg[0] = "Failure opening URL: ";
                this._errorMsg[1] = " " + string;
                this._errorMsg[2] = iOException.getMessage();
                return;
            }
        }
        try {
            object = new BufferedReader(new InputStreamReader(dataInputStream));
            String string2 = ((BufferedReader)object).readLine();
            while (string2 != null) {
                this._parseLine(string2);
                string2 = ((BufferedReader)object).readLine();
            }
        }
        catch (MalformedURLException malformedURLException) {
            this._errorMsg = new String[2];
            this._errorMsg[0] = "Malformed URL: " + string;
            this._errorMsg[1] = malformedURLException.getMessage();
            return;
        }
        catch (IOException iOException) {
            this._errorMsg = new String[2];
            this._errorMsg[0] = "Failure reading data: " + string;
            this._errorMsg[1] = iOException.getMessage();
            this._errorMsg[1] = iOException.getMessage();
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream inputStream) throws IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    this._parseLine(string);
                    string = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            this._errorMsg = new String[2];
            this._errorMsg[0] = "Failure reading input data.";
            this._errorMsg[1] = iOException.getMessage();
            throw iOException;
        }
    }

    public void read(String string) {
        this._parseLine(string);
    }

    public void samplePlot() {
    }

    public void setBackground(Color color) {
        this._background = color;
        super.setBackground(this._background);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this._width = n3;
        this._height = n4;
        this._buffer = null;
        super.setBounds(n, n2, this._width, this._height);
    }

    public void setButtons(boolean bl) {
        if (this._fillButton == null) {
            this._fillButton = new Button("fill");
            this._fillButton.addActionListener(new FillButtonListener());
            this.add(this._fillButton);
        }
        this._fillButton.setVisible(bl);
        this.requestFocus();
    }

    public void setColor(boolean bl) {
        this._usecolor = bl;
    }

    public void setDataurl(String string) {
        this._filespec = string;
    }

    public void setDocumentBase(URL uRL) {
        this._documentBase = uRL;
    }

    public void setForeground(Color color) {
        this._foreground = color;
        super.setForeground(this._foreground);
    }

    public void setGrid(boolean bl) {
        this._grid = bl;
    }

    public void setLabelFont(String string) {
        this._labelFont = Font.decode(string);
        this._labelFontMetrics = this.getFontMetrics(this._labelFont);
    }

    public void setSize(int n, int n2) {
        this._width = n;
        this._height = n2;
        this._buffer = null;
        super.setSize(n, n2);
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public void setTitleFont(String string) {
        this._titleFont = Font.decode(string);
        this._titleFontMetrics = this.getFontMetrics(this._titleFont);
    }

    public void setWrap(boolean bl) {
        this._wrap = bl;
    }

    public void setXLabel(String string) {
        this._xlabel = string;
    }

    public void setXLog(boolean bl) {
        this._xlog = bl;
    }

    public void setXRange(double d, double d2) {
        this._xRangeGiven = true;
        this._xlowgiven = d;
        this._xhighgiven = d2;
        this._setXRange(d, d2);
    }

    public void setYLabel(String string) {
        this._ylabel = string;
    }

    public void setYLog(boolean bl) {
        this._ylog = bl;
    }

    public void setYRange(double d, double d2) {
        this._yRangeGiven = true;
        this._ylowgiven = d;
        this._yhighgiven = d2;
        this._setYRange(d, d2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void write(OutputStream outputStream) {
        this.write(outputStream, null);
    }

    public void write(OutputStream outputStream, String string) {
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(outputStream), false);
        if (string == null) {
            printWriter.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
            printWriter.println("<!DOCTYPE plot [");
            printWriter.println(_DTD);
            printWriter.println("]>");
        } else {
            printWriter.println("<?xml version=\"1.0\" standalone=\"no\"?>");
            printWriter.println("<!DOCTYPE plot SYSTEM \"" + string + "\">");
        }
        printWriter.println("<plot>");
        printWriter.println("<!-- Ptolemy plot, version 3.1, PlotML format. -->");
        this._write(printWriter);
        printWriter.println("</plot>");
        printWriter.flush();
        if (outputStream != System.out) {
            printWriter.close();
        }
    }

    public void writeOldSyntax(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(outputStream), false);
        this._writeOldSyntax(printWriter);
        printWriter.flush();
        if (outputStream != System.out) {
            printWriter.close();
        }
    }

    public synchronized void zoom(double d, double d2, double d3, double d4) {
        this._setXRange(d, d3);
        this._setYRange(d2, d4);
        this.repaint();
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl) {
        int n;
        int n2;
        int n3;
        double d;
        Object object;
        Object object2;
        int n4;
        Object object3;
        if (graphics == null) {
            throw new RuntimeException("PlotBox._drawPlot: Attempt to draw axes without a Graphics object.");
        }
        Rectangle rectangle = this.getBounds();
        graphics.setPaintMode();
        if (bl) {
            graphics.setColor(super.getBackground());
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics.setColor(Color.black);
        }
        if (this._errorMsg != null) {
            int n5;
            int n6 = n5 = this._labelFontMetrics.getHeight() + 2;
            graphics.setColor(Color.black);
            for (int i = 0; i < this._errorMsg.length; ++i) {
                graphics.drawString(this._errorMsg[i], 10, n6);
                n6 += n5;
                System.err.println(this._errorMsg[i]);
            }
            return;
        }
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this._setXRange(0.0, 0.0);
            } else {
                this._setXRange(this._xBottom, this._xTop);
            }
        }
        if (!this._yRangeGiven) {
            if (this._yBottom > this._yTop) {
                this._setYRange(0.0, 0.0);
            } else {
                this._setYRange(this._yBottom, this._yTop);
            }
        }
        int n7 = 0;
        int n8 = this._titleFontMetrics.getHeight();
        if (this._title == null) {
            this._title = "";
        }
        if (this._title != null || this._yExp != 0) {
            n7 = n8 + this._topPadding;
        }
        graphics.setFont(this._labelFont);
        int n9 = this._labelFontMetrics.getHeight();
        int n10 = n9 / 2;
        int n11 = rectangle.height - 5;
        int n12 = rectangle.width - this._rightPadding;
        if (this._xlog) {
            this._xExp = (int)Math.floor(this._xtickMin);
        }
        if (this._xExp != 0 && this._xticks == null) {
            String string = Integer.toString(this._xExp);
            n12 -= this._superscriptFontMetrics.stringWidth(string);
            graphics.setFont(this._superscriptFont);
            if (!this._xlog) {
                graphics.drawString(string, n12, n11 - n10);
                graphics.setFont(this._labelFont);
                graphics.drawString("x10", n12 -= this._labelFontMetrics.stringWidth("x10"), n11);
            }
            this._bottomPadding = 3 * n9 / 2 + 5;
        }
        if (this._xlabel != null && this._bottomPadding < n9 + 5) {
            this._bottomPadding = n9 + 5;
        }
        this._uly = n7 + 5;
        this._lry = rectangle.height - n9 - this._bottomPadding - 3;
        int n13 = this._lry - this._uly;
        this._yscale = (double)n13 / (this._yMax - this._yMin);
        this._ytickscale = (double)n13 / (this._ytickMax - this._ytickMin);
        int n14 = 2 + n13 / (n9 + 10);
        double d2 = this._roundUp((this._ytickMax - this._ytickMin) / (double)n14);
        double d3 = d2 * Math.ceil(this._ytickMin / d2);
        int n15 = 0;
        String[] stringArray = new String[n14];
        int[] nArray = new int[n14];
        int n16 = 0;
        if (this._yticks == null) {
            object3 = null;
            if (this._ylog) {
                object3 = this._gridInit(d3, d2, true, null);
            }
            n4 = this._numFracDigits(d2);
            double d4 = d3;
            if (this._ylog) {
                d4 = this._gridStep((Vector)object3, d3, d2, this._ylog);
            }
            double d5 = d4;
            while (d5 <= this._ytickMax && n16 < n14) {
                object2 = this._ylog ? this._formatLogNum(d5, n4) : this._formatNum(d5, n4);
                stringArray[n16] = object2;
                int n17 = this._labelFontMetrics.stringWidth((String)object2);
                nArray[n16++] = n17;
                if (n17 > n15) {
                    n15 = n17;
                }
                d5 = this._gridStep((Vector)object3, d5, d2, this._ylog);
            }
        } else {
            object3 = this._yticklabels.elements();
            while (object3.hasMoreElements()) {
                String string = (String)object3.nextElement();
                int n18 = this._labelFontMetrics.stringWidth(string);
                if (n18 <= n15) continue;
                n15 = n18;
            }
        }
        this._ulx = this._ylabel != null ? n15 + this._labelFontMetrics.stringWidth("W") + this._leftPadding : n15 + this._leftPadding;
        int n19 = this._drawLegend(graphics, rectangle.width - this._rightPadding, this._uly);
        this._lrx = rectangle.width - n19 - this._rightPadding;
        n4 = this._lrx - this._ulx;
        this._xscale = (double)n4 / (this._xMax - this._xMin);
        this._xtickscale = (double)n4 / (this._xtickMax - this._xtickMin);
        graphics.setColor(Color.white);
        graphics.fillRect(this._ulx, this._uly, n4, n13);
        graphics.setColor(this._foreground);
        graphics.drawRect(this._ulx, this._uly, n4, n13);
        int n20 = 5;
        int n21 = this._ulx + n20;
        int n22 = this._lrx - n20;
        if (this._yticks == null) {
            object = null;
            double d6 = d3;
            if (this._ylog) {
                object = this._gridInit(d3, d2, true, null);
                d6 = this._gridStep((Vector)object, d3, d2, this._ylog);
                n14 = n16;
            }
            n16 = 0;
            boolean bl2 = this._ylog;
            d = d6;
            while (d <= this._ytickMax && n16 < n14) {
                n3 = this._lry - (int)((d - this._ytickMin) * this._ytickscale);
                int n23 = 0;
                if (n16 > 0 && !this._ylog) {
                    n23 = n10;
                }
                graphics.drawLine(this._ulx, n3, n21, n3);
                graphics.drawLine(this._lrx, n3, n22, n3);
                if (this._grid && n3 != this._uly && n3 != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n21, n3, n22, n3);
                    graphics.setColor(this._foreground);
                }
                if (this._ylog && stringArray[n16].indexOf(101) != -1) {
                    bl2 = false;
                }
                graphics.drawString(stringArray[n16], this._ulx - nArray[n16++] - 4, n3 + n23);
                d = this._gridStep((Vector)object, d, d2, this._ylog);
            }
            if (this._ylog) {
                Vector vector = this._gridInit(d3, d2, false, (Vector)object);
                if (vector.size() > 0) {
                    double d7 = d2 > 1.0 ? 1.0 : d2;
                    double d8 = this._gridStep(vector, d3, d7, this._ylog);
                    while (d8 <= this._ytickMax) {
                        n2 = this._lry - (int)((d8 - this._ytickMin) * this._ytickscale);
                        if (this._grid && n2 != this._uly && n2 != this._lry) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(this._ulx + 1, n2, this._lrx - 1, n2);
                            graphics.setColor(this._foreground);
                        }
                        d8 = this._gridStep(vector, d8, d7, this._ylog);
                    }
                }
                this._yExp = bl2 ? (int)Math.floor(d6) : 0;
            }
            if (this._yExp != 0) {
                graphics.drawString("x10", 2, n7);
                graphics.setFont(this._superscriptFont);
                graphics.drawString(Integer.toString(this._yExp), this._labelFontMetrics.stringWidth("x10") + 2, n7 - n10);
                graphics.setFont(this._labelFont);
            }
        } else {
            object = this._yticks.elements();
            object2 = this._yticklabels.elements();
            while (object2.hasMoreElements()) {
                String string = (String)object2.nextElement();
                double d9 = (Double)object.nextElement();
                if (d9 > this._yMax || d9 < this._yMin) continue;
                int n24 = this._lry - (int)((d9 - this._yMin) * this._yscale);
                n3 = 0;
                if (d9 < (double)(this._lry - n9)) {
                    n3 = n10;
                }
                graphics.drawLine(this._ulx, n24, n21, n24);
                graphics.drawLine(this._lrx, n24, n22, n24);
                if (this._grid && n24 != this._uly && n24 != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n21, n24, n22, n24);
                    graphics.setColor(this._foreground);
                }
                graphics.drawString(string, this._ulx - this._labelFontMetrics.stringWidth(string) - 3, n24 + n3);
            }
        }
        int n25 = this._uly + n20;
        int n26 = this._lry - n20;
        if (this._xticks == null) {
            Object object4;
            int n27 = 10;
            double d10 = 0.0;
            int n28 = 0;
            n3 = this._labelFontMetrics.stringWidth("8");
            if (this._xlog) {
                n27 = 2 + n4 / (n3 * 6 + 10);
            } else {
                int n29 = 0;
                while (n29++ <= 10) {
                    int n30;
                    int n31;
                    d10 = this._roundUp((this._xtickMax - this._xtickMin) / (double)n27);
                    n28 = this._numFracDigits(d10);
                    n = this._numIntDigits(this._xtickMax);
                    if (n < (n2 = this._numIntDigits(this._xtickMin))) {
                        n = n2;
                    }
                    if ((n27 = 2 + n4 / ((n31 = n3 * (n28 + 2 + n)) + 10)) - (n30 = n27) > 1 && n30 - n27 > 1) continue;
                }
            }
            d10 = this._roundUp((this._xtickMax - this._xtickMin) / (double)n27);
            n28 = this._numFracDigits(d10);
            double d11 = d10 * Math.ceil(this._xtickMin / d10);
            Vector vector = null;
            double d12 = d11;
            if (this._xlog) {
                vector = this._gridInit(d11, d10, true, null);
                d12 = this._gridRoundUp(vector, d11);
            }
            boolean bl3 = this._xlog;
            double d13 = d12;
            while (d13 <= this._xtickMax) {
                if (this._xlog) {
                    object4 = this._formatLogNum(d13, n28);
                    if (((String)object4).indexOf(101) != -1) {
                        bl3 = false;
                    }
                } else {
                    object4 = this._formatNum(d13, n28);
                }
                n21 = this._ulx + (int)((d13 - this._xtickMin) * this._xtickscale);
                graphics.drawLine(n21, this._uly, n21, n25);
                graphics.drawLine(n21, this._lry, n21, n26);
                if (this._grid && n21 != this._ulx && n21 != this._lrx) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n21, n25, n21, n26);
                    graphics.setColor(this._foreground);
                }
                int n32 = n21 - this._labelFontMetrics.stringWidth((String)object4) / 2;
                graphics.drawString((String)object4, n32, this._lry + 3 + n9);
                d13 = this._gridStep(vector, d13, d10, this._xlog);
            }
            if (this._xlog) {
                d13 = d10 > 1.0 ? 1.0 : d10;
                d12 = d13 * Math.ceil(this._xtickMin / d13);
                object4 = this._gridInit(d12, d13, false, vector);
                if (((Vector)object4).size() > 0) {
                    double d14 = this._gridStep((Vector)object4, d12, d13, this._xlog);
                    while (d14 <= this._xtickMax) {
                        n21 = this._ulx + (int)((d14 - this._xtickMin) * this._xtickscale);
                        if (this._grid && n21 != this._ulx && n21 != this._lrx) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(n21, this._uly + 1, n21, this._lry - 1);
                            graphics.setColor(this._foreground);
                        }
                        d14 = this._gridStep((Vector)object4, d14, d13, this._xlog);
                    }
                }
                if (bl3) {
                    this._xExp = (int)Math.floor(d12);
                    graphics.setFont(this._superscriptFont);
                    graphics.drawString(Integer.toString(this._xExp), n12, n11 - n10);
                    graphics.setFont(this._labelFont);
                    graphics.drawString("x10", n12 -= this._labelFontMetrics.stringWidth("x10"), n11);
                } else {
                    this._xExp = 0;
                }
            }
        } else {
            Enumeration enumeration = this._xticks.elements();
            Enumeration enumeration2 = this._xticklabels.elements();
            d = 0.0;
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                double d15 = (Double)enumeration.nextElement();
                if (d15 > this._xMax || d15 < this._xMin || !((double)(n2 = (n21 = this._ulx + (int)((d15 - this._xMin) * this._xscale)) - this._labelFontMetrics.stringWidth(string) / 2) > d)) continue;
                d = n21 + this._labelFontMetrics.stringWidth(string) / 2 + 10;
                graphics.drawString(string, n2, this._lry + 3 + n9);
                graphics.drawLine(n21, this._uly, n21, n25);
                graphics.drawLine(n21, this._lry, n21, n26);
                if (!this._grid || n21 == this._ulx || n21 == this._lrx) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n21, n25, n21, n26);
                graphics.setColor(this._foreground);
            }
        }
        graphics.setColor(this._foreground);
        if (this._title != null) {
            graphics.setFont(this._titleFont);
            int n33 = this._ulx + (n4 - this._titleFontMetrics.stringWidth(this._title)) / 2;
            graphics.drawString(this._title, n33, n7);
        }
        graphics.setFont(this._labelFont);
        if (this._xlabel != null) {
            int n34 = this._ulx + (n4 - this._labelFontMetrics.stringWidth(this._xlabel)) / 2;
            graphics.drawString(this._xlabel, n34, n11);
        }
        int n35 = 2 + this._labelFontMetrics.stringWidth("W") / 2;
        int n36 = n9;
        if (this._ylabel != null) {
            int n37 = this._ylabel.length();
            int n38 = this._uly + (this._lry - this._uly) / 2 - n37 * n36 / 2 + n36;
            for (int i = 0; i < n37; ++i) {
                String string = this._ylabel.substring(i, i + 1);
                n = this._labelFontMetrics.stringWidth(string);
                graphics.drawString(string, n35 - n / 2, n38);
                n38 += n36;
            }
        }
    }

    protected void _drawPoint(Graphics graphics, int n, long l, long l2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = l2 <= (long)this._lry && l2 >= (long)this._uly && l <= (long)this._lrx && l >= (long)this._ulx;
        if (!bl2 && bl) {
            return;
        }
        graphics.fillRect((int)l - 6, (int)l2 - 6, 6, 6);
    }

    protected void _help() {
        Message message = new Message("Ptolemy plot package\nBy: Edward A. Lee, eal@eecs.berkeley.edu\nand Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 3.1, Build: $Id: RepastPlotBox.java,v 1.10 2004/11/03 19:51:02 jerryvos Exp $\n\nKey bindings:\n   D: dump plot data to standard out\n   E: export plot to standard out (EPS format)\n   F: fill plot\n   H or ?: print help message (this message)\n   Cntr-D or Q: quit\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n", null, null, 24, 60, 3);
        message.setTitle("About Ptolemy Plot Package");
    }

    protected boolean _parseLine(String string) {
        String string2 = new String(string.toLowerCase());
        if (string2.startsWith("#")) {
            return true;
        }
        if (string2.startsWith("titletext:")) {
            this.setTitle(string.substring(10).trim());
            return true;
        }
        if (string2.startsWith("title:")) {
            this.setTitle(string.substring(10).trim());
            return true;
        }
        if (string2.startsWith("xlabel:")) {
            this.setXLabel(string.substring(7).trim());
            return true;
        }
        if (string2.startsWith("ylabel:")) {
            this.setYLabel(string.substring(7).trim());
            return true;
        }
        if (string2.startsWith("xrange:")) {
            int n = string.indexOf(",", 7);
            if (n > 0) {
                String string3 = string.substring(7, n).trim();
                String string4 = string.substring(n + 1).trim();
                try {
                    Double d = new Double(string3);
                    Double d2 = new Double(string4);
                    this.setXRange(d, d2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (string2.startsWith("yrange:")) {
            int n = string.indexOf(",", 7);
            if (n > 0) {
                String string5 = string.substring(7, n).trim();
                String string6 = string.substring(n + 1).trim();
                try {
                    Double d = new Double(string5);
                    Double d3 = new Double(string6);
                    this.setYRange(d, d3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (string2.startsWith("xticks:")) {
            this._parsePairs(string.substring(7), true);
            return true;
        }
        if (string2.startsWith("yticks:")) {
            this._parsePairs(string.substring(7), false);
            return true;
        }
        if (string2.startsWith("xlog:")) {
            this._xlog = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("ylog:")) {
            this._ylog = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("grid:")) {
            this._grid = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("wrap:")) {
            this._wrap = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("color:")) {
            this._usecolor = string2.indexOf("off", 6) < 0;
            return true;
        }
        return false;
    }

    protected void _setButtonsVisibility(boolean bl) {
        this._fillButton.setVisible(bl);
    }

    protected void _write(PrintWriter printWriter) {
        int n;
        int n2;
        if (this._title != null) {
            printWriter.println("<title>" + this._title + "</title>");
        }
        if (this._xlabel != null) {
            printWriter.println("<xLabel>" + this._xlabel + "</xLabel>");
        }
        if (this._ylabel != null) {
            printWriter.println("<yLabel>" + this._ylabel + "</yLabel>");
        }
        if (this._xRangeGiven) {
            printWriter.println("<xRange min=\"" + this._xlowgiven + "\" max=\"" + this._xhighgiven + "\"/>");
        }
        if (this._yRangeGiven) {
            printWriter.println("<yRange min=\"" + this._ylowgiven + "\" max=\"" + this._yhighgiven + "\"/>");
        }
        if (this._xticks != null && this._xticks.size() > 0) {
            printWriter.println("<xTicks>");
            n2 = this._xticks.size() - 1;
            for (n = 0; n <= n2; ++n) {
                printWriter.println("  <tick label=\"" + (String)this._xticklabels.elementAt(n) + "\" position=\"" + (Double)this._xticks.elementAt(n) + "\"/>");
            }
            printWriter.println("</xTicks>");
        }
        if (this._yticks != null && this._yticks.size() > 0) {
            printWriter.println("<yTicks>");
            n2 = this._yticks.size() - 1;
            for (n = 0; n <= n2; ++n) {
                printWriter.println("  <tick label=\"" + (String)this._yticklabels.elementAt(n) + "\" position=\"" + (Double)this._yticks.elementAt(n) + "\"/>");
            }
            printWriter.println("</yTicks>");
        }
        if (this._xlog) {
            printWriter.println("<xLog/>");
        }
        if (this._ylog) {
            printWriter.println("<yLog/>");
        }
        if (!this._grid) {
            printWriter.println("<noGrid/>");
        }
        if (this._wrap) {
            printWriter.println("<wrap/>");
        }
        if (!this._usecolor) {
            printWriter.println("<noColor/>");
        }
    }

    protected void _writeOldSyntax(PrintWriter printWriter) {
        int n;
        int n2;
        printWriter.println("# Ptolemy plot, version 2.0");
        if (this._title != null) {
            printWriter.println("TitleText: " + this._title);
        }
        if (this._xlabel != null) {
            printWriter.println("XLabel: " + this._xlabel);
        }
        if (this._ylabel != null) {
            printWriter.println("YLabel: " + this._ylabel);
        }
        if (this._xRangeGiven) {
            printWriter.println("XRange: " + this._xlowgiven + ", " + this._xhighgiven);
        }
        if (this._yRangeGiven) {
            printWriter.println("YRange: " + this._ylowgiven + ", " + this._yhighgiven);
        }
        if (this._xticks != null && this._xticks.size() > 0) {
            printWriter.print("XTicks: ");
            n2 = this._xticks.size() - 1;
            for (n = 0; n < n2; ++n) {
                printWriter.print("\"" + (String)this._xticklabels.elementAt(n) + "\" " + (Double)this._xticks.elementAt(n) + ", ");
            }
            printWriter.println("\"" + (String)this._xticklabels.elementAt(n2) + "\" " + (Double)this._xticks.elementAt(n2));
        }
        if (this._yticks != null && this._yticks.size() > 0) {
            printWriter.print("YTicks: ");
            n2 = this._yticks.size() - 1;
            for (n = 0; n < n2; ++n) {
                printWriter.print("\"" + (String)this._yticklabels.elementAt(n) + "\" " + (Double)this._yticks.elementAt(n) + ", ");
            }
            printWriter.println("\"" + (String)this._yticklabels.elementAt(n2) + "\" " + (Double)this._yticks.elementAt(n2));
        }
        if (this._xlog) {
            printWriter.println("XLog: on");
        }
        if (this._ylog) {
            printWriter.println("YLog: on");
        }
        if (!this._grid) {
            printWriter.println("Grid: off");
        }
        if (this._wrap) {
            printWriter.println("Wrap: on");
        }
        if (!this._usecolor) {
            printWriter.println("Color: off");
        }
    }

    private int _drawLegend(Graphics graphics, int n, int n2) {
        graphics.setFont(this._labelFont);
        int n3 = this._labelFontMetrics.getHeight();
        Enumeration enumeration = this._legendStrings.elements();
        Enumeration enumeration2 = this._legendDatasets.elements();
        int n4 = n2 + n3;
        int n5 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n6 = (Integer)enumeration2.nextElement();
            if (n6 < 0) continue;
            if (this._usecolor) {
                Color color = (Color)this.dsColorMap.get(n6);
                graphics.setColor(color);
            }
            this._drawPoint(graphics, n6, n - 3, n4 - 3, false);
            graphics.setColor(this._foreground);
            int n7 = this._labelFontMetrics.stringWidth(string);
            if (n7 > n5) {
                n5 = n7;
            }
            graphics.drawString(string, n - 15 - n7, n4);
            n4 += n3;
        }
        int n8 = this._drawDetails(graphics, n, n4, n3);
        if (n8 > n5) {
            n5 = n8;
        }
        return 22 + n5;
    }

    private int _drawDetails(Graphics graphics, int n, int n2, int n3) {
        int n4 = this._detailsStrings.size();
        int n5 = 0;
        if (n4 > 0) {
            int n6 = n2 + n3 + 5;
            for (int i = 0; i < n4; ++i) {
                String string = (String)this._detailsStrings.get(i);
                int n7 = this._labelFontMetrics.stringWidth(string);
                if (n7 > n5) {
                    n5 = n7;
                }
                graphics.drawString(string, n - 12 - n7, n6);
                n6 += n3;
            }
            graphics.drawRect(n - 15 - n5, n2 + 5, n5 + 6, n6 - n2 - n3);
            n5 += 6;
        }
        return n5;
    }

    private String _formatLogNum(double d, int n) {
        int n2 = (int)d;
        String string = n2 >= 0 && n2 < 10 ? "0" + n2 : (n2 < 0 && n2 > -10 ? "-0" + -n2 : Integer.toString(n2));
        string = d >= 0.0 ? (d - (double)((int)d) < 0.001 ? "1e" + string : this._formatNum(Math.pow(10.0, d - (double)((int)d)), n)) : (-d - (double)((int)(-d)) < 0.001 ? "1e" + string : this._formatNum(Math.pow(10.0, d - (double)((int)d)) * 10.0, n));
        return string;
    }

    private String _formatNum(double d, int n) {
        double d2 = 0.5;
        if (d < 0.0) {
            d2 = -0.5;
        }
        String string = Double.toString(d + d2 * Math.pow(10.0, -n));
        int n2 = string.lastIndexOf(".");
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 < 0) {
            if (n <= 0) {
                stringBuffer.append(string);
                return stringBuffer.toString();
            }
            stringBuffer.append(".");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("0");
            }
            return stringBuffer.toString();
        }
        int n3 = n - (string.length() - n2 - 1);
        if (n3 <= 0) {
            int n4 = n2 + n + 1;
            if (n == 0) {
                --n4;
            }
            stringBuffer.append(string.substring(0, n4));
            return stringBuffer.toString();
        }
        stringBuffer.append(string);
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    private Vector _gridInit(double d, double d2, boolean bl, Vector vector) {
        Vector<Double> vector2 = new Vector<Double>(10);
        double d3 = Math.pow(10.0, d2);
        int n = 1;
        if (bl) {
            if (d3 <= 3.5) {
                n = d3 > 2.0 ? 2 : (d3 > 1.26 ? 5 : (d3 > 1.125 ? 10 : (int)Math.rint(1.0 / d2)));
            }
        } else {
            n = d3 > 10.0 ? 1 : (d3 > 3.0 ? 2 : (d3 > 2.0 ? 5 : (d3 > 1.125 ? 10 : 100)));
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d4 = (double)i * 1.0 / (double)n * 10.0;
            double d5 = _LOG10SCALE * Math.log(d4);
            if (d5 == Double.NEGATIVE_INFINITY) {
                d5 = 0.0;
            }
            if (vector != null && n2 < vector.size()) {
                while (n2 < vector.size() && (Double)vector.elementAt(n2) < d5) {
                    ++n2;
                }
                if (n2 < vector.size()) {
                    if (!(Math.abs((Double)vector.elementAt(n2) - d5) > 1.0E-5)) continue;
                    vector2.addElement(new Double(d5));
                    continue;
                }
                vector2.addElement(new Double(d5));
                continue;
            }
            vector2.addElement(new Double(d5));
        }
        this._gridCurJuke = 0;
        if (d == -0.0) {
            d = 0.0;
        }
        this._gridBase = Math.floor(d);
        double d6 = d - this._gridBase;
        this._gridCurJuke = -1;
        while (this._gridCurJuke + 1 < vector2.size() && d6 >= (Double)vector2.elementAt(this._gridCurJuke + 1)) {
            ++this._gridCurJuke;
        }
        return vector2;
    }

    private double _gridRoundUp(Vector vector, double d) {
        int n;
        double d2 = d - Math.floor(d);
        for (n = 0; n < vector.size() && d2 >= (Double)vector.elementAt(n); ++n) {
        }
        if (n >= vector.size()) {
            return d;
        }
        return Math.floor(d) + (Double)vector.elementAt(n);
    }

    private double _gridStep(Vector vector, double d, double d2, boolean bl) {
        if (bl) {
            if (++this._gridCurJuke >= vector.size()) {
                this._gridCurJuke = 0;
                this._gridBase += Math.ceil(d2);
            }
            if (this._gridCurJuke >= vector.size()) {
                return d + d2;
            }
            return this._gridBase + (Double)vector.elementAt(this._gridCurJuke);
        }
        return d + d2;
    }

    private void _measureFonts() {
        if (this._labelFont == null) {
            this._labelFont = new Font("Helvetica", 0, 10);
        }
        if (this._superscriptFont == null) {
            this._superscriptFont = new Font("Helvetica", 0, 9);
        }
        if (this._titleFont == null) {
            this._titleFont = new Font("Helvetica", 1, 14);
        }
        this._labelFontMetrics = this.getFontMetrics(this._labelFont);
        this._superscriptFontMetrics = this.getFontMetrics(this._superscriptFont);
        this._titleFontMetrics = this.getFontMetrics(this._titleFont);
    }

    private int _numFracDigits(double d) {
        int n;
        for (n = 0; n <= 15 && d != Math.floor(d); d *= 10.0, ++n) {
        }
        return n;
    }

    private int _numIntDigits(double d) {
        int n;
        for (n = 0; n <= 15 && (double)((int)d) != 0.0; ++n) {
            d /= 10.0;
        }
        return n;
    }

    private void _parsePairs(String string, boolean bl) {
        if (bl) {
            this._xticks = null;
            this._xticklabels = null;
        } else {
            this._yticks = null;
            this._yticklabels = null;
        }
        int n = 0;
        boolean bl2 = true;
        while (bl2) {
            int n2 = string.indexOf(",", n);
            String string2 = null;
            if (n2 > n) {
                string2 = string.substring(n, n2).trim();
            } else {
                string2 = string.substring(n).trim();
                bl2 = false;
            }
            int n3 = -1;
            int n4 = 0;
            if (string2.startsWith("\"")) {
                n3 = string2.indexOf("\"", 1);
                n4 = 1;
            } else {
                n3 = string2.indexOf(" ");
            }
            if (n3 > 0) {
                String string3 = string2.substring(n4, n3);
                String string4 = string2.substring(n3 + 1).trim();
                try {
                    double d = Double.valueOf(string4);
                    if (bl) {
                        this.addXTick(string3, d);
                    } else {
                        this.addYTick(string3, d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Warning from PlotBox: Unable to parse ticks: " + numberFormatException.getMessage());
                }
            }
            n = n2 + 1;
            n2 = string.indexOf(",", n);
        }
    }

    private double _roundUp(double d) {
        int n;
        if ((d *= Math.pow(10.0, -(n = (int)Math.floor(Math.log(d) * _LOG10SCALE)))) > 5.0) {
            d = 10.0;
        } else if (d > 2.0) {
            d = 5.0;
        } else if (d > 1.0) {
            d = 2.0;
        }
        return d *= Math.pow(10.0, n);
    }

    private void _setXRange(double d, double d2) {
        if (d > d2) {
            d = -1.0;
            d2 = 1.0;
        } else if (d == d2) {
            d -= 1.0;
            d2 += 1.0;
        }
        this._xMin = d - (d2 - d) * 0.05;
        this._xMax = d2 + (d2 - d) * 0.05;
        double d3 = Math.max(Math.abs(this._xMin), Math.abs(this._xMax));
        this._xExp = (int)Math.floor(Math.log(d3) * _LOG10SCALE);
        if (this._xExp > 1 || this._xExp < -1) {
            double d4 = 1.0 / Math.pow(10.0, this._xExp);
            this._xtickMin = this._xMin * d4;
            this._xtickMax = this._xMax * d4;
        } else {
            this._xtickMin = this._xMin;
            this._xtickMax = this._xMax;
            this._xExp = 0;
        }
    }

    private void _setYRange(double d, double d2) {
        if (d > d2) {
            d = -1.0;
            d2 = 1.0;
        } else if (d == d2) {
            d -= 0.1;
            d2 += 0.1;
        }
        this._yMin = d - (d2 - d) * 0.05;
        this._yMax = d2 + (d2 - d) * 0.05;
        double d3 = Math.max(Math.abs(this._yMin), Math.abs(this._yMax));
        this._yExp = (int)Math.floor(Math.log(d3) * _LOG10SCALE);
        if (this._yExp > 1 || this._yExp < -1) {
            double d4 = 1.0 / Math.pow(10.0, this._yExp);
            this._ytickMin = this._yMin * d4;
            this._ytickMax = this._yMax * d4;
        } else {
            this._ytickMin = this._yMin;
            this._ytickMax = this._yMax;
            this._yExp = 0;
        }
    }

    private synchronized void _zoom(int n, int n2) {
        if (this.zListener != null) {
            this.zListener.zoom(n, n2);
        }
        this._zooming = false;
        Graphics graphics = this.getGraphics();
        if (this._zoomin && this._drawn) {
            if (this._zoomxn != -1 || this._zoomyn != -1) {
                int n3 = Math.min(this._zoomx, this._zoomxn);
                int n4 = Math.max(this._zoomx, this._zoomxn);
                int n5 = Math.min(this._zoomy, this._zoomyn);
                int n6 = Math.max(this._zoomy, this._zoomyn);
                graphics.setXORMode(_boxColor);
                graphics.drawRect(n3, n5, n4 - n3, n6 - n5);
                graphics.setPaintMode();
                if (n2 > this._lry) {
                    n2 = this._lry;
                }
                if (n2 < this._uly) {
                    n2 = this._uly;
                }
                if (n > this._lrx) {
                    n = this._lrx;
                }
                if (n < this._ulx) {
                    n = this._ulx;
                }
                if (Math.abs(this._zoomx - n) > 5 && Math.abs(this._zoomy - n2) > 5) {
                    double d = this._xMin + (double)(this._zoomx - this._ulx) / this._xscale;
                    double d2 = this._xMin + (double)(n - this._ulx) / this._xscale;
                    if (d < d2) {
                        this.setXRange(d, d2);
                    } else {
                        this.setXRange(d2, d);
                    }
                    d = this._yMax - (double)(this._zoomy - this._uly) / this._yscale;
                    d2 = this._yMax - (double)(n2 - this._uly) / this._yscale;
                    if (d < d2) {
                        this.setYRange(d, d2);
                    } else {
                        this.setYRange(d2, d);
                    }
                }
                this.repaint();
            }
        } else if (this._zoomout && this._drawn) {
            graphics.setXORMode(_boxColor);
            int n7 = Math.abs(this._zoomx - this._zoomxn);
            int n8 = Math.abs(this._zoomy - this._zoomyn);
            graphics.drawRect(this._zoomx - 15 - n7, this._zoomy - 15 - n8, 30 + n7 * 2, 30 + n8 * 2);
            graphics.setPaintMode();
            double d = (double)Math.abs(this._zoomx - n) / 30.0;
            double d3 = (double)Math.abs(this._zoomy - n2) / 30.0;
            double d4 = this._xMax + (this._xMax - this._xMin) * d;
            double d5 = this._xMin - (this._xMax - this._xMin) * d;
            double d6 = this._yMax + (this._yMax - this._yMin) * d3;
            double d7 = this._yMin - (this._yMax - this._yMin) * d3;
            this.zoom(d5, d7, d4, d6);
        } else if (!this._drawn) {
            this.repaint();
        }
        this._drawn = false;
        this._zoomout = false;
        this._zoomin = false;
        this._zoomy = -1;
        this._zoomx = -1;
        this._zoomyn = -1;
        this._zoomxn = -1;
    }

    private synchronized void _zoomBox(int n, int n2) {
        if (!this._zooming) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        if (this._zoomx != -1 || this._zoomy != -1) {
            if (!this._zoomin && !this._zoomout) {
                if (n2 < this._zoomy) {
                    this._zoomout = true;
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15, this._zoomy - 15, 30, 30);
                } else if (n2 > this._zoomy) {
                    this._zoomin = true;
                }
            }
            if (this._zoomin) {
                int n3;
                int n4;
                int n5;
                int n6;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    n6 = Math.min(this._zoomx, this._zoomxn);
                    n5 = Math.max(this._zoomx, this._zoomxn);
                    n4 = Math.min(this._zoomy, this._zoomyn);
                    n3 = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(n6, n4, n5 - n6, n3 - n4);
                }
                if (n2 > this._zoomy) {
                    this._zoomxn = n;
                    this._zoomyn = n2;
                    n6 = Math.min(this._zoomx, this._zoomxn);
                    n5 = Math.max(this._zoomx, this._zoomxn);
                    n4 = Math.min(this._zoomy, this._zoomyn);
                    n3 = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(n6, n4, n5 - n6, n3 - n4);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            } else if (this._zoomout) {
                int n7;
                int n8;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    n8 = Math.abs(this._zoomx - this._zoomxn);
                    n7 = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - n8, this._zoomy - 15 - n7, 30 + n8 * 2, 30 + n7 * 2);
                }
                if (n2 < this._zoomy) {
                    this._zoomxn = n;
                    this._zoomyn = n2;
                    n8 = Math.abs(this._zoomx - this._zoomxn);
                    n7 = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - n8, this._zoomy - 15 - n7, 30 + n8 * 2, 30 + n7 * 2);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            }
        }
        graphics.setPaintMode();
    }

    private synchronized void _zoomStart(int n, int n2) {
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        this._zoomx = n;
        this._zoomy = n2;
        this._zooming = true;
    }

    public BufferedImage getImage() {
        Dimension dimension = this.getSize();
        BufferedImage bufferedImage = (BufferedImage)this.createImage(dimension.width, dimension.height);
        Graphics graphics = bufferedImage.getGraphics();
        this.paint(graphics);
        graphics.dispose();
        return bufferedImage;
    }

    class CommandListener
    implements KeyListener {
        private boolean _control = false;
        private boolean _shift = false;

        CommandListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 17: {
                    this._control = true;
                    break;
                }
                case 16: {
                    this._shift = true;
                    break;
                }
                case 67: {
                    if (!this._control) break;
                    RepastPlotBox.this.export(null);
                    Message message = new Message("Encapsulated PostScript (EPS) exported to clipboard.", null, null, 1, 60, 3);
                    message.setTitle("Ptolemy Plot Message");
                    break;
                }
                case 68: {
                    if (!this._control && this._shift) {
                        RepastPlotBox.this.write(System.out);
                        Message message = new Message("Plot data sent to standard out.", null, null, 1, 40, 3);
                        message.setTitle("Ptolemy Plot Message");
                    }
                    if (!this._control) break;
                    System.exit(1);
                    break;
                }
                case 69: {
                    if (this._control || !this._shift) break;
                    RepastPlotBox.this.export(System.out);
                    Message message = new Message("Encapsulated PostScript (EPS) exported to standard out.", null, null, 1, 60, 3);
                    message.setTitle("Ptolemy Plot Message");
                    break;
                }
                case 70: {
                    if (this._control || !this._shift) break;
                    RepastPlotBox.this.fillPlot();
                    break;
                }
                case 72: {
                    if (this._control || !this._shift) break;
                    RepastPlotBox.this._help();
                    break;
                }
                case 47: {
                    if (!this._shift) break;
                    RepastPlotBox.this._help();
                    break;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 17: {
                    this._control = false;
                    break;
                }
                case 16: {
                    this._shift = false;
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    public class DragListener
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            RepastPlotBox.this._zoomBox(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    public class PtZoomListener
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 || mouseEvent.getModifiers() == 0) {
                RepastPlotBox.this._zoomStart(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 || mouseEvent.getModifiers() == 0) {
                RepastPlotBox.this._zoom(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class FillButtonListener
    implements ActionListener {
        FillButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RepastPlotBox.this.fillPlot();
        }
    }
}

