/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.awt.Color;
import uchicago.src.sim.analysis.OpenSeqStatistic;
import uchicago.src.sim.analysis.Sequence;
import uchicago.src.sim.analysis.plot.OpenGraph;
import uchicago.src.sim.engine.SimModel;

public class OpenSequenceGraph
extends OpenGraph {
    private OpenSeqStatistic stats;
    private int pointIndex = 0;
    private int sequenceIndex = 0;
    private double xRange;
    private double yRange;
    private PolicyConstant xExpandConst = SHOW_ALL;
    private PolicyConstant yExpandConst = SHOW_ALL;
    private ExpandPolicy xExpand = new ShowAllPointsX();
    private ExpandPolicy yExpand = new ShowAllPointsY();
    public static final PolicyConstant SHOW_ALL = new PolicyConstant(){

        public ExpandPolicy createXPolicy() {
            return new ShowAllPointsX();
        }

        public ExpandPolicy createYPolicy() {
            return new ShowAllPointsY();
        }
    };
    public static final PolicyConstant SHOW_FIRST = new PolicyConstant(){

        public ExpandPolicy createXPolicy() {
            return new ShowFirst();
        }

        public ExpandPolicy createYPolicy() {
            return new ShowFirst();
        }
    };
    public static final PolicyConstant SHOW_LAST = new PolicyConstant(){

        public ExpandPolicy createXPolicy() {
            return new ShowLastX();
        }

        public ExpandPolicy createYPolicy() {
            return new ShowLastY();
        }
    };

    public OpenSequenceGraph(String string, SimModel simModel) {
        super(string);
        this.model = simModel;
        this.stats = new OpenSeqStatistic(simModel);
        this.plot.setMarksStyle("dots");
        this.setXRange(0.0, 200.0);
        this.xRange = this.xMax - this.xMin;
        this.yRange = this.yMax - this.yMin;
    }

    public OpenSequenceGraph(String string, SimModel simModel, String string2, int n) {
        super(string);
        this.model = simModel;
        this.stats = new OpenSeqStatistic(string2, n, string, simModel);
        this.plot.setMarksStyle("dots");
        this.setXRange(0.0, 200.0);
        this.xRange = this.xMax - this.xMin;
        this.yRange = this.yMax - this.yMin;
    }

    public Sequence addSequence(String string, Sequence sequence) {
        Sequence sequence2 = this.stats.addSequence(string, sequence);
        this.plot.addLegend(this.sequenceIndex++, string);
        return sequence2;
    }

    public Sequence createSequence(String string, Object object, String string2) {
        return this.addSequence(string, this.createSequence(object, string2));
    }

    public Sequence addSequence(String string, Sequence sequence, Color color) {
        Sequence sequence2 = this.stats.addSequence(string, sequence);
        this.plot.addLegend(this.sequenceIndex++, string, color);
        return sequence2;
    }

    public Sequence createSequence(String string, Color color, Object object, String string2) {
        return this.addSequence(string, this.createSequence(object, string2), color);
    }

    public Sequence addSequence(String string, Sequence sequence, int n) {
        Sequence sequence2 = this.stats.addSequence(string, sequence);
        this.plot.addLegend(this.sequenceIndex++, string, n);
        return sequence2;
    }

    public Sequence createSequence(String string, int n, Object object, String string2) {
        return this.addSequence(string, this.createSequence(object, string2), n);
    }

    public Sequence addSequence(String string, Sequence sequence, Color color, int n) {
        Sequence sequence2 = this.stats.addSequence(string, sequence);
        this.plot.addLegend(this.sequenceIndex++, string, color, n);
        return sequence2;
    }

    public Sequence createSequence(String string, Color color, int n, Object object, String string2) {
        return this.addSequence(string, this.createSequence(object, string2), color, n);
    }

    public void setXRange(double d, double d2) {
        super.setXRange(d, d2);
        this.xRange = this.xMax - this.xMin;
    }

    public void setYRange(double d, double d2) {
        super.setYRange(d, d2);
        this.yRange = this.yMax - this.yMin;
    }

    public void setXViewPolicy(PolicyConstant policyConstant) {
        this.xExpand = policyConstant.createXPolicy();
        this.xExpandConst = policyConstant;
    }

    public PolicyConstant getXViewPolicy() {
        return this.xExpandConst;
    }

    public void setYViewPolicy(PolicyConstant policyConstant) {
        this.yExpand = policyConstant.createYPolicy();
        this.yExpandConst = policyConstant;
    }

    public PolicyConstant getYViewPolicy() {
        return this.yExpandConst;
    }

    public void setXAutoExpand(boolean bl) {
        if (bl) {
            this.setXViewPolicy(SHOW_ALL);
        } else {
            this.setXViewPolicy(SHOW_FIRST);
        }
    }

    public boolean getXAutoExpand() {
        return this.xExpandConst == SHOW_ALL;
    }

    public void setYAutoExpand(boolean bl) {
        if (bl) {
            this.setYViewPolicy(SHOW_ALL);
        } else {
            this.setYViewPolicy(SHOW_FIRST);
        }
    }

    public boolean getYAutoExpand() {
        return this.yExpandConst == SHOW_ALL;
    }

    public void record() {
        this.stats.record();
    }

    public void updateGraph() {
        int n = this.stats.getXValCount();
        int n2 = this.stats.getSequenceCount();
        for (int i = this.pointIndex; i < n; ++i) {
            double d = this.stats.getXVal(i);
            this.xExpand.expand(d, this);
            for (int j = 0; j < n2; ++j) {
                double d2 = this.stats.getYVal(j, i);
                if (Double.isNaN(d2)) continue;
                this.plot.addPoint(j, d, d2, true);
                this.yExpand.expand(d2, this);
            }
        }
        this.pointIndex = n;
    }

    public void writeToFile() {
        this.stats.writeToFile();
    }

    static interface PolicyConstant {
        public ExpandPolicy createXPolicy();

        public ExpandPolicy createYPolicy();
    }

    static class ShowLastY
    implements ExpandPolicy {
        ShowLastY() {
        }

        public void expand(double d, OpenSequenceGraph openSequenceGraph) {
            double[] dArray = openSequenceGraph.plot.getYRange();
            if (d > dArray[1]) {
                openSequenceGraph.setYRange(d - openSequenceGraph.yRange, d);
                openSequenceGraph.plot.repaint();
            } else if (d < dArray[0]) {
                openSequenceGraph.setYRange(d, d + openSequenceGraph.yRange);
                openSequenceGraph.plot.repaint();
            }
        }
    }

    static class ShowLastX
    implements ExpandPolicy {
        ShowLastX() {
        }

        public void expand(double d, OpenSequenceGraph openSequenceGraph) {
            double[] dArray = openSequenceGraph.plot.getXRange();
            if (d > dArray[1]) {
                openSequenceGraph.setXRange(d - openSequenceGraph.xRange, d);
                openSequenceGraph.plot.repaint();
            }
        }
    }

    static class ShowFirst
    implements ExpandPolicy {
        ShowFirst() {
        }

        public void expand(double d, OpenSequenceGraph openSequenceGraph) {
        }
    }

    static class ShowAllPointsY
    implements ExpandPolicy {
        ShowAllPointsY() {
        }

        public void expand(double d, OpenSequenceGraph openSequenceGraph) {
            double[] dArray = openSequenceGraph.plot.getYRange();
            if (d >= dArray[1]) {
                openSequenceGraph.setYRange(dArray[0], d + openSequenceGraph.yIncr);
                openSequenceGraph.plot.repaint();
            } else if (d <= dArray[0]) {
                openSequenceGraph.setYRange(d - openSequenceGraph.yIncr, dArray[1]);
                openSequenceGraph.plot.repaint();
            }
        }
    }

    static class ShowAllPointsX
    implements ExpandPolicy {
        ShowAllPointsX() {
        }

        public void expand(double d, OpenSequenceGraph openSequenceGraph) {
            double[] dArray = openSequenceGraph.plot.getXRange();
            if (d >= dArray[1]) {
                openSequenceGraph.setXRange(dArray[0], d + openSequenceGraph.xIncr);
                openSequenceGraph.plot.repaint();
            }
        }
    }

    static interface ExpandPolicy {
        public void expand(double var1, OpenSequenceGraph var3);
    }
}

