/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import uchicago.src.sim.analysis.AverageSequence;
import uchicago.src.sim.analysis.ObjectSequence;
import uchicago.src.sim.analysis.PlotModel;
import uchicago.src.sim.analysis.Sequence;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.util.SimUtilities;

public class OpenSeqStatistic
extends PlotModel {
    private ArrayList sequences = new ArrayList();
    Date date = new Date();
    private int lastIndex = -1;

    public OpenSeqStatistic(SimModel simModel) {
        super(simModel);
    }

    public OpenSeqStatistic(String string, int n, String string2, SimModel simModel) {
        super(string, n, string2, simModel);
    }

    public Sequence createSequence(String string, Object object, String string2) {
        ObjectSequence objectSequence = new ObjectSequence(object, string2);
        this.addSequence(string);
        this.sequences.add(new SequenceWrapper(this.sequences.size(), objectSequence));
        return objectSequence;
    }

    public Sequence addSequence(String string, Sequence sequence) {
        this.addSequence(string);
        this.sequences.add(new SequenceWrapper(this.sequences.size(), sequence));
        return sequence;
    }

    public Sequence createAverageSequence(String string, ArrayList arrayList, String string2) {
        AverageSequence averageSequence = new AverageSequence(arrayList, string2);
        this.addSequence(string);
        this.sequences.add(new SequenceWrapper(this.sequences.size(), averageSequence));
        return averageSequence;
    }

    public double getYVal(int n, int n2) {
        SequenceWrapper sequenceWrapper = (SequenceWrapper)this.sequences.get(n);
        if (n2 - sequenceWrapper.startingX < 0) {
            return Double.NaN;
        }
        return super.getYVal(n, n2 - sequenceWrapper.startingX);
    }

    public void record() {
        if (this.sequences.size() != 0) {
            double d = this.model.getTickCount();
            this.addX(d);
            double d2 = 0.0;
            for (int i = 0; i < this.sequences.size(); ++i) {
                SequenceWrapper sequenceWrapper = (SequenceWrapper)this.sequences.get(i);
                if (sequenceWrapper.startingX == -1 && this.getXValCount() == 1) {
                    sequenceWrapper.startingX = 0;
                } else if (sequenceWrapper.startingX == -1) {
                    sequenceWrapper.startingX = this.getXValCount() - 1;
                }
                d2 = sequenceWrapper.sequence.getSValue();
                this.addY(d2, i);
            }
        }
    }

    public void writeToFile() {
        BufferedWriter bufferedWriter = null;
        try {
            if (this.lastIndex == -1) {
                this.renameFile();
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
                String string = DateFormat.getDateTimeInstance().format(this.date);
                bufferedWriter.write(string + "\n");
                bufferedWriter.write(this.model.getPropertiesValues());
                bufferedWriter.write("\n");
                String string2 = "\"tick\"";
                ArrayList arrayList = this.getSequenceNames();
                for (int i = 0; i < arrayList.size(); ++i) {
                    string2 = string2 + ", \"" + (String)arrayList.get(i) + "\"";
                }
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
                this.lastIndex = 0;
            }
            if (bufferedWriter == null) {
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            }
            int n = this.getXValCount();
            int n2 = this.getSequenceCount();
            for (int i = this.lastIndex; i < n; ++i) {
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getXVal(i)));
                for (int j = 0; j < n2; ++j) {
                    stringBuffer.append(", ");
                    double d = this.getYVal(j, i);
                    if (Double.isNaN(d)) continue;
                    stringBuffer.append(this.getYVal(j, i));
                }
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
            this.lastIndex = n;
        }
        catch (IOException iOException) {
            SimUtilities.showError("Unable to write sequence to file", iOException);
            iOException.printStackTrace();
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    class SequenceWrapper {
        int series;
        Sequence sequence;
        boolean suspended = false;
        int startingX = -1;

        public SequenceWrapper(int n, Sequence sequence) {
            this.series = n;
            this.sequence = sequence;
        }

        public boolean equals(Object object) {
            return this.sequence.equals(object);
        }
    }
}

