/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.adaptation.neural;

import org.joone.engine.DirectSynapse;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.net.NeuralNet;
import uchicago.src.sim.adaptation.neural.NeuralException;
import uchicago.src.sim.adaptation.neural.NeuralUtils;

public class RepastNeuralWrapper
implements NeuralNetListener {
    protected NeuralNet net;
    protected int epochsPerIteration = 1;
    protected transient boolean netStopped = true;
    private Object networkRunningMonitor = new Object();

    public RepastNeuralWrapper() {
        this(new NeuralNet());
    }

    public RepastNeuralWrapper(NeuralNet neuralNet) {
        this.net = neuralNet;
        neuralNet.removeAllListeners();
        neuralNet.addNeuralNetListener((NeuralNetListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Pattern retrieve(InputPatternListener inputPatternListener) throws NeuralException {
        TeachingSynapse teachingSynapse = this.net.getTeacher();
        DirectSynapse directSynapse = new DirectSynapse();
        this.net.removeAllInputs();
        this.net.removeAllOutputs();
        this.net.addInputSynapse(inputPatternListener);
        this.net.addOutputSynapse((OutputPatternListener)directSynapse);
        Monitor monitor = this.net.getMonitor();
        monitor.setTrainingPatterns(1);
        monitor.setTotCicles(1);
        monitor.setLearning(false);
        this.net.start();
        if (!(inputPatternListener instanceof DirectSynapse)) {
            this.net.getMonitor().Go();
        }
        Pattern pattern = directSynapse.fwdGet();
        this.net.stop(true);
        if (!(inputPatternListener instanceof DirectSynapse)) {
            this.net.getMonitor().Stop();
        }
        try {
            Object object = this.networkRunningMonitor;
            synchronized (object) {
                while (!this.netStopped) {
                    this.networkRunningMonitor.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new NeuralException("Error waiting for net to stop", interruptedException);
        }
        this.waitTilNetTrulyStops();
        this.net.setTeacher(teachingSynapse);
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void train(InputPatternListener inputPatternListener) throws NeuralException {
        TeachingSynapse teachingSynapse = this.net.getTeacher();
        this.net.removeAllInputs();
        this.net.removeAllOutputs();
        this.net.setTeacher(teachingSynapse);
        this.net.addInputSynapse(inputPatternListener);
        this.net.addOutputSynapse((OutputPatternListener)teachingSynapse);
        this.net.getMonitor().setLearning(true);
        this.net.start();
        this.net.getMonitor().Go();
        try {
            Object object = this.networkRunningMonitor;
            synchronized (object) {
                while (!this.netStopped) {
                    this.networkRunningMonitor.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new NeuralException("Error waiting for net to stop", interruptedException);
        }
        this.waitTilNetTrulyStops();
    }

    private synchronized void waitTilNetTrulyStops() throws NeuralException {
        for (int i = 0; this.net.isRunning() && i < 100; ++i) {
            try {
                Thread.sleep(3L);
                if (i != 50) continue;
                this.net.stop();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.net.isRunning()) {
            throw new NeuralException("Couldn't stop network");
        }
    }

    public synchronized int getEpochsPerIteration() {
        return this.epochsPerIteration;
    }

    public synchronized void setEpochsPerIteration(int n) {
        this.epochsPerIteration = n;
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        this.netStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void netStopped(NeuralNetEvent neuralNetEvent) {
        if (!this.netStopped) {
            this.netStopped = true;
            Object object = this.networkRunningMonitor;
            synchronized (object) {
                this.networkRunningMonitor.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
        System.out.println("STOPPED ON ERROR");
        if (!this.netStopped) {
            this.netStopped = true;
            Object object = this.networkRunningMonitor;
            synchronized (object) {
                this.networkRunningMonitor.notify();
            }
        }
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
    }

    public synchronized NeuralNet getNet() {
        return this.net;
    }

    public synchronized void setNet(NeuralNet neuralNet) {
        this.net = neuralNet;
    }

    public void saveNetToFile(String string) throws NeuralException {
        NeuralUtils.saveNetToFile(this.net, string);
    }
}

