/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.codegen;

import ViolinStrings.Strings;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import uchicago.src.codegen.ArgGenerator;
import uchicago.src.codegen.BodyGenerator;
import uchicago.src.codegen.ClassGenerator;
import uchicago.src.codegen.CodeGenerator;
import uchicago.src.codegen.CompUnitGenerator;
import uchicago.src.codegen.ImportGenerator;
import uchicago.src.codegen.IvarGenerator;
import uchicago.src.codegen.MethodGenerator;

public class GeneratorUtilities {
    public static StringBuffer getBufferWithIndent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        return stringBuffer;
    }

    public static CodeGenerator createCodeGenerator(Node node) {
        String string = node.getNodeName();
        NamedNodeMap namedNodeMap = node.getAttributes();
        CodeGenerator codeGenerator = null;
        if (string.equals("COMP_UNIT")) {
            String string2 = namedNodeMap.getNamedItem("NAME").getNodeValue();
            String string3 = namedNodeMap.getNamedItem("PACKAGE").getNodeValue();
            codeGenerator = new CompUnitGenerator(string2, string3);
        } else if (string.equals("CLASS")) {
            String string4 = namedNodeMap.getNamedItem("ID").getNodeValue();
            String string5 = namedNodeMap.getNamedItem("NAME").getNodeValue();
            codeGenerator = new ImportGenerator(string4, string5);
        } else if (string.equals("CLASS_DEF")) {
            String string6 = namedNodeMap.getNamedItem("NAME").getNodeValue();
            String string7 = namedNodeMap.getNamedItem("SCOPE").getNodeValue();
            String string8 = namedNodeMap.getNamedItem("EXTENDS").getNodeValue();
            String string9 = namedNodeMap.getNamedItem("IMPLEMENTS").getNodeValue();
            string9 = Strings.change((String)string9, (String)" ", (String)", ");
            codeGenerator = new ClassGenerator(string7, string6, string8, string9);
        } else if (string.equals("IVAR")) {
            String string10 = namedNodeMap.getNamedItem("NAME").getNodeValue();
            String string11 = namedNodeMap.getNamedItem("SCOPE").getNodeValue();
            String string12 = "";
            if (namedNodeMap.getNamedItem("VAL") != null) {
                string12 = namedNodeMap.getNamedItem("VAL").getNodeValue();
            }
            String string13 = namedNodeMap.getNamedItem("TYPE").getNodeValue();
            codeGenerator = new IvarGenerator(string11, string10, string13, string12);
        } else if (string.equals("METHOD")) {
            String string14 = namedNodeMap.getNamedItem("NAME").getNodeValue();
            String string15 = namedNodeMap.getNamedItem("SCOPE").getNodeValue();
            String string16 = namedNodeMap.getNamedItem("RETVAL").getNodeValue();
            String string17 = "";
            if (namedNodeMap.getNamedItem("EXP") != null) {
                string17 = namedNodeMap.getNamedItem("EXP").getNodeValue();
            }
            codeGenerator = new MethodGenerator(string15, string14, string16, string17);
        } else if (string.equals("ARG")) {
            String string18 = namedNodeMap.getNamedItem("TYPE").getNodeValue();
            codeGenerator = new ArgGenerator(string, string18);
        } else if (string.equals("BODY")) {
            codeGenerator = new BodyGenerator(node.getNodeValue());
        }
        return codeGenerator;
    }
}

