/*
 * Decompiled with CFR 0.152.
 */
package anl.repast.gis.display;

import anl.repast.gis.display.RepastGeometryOfInterest;
import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.event.GestureResponsePolicy;
import com.bbn.openmap.omGraphics.event.MapMouseInterpreter;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class RepastMapMouseInterpreter
implements MapMouseInterpreter {
    protected boolean DEBUG = false;
    protected OMGraphicHandlerLayer layer = null;
    protected String[] mouseModeServiceList = null;
    protected String lastToolTip = null;
    protected GestureResponsePolicy grp = null;
    protected RepastGeometryOfInterest clickInterest = null;
    protected RepastGeometryOfInterest movementInterest = null;
    protected boolean consumeEvents = false;
    protected boolean noTimerOverOMGraphic = true;
    protected int mouseTimerInterval = 150;
    protected Timer mouseTimer = null;
    protected MouseTimerListener mouseTimerListener = new MouseTimerListener();
    protected MouseEvent currentMouseEvent;

    public RepastMapMouseInterpreter() {
        this.DEBUG = Debug.debugging((String)"grp");
    }

    public RepastMapMouseInterpreter(OMGraphicHandlerLayer oMGraphicHandlerLayer) {
        this();
        this.setLayer(oMGraphicHandlerLayer);
    }

    public void setConsumeEvents(boolean bl) {
        this.consumeEvents = bl;
    }

    public boolean getConsumeEvents() {
        return this.consumeEvents;
    }

    public void setLayer(OMGraphicHandlerLayer oMGraphicHandlerLayer) {
        this.layer = oMGraphicHandlerLayer;
    }

    public OMGraphicHandlerLayer getLayer() {
        return this.layer;
    }

    public void setMouseModeServiceList(String[] stringArray) {
        this.mouseModeServiceList = stringArray;
    }

    public boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isControlDown();
    }

    public String[] getMouseModeServiceList() {
        return this.mouseModeServiceList;
    }

    protected void setClickInterest(RepastGeometryOfInterest repastGeometryOfInterest) {
        this.clickInterest = repastGeometryOfInterest;
    }

    protected RepastGeometryOfInterest getClickInterest() {
        return this.clickInterest;
    }

    protected void setMovementInterest(RepastGeometryOfInterest repastGeometryOfInterest) {
        this.movementInterest = repastGeometryOfInterest;
    }

    protected RepastGeometryOfInterest getMovementInterest() {
        return this.movementInterest;
    }

    public OMGraphic getGeometryUnder(MouseEvent mouseEvent) {
        OMGraphic oMGraphic = null;
        OMGraphicList oMGraphicList = null;
        if (this.layer != null) {
            oMGraphicList = this.layer.getList();
            if (oMGraphicList != null) {
                oMGraphic = oMGraphicList.findClosest(mouseEvent.getX(), mouseEvent.getY(), 4.0f);
            } else if (this.DEBUG) {
                Debug.output((String)"SMMI: no layer to evaluate mouse event");
            }
        } else if (this.DEBUG) {
            Debug.output((String)"SMMI: no layer to evaluate mouse event");
        }
        return oMGraphic;
    }

    public boolean mousePressed(MouseEvent mouseEvent) {
        if (this.DEBUG) {
            Debug.output((String)"SMMI: mousePressed()");
        }
        this.setCurrentMouseEvent(mouseEvent);
        boolean bl = false;
        RepastGeometryOfInterest repastGeometryOfInterest = this.getClickInterest();
        OMGraphic oMGraphic = this.getGeometryUnder(mouseEvent);
        if (repastGeometryOfInterest != null && !repastGeometryOfInterest.appliesTo(oMGraphic, mouseEvent)) {
            if (repastGeometryOfInterest.isLeftButton()) {
                this.leftClickOff(repastGeometryOfInterest.getGeometry(), mouseEvent);
            } else {
                this.rightClickOff(repastGeometryOfInterest.getGeometry(), mouseEvent);
            }
            this.setClickInterest(null);
        }
        if (oMGraphic != null) {
            if (this.isLeftMouseButton(mouseEvent)) {
                this.select(oMGraphic);
            }
            this.setClickInterest(new RepastGeometryOfInterest(oMGraphic, mouseEvent, this));
            bl = true;
        }
        return bl && this.consumeEvents;
    }

    public boolean mouseReleased(MouseEvent mouseEvent) {
        this.setCurrentMouseEvent(mouseEvent);
        return false;
    }

    public boolean mouseClicked(MouseEvent mouseEvent) {
        this.setCurrentMouseEvent(mouseEvent);
        RepastGeometryOfInterest repastGeometryOfInterest = this.getClickInterest();
        if (repastGeometryOfInterest != null) {
            if (this.isLeftMouseButton(mouseEvent)) {
                this.leftClick(repastGeometryOfInterest.getGeometry(), mouseEvent);
            } else {
                this.rightClick(repastGeometryOfInterest.getGeometry(), mouseEvent);
            }
        } else if (this.isLeftMouseButton(mouseEvent)) {
            this.leftClick(mouseEvent);
        } else {
            this.rightClick(mouseEvent);
        }
        return this.consumeEvents;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCurrentMouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCurrentMouseEvent(mouseEvent);
    }

    public boolean mouseDragged(MouseEvent mouseEvent) {
        this.setCurrentMouseEvent(mouseEvent);
        RepastGeometryOfInterest repastGeometryOfInterest = this.getClickInterest();
        if (repastGeometryOfInterest != null) {
            this.setClickInterest(null);
        }
        return this.mouseMoved(mouseEvent) && this.consumeEvents;
    }

    public boolean mouseMoved(MouseEvent mouseEvent) {
        this.setCurrentMouseEvent(mouseEvent);
        if (this.noTimerOverOMGraphic && this.getMovementInterest() != null || this.mouseTimerInterval <= 0) {
            return this.updateMouseMoved(mouseEvent);
        }
        if (this.mouseTimer == null) {
            this.mouseTimer = new Timer(this.mouseTimerInterval, this.mouseTimerListener);
            this.mouseTimer.setRepeats(false);
        }
        this.mouseTimerListener.setEvent(mouseEvent);
        this.mouseTimer.restart();
        return false;
    }

    public void setNoTimerOverOMGraphic(boolean bl) {
        this.noTimerOverOMGraphic = bl;
    }

    public boolean getNoTimerOverOMGraphic() {
        return this.noTimerOverOMGraphic;
    }

    public void setMouseTimerInterval(int n) {
        this.mouseTimerInterval = n;
    }

    public int getMouseTimerInterval() {
        return this.mouseTimerInterval;
    }

    protected boolean updateMouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        OMGraphic oMGraphic = this.getGeometryUnder(mouseEvent);
        RepastGeometryOfInterest repastGeometryOfInterest = this.getMovementInterest();
        if (oMGraphic != null && this.grp != null) {
            if (repastGeometryOfInterest == null || !repastGeometryOfInterest.appliesTo(oMGraphic)) {
                if (repastGeometryOfInterest != null) {
                    this.mouseNotOver(repastGeometryOfInterest.getGeometry());
                }
                repastGeometryOfInterest = new RepastGeometryOfInterest(oMGraphic, mouseEvent, this);
                this.setMovementInterest(repastGeometryOfInterest);
                this.setNoTimerOverOMGraphic(!oMGraphic.shouldRenderFill());
                bl = this.mouseOver(oMGraphic, mouseEvent);
            }
        } else {
            if (repastGeometryOfInterest != null) {
                this.mouseNotOver(repastGeometryOfInterest.getGeometry());
                this.setMovementInterest(null);
            }
            bl = this.mouseOver(mouseEvent);
        }
        return bl && this.consumeEvents;
    }

    public void mouseMoved() {
        RepastGeometryOfInterest repastGeometryOfInterest = this.getMovementInterest();
        if (repastGeometryOfInterest != null) {
            this.mouseNotOver(repastGeometryOfInterest.getGeometry());
            this.setMovementInterest(null);
        }
    }

    public boolean leftClick(MouseEvent mouseEvent) {
        if (this.DEBUG) {
            Debug.output((String)("leftClick(MAP) at " + mouseEvent.getX() + ", " + mouseEvent.getY()));
        }
        if (this.grp != null && this.grp.receivesMapEvents() && mouseEvent instanceof MapMouseEvent) {
            return this.grp.leftClick((MapMouseEvent)mouseEvent);
        }
        return false;
    }

    public boolean leftClick(OMGraphic oMGraphic, MouseEvent mouseEvent) {
        if (this.DEBUG) {
            Debug.output((String)("leftClick(" + oMGraphic.getClass().getName() + ") at " + mouseEvent.getX() + ", " + mouseEvent.getY()));
        }
        return false;
    }

    public boolean leftClickOff(OMGraphic oMGraphic, MouseEvent mouseEvent) {
        if (this.DEBUG) {
            Debug.output((String)("leftClickOff(" + oMGraphic.getClass().getName() + ") at " + mouseEvent.getX() + ", " + mouseEvent.getY()));
        }
        this.deselect(oMGraphic);
        return false;
    }

    public boolean rightClick(MouseEvent mouseEvent) {
        if (this.DEBUG) {
            Debug.output((String)("rightClick(MAP) at " + mouseEvent.getX() + ", " + mouseEvent.getY()));
        }
        if (mouseEvent instanceof MapMouseEvent) {
            return this.displayPopup(this.grp.getItemsForMapMenu((MapMouseEvent)mouseEvent), mouseEvent);
        }
        return false;
    }

    public boolean rightClick(OMGraphic oMGraphic, MouseEvent mouseEvent) {
        if (this.DEBUG) {
            Debug.output((String)("rightClick(" + oMGraphic.getClass().getName() + ") at " + mouseEvent.getX() + ", " + mouseEvent.getY()));
        }
        return this.displayPopup(this.grp.getItemsForOMGraphicMenu(oMGraphic), mouseEvent);
    }

    protected boolean displayPopup(List list, MouseEvent mouseEvent) {
        if (this.DEBUG) {
            Debug.output((String)("displayPopup(" + list + ") " + mouseEvent));
        }
        if (list != null && list.size() > 0) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Component)) continue;
                jPopupMenu.add((Component)e);
            }
            jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }

    public boolean rightClickOff(OMGraphic oMGraphic, MouseEvent mouseEvent) {
        if (this.DEBUG) {
            Debug.output((String)("rightClickOff(" + oMGraphic.getClass().getName() + ") at " + mouseEvent.getX() + ", " + mouseEvent.getY()));
        }
        return false;
    }

    public boolean mouseOver(MouseEvent mouseEvent) {
        if (this.DEBUG) {
            Debug.output((String)("mouseOver(MAP) at " + mouseEvent.getX() + ", " + mouseEvent.getY()));
        }
        if (this.grp != null && this.grp.receivesMapEvents() && mouseEvent instanceof MapMouseEvent) {
            return this.grp.mouseOver((MapMouseEvent)mouseEvent);
        }
        return false;
    }

    public boolean mouseOver(OMGraphic oMGraphic, MouseEvent mouseEvent) {
        if (this.DEBUG) {
            Debug.output((String)("mouseOver(" + oMGraphic.getClass().getName() + ") at " + mouseEvent.getX() + ", " + mouseEvent.getY()));
        }
        if (this.grp != null) {
            this.handleToolTip(this.grp.getToolTipTextFor(oMGraphic));
            this.handleInfoLine(this.grp.getInfoText(oMGraphic));
            if (this.grp.isHighlightable(oMGraphic)) {
                this.grp.highlight(oMGraphic);
            }
        }
        return true;
    }

    protected void handleToolTip(String string) {
        if (this.lastToolTip == string) {
            return;
        }
        this.lastToolTip = string;
        if (this.layer != null) {
            if (this.lastToolTip != null) {
                this.layer.fireRequestToolTip(this.lastToolTip);
            } else {
                this.layer.fireHideToolTip();
            }
        }
    }

    protected void handleInfoLine(String string) {
        if (this.layer != null) {
            this.layer.fireRequestInfoLine(string == null ? "" : string);
        }
    }

    public boolean mouseNotOver(OMGraphic oMGraphic) {
        if (this.DEBUG) {
            Debug.output((String)("mouseNotOver(" + oMGraphic.getClass().getName() + ")"));
        }
        if (this.grp != null) {
            this.grp.unhighlight(oMGraphic);
        }
        this.handleToolTip(null);
        this.handleInfoLine(null);
        return false;
    }

    public void select(OMGraphic oMGraphic) {
        if (this.grp != null && this.grp.isSelectable(oMGraphic)) {
            OMGraphicList oMGraphicList = new OMGraphicList();
            oMGraphicList.add(oMGraphic);
            this.grp.select(oMGraphicList);
        }
    }

    public void deselect(OMGraphic oMGraphic) {
        if (this.grp != null && this.grp.isSelectable(oMGraphic)) {
            OMGraphicList oMGraphicList = new OMGraphicList();
            oMGraphicList.add(oMGraphic);
            this.grp.deselect(oMGraphicList);
        }
    }

    protected void setCurrentMouseEvent(MouseEvent mouseEvent) {
        this.currentMouseEvent = mouseEvent;
    }

    public MouseEvent getCurrentMouseEvent() {
        return this.currentMouseEvent;
    }

    public void setGRP(GestureResponsePolicy gestureResponsePolicy) {
        this.grp = gestureResponsePolicy;
    }

    public GestureResponsePolicy getGRP() {
        return this.grp;
    }

    protected class MouseTimerListener
    implements ActionListener {
        private MouseEvent event;

        protected MouseTimerListener() {
        }

        public synchronized void setEvent(MouseEvent mouseEvent) {
            this.event = mouseEvent;
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            if (this.event != null) {
                RepastMapMouseInterpreter.this.updateMouseMoved(this.event);
            }
        }
    }
}

