/*
 * Decompiled with CFR 0.152.
 */
package anl.repast.gis.display;

import anl.repast.gis.OpenMapAgent;
import anl.repast.gis.data.OpenMapData;
import anl.repast.gis.display.RepastOMLayer;
import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.app.OpenMap;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolyline;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.event.DistanceMouseMode;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.NavMouseMode2;
import com.bbn.openmap.event.NullMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.gui.BasicMapPanel;
import com.bbn.openmap.gui.ControlMenu;
import com.bbn.openmap.gui.GoToMenu;
import com.bbn.openmap.gui.LayerControlButtonPanel;
import com.bbn.openmap.gui.LayersMenu;
import com.bbn.openmap.gui.LayersPanel;
import com.bbn.openmap.gui.MenuBar;
import com.bbn.openmap.gui.MouseModeButtonPanel;
import com.bbn.openmap.gui.MouseModePanel;
import com.bbn.openmap.gui.NavigateMenu;
import com.bbn.openmap.gui.NavigatePanel;
import com.bbn.openmap.gui.OpenMapFrame;
import com.bbn.openmap.gui.ProjectionStackTool;
import com.bbn.openmap.gui.ScaleTextPanel;
import com.bbn.openmap.gui.ToolPanel;
import com.bbn.openmap.gui.ZoomPanel;
import com.bbn.openmap.layer.GraticuleLayer;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.location.LocationLayer;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionStack;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.gui.MediaProducer;
import uchicago.src.sim.gui.MovieMaker;
import uchicago.src.sim.util.SimUtilities;

public class OpenMapDisplay
implements MediaProducer {
    OpenMapFrame frame;
    BasicMapPanel mapPanel;
    MapBean mapBean;
    MapHandler mapHandler;
    ShapeLayer shapeLayer;
    LayerHandler layerHandler;
    Layer[] layers;
    LayersMenu layersMenu;
    LayersPanel layersPanel;
    PropertyHandler propertyHandler;
    OpenMap openMap;
    Color highlightColor;
    GoToMenu goTo;
    private MovieMaker movieMaker;
    private SimModel model;
    private String snapshotFile;

    public OpenMapDisplay() {
        this("");
    }

    public OpenMapDisplay(String string) {
        this(string, new Color(137, 197, 249, 255));
    }

    public OpenMapDisplay(String string, Color color) {
        this(string, new Color(137, 197, 249, 255), false);
    }

    public OpenMapDisplay(String string, Color color, boolean bl) {
        this.setHighlightColor(Color.YELLOW);
        try {
            this.frame = new OpenMapFrame(string);
            this.frame.setSize(800, 600);
            this.frame = new OpenMapFrame(string);
            this.mapPanel = new BasicMapPanel();
            this.mapHandler = this.mapPanel.getMapHandler();
            this.mapHandler.add((Object)this.frame);
            this.mapBean = this.mapPanel.getMapBean();
            this.mapBean.setBackgroundColor(color);
            this.layerHandler = new LayerHandler();
            this.layerHandler.addLayerListener((LayerListener)this.mapBean);
            this.layerHandler.removeAll();
            this.mapHandler.add((Object)new MouseDelegator(this.mapBean));
            this.mapHandler.add((Object)new NavMouseMode2());
            this.mapHandler.add((Object)new DistanceMouseMode());
            this.mapHandler.add((Object)new SelectMouseMode("Gestures", true));
            this.mapHandler.add((Object)new MouseModePanel());
            this.mapHandler.add((Object)new MouseModeButtonPanel());
            this.mapHandler.add((Object)new NullMouseMode());
            this.mapHandler.add((Object)new ScaleTextPanel());
            this.mapHandler.add((Object)new ControlMenu());
            this.mapHandler.add((Object)new NavigateMenu());
            this.mapHandler.add((Object)new NavigatePanel());
            this.mapHandler.add((Object)new ZoomPanel());
            this.mapHandler.add((Object)new MenuBar());
            this.mapHandler.add((Object)new InformationDelegator());
            this.mapHandler.add((Object)new ToolPanel());
            this.mapHandler.add((Object)new ProjectionStack());
            this.mapHandler.add((Object)new ProjectionStackTool());
            this.goTo = new GoToMenu();
            this.goTo.setMap(this.mapBean);
            this.goTo.addDefaultLocations();
            this.mapHandler.add((Object)this.goTo);
            this.layersMenu = new LayersMenu(this.layerHandler, "Layers", 1);
            this.mapHandler.add((Object)this.layersMenu);
            this.layersPanel = new LayersPanel(this.layerHandler);
            LayerControlButtonPanel layerControlButtonPanel = new LayerControlButtonPanel(this.layersPanel);
            layerControlButtonPanel.removeLayersPanel(this.layersPanel);
            this.layersMenu.setupEditLayersButton(this.layersPanel);
            this.layersPanel.setControls(layerControlButtonPanel);
            this.layersPanel.updateLayerLabels();
            this.mapHandler.add((Object)this.layersPanel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SimModel getModel() {
        return this.model;
    }

    public void setModel(SimModel simModel) {
        this.model = simModel;
    }

    public void addGraticuleLayer() {
        GraticuleLayer graticuleLayer = new GraticuleLayer();
        graticuleLayer.setShowRuler(true);
        graticuleLayer.setConsumeEvents(false);
        Layer[] layerArray = this.layerHandler.getLayers();
        this.layerHandler.addLayer((Layer)graticuleLayer, layerArray.length);
    }

    public void centerMap(LatLonPoint latLonPoint) {
        this.mapBean.setCenter(latLonPoint);
    }

    public void setMapScale(float f) {
        this.mapBean.setScale(f);
    }

    public RepastOMLayer addLayer(List list, String string) {
        return this.addLayer(list, string, this.getHighlightColor());
    }

    public RepastOMLayer addLayer(List list, String string, Color color) {
        RepastOMLayer repastOMLayer = new RepastOMLayer(this, string);
        try {
            Object object;
            String[] stringArray;
            OMGraphicList oMGraphicList = new OMGraphicList();
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                stringArray = (String[])object2.next();
                object = stringArray.getOMGraphic();
                object.setFillPaint(stringArray.getFillPaint());
                oMGraphicList.add((OMGraphic)object);
            }
            object2 = new Properties();
            ((Properties)object2).put("prettyName", string);
            ((Properties)object2).put("lineColor", "000000");
            ((Properties)object2).put("fillColor", "BDDE83");
            repastOMLayer.setProperties((Properties)object2);
            this.layerHandler.addLayer((Layer)repastOMLayer, 0);
            this.layerHandler.setLayers();
            this.mapHandler.add((Object)repastOMLayer);
            stringArray = new String[]{"Gestures"};
            repastOMLayer.setMouseModeIDsForEvents(stringArray);
            repastOMLayer.setName(string);
            this.layersMenu.updateLayerLabels();
            repastOMLayer.setList(oMGraphicList);
            repastOMLayer.setHighlightFillPaint(color);
            repastOMLayer.setVisible(true);
            repastOMLayer.setConsumeEvents(true);
            repastOMLayer.setAgentList(list);
            repastOMLayer.doPrepare();
            object = OpenMapData.getInstance();
            LatLonPoint latLonPoint = ((OpenMapData)object).getCenter(((OpenMapData)object).buildEsriGraphicList(list));
            Properties properties = new Properties();
            properties.put("name", string);
            properties.put("latitude", "" + latLonPoint.getLatitude());
            properties.put("longitiude", "" + latLonPoint.getLongitude());
            properties.put("projection", "" + this.getProjection());
            properties.put("scale", "5f");
            this.goTo.addLocationItem(string, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return repastOMLayer;
    }

    public void updateDisplay() {
        Layer[] layerArray = this.layerHandler.getLayers();
        for (int i = 0; i < layerArray.length; ++i) {
            if (layerArray[i] instanceof OMGraphicHandlerLayer) {
                ((OMGraphicHandlerLayer)layerArray[i]).doPrepare();
                continue;
            }
            if (layerArray[i] instanceof LocationLayer) {
                ((LocationLayer)layerArray[i]).doPrepare();
                continue;
            }
            layerArray[i].repaint();
        }
    }

    public boolean updateLayer(List list, String string) {
        Layer layer = this.getLayer(string);
        if (layer instanceof RepastOMLayer) {
            ((RepastOMLayer)layer).setAgentList(list);
            ((RepastOMLayer)layer).doPrepare();
            return true;
        }
        return false;
    }

    public Layer getLayer(String string) {
        Layer[] layerArray = this.layerHandler.getLayers();
        for (int i = 0; i < layerArray.length; ++i) {
            if (!layerArray[i].getName().equalsIgnoreCase(string)) continue;
            return layerArray[i];
        }
        return null;
    }

    public EsriGraphicList buildEsriGraphicList(Collection collection) {
        Object object = null;
        OMGraphic oMGraphic = ((OpenMapAgent)collection.iterator().next()).getOMGraphic();
        object = oMGraphic instanceof OMPoint ? new EsriPointList() : (oMGraphic instanceof EsriPolyline ? new EsriPolylineList() : new EsriPolygonList());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            OpenMapAgent openMapAgent = (OpenMapAgent)iterator.next();
            object.add(openMapAgent.getOMGraphic());
        }
        return object;
    }

    public Projection getProjection() {
        return this.mapBean.getProjection();
    }

    public Projection getProjection(String string) {
        Layer layer = this.getLayer(string);
        return layer.getProjection();
    }

    public Projection getProjection(Layer layer) {
        return layer.getProjection();
    }

    public Point latLonToPoint(LatLonPoint latLonPoint) {
        Projection projection = this.mapBean.getProjection();
        return projection.forward(latLonPoint);
    }

    public LatLonPoint pointToLatLon(Point point) {
        Projection projection = this.mapBean.getProjection();
        return projection.inverse(point);
    }

    public LatLonPoint xyToLatLon(int n, int n2) {
        Projection projection = this.mapBean.getProjection();
        return projection.inverse(n, n2);
    }

    public ArrayList findClosestAgents(int n, int n2) {
        ArrayList<OpenMapAgent> arrayList = new ArrayList<OpenMapAgent>();
        Layer[] layerArray = this.layerHandler.getLayers();
        for (int i = 0; i < layerArray.length; ++i) {
            if (!(layerArray[i] instanceof RepastOMLayer)) continue;
            arrayList.add(((RepastOMLayer)layerArray[i]).findClosestAgent(n, n2));
        }
        return arrayList;
    }

    public ArrayList findClosestAgents(int n, int n2, float f) {
        ArrayList<OpenMapAgent> arrayList = new ArrayList<OpenMapAgent>();
        Layer[] layerArray = this.layerHandler.getLayers();
        for (int i = 0; i < layerArray.length; ++i) {
            if (!(layerArray[i] instanceof RepastOMLayer)) continue;
            arrayList.add(((RepastOMLayer)layerArray[i]).findClosestAgent(n, n2, f));
        }
        return arrayList;
    }

    public ShapeLayer addShapeLayer(String string, String string2) {
        return this.addShapeLayer(string, string2, "000000", "BDDE83");
    }

    public ShapeLayer addShapeLayer(String string, String string2, String string3, String string4) {
        try {
            ShapeLayer shapeLayer = new ShapeLayer(string);
            Properties properties = new Properties();
            properties.put("prettyName", string2);
            properties.put("lineColor", string3);
            properties.put("fillColor", string4);
            shapeLayer.setProperties(properties);
            this.mapHandler.add((Object)shapeLayer);
            this.layerHandler.addLayer((Layer)shapeLayer);
            this.layersMenu.updateLayerLabels();
            shapeLayer.doPrepare();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.shapeLayer;
    }

    public void dispose() {
        this.frame.dispose();
    }

    public OpenMapFrame getFrame() {
        return this.frame;
    }

    public void setFrame(OpenMapFrame openMapFrame) {
        this.frame = openMapFrame;
    }

    public LayerHandler getLayerHandler() {
        return this.layerHandler;
    }

    public void setLayerHandler(LayerHandler layerHandler) {
        this.layerHandler = layerHandler;
    }

    public Layer[] getLayers() {
        return this.layers;
    }

    public void setLayers(Layer[] layerArray) {
        this.layers = layerArray;
    }

    public MapBean getMapBean() {
        return this.mapBean;
    }

    public void setMapBean(MapBean mapBean) {
        this.mapBean = mapBean;
    }

    public MapHandler getMapHandler() {
        return this.mapHandler;
    }

    public void setMapHandler(MapHandler mapHandler) {
        this.mapHandler = mapHandler;
    }

    public BasicMapPanel getMapPanel() {
        return this.mapPanel;
    }

    public void setMapPanel(BasicMapPanel basicMapPanel) {
        this.mapPanel = basicMapPanel;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public OpenMap getOpenMap() {
        return this.openMap;
    }

    public void setOpenMap(OpenMap openMap) {
        this.openMap = openMap;
    }

    public PropertyHandler getPropertyHandler() {
        return this.propertyHandler;
    }

    public void setPropertyHandler(PropertyHandler propertyHandler) {
        this.propertyHandler = propertyHandler;
    }

    public void setMovieName(String string, String string2) {
        Dimension dimension = this.mapBean.getSize();
        if (string2.equals("video.quicktime")) {
            string = string + ".mov";
            this.movieMaker = new MovieMaker(dimension.width, dimension.height, 1, string, string2);
        } else {
            SimUtilities.showMessage("Movie type " + string2 + " is unsupported");
        }
    }

    public void addMovieFrame() {
        if (this.movieMaker == null) {
            System.err.println("Unable to create frame - use setMovieFileName first");
            return;
        }
        this.updateDisplay();
        BufferedImage bufferedImage = this.mapBean.getGraphicsConfiguration().createCompatibleImage(this.mapBean.getWidth(), this.mapBean.getHeight());
        Graphics graphics = bufferedImage.getGraphics();
        this.mapBean.paint(graphics);
        graphics.dispose();
        this.movieMaker.addImageAsFrame(bufferedImage);
    }

    public void closeMovie() {
        if (this.movieMaker != null) {
            this.movieMaker.cleanUp();
        }
    }

    public void setSnapshotFileName(String string) {
        this.snapshotFile = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void takeSnapshot() {
        block14: {
            if (this.snapshotFile == null) {
                System.err.println("file not defined - use setSnapshotFileName");
                return;
            }
            this.updateDisplay();
            String string = this.model != null ? this.snapshotFile + this.model.getTickCount() + ".png" : this.snapshotFile + ".png";
            DataOutputStream dataOutputStream = null;
            dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            try {
                BufferedImage bufferedImage = this.mapBean.getGraphicsConfiguration().createCompatibleImage(this.mapBean.getWidth(), this.mapBean.getHeight());
                Graphics graphics = bufferedImage.getGraphics();
                this.mapBean.paint(graphics);
                ImageIO.write((RenderedImage)bufferedImage, "png", dataOutputStream);
                graphics.dispose();
            }
            catch (IOException iOException) {
                SimUtilities.showError("Unable to write snapshot image to file", iOException);
            }
            Object var6_7 = null;
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
                break block14;
            }
            catch (Exception exception) {
                SimUtilities.showError("Unable to close output stream for snapshot image", exception);
                exception.printStackTrace();
            }
            break block14;
            {
                catch (IOException iOException) {
                    SimUtilities.showError("Unable to create output stream for snapshot image", iOException);
                    iOException.printStackTrace();
                    Object var6_8 = null;
                    try {
                        if (dataOutputStream != null) {
                            dataOutputStream.close();
                        }
                        break block14;
                    }
                    catch (Exception exception) {
                        SimUtilities.showError("Unable to close output stream for snapshot image", exception);
                        exception.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    SimUtilities.showError("Unable to close output stream for snapshot image", exception);
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
    }
}

