/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Sphere;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import jwsu.viewbranch.CyberGloveEvent;
import jwsu.viewbranch.Draggable;
import jwsu.viewbranch.HandBehavior;
import jwsu.viewbranch.HandBehaviorGrow;
import jwsu.viewbranch.HandBehaviorTip;
import jwsu.viewbranch.PinchEvent;
import jwsu.viewbranch.VirtualHand;

public class VirtualHandGrow
extends VirtualHand {
    private HandBehaviorGrow vbehavior = null;
    private TransformGroup sTG = null;
    private TransformGroup tipTG = null;

    TransformGroup get_sTG() {
        return this.sTG;
    }

    TransformGroup get_tipTG() {
        return this.tipTG;
    }

    public VirtualHandGrow(InputDevice inputDevice, int n) {
        this(inputDevice, n, null);
    }

    public VirtualHandGrow(InputDevice inputDevice, int n, Node node) {
        super(inputDevice, n, node);
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(new Vector3d(1.0, 1.0, 10.0));
        transform3D.setTranslation(new Vector3d(0.0, 0.0, -1.0));
        this.sTG = new TransformGroup(transform3D);
        this.sTG.setCapability(18);
        this.sTG.setCapability(17);
        this.getLocalOffSetTG().addChild((Node)this.sTG);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setColor(1.0f, 0.0f, 0.0f);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(coloringAttributes);
        appearance.setPolygonAttributes(polygonAttributes);
        Box box = new Box(0.1f, 0.1f, 0.1f, appearance);
        this.sTG.addChild((Node)box);
        ColoringAttributes coloringAttributes2 = new ColoringAttributes();
        coloringAttributes2.setColor(0.0f, 1.0f, 1.0f);
        PolygonAttributes polygonAttributes2 = new PolygonAttributes();
        Appearance appearance2 = new Appearance();
        appearance2.setColoringAttributes(coloringAttributes2);
        appearance2.setPolygonAttributes(polygonAttributes2);
        int n2 = 97;
        Sphere sphere = new Sphere(0.9f, n2, appearance2);
        this.tipTG = new TransformGroup();
        this.tipTG.setCapability(18);
        this.tipTG.setCapability(17);
        this.getLocalOffSetTG().addChild((Node)this.tipTG);
        this.tipTG.addChild((Node)sphere);
        this.sTG.getTransform(transform3D);
        Vector3d vector3d = new Vector3d();
        transform3D.getScale(vector3d);
        transform3D.setScale(1.0);
        transform3D.setTranslation(new Vector3d(0.0, 0.0, -2.0 * vector3d.z * 0.1));
        this.tipTG.setTransform(transform3D);
        int n3 = 0;
        while (n3 < this.numChildren()) {
            if (this.getChild(n3) instanceof HandBehavior) {
                this.removeChild(n3);
            }
            ++n3;
        }
        HandBehaviorTip handBehaviorTip = new HandBehaviorTip(this);
        handBehaviorTip.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
        this.addChild((Node)handBehaviorTip);
        this.vbehavior = new HandBehaviorGrow(this);
        this.vbehavior.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
        this.addChild((Node)this.vbehavior);
    }

    public void CyberGloveTouched(CyberGloveEvent cyberGloveEvent) {
        if (this.WhichHand() == 2 && cyberGloveEvent.isLeft() || this.WhichHand() == 1 && cyberGloveEvent.isRight()) {
            Transform3D transform3D = this.CalcMyPositionOrientation();
            Transform3D transform3D2 = new Transform3D();
            this.get_sTG().getTransform(transform3D2);
            Vector3d vector3d = new Vector3d();
            transform3D2.getScale(vector3d);
            Point3d point3d = new Point3d(0.0, 0.0, -2.0 * vector3d.z * 0.1);
            transform3D.transform(point3d);
            BoundingSphere boundingSphere = new BoundingSphere(point3d, 0.07619999999999999);
            Iterator iterator = Draggable.getInstances().iterator();
            while (iterator.hasNext()) {
                Draggable draggable = (Draggable)iterator.next();
                if (!draggable.intersect((Bounds)boundingSphere)) continue;
                if (this.getOtherHand() != null && this.getOtherHand().getTarget() != null && this.getOtherHand().getTarget().getTG() == draggable.getTG()) {
                    this.getOtherHand().setTarget(null);
                    System.out.println("\n\t** Releasing object from other hand. **\t");
                }
                this.setTarget(draggable);
                System.out.println("-> GRAB: " + this.getTarget().getNode());
                break;
            }
        }
    }

    public void pinchTouched(PinchEvent pinchEvent) {
        if (this.WhichHand() == 2 && pinchEvent.isLeft() || this.WhichHand() == 1 && pinchEvent.isRight()) {
            if (pinchEvent.finger1 == 0 && pinchEvent.finger2 == 1 || pinchEvent.finger1 == 5 && pinchEvent.finger2 == 6) {
                this.vbehavior.stateGrow();
            } else if (pinchEvent.finger1 == 0 && pinchEvent.finger2 == 2 || pinchEvent.finger1 == 5 && pinchEvent.finger2 == 7) {
                this.vbehavior.stateShring();
            }
        }
    }

    public void pinchReleased(PinchEvent pinchEvent) {
        if ((this.WhichHand() == 2 && pinchEvent.isLeft() || this.WhichHand() == 1 && pinchEvent.isRight()) && (pinchEvent.finger1 == 0 && pinchEvent.finger2 == 1 || pinchEvent.finger1 == 0 && pinchEvent.finger2 == 2 || pinchEvent.finger1 == 5 && pinchEvent.finger2 == 6 || pinchEvent.finger1 == 5 && pinchEvent.finger2 == 7)) {
            this.vbehavior.stateIdle();
        }
    }
}

