/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import com.sun.j3d.utils.geometry.Box;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import jwsu.viewbranch.CyberGloveEvent;
import jwsu.viewbranch.CyberGloveListener;
import jwsu.viewbranch.Draggable;
import jwsu.viewbranch.Hand;
import jwsu.viewbranch.HandBehavior;
import jwsu.viewbranch.PinchEvent;
import jwsu.viewbranch.PinchListener;

public class VirtualHand
extends Hand
implements PinchListener,
MouseListener,
KeyListener,
CyberGloveListener {
    private final float handsize = 0.5f;
    private Node node;

    public VirtualHand(InputDevice inputDevice, int n) {
        this(inputDevice, n, null);
    }

    public VirtualHand(InputDevice inputDevice, int n, Node node) {
        super(n);
        Object object;
        this.node = node;
        this.setSensor(inputDevice.getSensor(n == 1 ? 1 : 2));
        if (node == null) {
            object = new ColoringAttributes();
            if (n == 1) {
                object.setColor(0.0f, 1.0f, 0.0f);
            } else {
                object.setColor(1.0f, 0.0f, 0.0f);
            }
            PolygonAttributes polygonAttributes = new PolygonAttributes();
            Appearance appearance = new Appearance();
            appearance.setColoringAttributes(object);
            appearance.setPolygonAttributes(polygonAttributes);
            this.node = new Box(0.5f, 0.5f, 0.5f, appearance);
        }
        this.getSwitch().addChild(this.node);
        object = new HandBehavior(this);
        object.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
        this.addChild((Node)object);
    }

    public Node getNode() {
        return this.node;
    }

    protected void setNode(Node node) {
        this.node = node;
    }

    public void CyberGloveTouched(CyberGloveEvent cyberGloveEvent) {
        if (this.WhichHand() == 2 && cyberGloveEvent.isLeft() || this.WhichHand() == 1 && cyberGloveEvent.isRight()) {
            Transform3D transform3D = this.CalcMyPositionOrientation();
            Point3d point3d = new Point3d(0.0, 0.0, 0.0);
            transform3D.transform(point3d);
            BoundingSphere boundingSphere = new BoundingSphere(point3d, 0.07619999999999999);
            Iterator iterator = Draggable.getInstances().iterator();
            while (iterator.hasNext()) {
                Draggable draggable = (Draggable)iterator.next();
                if (!draggable.intersect((Bounds)boundingSphere)) continue;
                if (this.getOtherHand() != null && this.getOtherHand().getTarget() != null && this.getOtherHand().getTarget().getTG() == draggable.getTG()) {
                    this.getOtherHand().setTarget(null);
                    System.out.println("\n\t** Releasing object from other hand. **\t");
                }
                this.setTarget(draggable);
                System.out.println("GRAB: " + this.getTarget().getNode());
                break;
            }
        }
    }

    public void CyberGloveReleased(CyberGloveEvent cyberGloveEvent) {
        if (this.WhichHand() == 2 && cyberGloveEvent.isLeft() || this.WhichHand() == 1 && cyberGloveEvent.isRight()) {
            this.setTarget(null);
        }
    }

    public void CyberGloveFly(CyberGloveEvent cyberGloveEvent) {
    }

    public void CyberGloveDrive(CyberGloveEvent cyberGloveEvent) {
    }

    public void CyberGloveInteract(CyberGloveEvent cyberGloveEvent) {
    }

    public void pinchTouched(PinchEvent pinchEvent) {
        if (this.WhichHand() == 2 && pinchEvent.isLeft() || this.WhichHand() == 1 && pinchEvent.isRight()) {
            Transform3D transform3D = this.CalcMyPositionOrientation();
            Point3d point3d = new Point3d(0.0, 0.0, 0.0);
            transform3D.transform(point3d);
            BoundingSphere boundingSphere = new BoundingSphere(point3d, 0.07619999999999999);
            Iterator iterator = Draggable.getInstances().iterator();
            while (iterator.hasNext()) {
                Draggable draggable = (Draggable)iterator.next();
                if (!draggable.intersect((Bounds)boundingSphere)) continue;
                if (this.getOtherHand() != null && this.getOtherHand().getTarget() != null && this.getOtherHand().getTarget().getTG() == draggable.getTG()) {
                    this.getOtherHand().setTarget(null);
                    System.out.println("\n\t** Releasing object from other hand. **\t");
                }
                this.setTarget(draggable);
                System.out.println("pinchGRAB: " + this.getTarget().getNode());
                break;
            }
        }
    }

    public void pinchReleased(PinchEvent pinchEvent) {
        if (this.WhichHand() == 2 && pinchEvent.isLeft() || this.WhichHand() == 1 && pinchEvent.isRight()) {
            this.setTarget(null);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 16) {
            this.pinchTouched(new PinchEvent(0, 1));
        } else {
            this.pinchTouched(new PinchEvent(5, 6));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 16) {
            this.pinchReleased(new PinchEvent(0, 1));
        } else {
            this.pinchReleased(new PinchEvent(5, 6));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == 'L') {
            this.pinchTouched(new PinchEvent(5, 6));
        } else if (c == 'l') {
            this.pinchReleased(new PinchEvent(5, 6));
        } else if (c == 'R') {
            this.pinchTouched(new PinchEvent(0, 1));
        } else if (c == 'r') {
            this.pinchReleased(new PinchEvent(0, 1));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }
}

