/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.media.j3d.GraphicsConfigTemplate3D;

class StereoFS_config {
    private GraphicsConfiguration gcfg = null;

    public StereoFS_config(int n) {
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        graphicsConfigTemplate3D.setDoubleBuffer(1);
        graphicsConfigTemplate3D.setStereo(2);
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (n >= graphicsDeviceArray.length || n < 0) {
            System.err.println("Requesting config for screen that does not exist. Screen id: " + n);
            System.exit(-1);
        } else {
            this.gcfg = graphicsDeviceArray[n].getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
        }
        if (!graphicsConfigTemplate3D.isGraphicsConfigSupported(this.gcfg)) {
            System.out.println("[WARNING] STEREO FS is **NOT** supported");
        }
    }

    public StereoFS_config() {
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        graphicsConfigTemplate3D.setDoubleBuffer(1);
        graphicsConfigTemplate3D.setStereo(2);
        this.gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
        if (!graphicsConfigTemplate3D.isGraphicsConfigSupported(this.gcfg)) {
            System.out.println("[WARNING] STEREO FS is **NOT** supported");
        }
    }

    public GraphicsConfiguration getConfig() {
        return this.gcfg;
    }
}

